#ifndef _SETI_APPLET_SKIN
#define _SETI_APPLET_SKIN

typedef void *skin_data;

typedef struct _seti_applet_skin_t
{
    skin_data *private;
    gboolean (*setup) (void);
    gboolean(*cleanup) (skin_data *);
    GnomeCanvasItem *(*cputimeoverall) (skin_data *,
                                        GnomeCanvasGroup *,
                                        gdouble,
                                        seti_applet_size_t *);
    GnomeCanvasItem *(*cputimecurrent) (skin_data *,
                                        GnomeCanvasGroup *,
                                        gdouble,
                                        seti_applet_size_t *);
    GnomeCanvasItem *(*gaussian) (skin_data *,
                                  GnomeCanvasGroup *,
                                  gdouble *,
                                  gdouble,
                                  gdouble,
                                  gdouble,
                                  guint,
                                  seti_applet_size_t *);
    GnomeCanvasItem *(*spike) (skin_data *,
                               GnomeCanvasGroup *,
                               gdouble,
                               seti_applet_size_t *);
    GnomeCanvasItem *(*units) (skin_data *,
                               GnomeCanvasGroup *,
                               gdouble,
                               seti_applet_size_t *);
    GnomeCanvasItem *(*progress) (skin_data *,
                                  GnomeCanvasGroup *,
                                  gdouble,
                                  seti_applet_size_t *);
    GnomeCanvasItem *(*radar_red) (skin_data *,
                                   GnomeCanvasGroup *,
                                   seti_applet_size_t *);
    GnomeCanvasItem *(*radar_green) (skin_data *,
                                     GnomeCanvasGroup *,
                                     seti_applet_size_t *);
    GnomeCanvasItem *(*radar_grey) (skin_data *,
                                    GnomeCanvasGroup *,
                                    seti_applet_size_t *);
    gchar      *(*tooltip) (skin_data *,
                            setiapplet_current_unit *,
                            setiapplet_user_info *);
    GnomeCanvasItem *(*title) (skin_data *,
                               GnomeCanvasGroup *,
                               seti_applet_size_t *);
}
seti_applet_skin_t;

#endif
