/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _BASEGUI_H_
#define _BASEGUI_H_

#include <qmainwindow.h>
#include "mediadata.h"
#include "mediasettings.h"
#include "preferences.h"
#include "core.h"
#include "config.h"

class QWidget;
class QPopupMenu;
class MyPopupMenu;
class QTextBrowser;
class LogWindow;
class MplayerWindow;
class QGridLayout;
class QLabel;
class PreferencesDialog;
class FilePropertiesDialog;
class VideoEqualizer;
class Playlist;
class QDockWindow;
class Recents;
class MyAction;
class QActionGroup;
class InfoReader;
class CSManager;

/*
#if KDE_SUPPORT
#define MAINWINDOW KMainWindow
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#else
#define MAINWINDOW QMainWindow
#endif
*/

class BaseGui : public QMainWindow
{
    Q_OBJECT
    
public:
    BaseGui( QStringList files, QWidget* parent = 0, const char* name = 0, 
             WFlags fl = WType_TopLevel );
	~BaseGui();
    
public slots:
	virtual void open(QString file); // Generic open, autodetect type.
    virtual void openFile();
	virtual void openFile(QString file);
	virtual void openFiles(QStringList files);
	virtual void openURL();
	virtual void openURL(QString url);
	virtual void openVCD();
	virtual void openAudioCD();
	virtual void openDVD();
	virtual void openDVDFromFolder();
	virtual void openDVDFromFolder(QString directory);
	virtual void openDirectory();
	virtual void openDirectory(QString directory);

    virtual void helpAbout();
	virtual void helpAboutQt();

    virtual void loadSub();
	virtual void loadAudioFile(); // Load external audio file

	virtual void showPlaylist();
	virtual void showPlaylist(bool b);
	virtual void showEqualizer();
	virtual void showEqualizer(bool b);
	virtual void showMplayerLog();
    virtual void showLog();
	virtual void showPreferencesDialog();
	virtual void showFilePropertiesDialog();

	virtual void exitFullscreen();
	virtual void toggleFullscreen();
    virtual void toggleFullscreen(bool);

	virtual void toggleCompactMode();
	virtual void toggleCompactMode(bool);

	virtual void toggleStayOnTop();
	virtual void toggleStayOnTop(bool);

	virtual void toggleFrameCounter();
	virtual void toggleFrameCounter(bool);

protected slots:
	virtual void languageChange();
	virtual void closeWindow();

	virtual void setJumpTexts();

	// Replace for setCaption (in Qt 4 it's not virtual)
	virtual void setWindowCaption(const QString & title); 

	virtual void openRecent(int item);
	virtual void enterFullscreenOnPlay();
	virtual void exitFullscreenOnStop();
	virtual void exitFullscreenIfNeeded();

    virtual void displayState(int state);
	virtual void displayMessage(QString message);
	virtual void gotCurrentTime(double);

    virtual void initializeMenus();
	virtual void updateWidgets();
	virtual void updateEqualizer();

	virtual void newMediaLoaded();
	virtual void updateMediaInfo();

	virtual void resizeWindow(int w, int h);
	virtual void hidePanel();

	virtual void playlistVisibilityChanged();

	virtual void displayGotoTime(int);

	virtual void showPopupMenu( QPoint p );
	virtual void mouseReleaseEvent( QMouseEvent * e );
	virtual void mouseDoubleClickEvent( QMouseEvent * e );
	virtual void wheelEvent( QWheelEvent * e ) ;

	virtual void leftClickFunction();
	virtual void doubleClickFunction();
	virtual void processFunction(QString function);

	virtual void dragEnterEvent( QDragEnterEvent * ) ;
	virtual void dropEvent ( QDropEvent * );

	virtual void applyNewPreferences();
	virtual void applyFileProperties();

	virtual void clearRecentsList();

	virtual void loadActions();
	virtual void saveActions();

	// Check the mouse pos in fullscreen mode, to
	// show the controlwidget if it's moved to
	// the bottom area.
	virtual void checkMousePos( QPoint );

	// Single instance stuff
	// Another instance request open a file
	virtual void remoteOpen(QString file);
	virtual void remoteOpenFiles(QStringList files);

	// CSManager tell us to continue start up (show and open initial file)
	virtual void continueStartUp(int);

	// stylesheet
	virtual void loadQss(QString filename);
	virtual void changeStyleSheet(QString style);

	virtual void firstShow();

signals:
	void frameChanged(int);
	void timeChanged(double, int, QString);

	void cursorNearTop(QPoint);
	void cursorNearBottom(QPoint);
	void cursorFarEdges();
	
	void wheelUp();
	void wheelDown();
	void doubleClicked();
	void leftClicked();

protected:
	virtual void aboutToEnterFullscreen();
	virtual void aboutToExitFullscreen();
	virtual void aboutToEnterCompactMode();
	virtual void aboutToExitCompactMode();

protected:
	void createCore();
	void createMplayerWindow();
	void createVideoEqualizer();
	void createPlaylist();
	void createPanel();
	void createPreferencesDialog();
	void createFilePropertiesDialog();
	void setDataToFileProperties();
	void initializeGui();
	void createActions();
	void createMenus();
	void updateRecents();
	/* virtual void closeEvent( QCloseEvent * e ); */

protected:
	QWidget * panel;

	// Menu File
	MyAction * openFileAct;
	MyAction * openDirectoryAct;
	MyAction * openPlaylistAct;
	MyAction * openVCDAct;
	MyAction * openAudioCDAct;
	MyAction * openDVDAct;
	MyAction * openDVDFolderAct;
	MyAction * openURLAct;
	MyAction * exitAct;

	// Menu Play
	MyAction * playAct;
	MyAction * playOrPauseAct;
	MyAction * pauseAct;
	MyAction * pauseAndStepAct;
	MyAction * stopAct;
	MyAction * frameStepAct;
	MyAction * rewind1Act;
	MyAction * rewind2Act;
	MyAction * rewind3Act;
	MyAction * forward1Act;
	MyAction * forward2Act;
	MyAction * forward3Act;
	MyAction * repeatAct;

	// Menu Speed
	MyAction * normalSpeedAct;
	MyAction * halveSpeedAct;
	MyAction * doubleSpeedAct;
	MyAction * decSpeedAct;
	MyAction * incSpeedAct;
	QActionGroup * speedAct;

	// Menu Video
	MyAction * fullscreenAct;
	MyAction * compactAct;
	MyAction * equalizerAct;
	MyAction * screenshotAct;
	MyAction * onTopAct;
	MyAction * postProcessingAct;
	MyAction * phaseAct;
	MyAction * deblockAct;
	MyAction * deringAct;
	MyAction * addNoiseAct;
	QActionGroup * videoFilterAct;


	// Menu Audio
	MyAction * muteAct;
	MyAction * decVolumeAct;
	MyAction * incVolumeAct;
	MyAction * decAudioDelayAct;
	MyAction * incAudioDelayAct;
	MyAction * extrastereoAct;
	MyAction * karaokeAct;
	MyAction * volnormAct;
	MyAction * loadAudioAct;
	MyAction * unloadAudioAct;
	QActionGroup * audioFilterAct;

	// Menu Subtitles
	MyAction * loadSubsAct;
	MyAction * unloadSubsAct;
	MyAction * decSubDelayAct;
	MyAction * incSubDelayAct;
	MyAction * decSubPosAct;
	MyAction * incSubPosAct;
	MyAction * incSubStepAct;
	MyAction * decSubStepAct;


	// Menu Options
	MyAction * showPlaylistAct;
	MyAction * showPropertiesAct;
	MyAction * frameCounterAct;
	MyAction * showPreferencesAct;
	MyAction * showLogMplayerAct;
	MyAction * showLogSmplayerAct;
	QActionGroup * showLogsAct;

	// Menu Help
	MyAction * aboutQtAct;
	MyAction * aboutThisAct;

	// Playlist
	MyAction * playPrevAct;
	MyAction * playNextAct;

	// Actions not in menus
	MyAction * decVolume2Act;
	MyAction * incVolume2Act;
	MyAction * exitFullscreenAct;
	MyAction * nextOSDAct;
	MyAction * decContrastAct;
	MyAction * incContrastAct;
	MyAction * decBrightnessAct;
	MyAction * incBrightnessAct;
	MyAction * decHueAct;
	MyAction * incHueAct;
	MyAction * decSaturationAct;
	MyAction * incSaturationAct;
	MyAction * decGammaAct;
	MyAction * incGammaAct;
	MyAction * nextAudioAct;
	MyAction * nextSubtitleAct;
	MyAction * nextChapterAct;
	MyAction * prevChapterAct;
	MyAction * doubleSizeAct;

	// Moving and zoom
	MyAction * moveUpAct;
	MyAction * moveDownAct;
	MyAction * moveLeftAct;
	MyAction * moveRightAct;
	MyAction * incZoomAct;
	MyAction * decZoomAct;
	MyAction * resetZoomAct;

	QPopupMenu *openMenu;
    QPopupMenu *playMenu;
    QPopupMenu *videoMenu;
    QPopupMenu *audioMenu;
    QPopupMenu *subtitlesMenu;
    QPopupMenu *browseMenu;
    QPopupMenu *optionsMenu;
    QPopupMenu *helpMenu;

    MyPopupMenu * subtitlestrack_menu;
	MyPopupMenu * audiotrack_menu;
	MyPopupMenu * titles_menu;
	MyPopupMenu * chapters_menu;
	MyPopupMenu * angles_menu;
	MyPopupMenu * aspect_menu;
	MyPopupMenu * osd_menu;
	MyPopupMenu * deinterlace_menu;
	MyPopupMenu * denoise_menu;
	MyPopupMenu * videosize_menu;
	MyPopupMenu * audiochannels_menu;
	MyPopupMenu * stereomode_menu;

	QPopupMenu * speed_menu;
	QPopupMenu * videofilter_menu;
	QPopupMenu * audiofilter_menu;
	QPopupMenu * logs_menu;
	QPopupMenu * panscan_menu;

	QPopupMenu * popup;
	QPopupMenu * recentfiles_menu;
    
    LogWindow * mplayer_log_window;
    LogWindow * smplayer_log_window;

	PreferencesDialog *pref_dialog;
	FilePropertiesDialog *file_dialog;
	Playlist * playlist;
	VideoEqualizer * equalizer;

	Core * core;
    MplayerWindow *mplayerwindow;
    QGridLayout* panelLayout;

	Recents * recents;

	CSManager * csmanager;

	// File to open, passed from command line
	QStringList initial_files;

	QStringList actions_list;

private:
	QString default_style;
	InfoReader * info_reader;

	int last_second;
	bool near_top;
	bool near_bottom;

	// Variables to restore pos and size of the window
	// when exiting from fullscreen mode.
	#ifdef Q_OS_WIN
	QPoint win_pos;
	QSize win_size;
	#endif
};
    
#endif

