/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "eqslider.h"
#include <qslider.h>
#include <qlabel.h>
#include <qpixmap.h>
#include "verticaltext.h"
#include "qt3_4_compat.h"

EqSlider::EqSlider( QWidget* parent, const char* name, WFlags fl) 
	: EqSliderBase(parent, name, fl)
{
	_icon->setText( QString::null );
	_slider->setFocusPolicy( STRONGFOCUS );
	_slider->setTickmarks( QSlider::Right );
	_slider->setTickInterval( 10 );
	_slider->setLineStep( 1 );
	_slider->setPageStep( 10 );

	connect( _slider, SIGNAL(valueChanged(int)),
             this, SLOT(sliderValueChanged(int)) );
}

EqSlider::~EqSlider() {
}


void EqSlider::languageChange() {
}

void EqSlider::setIcon( QPixmap i) {
	_icon->setPixmap(i);
}

const QPixmap * EqSlider::icon() const {
	return _icon->pixmap();
}

void EqSlider::setLabel( QString s) {
	_label->setText(s);
}

QString EqSlider::label() const {
	return _label->text();
}

void EqSlider::setValue(int value) {
    #if QT_VERSION >= 0x040000
	_slider->setValue(value);
	#else
	// QSlider in Qt 3works upside-down!
	_slider->setValue(-value);
	#endif
}

int EqSlider::value() const {
    #if QT_VERSION >= 0x040000
	return _slider->value();
	#else
	// QSlider in Qt 3 works upside-down!
	return - _slider->value();
	#endif
}

void EqSlider::sliderValueChanged(int v) {
    #if QT_VERSION >= 0x040000
	emit valueChanged( v );
	#else
	// QSlider in Qt 3 works upside-down!
	emit valueChanged( -v );
	#endif
}
