/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "images.h"
#include "global.h"
#include "preferences.h"
#include "helper.h"

#include <qglobal.h>
#include <qdragobject.h>
#include <qfileinfo.h>

#if QT_VERSION >= 0x040000
#include <Q3MimeSourceFactory>
#else
#include <qmime.h>
#endif


QPixmap Images::icon(QString name, int size, bool png) {
	// qmake in windows has a "silly" bug. qmake creates an invalid file
	// if names start with "r", "n" or "t", so I appended an "x".
	if ( (name.startsWith("r")) || 
         (name.startsWith("t")) || 
         (name.startsWith("n")) ) 
	{
		name = "x" + name;
	}
	
	bool small=FALSE;

	if (name.endsWith("_small")) {
		small=TRUE;
		name = name.replace("_small", "");
	}

	if (png) name += ".png";

	bool ok = FALSE;
	QPixmap p;

	QString filename = Helper::themesPath() + "/" + pref->iconset + "/" +  name;
	//qDebug("Images2::icon: filename: '%s'", filename.utf8().data() );

	if ( (!pref->iconset.isEmpty()) && (QFileInfo( filename ).exists()) ) {
		ok = p.load( filename );
	} else {
		const QMimeSource *m= QMimeSourceFactory::defaultFactory()->data(name);
		if (m) {
			QImageDrag::decode(m,p);
			ok = TRUE;
		}
	}

	if (ok) {
		if (small) {
			p = resize(&p);
		}
		if (size!=-1) {
			p = resize(&p,size);
		}
	} else {
		/* qWarning("Images2::icon: icon '%s' not found", name.utf8().data()); */
	}

	return p;
}

QPixmap Images::resize(QPixmap *p, int size) {
	QPixmap pix;
	pix.convertFromImage( (*p).convertToImage().smoothScale(size,size) );
	return pix;
}
