/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if KDE_SUPPORT
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#else
#include <qapplication.h>
#endif

#include <qcolor.h>
#include "defaultgui.h"
#include "helper.h"
#include "global.h"
#include "preferences.h"
#include "translator.h"
#include "version.h"

#include <qlocale.h>
#include <qtranslator.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qsettings.h>
#include <qregexp.h>

#include <stdio.h>
#include <stdlib.h>

#include <qmime.h>
#include <qurl.h>


static QRegExp rx_log;

void myMessageOutput( QtMsgType type, const char *msg ) {
	if ( (!pref) || (!pref->log_smplayer) ) return;

	rx_log.setPattern(pref->log_filter);

	QString line = QString::fromUtf8(msg);
	switch ( type ) {
		case QtDebugMsg:
			if (rx_log.search(line) > -1) {
				#ifndef NO_DEBUG_ON_CONSOLE
				fprintf( stderr, "Debug: %s\n", line.local8Bit().data() );
				#endif
				Helper::addLog( line );
			}
			break;
		case QtWarningMsg:
			#ifndef NO_DEBUG_ON_CONSOLE
			fprintf( stderr, "Warning: %s\n", line.local8Bit().data() );
			#endif
			Helper::addLog( "WARNING: " + line );
			break;
		case QtFatalMsg:
			#ifndef NO_DEBUG_ON_CONSOLE
			fprintf( stderr, "Fatal: %s\n", line.local8Bit().data() );
			#endif
			Helper::addLog( "FATAL: " + line );
			abort();                    // deliberately core dump
#if QT_VERSION >= 0x040000
		case QtCriticalMsg:
			#ifndef NO_DEBUG_ON_CONSOLE
			fprintf( stderr, "Critical: %s\n", line.local8Bit().data() );
			#endif
			Helper::addLog( "CRITICAL: " + line );
			break;
#endif
	}
}

void showInfo() {
	qDebug("This is smplayer v. " VERSION " running on "
#ifdef Q_OS_LINUX
           "Linux"
#else
#ifdef Q_OS_WIN
           "Windows"
#else
		   "Other OS"
#endif
#endif
		);
	qDebug("Qt v. " QT_VERSION_STR);

	qDebug(" * application path: '%s'", Helper::appPath().utf8().data());
	qDebug(" * data path: '%s'", Helper::dataPath().utf8().data());
	qDebug(" * translation path: '%s'", Helper::translationPath().utf8().data());
	qDebug(" * doc path: '%s'", Helper::docPath().utf8().data());
	qDebug(" * themes path: '%s'", Helper::themesPath().utf8().data());
	qDebug(" * shortcuts path: '%s'", Helper::shortcutsPath().utf8().data());
}


int main( int argc, char ** argv ) 
{
#if KDE_SUPPORT
	QMimeSourceFactory *sf = QMimeSourceFactory::defaultFactory();

	KAboutData *aboutdata = new KAboutData("smplayer", 
		"SMPlayer", VERSION, 
        QT_TR_NOOP("Front-end for mplayer"), KAboutData::License_GPL,
		"(c) 2006, 2007 Ricardo Villalba","",
		"http://smplayer.sourceforge.net");
	aboutdata->addAuthor("Ricardo Villalba",
		QT_TR_NOOP("Developer"),"rvm@escomposlinux.org");

	static const KCmdLineOptions options[] =
	{ 
     //{ "ini-path <dir>", "path for ini file", 0 },
     {"+[file]", QT_TR_NOOP("File to open"), 0 }, KCmdLineLastOption };

	KCmdLineArgs::init(argc, argv, aboutdata);
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication a;
	QMimeSourceFactory * kdeFactory = QMimeSourceFactory::takeDefaultFactory();
	QMimeSourceFactory::setDefaultFactory( sf );
	if ( kdeFactory ) {
		QMimeSourceFactory::addFactory( kdeFactory );
	}
#else
	QApplication a( argc, argv );
#endif


	QString app_path = a.applicationDirPath();
	Helper::setAppPath(app_path);
	//qDebug( "main: application path: '%s'", app_path.utf8().data());


	QString ini_path="";
	QStringList files_to_play;

#if KDE_SUPPORT
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	int arg_init = 0;
	int arg_count = args->count();

	if ( arg_count > arg_init ) {
		for (int n=arg_init; n < arg_count; n++) {
			QString argument = QString::fromLocal8Bit( args->arg(n) );
			if (QFile::exists( argument )) {
				argument = QFileInfo(argument).absFilePath();
			}
			files_to_play.append( argument );
		}
	}

#else
	// Qt code
	int arg_init = 1;
	#if QT_VERSION >= 0x040100
	int arg_count = a.arguments().count();
	#else
	int arg_count = a.argc();
	#endif

	if ( arg_count > arg_init ) {
		for (int n=arg_init; n < arg_count; n++) {
			#if QT_VERSION >= 0x040100
			QString argument = a.arguments()[n];
			#else
			QString argument = QString::fromLocal8Bit( a.argv()[n] );
			#endif
			if (argument == "-ini-path") {
				//qDebug( "ini_path: %d %d", n+1, arg_count );
				ini_path = Helper::appPath();
				if (n+1 < arg_count) {
					n++;
					#if QT_VERSION >= 0x040100
					ini_path = a.arguments()[n];
					#else
					ini_path = QString::fromLocal8Bit( a.argv()[n] );
					#endif
				}
			}
			else {
				if (QFile::exists( argument )) {
					argument = QFileInfo(argument).absFilePath();
				}
				files_to_play.append( argument );
			}
		}
	}
#endif

	global_init(ini_path);

	qInstallMsgHandler( myMessageOutput );

	showInfo();
#if QT_VERSION >= 0x040000
	qDebug(" * ini path: '%s'", ini_path.utf8().data());
#endif

	// Translator
	translator->load( pref->language );
	a.installTranslator(translator->qtranslator());

	qDebug("main: files_to_play: count: %d", files_to_play.count() );
	for (int n=0; n < files_to_play.count(); n++) {
		qDebug("main: files_to_play[%d]: '%s'", n, files_to_play[n].utf8().data());
	}

	DefaultGui * w = new DefaultGui(files_to_play, 0, "gui");
	a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );

	int r = a.exec();
	delete w;

	a.removeTranslator( translator->qtranslator() );

	global_end();

	return r;
}
