/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

/* Global settings */

#include <qstring.h>
#include "config.h"

class Preferences {

public:
	enum OSD { None = 0, Seek = 1, SeekTimer = 2, SeekTimerTotal = 3 };
	enum Resize { Never = 0, Always = 1, Afterload = 2 };
	enum Priority { Realtime = 0, High = 1, AboveNormal = 2, Normal = 3,
                    BelowNormal = 4, Idle = 5 };
	enum WheelFunction { Seeking = 0, Volume = 1, Zoom = 2 };

	Preferences();
	virtual ~Preferences();

	virtual void reset();

	void save();
	void load();

	QString mplayer_bin;
	QString vo; // video output
	QString ao; // audio output

	unsigned int color_key;

	// Subtitles font
	bool use_fontconfig;
	QString font_file;
	QString font_name;
	QString subcp; // -subcp
	int font_autoscale; // -subfont-autoscale
	int font_textscale; // -subfont-text-scale
	bool use_ass_subtitles;
	bool autoload_sub;
	int subfuzziness;
	unsigned int ass_color;
	unsigned int ass_border_color;
	QString ass_styles;

	int osd;

	bool audio_change_requires_restart;
	bool fast_chapter_change;

	QString dvd_device;
	QString cdrom_device;

	bool use_cache;
	int cache;

	bool use_mplayer_window;

	QString monitor_aspect;
	double monitor_aspect_double();

	// Directory of the latest file loaded
	QString latest_dir;
	QString last_url;
	QString last_dvd_directory;

	QString mplayer_verbose;

	// Mainwindow resize method
	int resize_method;

	bool disable_screensaver;

	QString screenshot_directory;
	bool subtitles_on_screenshots;

	bool use_soft_video_eq;
	bool use_soft_vol;
	bool use_volnorm;
	int softvol_max;

	QString audio_lang; 		// Preferred audio language
	QString subtitle_lang;		// Preferred subtitle language

	bool use_hwac3; // -afm hwac3

	int vcd_initial_title;

	// Initial values for some options
	int initial_volume;
	int initial_contrast;
	int initial_brightness;
	int initial_hue;
	int initial_saturation;
	int initial_gamma;

	// Default value for panscan (1.0 = no zoom)
	double initial_panscan_factor;

	// Default value for position of subtitles on screen
	// 100 = 100% at the bottom
	int initial_sub_pos;

	// Let the user pass options to mplayer
	QString mplayer_additional_options;
	QString mplayer_additional_video_filters;
	QString mplayer_additional_audio_filters;

	// Performance
	int priority;
	bool frame_drop;
	bool hard_frame_drop;
	bool autosync;
	int autosync_factor;

	// SMPlayer will remember all media settings for all videos.
	// This options allow to disable it:
	bool dont_remember_media_settings; 	// Will not remember anything
	bool dont_remember_time_pos;		// Will not remember time pos

#if STYLE_SWITCHING
	// SMPlayer look
	QString style;
#endif

	bool fullscreen;
	bool start_in_fullscreen;

	bool compact_mode;
	bool stay_on_top;
	int size_factor;

	bool show_frame_counter;

	
	// Postprocessing
	bool use_postprocessing; // global postprocessing filter
	int autoq;

	// Loop. If true repeat the file
	bool loop;

	bool use_single_instance;
	int connection_port;

	// Function of mouse buttons:
	QString mouse_left_click_function;
	QString mouse_double_click_function;
	int wheel_function;

	// Max items in recent's list
	int recents_max_items;

	// Configurable seeking
	int seeking1; // By default 10s
	int seeking2; // By default 1m
	int seeking3; // By default 10m
	int seeking4; // For mouse wheel, by default 30s

	// Logs
	bool log_mplayer;
	bool log_smplayer;
	QString log_filter;

	QString language;

	QString iconset;

	bool always_clear_background; // If true, mplayerlayer erases its background

	// Make configurable some of the mplayerprocess regular expressions
	QString rx_endoffile;
	QString rx_novideo;

	// Number of times to show the balloon remembering that the program
	// is still running in the system tray.
	int balloon_count;

	// If true, -brightness, -contrast and so on, won't be passed to
	// mplayer. It seems that some graphic cards don't support those options.
	bool dont_use_eq_options;

	// Recent releases of MPlayer need the font for subtitles passed
    // through the -subfont option.
	bool use_subfont;
};

#endif
