/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PREFERENCES_DIALOG_H_
#define _PREFERENCES_DIALOG_H_

#include "preferencesdialogbase.h"
#include "inforeader.h"
#include "config.h"

class Encodings;

class PreferencesDialog : public PreferencesDialogBase
{
	Q_OBJECT

public:
	enum Section { General=0, Drives=1, Performance=2, Subtitles=3,
                   Gui=4, Mouse=5, Advanced=6 };

	PreferencesDialog( QWidget* parent = 0, const char* name = 0, bool modal  = FALSE, WFlags fl = 0 );
    ~PreferencesDialog();

	// Call it as soon as possible
	void setDrivers(InfoList vo_list, InfoList ao_list);
	bool hasDriversList() { return drivers_set; };
	void setActionsList(QStringList l);

	// General Page
	void setMplayerPath( QString path );
	QString mplayerPath();

	void setScreenshotDir( QString path );
	QString screenshotDir();

	void setVO( QString vo_driver );
	QString VO();

	void setAO( QString ao_driver );
	QString AO();

	void setEq2(bool b);
	bool eq2();

	void setSoftVol(bool b);
	bool softVol();

	void setAc3DTSPassthrough(bool b);
	bool Ac3DTSPassthrough();

	void setVolNorm(bool b);
	bool volNorm();

	void setPostprocessing(bool b);
	bool postprocessing();

	void setAmplification(int n);
	int amplification();

	void setRememberSettings(bool b);
	bool rememberSettings();

	void setDontRememberTimePos(bool b);
	bool dontRememberTimePos();

	void setStartInFullscreen(bool b);
	bool startInFullscreen();

	void setAudioLang(QString lang);
	QString audioLang();

	void setSubtitleLang(QString lang);
	QString subtitleLang();

	void setSubtitlesOnScreenshots(bool b);
	bool subtitlesOnScreenshots();

	// Drive page
	void setDVDDevice( QString dir );
	QString dvdDevice();

	void setCDRomDevice( QString dir );
	QString cdromDevice();

	// Misc Page
	void setDisableScreensaver(bool b);
	bool disableScreensaver();

	void setResizeMethod(int v);
	int resizeMethod();

	void setMonitorAspect(QString asp);
	QString monitorAspect();

	void setStyle(QString style);
	QString style();

	void setUseSingleInstance(bool b);
	bool useSingleInstance();

	void setServerPort(int port);
	int serverPort();

	void setRecentsMaxItems(int n);
	int recentsMaxItems();

	void setSeeking1(int n);
	int seeking1();

	void setSeeking2(int n);
	int seeking2();

	void setSeeking3(int n);
	int seeking3();

	void setSeeking4(int n);
	int seeking4();

	void setLeftClickFunction(QString f);
	QString leftClickFunction();

	void setDoubleClickFunction(QString f);
	QString doubleClickFunction();

	void setWheelFunction(int function);
	int wheelFunction();

	void setInitialVolume(int v);
	int initialVolume();

	void setLanguage(QString lang);
	QString language();

	void setIconSet(QString set);
	QString iconSet();

	// Subtitle Page
	void setFontName(QString font_name);
	QString fontName();

	void setFontFile(QString font_file);
	QString fontFile();

	void setUseFontconfig(bool b);
	bool useFontconfig();

	void setFontAutoscale(int n);
	int fontAutoscale();

	void setFontTextscale(int n);
	int fontTextscale();

	void setAutoloadSub(bool v);
	bool autoloadSub();

	void setFontEncoding(QString s);
	QString fontEncoding();

	void setSubPos(int pos);
	int subPos();

	void setUseFontASS(bool v);
	bool useFontASS();

	void setAssColor( unsigned int color );
	unsigned int assColor();

	void setAssBorderColor( unsigned int color );
	unsigned int assBorderColor();

	void setAssStyles(QString styles);
	QString assStyles();

	void setFontFuzziness(int n);
	int fontFuzziness();

	void setUseSubfont(bool b);
	bool useSubfont();

	// Advanced Page
	void setClearBackground(bool b);
	bool clearBackground();

	void setUseMplayerWindow(bool v);
	bool useMplayerWindow();

	void setMplayerAdditionalArguments(QString args);
	QString mplayerAdditionalArguments();

	void setMplayerAdditionalVideoFilters(QString s);
	QString mplayerAdditionalVideoFilters();

	void setMplayerAdditionalAudioFilters(QString s);
	QString mplayerAdditionalAudioFilters();

	void setColorKey(unsigned int c);
	unsigned int colorKey();

	// Performance Page
	void setCacheEnabled(bool b);
	bool cacheEnabled();

	void setCache(int n);
	int cache();

	void setPriority(int n);
	int priority();

	void setFrameDrop(bool b);
	bool frameDrop();

	void setHardFrameDrop(bool b);
	bool hardFrameDrop();

	void setAutoq(int n);
	int autoq();

	void setAutoSyncFactor(int factor);
	int autoSyncFactor();
	void setAutoSyncActivated(bool b);
	bool autoSyncActivated();

	void setFastChapterSeeking(bool b);
	bool fastChapterSeeking();

	void setFastAudioSwitching(bool b);
	bool fastAudioSwitching();

	// Log options
	void setLogMplayer(bool b);
	bool logMplayer();

	void setLogSmplayer(bool b);
	bool logSmplayer();

	void setLogFilter(QString filter);
	QString logFilter();

	// MPlayer language
	void setEndOfFileText(QString t);
	QString endOfFileText();

	void setNoVideoText(QString t);
	QString noVideoText();

public slots:
	void showSection(Section);

protected slots:
    virtual void languageChange();

	void changeSection(int);
	void autoSyncButtonToggled(bool);

	void singleInstanceButtonToggled(bool);
	void clearRecents();

	void systemFontRadioButtonSelected();
	void ttfFontRadioButtonSelected();
	void assButtonToggled(bool);
	void rememberAllButtonToggled(bool);

	void selectSystemFont();
	void selectTtfFont();
	void selectAssColor();
	void selectAssBorderColor();

	void selectMplayerPath();
	void selectScreenshotDirectory();

	virtual void selectColorkey();

	// Reimplemented to send a signal
	void accept();
	void apply();

protected:
	void createLanguageCombo();
	void createHelpMessages();

signals:
	void applyButtonPressed();
	void clearRecentsButtonPressed();

protected:
	Encodings * encodings;
	bool drivers_set;
	unsigned int ass_color, ass_border_color;

	QStringList languages_list;
};


#endif
