TEMPLATE	= app
LANGUAGE	= C++

CONFIG	+= qt warn_on release thread

HEADERS	+= config.h \
	constants.h \
	qt3_4_compat.h \
	version.h \
	global.h \
	helper.h \
	translator.h \
	subtracks.h \
	trackdata.h \
	tracks.h \
	desktopinfo.h \
	mplayerprocess.h \
	mplayerwindow.h \
	mediadata.h \
	mediasettings.h \
	preferences.h \
	images.h \
	inforeader.h \
	recents.h \
	core.h \
	logwindow.h \
	infofile.h \
	encodings.h \
	seekwidget.h \
	mytable.h \
	keychooser.h \
	actionseditor.h \
	preferencesdialog.h \
	filepropertiesdialog.h \
	playlist.h \
	verticaltext.h \
	eqslider.h \
	videoequalizer.h \
	timeslider.h \
	inputdvddirectory.h \
	mypopupmenu.h \
	myaction.h \
	client.h \
	server.h \
	csmanager.h \
	filedialog.h \
	aboutdialog.h \
	basegui.h \
	baseguiplus.h \
	floatingcontrol.h \
	defaultgui.h

SOURCES	+= global.cpp \
	helper.cpp \
	translator.cpp \
	subtracks.cpp \
	trackdata.cpp \
	tracks.cpp \
	desktopinfo.cpp \
	mplayerprocess.cpp \
	mplayerwindow.cpp \
	mediadata.cpp \
	mediasettings.cpp \
	preferences.cpp \
	images.cpp \
	inforeader.cpp \
	recents.cpp \
	core.cpp \
	logwindow.cpp \
	infofile.cpp \
	encodings.cpp \
	seekwidget.cpp \
	mytable.cpp \
	keychooser.cpp \
	actionseditor.cpp \
	preferencesdialog.cpp \
	filepropertiesdialog.cpp \
	playlist.cpp \
	verticaltext.cpp \
	eqslider.cpp \
	videoequalizer.cpp \
	timeslider.cpp \
	inputdvddirectory.cpp \
	mypopupmenu.cpp \
	myaction.cpp \
	client.cpp \
	server.cpp \
	csmanager.cpp \
	filedialog.cpp \
	aboutdialog.cpp \
	basegui.cpp \
	baseguiplus.cpp \
	floatingcontrol.cpp \
	defaultgui.cpp \
	main.cpp

FORMS	= preferencesdialogbase.ui \
	logwindowbase.ui \
	filepropertiesdialogbase.ui \
	eqsliderbase.ui \
	inputdvddirectorybase.ui \
	seekwidgetbase.ui

IMAGES	= icons-png/logo.png \
	icons-png/mouse.png \
	icons-png/keyboard.png \
	icons-png/speaker.png \
	icons-png/xresize_window.png \
	icons-png/monitor.png \
	icons-png/cdrom_drive.png \
	icons-png/dvd_drive.png \
	icons-png/pref_advanced.png \
	icons-png/pref_general.png \
	icons-png/pref_performance.png \
	icons-png/pref_devices.png \
	icons-png/pref_gui.png \
	icons-png/pref_subtitles.png \
	icons-png/input_devices.png \
	icons-png/plus.png \
	icons-png/minus.png \
	icons-png/up.png \
	icons-png/down.png \
	icons-png/xrepeat.png \
	icons-png/shuffle.png \
	icons-png/ok.png \
	icons-png/open.png \
	icons-png/openfolder.png \
	icons-png/dvd.png \
	icons-png/dvd_hd.png \
	icons-png/vcd.png \
	icons-png/cdda.png \
	icons-png/url.png \
	icons-png/close.png \
	icons-png/exit.png \
	icons-png/save.png \
	icons-png/copy.png \
	icons-png/speed.png \
	icons-png/playlist.png \
	icons-png/info.png \
	icons-png/prefs.png \
	icons-png/logs.png \
	icons-png/chapter.png \
	icons-png/xtitle.png \
	icons-png/sub.png \
	icons-png/aspect.png \
	icons-png/screenshot.png \
	icons-png/fullscreen.png \
	icons-png/compact.png \
	icons-png/volume.png \
	icons-png/mute.png \
	icons-png/unload.png \
	icons-png/forward10s.png \
	icons-png/forward1m.png \
	icons-png/forward10m.png \
	icons-png/xrewind10s.png \
	icons-png/xrewind1m.png \
	icons-png/xrewind10m.png \
	icons-png/play.png \
	icons-png/pause.png \
	icons-png/stop.png \
	icons-png/previous.png \
	icons-png/xnext.png \
	icons-png/delete.png \
	icons-png/brightness.png \
	icons-png/contrast.png \
	icons-png/hue.png \
	icons-png/saturation.png \
	icons-png/gamma.png \
	icons-png/background.png \
	icons-png/conflict.png \
	icons-png/xtype_video.png \
	icons-png/xtype_audio.png \
	icons-png/xtype_dvd.png \
	icons-png/xtype_vcd.png \
	icons-png/xtype_cdda.png \
	icons-png/xtype_url.png \
	icons-png/xtype_unknown.png

TRANSLATIONS = translations/smplayer_es.ts translations/smplayer_de.ts \
               translations/smplayer_sk.ts translations/smplayer_it.ts \
               translations/smplayer_fr.ts translations/smplayer_zh_CN.ts \
               translations/smplayer_ru_RU.ts translations/smplayer_hu.ts \
               translations/smplayer_en_US.ts translations/smplayer_pl.ts \
               translations/smplayer_ja.ts translations/smplayer_nl.ts \
               translations/smplayer_uk_UA.ts translations/smplayer_pt_BR.ts \
               translations/smplayer_ka.ts translations/smplayer_cs.ts \
               translations/smplayer_bg.ts translations/smplayer_tr.ts \
               translations/smplayer_sv.ts translations/smplayer_sr.ts \
               translations/smplayer_zh_TW.ts translations/smplayer_ro_RO.ts \
               translations/smplayer_pt_PT.ts

QT += qt3support

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj

  DEFINES += DATA_PATH=$(DATA_PATH)
  DEFINES += DOC_PATH=$(DOC_PATH)
  DEFINES += TRANSLATION_PATH=$(TRANSLATION_PATH)
  DEFINES += CONF_PATH=$(CONF_PATH)
  DEFINES += THEMES_PATH=$(THEMES_PATH)
  DEFINES += SHORTCUTS_PATH=$(SHORTCUTS_PATH)
  #DEFINES += NO_DEBUG_ON_CONSOLE

  #DEFINES += KDE_SUPPORT
  #INCLUDEPATH += /opt/kde3/include/
  #LIBS += -lkio -L/opt/kde3/lib/
  contains( DEFINES, KDE_SUPPORT) {
	HEADERS += mysystemtrayicon.h
	SOURCES += mysystemtrayicon.cpp
  }
}

win32 {
	RC_FILE = smplayer.rc
	DEFINES += NO_DEBUG_ON_CONSOLE
#	debug {
#		CONFIG += console
#	}
}
