

#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class OptionsSimple;
class OptionsDetailed;
//class MoreOptions;

class QStringList;
class QTabWidget;

/**
 * @short Options
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class Options : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Options( QWidget *parent=0, const char *name=0, int text=0 );

    QString currentFormat();

    /**
     * Default Destructor
     */
    virtual ~Options();

public slots:
    void addFiles(QStringList);
    void tabChanged(QWidget*);
    //void showMoreOptions();
    void reset();

signals:
    void timeAdded(float);
    void addFile(QStringList);
    void allFilesAdded();

private:
    OptionsSimple *optionsS;
    OptionsDetailed *optionsD;
    //MoreOptions *moreOptions;
    QTabWidget *tab;

};

#endif // _OPTIONS_H_
