
#include "soundkonverterapp.h"
#include "soundkonverter.h"

#include <qstringlist.h>
#include <qfile.h>

#include <kglobal.h>
#include <kstartupinfo.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>


soundKonverterApp::soundKonverterApp()
    : KUniqueApplication()
{}

soundKonverterApp::~soundKonverterApp()
{}

int soundKonverterApp::newInstance()
{
    // register ourselves as a dcop client
    if( !dcopClient()->isRegistered() )
        dcopClient()->registerAs(name(), false);

    // see if we are starting with session management
    if(restoringSession())
    {
        RESTORE(soundKonverter);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        if(!mainWidget())
        {
            soundKonverter *widget = new soundKonverter();
            setMainWidget(widget);
            widget->show();
        }
        else
            KStartupInfo::setNewStartupId( mainWidget(), kapp->startupId());

        soundKonverter *widget = ::qt_cast<soundKonverter*>( mainWidget() );

        widget->increaseInstances();

        if( args->isSet( "replaygain" ) ) {
            QStringList replayGainFiles;
            for( int i = 0; i < args->count(); i++ ) {
                replayGainFiles.append(QFile::decodeName(args->arg(i)));
            }
            if(!replayGainFiles.isEmpty())
                widget->openReplayGainFiles(replayGainFiles);
        }
        else {
            QStringList files;
            for(int i = 0; i < args->count(); i++)
            {
                files.append(QFile::decodeName(args->arg(i)));
            }
            if(!files.isEmpty())
                widget->openFiles(files);
        }
        args->clear();
    }
    return 0;
}
