/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IPropertyListener;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.views.BeansView;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class RootNode
extends AbstractNode {
    public static final int PROJECTS = 1;
    private BeansView view;
    private Map projects;
    private ListenerList listeners;
    static /* synthetic */ Class class$0;

    public RootNode(BeansView view) {
        super("BeansModel");
        this.setElement((IModelElement)BeansCorePlugin.getModel());
        this.view = view;
        this.projects = new HashMap();
        this.listeners = new ListenerList();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void propertyChanged(INode node, int propertyId) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertyListener listener = (IPropertyListener)array[i];
            listener.propertyChanged((Object)node, propertyId);
            ++i;
        }
    }

    public void reloadConfigs() {
        this.projects.clear();
        Iterator projects = BeansCorePlugin.getModel().getProjects().iterator();
        while (projects.hasNext()) {
            IBeansProject project = (IBeansProject)projects.next();
            this.addProject(project.getElementName(), project.getConfigNames(), project.getConfigSets());
        }
    }

    public ProjectNode getProject(IFile file) {
        return this.getProject(file.getProject().getName());
    }

    public ProjectNode getProject(String name) {
        return this.projects.containsKey(name) ? (ProjectNode)this.projects.get(name) : null;
    }

    public ProjectNode[] getProjects() {
        return this.projects.values().toArray(new ProjectNode[this.projects.size()]);
    }

    public boolean hasProjects() {
        return !this.projects.isEmpty();
    }

    public void addProject(String project, Collection configs, Collection configSets) {
        ProjectNode node = this.getProject(project);
        if (node == null) {
            node = new ProjectNode(this, project);
            this.projects.put(project, node);
            this.propertyChanged(this, 1);
        }
        node.setConfigs(configs);
        node.setConfigSets(configSets);
    }

    public ConfigNode getConfig(IFile file) {
        ProjectNode project = this.getProject(file);
        if (project != null) {
            return project.getConfig(file);
        }
        return null;
    }

    public void removeConfig(IFile config) {
        this.removeConfig(config.getProject().getName(), config.getProjectRelativePath().toString());
    }

    public void removeConfig(String project, String config) {
        ProjectNode node = this.getProject(project);
        if (node != null) {
            node.removeConfig(config);
            if (!node.hasConfigs()) {
                this.projects.remove(project);
                this.propertyChanged(this, 1);
            }
        }
    }

    public boolean containsProject(IProject project) {
        return this.projects.containsKey(project.getName());
    }

    public void removeProject(IProject project) {
        this.projects.remove(project.getName());
        this.propertyChanged(this, 1);
    }

    public void remove(INode node) {
        this.projects.remove(node);
    }

    public void refreshViewer() {
        this.view.refresh();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return BeansCorePlugin.getModel();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getName());
        text.append(": projects=");
        text.append(this.projects);
        return text.toString();
    }
}

