/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import java.util.Comparator;
import org.springframework.util.comparator.CompoundComparator;
import org.springframework.util.comparator.NullSafeComparator;

public interface LabeledEnum
extends Comparable {
    public static final Comparator CODE_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Comparable c1 = ((LabeledEnum)o1).getCode();
            Comparable c2 = ((LabeledEnum)o2).getCode();
            return c1.compareTo(c2);
        }
    };
    public static final Comparator LABEL_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            LabeledEnum e1 = (LabeledEnum)o1;
            LabeledEnum e2 = (LabeledEnum)o2;
            NullSafeComparator comp = new NullSafeComparator(String.CASE_INSENSITIVE_ORDER, true);
            return comp.compare(e1.getLabel(), e2.getLabel());
        }
    };
    public static final Comparator DEFAULT_ORDER = new CompoundComparator(new Comparator[]{LABEL_ORDER, CODE_ORDER});

    public Class getType();

    public Comparable getCode();

    public String getLabel();
}

