/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescription;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionReader;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionWriter;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.AbstractSourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;

public class BeansProject
extends AbstractSourceModelElement
implements IBeansProject {
    private IProject project;
    private BeansProjectDescription description;

    public BeansProject(IProject project) {
        super((IModelElement)BeansCorePlugin.getModel(), project.getName());
        this.project = project;
    }

    public int getElementType() {
        return 2;
    }

    public IModelElement[] getElementChildren() {
        ArrayList children = new ArrayList(this.getDescription().getConfigs());
        children.addAll(this.getDescription().getConfigSets());
        return children.toArray(new IModelElement[children.size()]);
    }

    public IResource getElementResource() {
        return this.project;
    }

    public void accept(IModelElementVisitor visitor) {
        if (visitor.visit((IModelElement)this)) {
            IModelElement element;
            Iterator iter = this.description.getConfigs().iterator();
            while (iter.hasNext()) {
                element = (IModelElement)iter.next();
                element.accept(visitor);
            }
            iter = this.description.getConfigSets().iterator();
            while (iter.hasNext()) {
                element = (IModelElement)iter.next();
                element.accept(visitor);
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void reset() {
        this.description = null;
    }

    public void addConfig(IFile file) {
        this.getDescription().addConfig(file);
    }

    public void removeConfig(IFile file) {
        this.getDescription().removeConfig(file);
        BeansProjectDescriptionWriter.write(this.project, this.description);
    }

    public Collection getConfigNames() {
        return this.getDescription().getConfigNames();
    }

    public boolean hasConfig(IFile file) {
        return this.getDescription().hasConfig(file);
    }

    public boolean hasConfig(String configName) {
        return this.getDescription().hasConfig(configName);
    }

    public IBeansConfig getConfig(IFile configFile) {
        return this.getDescription().getConfig(configFile);
    }

    public IBeansConfig getConfig(String configName) {
        return this.getDescription().getConfig(configName);
    }

    public Collection getConfigs() {
        return this.getDescription().getConfigs();
    }

    public boolean hasConfigSet(String configSetName) {
        IBeansConfigSet configSet = this.getDescription().getConfigSet(configSetName);
        return configSet != null;
    }

    public Collection getConfigSets() {
        return this.getDescription().getConfigSets();
    }

    public boolean isBeanClass(String className) {
        Iterator configs = this.getDescription().getConfigs().iterator();
        while (configs.hasNext()) {
            IBeansConfig config = (IBeansConfig)configs.next();
            if (!config.isBeanClass(className)) continue;
            return true;
        }
        return false;
    }

    public Collection getBeanClasses() {
        HashSet beanClasses = new HashSet();
        Iterator configs = this.getDescription().getConfigs().iterator();
        while (configs.hasNext()) {
            IBeansConfig config = (IBeansConfig)configs.next();
            beanClasses.addAll(config.getBeanClasses());
        }
        return beanClasses;
    }

    public Collection getBeans(String className) {
        ArrayList beans = new ArrayList();
        Iterator configs = this.getDescription().getConfigs().iterator();
        while (configs.hasNext()) {
            IBeansConfig config = (IBeansConfig)configs.next();
            if (!config.isBeanClass(className)) continue;
            beans.addAll(config.getBeans(className));
        }
        return beans;
    }

    public void setConfigs(Collection configs) {
        BeansProjectDescription description = this.getDescription();
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        Iterator iter = description.getConfigNames().iterator();
        while (iter.hasNext()) {
            String config = (String)iter.next();
            if (configs.contains(config)) continue;
            IFile file = this.getConfig(config).getConfigFile();
            BeansCoreUtils.deleteProblemMarkers((IResource)file);
            toBeRemoved.add(config);
        }
        int i = 0;
        while (i < toBeRemoved.size()) {
            String config = (String)toBeRemoved.get(i);
            description.removeConfig(config);
            ++i;
        }
        description.setConfigNames(configs);
        BeansProjectDescriptionWriter.write(this.project, description);
    }

    public void setConfigSets(List configSets) {
        BeansProjectDescription description = this.getDescription();
        description.setConfigSets(configSets);
        BeansProjectDescriptionWriter.write(this.project, description);
    }

    public String toString() {
        return this.getElementName();
    }

    private BeansProjectDescription getDescription() {
        if (this.description == null) {
            this.description = BeansProjectDescriptionReader.read(this);
        }
        return this.description;
    }
}

