/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.figures.ConstructorArgumentFigure;
import org.springframework.ide.eclipse.beans.ui.graph.figures.PropertiesFigure;
import org.springframework.ide.eclipse.beans.ui.graph.figures.ShadowedLineBorder;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;

public class BeanFigure
extends Figure {
    public static final Color COLOR = new Color(null, 255, 255, 206);
    protected Bean bean;

    public BeanFigure(Bean bean) {
        this.bean = bean;
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new ShadowedLineBorder(ColorConstants.black, 1, 4));
        this.setBackgroundColor(COLOR);
        this.setOpaque(true);
        this.add((IFigure)this.createLabel(bean));
        if (bean.hasConstructorArguments()) {
            this.add((IFigure)this.createConstructorArguments(bean));
        }
        if (bean.hasProperties()) {
            this.add((IFigure)this.createProperties(bean));
        }
    }

    protected Label createLabel(Bean bean) {
        Label label = new Label();
        label.setText(bean.getName());
        if (bean.isRootBean()) {
            label.setIcon(BeansGraphImages.getImage("org.springframework.ide.eclipse.beans.ui.graph.rootbean_obj.gif"));
            if (bean.getClassName() != null) {
                label.setToolTip((IFigure)new Label("Class: " + bean.getClassName()));
            } else {
                label.setToolTip((IFigure)new Label("Class: <no class specified>"));
            }
        } else {
            label.setIcon(BeansGraphImages.getImage("org.springframework.ide.eclipse.beans.ui.graph.childbean_obj.gif"));
            label.setToolTip((IFigure)new Label("Parent: " + bean.getParentName()));
        }
        return label;
    }

    protected ConstructorArgumentFigure createConstructorArguments(Bean bean) {
        ConstructorArgument[] cargs = bean.getConstructorArguments();
        ConstructorArgumentFigure figure = new ConstructorArgumentFigure();
        int i = 0;
        while (i < cargs.length) {
            ConstructorArgument carg = cargs[i];
            Label label = new Label(carg.getName());
            label.setIcon(BeansGraphImages.getImage("org.springframework.ide.eclipse.beans.ui.graph.constructor_obj.gif"));
            Object value = carg.getBeanConstructorArgument().getValue();
            label.setToolTip((IFigure)new Label(this.createToolTipForValue(value)));
            figure.add((IFigure)label);
            ++i;
        }
        return figure;
    }

    protected PropertiesFigure createProperties(Bean bean) {
        Property[] props = bean.getProperties();
        PropertiesFigure properties = new PropertiesFigure();
        int i = 0;
        while (i < props.length) {
            Property prop = props[i];
            Label label = new Label(prop.getName());
            label.setIcon(BeansGraphImages.getImage("org.springframework.ide.eclipse.beans.ui.graph.property_obj.gif"));
            Object value = prop.getBeanProperty().getValue();
            label.setToolTip((IFigure)new Label(this.createToolTipForValue(value)));
            properties.add((IFigure)label);
            ++i;
        }
        return properties;
    }

    private String createToolTipForValue(Object value) {
        StringBuffer toolTip = new StringBuffer("Value: ");
        if (value == null) {
            toolTip.append("NULL");
        } else if (value instanceof RuntimeBeanReference) {
            toolTip.append('<');
            toolTip.append(((RuntimeBeanReference)value).getBeanName());
            toolTip.append('>');
        } else if (value instanceof BeanDefinitionHolder) {
            toolTip.append('{');
            toolTip.append(((BeanDefinitionHolder)value).getBeanName());
            toolTip.append('}');
        } else {
            toolTip.append(value.toString());
        }
        return toolTip.toString();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getClientArea());
        }
    }

    public String toString() {
        Rectangle rect = this.getBounds();
        return "BeanFigure '" + this.bean.getName() + "': x=" + rect.x + ", y=" + rect.y + ", width=" + rect.width + ", height=" + rect.height;
    }
}

