/*
 * DVD code copyright (C) 2002, 2003 Jan Panteltje <panteltje@yahoo.com>,
 * original CVD and SVCD code by unknown author.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

// prog for encoding DVD, CVD and SVCD subtitles and multiplexing them into an mpeg
// available under GPL v2


#define _FILE_OFFSET_BITS   64

#define VERSION "0.5"

#define SUB_BUFFER_MAX		53220 

#define CVD_SUB_CHANNEL		0x0
#define SVCD_SUB_CHANNEL	0x70
#define DVD_SUB_CHANNEL		0x20

/* for mode */
#define DVD_SUB		0
#define CVD_SUB		1
#define SVCD_SUB	2

/* for header_mode */
#define FIRST_FIRST	0
#define NEXT_FIRST	1
#define NEXT_NEXT	2


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#define psbufs 10
#define mintime 4

#ifndef O_BINARY
#define O_BINARY 0 //for mingw
#endif


#define optimize 0
#define until_next_sub 1 //if 0 subs without length are made when subs are overlapping
#define tbs  90
#define even_yofs 1
#define even_xd 1

int debug_flag;


#define maxx 720
#define maxy 576    

int dvd_encode();
int make_stop_packet();
int read_bmp(char *name);
size_t cwrite(int fd, const void *buf, size_t count);
size_t cread(int fd, void *buf, size_t count);


int background_contrast;
int pattern_contrast;
int emphasis1_contrast;
int emphasis2_contrast;

int current_background_contrast;
int current_pattern_contrast;
int current_emphasis1_contrast;
int current_emphasis2_contrast;


int submux_command = 0;
int current_submux_command;

int c_start_line;
int c_end_line;

int c_h_start[16];

int c_background[16];
int c_pattern[16];
int c_emphasis1[16];
int c_emphasis2[16];

int c_contrast0[16];
int c_contrast1[16];
int c_contrast2[16];
int c_contrast3[16];

int c_h_blocks;


int current_c_start_line;
int current_c_end_line;

int current_c_h_start[16];

int current_c_background[16];
int current_c_pattern[16];
int current_c_emphasis1[16];
int current_c_emphasis2[16];

int current_c_contrast0[16];
int current_c_contrast1[16];
int current_c_contrast2[16];
int current_c_contrast3[16];

int current_c_h_blocks;
int colors_specified_flag;

unsigned char *change_colcon_size;


typedef struct
{
unsigned char r, g, b, t;
} palt;

palt pal_[4], pal[4];
palt epal[4];

typedef struct
	{
	unsigned short int BM;
	unsigned int size;
	unsigned int r0;
	unsigned int ofs;
	unsigned int hsize;
	unsigned int x;
	unsigned int y;
	unsigned short int bplanes;
	unsigned short int bpp;
	unsigned int comp;
	unsigned int imgsize;
	unsigned int xpm,ypm;
	unsigned int cused;
	unsigned int cimp; 
	} __attribute__ ((packed)) bmpt;

unsigned char bb, bc;
unsigned char *sub, *cbuf;
unsigned char *img, *fimg;
unsigned char nbuf[256];
FILE *fds;

unsigned int subo, x0, y0, xd, yd, x0_, y0_, xd_, yd_;
unsigned int iline, progr, skip;
int sd, sd_;
int tofs, spts, nspts, lvpts;
int ofs, ofs1, io, debug, svcd;
static int pattern, background, emphasis1, emphasis2;
static int current_pattern, current_background, current_emphasis1, current_emphasis2;


#define maxx 720
#define maxy 576

char header[32]; // msu hold enough space form max header size (15) plus max stuffing bytes (7) + svcd stuff


void mkpackh(unsigned long int time, unsigned short int ext, unsigned int muxrate, unsigned char stuffing)
{
header[0] = 0x44 | ((time >> 27) & 0x38) | ((time >> 28) & 3);
header[1] = (time >> 20);
header[2] = 4 | ((time >> 12) & 0xf8) | ((time >> 13) & 3);
header[3] = (time >> 5);
header[4] = 4 | ((time & 31) << 3) | ((ext >> 7) & 2);
header[5] = 1 | (ext << 1);
header[6] = muxrate >> 14;
header[7] = muxrate >> 6;
header[8] = 3 | (muxrate << 2);
header[9] = 0xF8 | stuffing;
}


void mkpesh0(unsigned long int pts, unsigned char id)
{   
header[0] = 0x81;  
header[1] = 0x80;	//pts flag
header[2] = 5;
header[3] = 0x21 | ((pts >> 29) & 6);
header[4] = pts >> 22;
header[5] = 1 | (pts >> 14);
header[6] = (pts >> 7);
header[7] = 1 | (pts << 1);
header[8] = id;
}


void mkpesh1(unsigned long int pts, unsigned char id)
{   
header[0] = 0x81;  
header[1] = 0x81;	//pts flag + pes extension flag
header[2] = 8;
header[3] = 0x21 | ((pts >> 29)&6);
header[4] = pts >> 22;
header[5] = 1 | (pts >> 14);
header[6] = (pts >> 7);
header[7] = 1 | (pts << 1);
header[8] = 0x1e; //P - STD_buffer_flag
header[9] = 0x60; //buffer scale
header[10] = 0x3a; //buffer size (wtf nu det r..) (svcdverifier tycker  att 64 r ett bra tal hr..)
header[11] = id;
}

void mkpesh2 (unsigned char id)
{
header[0] = 0x81;  
header[1] = 0;
header[2] = 0;
header[3] = id;
}


unsigned long int getgts(unsigned char *buf)
{
if (((buf[8]&3) != 3) || ((buf[5]&1) != 1) || ((buf[4]&4) != 4)||((buf[2]&4) != 4)|| ((buf[0]&0xc4) != 0x44)) return -1;
return (buf[4] >> 3) + (buf[3]*32) + ((buf[2]&3)*32*256) + ((buf[2]&0xf8)*32*128) + (buf[1]*1024*1024) + ((buf[0]&3)*1024*1024*256) + ((buf[0]&0x38)*1024*1024*256*2);
}


unsigned int getmuxr(unsigned char *buf)
{
return (buf[8] >> 2)|(buf[7]*64)|(buf[5]*16384);
}


unsigned int getpts(unsigned char *buf)
{
if (!(buf[1]&0xc0) || (buf[2]<4) | ((buf[3]&0xe1) != 0x21) || ((buf[5]&1) != 1) || ((buf[7]&1) != 1)) return -1;
return (buf[7] >> 1) + buf[6]*128 + ((buf[5]&254)*16384) + buf[4]*16384*256 + ((buf[3]&14)*16384*256*128);
}
 
#define nco if (subo<65536) sub[subo++]
#define a2b(b) do { bb = (bb << 2) + b; bc--; if (!bc) { bc = 4;  nco = bb; }} while (0)


int svcd_encode()
{
unsigned int x,y,c,l2o;
double a;
 
subo = 2;
if (sd != -1)
	{
	nco = 0x2e;  nco = 0;
	nco = sd >> 24; nco = sd >> 16;
	nco = sd >> 8;  nco = sd;
	}
else
	{
	nco = 0x26;
	nco = 0;
	} 
 
if (debug > 2)
	fprintf(stderr,\
	"sd: %d   xd: %d  yd: %d  x0: %d  y0: %d\n", sd, xd, yd, x0, y0); 

nco = (x0 >> 8); nco = x0;
nco = (y0 >> 8); nco = y0;
nco = xd >> 8; nco = xd;
nco = yd >> 8; nco = yd;
for(c = 0;c<4;c++)
	{
	a = (0.257 * (double)epal[c].r) + (0.504*(double)epal[c].g) + (0.098*(double)epal[c].b) + 16;                 
	if (a>255) a = 255; if (a<0) a = 0; 
	nco = a;

	a = (0.439 * (double)epal[c].r) - (0.368 * (double)epal[c].g) - (0.071 * (double)epal[c].b)  +  128; 
	if (a>255) a = 255; if (a<0) a = 0; 
	nco = a;

	a = -(0.148 * (double)epal[c].r) - (0.291 * (double)epal[c].g)  +  (0.439 * (double)epal[c].b) + 128; 
	if (a>255) a = 255; if (a<0) a = 0; 
	nco = a;
  
	nco = epal[c].t;  
	} 
 
nco = 0; //?????
 
l2o = subo;
subo += 2;
y = 0;
odd_row: 
for(; y<yd; y += 2)
	{
	bc = 4; bb = 0;
	for(x = 0; x<xd;x++)
		{
		if ((c = fimg[y*xd+x]) != 0) a2b(c);
		else
			{
			c = 1;
			while (((++x)<xd)  &&  (!fimg[y*xd+x])) c++;
			x--;
			while (c>4)
				{
				a2b(0);
				a2b(3);
				c -= 4;
				}
			a2b(0);
			a2b(c - 1);
			}
		}
	if (bc != 4) nco = bb << (2*bc);
	}
 
if (!(y&1))
	{
	if (!(subo&1))
		{
		if (debug>3)
			fprintf(stderr,\
			"padded betweed fields with 1 byte to %d\n",subo%4);
		nco = 0;
		}
	y = 1;
	sub[l2o] = (subo - l2o - 2) >> 8;
	sub[l2o+1] = (subo - l2o - 2);
	goto odd_row;
	} 
 
nco = 0;// no additional commands
c = 0;
while (subo%4)
	{
	nco = 0; c++;
	}
if (debug>3) fprintf(stderr,"padded with %d byte\n",c);

sub[0] = subo >> 8;
sub[1] = subo;
if (subo == 65536) return -1;
else return subo;
} /* end function svcd_encode */


#define an(b) do { bb = (bb << 4)+(b); bc--; if (!bc) { bc = 2;  nco = bb; }} while (0)


int cvd_encode()
{
unsigned int x, y, c, d;
double a;
 
subo = 4;
ofs = 4;

c = 0;
for(y = 0; y < yd; y += 2)
	{
	odd_row_cvd: 
	bc = 2; bb = 0;
	for(x = 0; x < xd;)
		{
		d = fimg[y * xd + x];
		c = 1;
		while (((++x) < xd)  &&  (fimg[y * xd + x] == d) ) c++;
		if(x == xd)
			{
			an(0);
			an(d);
			if (bc != 2) an(0);
			continue;
			}
	   
		while(c > 3)
			{
			an(12 + d);
			c -= 3;
			}
   
		an((c << 2) + d);
		}
	}
 
if(!(y & 1))
	{
	y = 1;
	ofs1 = subo;
	goto odd_row_cvd;
	}  
 
sub[2] = subo >> 8;
sub[3] = subo;

/* setting this to all 0xff then no more subtitles */
nco = 0x0c;
nco = 0;
nco = 0;
nco = 0;
 
/* set pallette 0-3 */
for(c = 0; c < 4; c++)
	{
//#define nco if (subo<65536) sub[subo++]
	nco = 0x24 + c;
	if(debug > 3)
		{
		fprintf(stderr, "c=%d R=%.2f G=%.2f B=%.2f\n",\
		c, (double)epal[c].r, (double)epal[c].g, (double)epal[c].b);
		}

	/* Y */ 
	a = (0.257 * (double)epal[c].r) + (0.504 * (double)epal[c].g) +\
	(0.098 * (double)epal[c].b) + 16.0;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "Y=%.2f sub[subo]=%ud\n", a, sub[subo - 1]);
		}

	/* U */
	a = (0.439 * (double)epal[c].r) - (0.368 * (double)epal[c].g) -\
	(0.071 * (double)epal[c].b) + 128.0;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "U=%.2f sub[subo]=%ud\n", a, sub[subo - 1]);
		}

	/* V */
	a = -(0.148 * (double)epal[c].r) - (0.291 * (double)epal[c].g) +\
	(0.439 * (double)epal[c].b) + 128.0;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "V=%.2f  sub[subo]=%ud (0x%0x)\n",\
		a, sub[subo - 1], sub[subo - 1]);
		}

	} /* end for pallette 0-3 */
 
/* sethighlight  pallette  */
for(c = 0; c < 4; c++)
	{
//#define nco if (subo<65536) sub[subo++]
	nco = 0x2c + c;
	if(debug > 3)
		{
		fprintf(stderr, "c=%d R=%.2f G=%.2f B=%.2f\n",\
		c, (double)epal[c].r, (double)epal[c].g, (double)epal[c].b);
		}

	/* Y */ 
	a = (0.257 * (double)epal[c].r) + (0.504 * (double)epal[c].g) +\
	(0.098 * (double)epal[c].b) + 16;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "Y=%.2f sub[subo]=%d\n", a, sub[subo - 1]);
		}

	/* U */
	a = (0.439 * (double)epal[c].r) - (0.368 * (double)epal[c].g) -\
	(0.071 * (double)epal[c].b) + 128;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "U=%.2f sub[subo]=%d\n", a, sub[subo - 1]);
		}

	/* V */
	a = -(0.148 * (double)epal[c].r) - (0.291 * (double)epal[c].g) +\
	(0.439 * (double)epal[c].b) + 128;
	if (a > 255) a = 255;
	if (a < 0) a = 0;
	nco = a;
	if(debug > 3)
		{
		fprintf(stderr, "V=%.2f  sub[subo]=%d\n", a, sub[subo - 1]);
		}

	} /* end for pallette 4-7 */

if(debug > 3)
	{
	fprintf(stderr,\
	"epal[0].t=%d epal[1].t=%d epal[2].t=%d epal[3].t=%d\n",\
	epal[0].t, epal[1].t, epal[2].t, epal[3].t);
	}

/* x0, y0 */
nco = 0x17;
nco = 0xf0 + (x0 >> 6);
nco = (x0 << 2) + (y0 >> 8);
nco = y0;
 
/* xd, yd */
nco = 0x1f;
nco = 0xf0 + ((x0 + xd - 1) >> 6);
nco = ((x0 + xd - 1) << 2) + ((y0 + yd - 1) >> 8);
nco = y0 + yd - 1;
 
/* 0x37 is pallette.t 0-3 contrast */
nco = 0x37;
nco = 0xff;
//nco = 0x00;
//nco = 0xff;
nco = (epal[3].t & 0xf0) + (epal[2].t >> 4);
nco = (epal[1].t & 0xf0) + (epal[0].t >> 4);

if(debug > 3)
	{
	fprintf(stderr, "EPALS nco0(2 3h, 2l)=%02x nco1(2 1h,0l)=%02x\n",\
	sub[subo - 1], sub[subo - 2]);
	}

/* 0x3f is high light pallette.t 4-7 contrast */
nco = 0x3f;
nco = 0xff;
nco = 0xff;
nco = 0xf0;

/* ofs is 4 ? is offset in bitmap to first field data (interlace) */ 
nco = 0x47;
nco = 0xff;
nco = ofs >> 8;
nco = ofs;
 
/* ofs1 is offset to other field in bitmap (interlace) */
nco = 0x4f;
nco = 0xff;
nco = ofs1 >> 8;
nco = ofs1;
 
/* unknown!!! (in RX too!) setting all to 0xff keeps the pic on screen! */
nco = 0x0c;
nco = 0;
nco = 0;
nco = 0; 
 
/* sd, time in display, duration */
nco = 0x04;
nco = sd >> 16;
nco = sd >> 8;
nco = sd;
 
// IA3
//0: 02 68 02 24
//1: 08 61 08 1d
//2: 08 6b 08 27
//3: 07 6b 07 27
//4: 05 40 04 fc
//5: 08 81 08 3d
//6: 05 4f 15 40


sub[0] = subo >> 8;
sub[1] = subo;
nco = 4;
nco = 8;
nco = 12;
nco = 16;

if(subo == 65536) return -1;
else return subo;
} /* end function cvd_encode */


int h2d(char *ch)
{
int a;
if ((ch[0] < 48) || ((ch[0] > 57)  &&  (ch[0] < 97)) || (ch[0] > 102)) return 0;
if ((ch[1] < 48) || ((ch[1] > 57)  &&  (ch[1] < 97)) || (ch[1] > 102)) return 0;
if (ch[0] > 57) a = ch[0] - 87; else a = ch[0] - 48;
a = a << 4;
if (ch[1] > 57) a += ch[1] - 87; else a += ch[1] - 48;

return a;
} /* end function svcd_encode */


void rns()
{
unsigned char lbuf[256 + 80];
int a,b, i;

if(debug_flag)
	{
	fprintf(stdout, "rns(): arg none\n");
	}

colors_specified_flag = 0;

lns: 
if (feof(fds) || (!fgets(lbuf, 256 + 80, fds)) )
	{
	nspts = -1;

	return;
	} 

iline++;
 
/* find start of line ? */
if (strlen(lbuf) == 256 + 80 - 1) while(getc(fds) != 10);

/* scip comments and stuff ? */  
if ((lbuf[0] == '#') || (lbuf[0] == ' ') || (lbuf[0] == 0)) goto lns;
 
/* get bitmap filename */ 
a = 0;
while(lbuf[a]  &&  (lbuf[a] != 32)  &&  (lbuf[a] != 9)) nbuf[a++] = lbuf[a];
/* string termination */
nbuf[a] = 0;

/* get start time */
while((lbuf[a])  &&  !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++;
 nspts = atoi(lbuf + a) * 60 * 60 * 90000; a += 3;
nspts += atoi(lbuf + a) * 60 * 90000; a += 3;
nspts += atoi(lbuf + a) * 90000; a += 3;
nspts += atoi(lbuf + a) * 900; a += 2;
 
/* get stop time */
while((lbuf[a]) && !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++;
sd_ = atoi(lbuf+a) * 60 * 60 * 90000; a += 3;
sd_ += atoi(lbuf + a) * 60 * 90000; a += 3;
sd_ += atoi(lbuf + a) * 90000; a += 3;
sd_ += atoi(lbuf + a) * 900; a += 2;
 
if(a > strlen(lbuf))
	{
	skip++;
	if (debug > -1) fprintf(stderr,"warning, unable to parse line %d, skipping\n", iline);
	goto lns;
	} 

/* sanity test */
if (!sd_) sd_ = -1;
else
	{
	if (sd_ <= nspts)
		{
		if (debug > -1)
			{
			fprintf(stderr, "warning: sub on line %d has end<=start, skipping\n", iline);
			}

		skip++;
		goto lns;
		}
	 sd_ -= nspts;
	}
 
nspts += tofs;

/* h size */
while((lbuf[a])  &&  !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++; 
xd_ = atoi(lbuf + a);	

/* scip space */
while((lbuf[a])  &&  !((lbuf[a] < 48) || (lbuf[a] > 57))) a++;

/* v size */
while((lbuf[a])  &&  !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++;
yd_ = atoi(lbuf + a);

/* scip space (did he never hear about scanf????? */
while((lbuf[a])  &&  !((lbuf[a] < 48) || (lbuf[a] > 57))) a++;
 
/* x pos */
while((lbuf[a])  &&  !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++;
x0_ = atoi(lbuf + a);

/* scip space */
while((lbuf[a])  &&  !((lbuf[a] < 48) || (lbuf[a] > 57))) a++;
 
/* y pos */
while((lbuf[a])  &&  !((lbuf[a] > 47)  &&  (lbuf[a] < 58))) a++;
if(!lbuf[a])
	{
	skip++;
	if (debug>-1)
		{
		fprintf(stderr, "warning, unable to parse line %d, skipping\n",iline);
		}

	goto lns;
	} 
y0_ = atoi(lbuf + a);

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;
 
/* 4 contrast values */
for(b = 0; b < 4; b++)
	{
	/* get value */
	while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
	if (lbuf[a])
		{
		pal_[b].t = atoi(lbuf + a);

		if(b == 0) background_contrast =  atoi(lbuf + a);
		if(b == 1) pattern_contrast =  atoi(lbuf + a);
		if(b == 2) emphasis1_contrast =  atoi(lbuf + a);
		if(b == 3) emphasis2_contrast =  atoi(lbuf + a);
		}

	/* scip space */
	while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57))) a++;
  
	if (debug > 3)
		{
		fprintf(stderr,\
		"pal: %d #%.2x%.2x%.2x %d\n",\
		b, pal_[b].r, pal_[b].g, pal_[b].b, pal_[b].t);
		}
	}

/* 
Set pointers to the color lookup table in the IFO (CLUT) for each parameter.
Range = 0 - 15
*/

/* defaults */
background  = 0;
pattern     = 1;
emphasis1   = 2;
emphasis2   = 3;

/* get character background pointer in CLUT */ 
while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
if (lbuf[a])  background = atoi(lbuf + a);
background &= 15;

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

/* get character pattern pointer in CLUT */ 
while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
if (lbuf[a]) pattern = atoi(lbuf + a);
pattern &= 15;

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

/* get character emphasis1 pointer in CLUT */ 
while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
if (lbuf[a]) emphasis1 = atoi(lbuf + a);
emphasis1 &= 15;

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

/* get character emphasis2 pointer in CLUT */ 
while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
if (lbuf[a]) emphasis2 = atoi(lbuf + a);
emphasis2 &= 15;

colors_specified_flag = 1;

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


/* get submux-dvd control command code */ 

/* for compatibility with old versions: PIXELS + FORCED START + STOP = 1 + 16 + 2 = 19 */
submux_command = 19;

while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
if (lbuf[a]) submux_command = atoi(lbuf + a);

/* scip space */
while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

/* in case of COL_CON read the values */
/* default */
c_h_blocks = 0;
if(submux_command & 4)
	{
	/* read vertical region start */
	while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
	if (lbuf[a]) c_start_line = atoi(lbuf + a);

	/* scip space */
	while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

	/* read vertical region end */
	while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
	if (lbuf[a]) c_end_line = atoi(lbuf + a);

	/* scip space */
	while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;

	/* read data for up to 16 horizontal regions */
	while(1)
		{
		if( ! lbuf[a] ) break;

		/* read c_h_start[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_h_start[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;



		/* read c_contrast0[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_contrast0[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_contrast1[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_contrast1[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_contrast2[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_contrast2[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_contrast3[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_contrast3[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;



 		/* read c_background[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_background[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_pattern[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_pattern[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_emphasis1[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_emphasis1[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		/* read c_emphasis2[c_h_blocks] */
		while( (lbuf[a])  &&  !( (lbuf[a] > 47) && (lbuf[a] < 58) ) ) a++;
		if (lbuf[a]) c_emphasis2[c_h_blocks] = atoi(lbuf + a);

		/* scip space */
		while( (lbuf[a])  &&  !( (lbuf[a] < 48) || (lbuf[a] > 57) ) ) a++;


		c_h_blocks++;
		} /* end for all horizontal regions in this vertical region */

	c_h_blocks--;

	if(debug_flag)
		{
		for(i = 0; i < c_h_blocks; i++)
			{
			fprintf(stdout,\
			"rns(): c_h_start=%d\n\
			c_background=%d c_pattern=%d c_emphasis1=%d c_emphasis2=%d\n\
			c_contrast0=%d c_contrast1=%d c_contrast2=%d c_contrast3=%d\n",\
			c_h_start[i],\
			c_background[i], c_pattern[i], c_emphasis1[i], c_emphasis2[i],\
			c_contrast0[i], c_contrast1[i], c_contrast2[i], c_contrast3[i]); 			
			}		

		fprintf(stdout, "rns(): c_h_blocks=%d\n", c_h_blocks);
		}
	} /* end if submux_command & 4 */


if(debug_flag)
	{
	fprintf(stdout,\
	"rns(): background=%d pattern=%d emphasis1=%d emphasis2=%d submux_command=%d\n",\
	background, pattern, emphasis1, emphasis2, submux_command);
	}

if(debug > 2)
	{
	fprintf(stderr,\
	"img: %s, %d (%.2f) %d (%.2f) %d,%d %d,%d\n",\
	nbuf, nspts, (double)nspts / 90000, sd_, (double)sd_ / 90000, x0_,\
	y0_, xd_, yd_);
	}
} /* end function rns */


int imgfix()
{
int a, b, i, x0_, y0_, xd_, yd_, x, y, j;
int cst[4];
unsigned char c, r;
if (!optimize)
	{
	for(c = 0; c < 4; c++)
		{
		epal[c].r = pal[c].r;
		epal[c].g = pal[c].g;
		epal[c].b = pal[c].b;
		epal[c].t = pal[c].t;
		} 
	a = 0;
	for(y = 0; (y < yd) &&  (y < yd); y++) 
		for(x = 0; (x < xd)  &&  (x < xd); x++) fimg[a++] = img[a];
    
//#define P_TEST2
#ifdef P_TEST2 
 for(a = 0; a < 4; a++)
	{
	fprintf(stderr, "WAS P_TEST2 ORIGINAL setting\n\
	epal[%d].r=%d\n\
	epal[%d].g=%d\n\
	epal[%d].b=%d\n\
	epal[%d].t=%d\n",\
	a, epal[a].r,\
	a, epal[a].g,\
	a, epal[a].b,\
	a, epal[a].t);
	}
#endif /* P_TEST2 */

	return 1;
	}
 
//xd and yd should be multiples of 4...
a = 0;
x0_ = maxx;
xd_ = 0;
y0_ = yd_ = -1;
cst[0] = cst[1] = cst[2] = cst[3] = 0;
  
for(y = 0; y < yd; y++) 
	for(x = 0;x < xd; x++)
		{
		if (pal[img[a++]].t)
			{
			if (y0_ == -1) y0_ = y;
			if (x < x0_) x0_ = x;
			if (x > xd_) xd_ = x;
			yd_ = y;
			}
		}
  
if(yd_ != -1)
	{ 
	r = 0;

	if(svcd)
		{
		for(y = y0_; y < yd_; y++)
			for(x =x0_ ;x < xd_; x++) cst[ img[a] ]++;

		a = cst[0];
    
		for(i = 1; i < 4; i++) if (a < cst[i])
			{
			a = cst[i];
			r = i;
			}
		}
	else for(a = 3; a > 0;a--) if ( !pal[a].t) r = a;
  
//	if (debug>2)
		fprintf(stderr,"colors rotated %d steps\n", r);

	for(c = 0; c < 4; c++)
		{
		epal[c].r = pal[(c + r) % 4].r;
		epal[c].g = pal[(c + r) % 4].g;
		epal[c].b = pal[(c + r) % 4].b;
		epal[c].t = pal[(c + r) % 4].t;
		}

//#define P_TEST2
#ifdef P_TEST2 
 for(a = 0; a < 4; a++)
	{
	fprintf(stderr, "WAS P_TEST2 ROTATE setting\n\
	epal[%d].r=%d\n\
	epal[%d].g=%d\n\
	epal[%d].b=%d\n\
	epal[%d].t=%d\n",\
	a, epal[a].r,\
	a, epal[a].g,\
	a, epal[a].b,\
	a, epal[a].t);
	}
#endif /* P_TEST2 */

	r = 4 - r;
   
	xd_ -= x0_ -1;
	yd_ -= y0_ -1;
  
	b = 0;
	c = 0;
	for(a = 3; a > 0; a--) if (!epal[a].t) c = a;
  
	y = 0;
  
	if( ( (y0 + y0_) & 1)  &&  (even_yofs))
		{
		if (y0_) y0_--;
		else
			{
			for (j = 0;j < xd_ + xd; j++) fimg[b++] = c;
			y++;
			yd_++;
			y0--;
			} 
		} 
  
	if (even_xd) if (xd_ & 1) xd_++;
  
	a = y0_ * xd + x0_;

	for(;(y < yd_)  &&  (y < yd); y++)
		{
		for(x = 0; (x < xd_) && (x < xd); x++)
			fimg[b++] = (img[a++] + r) % 4;

		if(xd > xd_) a += xd - xd_;
		if(xd < xd_) for (j = 0; j < xd_ - xd; j++)
			fimg[b++] = c;
		} 
 
	while (yd_ & 1)
		{
		for(x = 0; x < xd_; x++) fimg[b++] = c;
		yd_++;
		} 
  
	x0 += x0_;
	y0 += y0_;
	xd = xd_;
	yd = yd_;
 
	if (debug > 2)
		{
		fprintf(stderr,\
		"x0: %d  y0: %d  w: %d  h: %d  start: %fs  len: %fs\n",\
		x0, y0, xd, yd, (double)spts / 90000, (double)sd / 90000); 
		}

	return 1;
	} 
 
return 0;
} /* end function imgfix */



unsigned char *subtitle_image_buffer;
unsigned char *subtitle_packet_buffer;
unsigned char *even_buf, *odd_buf;

int main(int argc,char **argv)
{
int fdi, fdo;
unsigned int q, c, a, i, j, k, gts, pts, muxrate, sector_size, frame, lps;
unsigned short int b, vss, subno;
unsigned char cc, seq, psbuf[psbufs], substr, *nptr[3], ncnt;
int sub_size;
int bytes_send;
unsigned short int header_size;
int mode;
int last_pts;
int max_sub_size;
int bytes_to_sector;
int stuffing_size;
int padding_size;
int bytes_left;
int bytes_free;
int available_space;
int header_mode;
int packet_length;
int pack_extention_flag1;
int pack_extention_flag2;
int pack_stuffing_flag;
int first_flag;
int pes_scrambling_control;
int pes_priority_flag;
int data_alignment_indicator_flag;
int copyright_flag;
int original_flag;


c_start_line = 2;

c_end_line = 499;

c_h_start[0] = 100;
c_h_start[1] = 200;
c_h_start[2] = 300;

c_background[0] = 0;
c_background[1] = 0;
c_background[2] = 0;

c_pattern[0] = 5;
c_pattern[1] = 9;
c_pattern[2] = 13;

c_emphasis1[0] = 2;
c_emphasis1[1] = 2;
c_emphasis1[2] = 2;

c_emphasis2[0] = 3;
c_emphasis2[1] = 3;
c_emphasis2[2] = 3;

c_contrast0[0] = 0;
c_contrast0[1] = 0;
c_contrast0[2] = 0;

c_contrast1[0] = 15;
c_contrast1[1] = 15;
c_contrast1[2] = 15;

c_contrast2[0] = 15;
c_contrast2[1] = 15;
c_contrast2[2] = 15;

c_contrast3[0] = 0;
c_contrast3[1] = 0;
c_contrast3[2] = 0;

c_h_blocks = 3; 


mode = 0; /* default DVD */

odd_buf = malloc(maxx * maxy);
if(! odd_buf)
	{
	fprintf(stderr, "submux-dvd(): could not allocate space for odd_buf, aborting.\n");

	exit(1);
	}

even_buf = malloc(maxx * maxy);
if(! even_buf)
	{
	fprintf(stderr, "submux-dvd(): could not allocate space for even_buf, aborting.\n");

	exit(1);
	}

subtitle_image_buffer = malloc(maxx * maxy * 3);
if(! subtitle_image_buffer)
	{
	fprintf(stderr, "submux-dvd(): could not allocate space for subtitle_image_buffer, aborting.\n");

	exit(1);
	}

subtitle_packet_buffer = malloc( SUB_BUFFER_MAX); //maxx * maxy * 3); //SUB_BUFFER_MAX);
if(! subtitle_packet_buffer)
	{
	fprintf(stderr, "submux-dvd(): could not allocate space for subtitle_packet_buffer, aborting.\n");

	exit(1);
	}
//fprintf(stderr, "malloc subtitle_packet_buffer=%p\n", subtitle_packet_buffer);

sub = subtitle_packet_buffer;

cbuf = malloc(65536);
img = malloc(maxx * maxy);
fimg = malloc(maxx * maxy);
 

fprintf(stderr, "submux-dvd-%s copyright 2003 Jan Panteltje\n", VERSION);

if (argc<4)
	{
parse_err: 
	fprintf(stderr, "submux-dvd [options] [in.mpg] [script.sub] [out.mpg]\n");
	fprintf(stderr, "options:\n");  
	fprintf(stderr, "-c             set copyright bit.\n");
	fprintf(stderr, "-m             0 = DVD mode (default), 1 = CVD, 2 = SVCD.\n");  	
	fprintf(stderr, "-s <stream>	number of the substream to insert (default 0).\n");   
	fprintf(stderr, "-t <time>      time in seconds (with decimals) to offset the script.\n");  
	fprintf(stderr, "-v <level>     verbosity level (default 0).\n");  
	fprintf(stderr, "-o             set original bit ( not a copy).\n");
	fprintf(stderr, "-P 		    enable progress indicator.\n");     
	fprintf(stderr, "\n");
	exit(-1);
	}

gts = 0;
tofs = 0;
progr = 0;
debug = 0;
ncnt = 0;
substr = 0;

i = 1;

/* for DVD spu flags */
pes_scrambling_control = 0;
pes_priority_flag = 0;
data_alignment_indicator_flag = 0;
copyright_flag = 0;
original_flag = 0;

while(i < argc)
	{
	if (argv[i][0] != '-')
		{
		if (ncnt == 3) goto parse_err;
		nptr[ncnt++] = argv[i];
		i++;
		continue;   
		}
  
switch(argv[i][1])
	{
	case '-':
		i++;
		while ((i < argc)  &&  (ncnt<3)) nptr[ncnt++] = argv[i++];
		if (argc != i) goto parse_err;
		continue; 
	case 'c':
		copyright_flag = 1;
		i++;
		break;
	case 'm':
		if (strlen(argv[i]) > 2) mode = atoi(argv[i] + 2);
		else
			{
			i++;
			if(i == argc) goto parse_err;
			mode = atoi(argv[i]);
			}     
		i++;
		break;
	case 'o':
		original_flag = 1;
		i++;
		break;
	case 's':
		if (strlen(argv[i]) > 2) substr = atoi(argv[i] + 2);
		else
			{
			i++;
			if(i == argc) goto parse_err;
			substr = atoi(argv[i]);
			}     
		i++;
		break;
	case 't':
		if (strlen(argv[i])>2) tofs = atof(argv[i] + 2) * 90000;
		else
			{
			i++;
			if (i == argc) goto parse_err;
			tofs = atof(argv[i]) * 90000;
			}
		i++;
	    break;
	case 'v':
		if (strlen(argv[i]) > 2) debug = atoi(argv[i] + 2);
		else
			{
			i++;
			if (i == argc) goto parse_err;
			debug=atoi(argv[i]);
			} 
		i++;
		break;
	case 'P':
		progr=1;
		i++;
		break;
	default:
		fprintf(stderr, "unknown option %s\n\n", argv[i]);
		goto parse_err;
		} 
	} /* end switch argv */
 
switch(mode)
	{
	case DVD_SUB:
	default:	
		svcd = 0;
		substr += DVD_SUB_CHANNEL;
		muxrate = 4400; // 0x1131; // 4400 kbps
		sector_size = 2048; //2324;
		break;
	case CVD_SUB:
		svcd = 0;
		substr += CVD_SUB_CHANNEL;
		muxrate = 2600; //0x0a28; // 2600 kbps
		sector_size = 2324;
		break;
	case SVCD_SUB:
		svcd = 4;
		substr += SVCD_SUB_CHANNEL;
		muxrate = 4400; //0x1131; // 4400 kbps
		sector_size = 2324;
		break;
	} /* end switch mode */


if(!ncnt) nptr[ncnt++] = "in.mpg";
if(ncnt == 1) nptr[ncnt++] = "script.sub";
if(ncnt == 2) nptr[ncnt++] = "out.mpg";

fdi = open(nptr[0], O_RDONLY | O_BINARY);
if(fdi<0)
	{
	fprintf(stderr, "unable to open file %s\n",  nptr[0]);
	return -1;
	}
fds = fopen(nptr[1], "r");
if(!fds)
	{
	fprintf(stderr, "unable to open file %s\n",  nptr[1]);
	return -1;
	}

fdo = open(nptr[2], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 511);
if(fdo<0)
	{
	fprintf(stderr, "unable to open file %s\n",  nptr[2]);
	return -1;
	}
 
if(tofs  &&  (debug > 0) )
	fprintf(stderr, "subtitles offset by %fs\n", (double)tofs / 90000);
 
pal_[0].t = 0;
pal_[1].t = 255;
pal_[2].t = 255;
pal_[3].t = 255;

iline=0;

skip=0;
 
rns();

max_sub_size = 0;
i = 0;
header_size = 12;
first_flag = 1;
vss = 0;
frame = 0;
lps = 0;
lvpts = -1;
subno = -1;
available_space = sector_size;	/* only to keep gcc -Wall happy */
packet_length = 0; 				/* only to keep gcc -Wall happy */

while(cread(fdi, &c, 4) == 4)
	{
	bytes_to_sector = 0;
	cwrite(fdo, &c, 4);
	bytes_to_sector += 4; // have 4!!!
   
	if(progr)
		{
		i = lseek(fdo, 0, SEEK_CUR);
		if (i > lps + 1024 * 1024 * 10)
			fprintf(stderr, "%d bytes of data written\r", lps = i);
		} 
   
	if(c == 0xba010000) /* packet start code */
		{ 
l_01ba:  
		if(debug > 5) fprintf(stderr, "pack_start_code\n");
		if(cread( fdi, psbuf, psbufs) < 1) break;
		a = getgts(psbuf);
		if(a != -1)
			{
			gts = a; 
			muxrate = getmuxr(psbuf);
			}
		else if (debug >- 1) fprintf(stderr, "incorrect pack header\n");
		
try_next:   
		/* wait for correct time to insert sub, leave time for vpts to occur */
		if( (lvpts != -1) && (nspts != -1) && (lvpts + 1 * 90000 > nspts) )
		/* 180 ms + 100kb = 200ms -> 380 ms = .38 * 90000 = 34200 */ 
			{
			/* save values read from .sub file, so we can already read next entry */
		    spts = nspts;
			xd = xd_;
			yd = yd_;
			x0 = x0_;
			y0 = y0_;
			sd = sd_; 
			for(a = 0; a < 4; a++) pal[a].t = pal_[a].t;

			current_background_contrast = background_contrast;
			current_pattern_contrast = pattern_contrast;
			current_emphasis1_contrast = emphasis1_contrast;
			current_emphasis2_contrast = emphasis2_contrast;

			current_pattern = pattern;
			current_background = background;
			current_emphasis1 = emphasis1;
			current_emphasis2 = emphasis2;
			current_submux_command = submux_command;

			current_c_start_line = c_start_line;
			current_c_end_line = c_end_line;

			for(k = 0; k < c_h_blocks; k++)
				{
				current_c_h_start[k] = c_h_start[k];

				current_c_background[k] = c_background[k];
				current_c_pattern[k] = c_pattern[k];
				current_c_emphasis1[k] = c_emphasis1[k];
				current_c_emphasis2[k] = c_emphasis2[k];

				current_c_contrast0[k] = c_contrast0[k];
				current_c_contrast1[k] = c_contrast1[k];
				current_c_contrast2[k] = c_contrast2[k];
				current_c_contrast3[k] = c_contrast3[k];
				}

			current_c_h_blocks = c_h_blocks;

			if(debug_flag)
				{
				fprintf(stdout,\
			"main(): current_pattern=%d current_background=%d current_emphasis1=%d current_emphasis2=%d\n\
				current_submux_command=%d\n",\
				current_pattern, current_background, current_emphasis1, current_emphasis2,\
				current_submux_command);

				for(k = 0; k < current_c_h_blocks; k++)
					{
					fprintf(stdout,\
					"main(): current_c_h_start=%d\n\
	current_c_background=%d current_c_pattern=%d current_c_emphasis1=%d current_c_emphasis2=%d\n\
	current_c_contrast0=%d current_c_contrast1=%d current_c_contrast2=%d current_c_contrast3=%d\n",\
					current_c_h_start[k],\
					current_c_background[k], current_c_pattern[k], current_c_emphasis1[k], current_c_emphasis2[k],\
					current_c_contrast0[k], current_c_contrast1[k], current_c_contrast2[k], current_c_contrast3[k]); 			
					}		
	
				fprintf(stdout, "main(): current_c_h_blocks=%d\n", current_c_h_blocks);
				}

			/* read bitmap data into img */
			a = read_bmp(nbuf);

			if(debug_flag)
				{
				fprintf(stderr, "after read_bmp(): xd=%d yd=%d x0=%d y0=%d\n", xd, yd, x0, y0);
				}

			rns(); // reads sub file into xd_ yd_ x0_ y0_ sd_ pattern background emphasis1 emphasis2

			if( feof(fds) )
				{
				fprintf(stderr, "Found EOF in .sub file.\n");
				}
    
			if (a)
				{
				if(debug > -1)
					{
					fprintf(stderr, "bad image,  skipping line %d\n", iline - 1);
					}
	
				skip++;
				goto try_next;
				}

		    if(spts < lvpts)
				{
				if(debug > -1)
					{
					fprintf(stderr, \
					"subtitle time spts=%.2fs < time of first video frame lvpts=%.2fs,  skipping line %d\n",\
					(double)spts / 90000.0, (double)lvpts / 90000.0, iline - 1);
					}

				skip++;
				goto try_next;
				}

			if( (spts < mintime * 90000) && (debug > -1) )
				{
				fprintf(stderr, \
				"warning, sub on line %d starts before %ds, (some players won't show it)\n", \
				iline - 1, mintime);
				}    

			if( !imgfix() ) /* data in img to fimg */
				{
				if (debug > -1)
					{
					fprintf(stderr, "blank image, skipping line %d\n", iline - 1);	
					}

				skip++;
				goto try_next;
				}

			if(nspts != -1) /* not last sub */
				{
				if(spts + sd + tbs > nspts)
					{
					if (debug > 4)
						fprintf(stderr, "overlapping sub\n");
					sd = -1;
					}
				} /* end if ! last sub */

			if(debug > 4)
				{
				fprintf(stderr, "spts: %d  sd: %d  nspts: %d\n",\
				spts / 90000, sd / 90000, nspts / 90000);
				}

			if( (sd == -1) && ( (!svcd) || until_next_sub) )
				{
				if(nspts > spts + tbs) sd = nspts - spts - tbs;
				else
					{ 
					if (debug > -1)
						{
						fprintf(stderr,\
						"sub with too short or negative duration on line %d, skipping\n",\
						iline - 1); 
						}
exit(1);
	
					skip++;
					goto try_next; 
					}
				}

			if(sd == -1)
				{
				if (debug > -1)
					{
					fprintf(stderr,\
					"last sub may not end on 00:00:00,00, skipping line %d\n", iline - 1);
					}
	
				skip++;
				goto try_next;
				}

			switch(mode)
				{
				case DVD_SUB:
					/* rle here */
					a = dvd_encode();

					/* data in subtitle_packet_buffer, size in a */
					sub = subtitle_packet_buffer;

					break;
				case CVD_SUB:
					a = cvd_encode();
					break;
				case SVCD_SUB:
					a = svcd_encode();
					break;
				} /* end switch */

			if(a == -1)
				{
				if(debug > -1)
					{
					fprintf(stderr, "image too large (encoded size>64k), skipping line %d\n", iline - 1);
					}

				skip++;
				goto try_next;
				}

			sub_size = a;     

			if(sub_size > SUB_BUFFER_MAX)
				{
				fprintf(stderr, "sub_size=%d, this is > %d bytes, fatal error, aborting\n",\
				sub_size, SUB_BUFFER_MAX);

				exit(1);
				}

			if(sub_size > max_sub_size)
				{
				max_sub_size = sub_size;
				fprintf(stderr, "max_sub_size=%d\n", max_sub_size);
				}

			seq = 0;
			subno++;

			if(mode == DVD_SUB)
				{
				if(first_flag)
					{
					header_mode = FIRST_FIRST;

					first_flag = 0;
					}
				else		
					{
					header_mode = NEXT_FIRST;
					}
				
				/* 
				DVD spec says:
				Note 2 P-STD parameter (see also the System Header in chapter 5.2.2)
				PES_extension is only allowed for the first packet of a VOB.
        		PES_extension is expected for the first packet of a VOB.
	      		The only allowed PES_extension data in DVD Video are the P-STD parameters.
       			PES_private_data_flag shall be 0 pack_header_field_flag shall be 0
        		program_packet_sequence_counter_flag shall be 0 PES_extension_flag_2
        		shall be 0 PSTD_buffer_flag shall be 1.
     			P_STD_buffer_scale value shall be set to 1.
        		P_STD_buffer_size value shall be set to 58 for prvate_stream_1
				*/

				bytes_send = 0;
				while(bytes_send != sub_size)
					{
					/* if not first pes packet */
					/* only packet start code on not first packet */
					if(bytes_send)
						{
						/* if any bytes send, not first in vob and not first in sub */
						header_mode = NEXT_NEXT;

						/* send packet start code if not first packet of sub (else was already send) */
						c = 0xba010000;
						cwrite(fdo, &c, 4);
						bytes_to_sector += 4;
						}

					/* known are: bytes_send, sub_size, sector_size, and DVD sector_size */
					/*
					sector_size(2048) - packet_start_code(4) - pack_header_size(10) -
					 - private_stream_code(4) - packet_length(2) - pes_header_size(11/8/3) - stream_id(1)
					*/ 
					if(header_mode == FIRST_FIRST)
						available_space = sector_size - 4 - 10 - 4 - 2 - 11 - 1; // - 32 = 2016 
					else if(header_mode == NEXT_FIRST)
						available_space = sector_size - 4 - 10 - 4 - 2 -  8 - 1; // - 29 = 2019
					else if(header_mode == NEXT_NEXT)
						available_space = sector_size - 4 - 10 - 4 - 2 -  3 - 1; // - 24 = 2024

					/* calculate bytes left to send */
					bytes_left = sub_size - bytes_send;
				
					/* calculate bytes free in sector */
					bytes_free = available_space - bytes_left;
					if(debug_flag)
						{
						if(bytes_free == 0)
							fprintf(stdout, "WAS EXACT MATCH!\n");
						}
					if(bytes_free < 0) bytes_free = 0;

					/* calculate bytes to send = i */
					/* calculate stuffing bytes if 1 to 7 bytes free = stuffing_bytes */
					/* calculate padding bytes if 8 or more bytes free = padding_bytes */
					if(bytes_free == 0) /* exact match */
						{
						i = available_space;
						stuffing_size = 0;
						padding_size = 0;
						}
/* 
NOTE by Panteltje 
DVD spec says: When packet length adjustment is >= 8, padding packet is added.
WHY is this not >= 7? (padding code(4) + padding size (2) + 1 byte 0xff padding).
*/
					else if(bytes_free >= 8) /* > 7 bytes free */
					/* there is space for >= 1 byte + padding code (4) + padding size (2) */
						{
 						i = bytes_left;
						stuffing_size = 0;
						padding_size = bytes_free - 6; /* leave space padding code (4) and padding size (2) */
						}
					else /* 1 to 7 bytes free */
						{
						i = bytes_left;
						padding_size = 0;
						stuffing_size = bytes_free;
						}					

					/* calculate packet_length */
					packet_length = i;
					if(header_mode == FIRST_FIRST)		 packet_length += 11 + 1;
					else if(header_mode == NEXT_FIRST)	 packet_length += 8 + 1;
					else if(header_mode == NEXT_NEXT)	 packet_length += 3 + 1;
					packet_length += stuffing_size;		// case stuffing

					pack_extention_flag1 = 0;
					pack_extention_flag2 = 0;
					pack_stuffing_flag = 0;

					/* fill in pack header */
					header[0] = 0x44 | ((gts >> 27) & 0x38) | ((gts >> 28) & 3);
					header[1] = (gts >> 20);
					header[2] = 4 | ((gts >> 12) & 0xf8) | ((gts >> 13) & 3);
					header[3] = (gts >> 5);
					header[4] = 4 | ((gts & 31) << 3) | ((pack_extention_flag1 >> 7) & 2);

					header[5] = 1 | (pack_extention_flag2 << 1);

					header[6] = muxrate >> 14;
					header[7] = muxrate >> 6;
					header[8] = 3 | (muxrate << 2);

					/* no stuffing in DVD pack header */
					header[9] = 0xF8 | pack_stuffing_flag; 

					/* write pack header */
					cwrite(fdo, header, 10);   
					bytes_to_sector += 10;

					/* write private stream code */
				    c = 0xbd010000;
					cwrite(fdo, &c, 4);     
					bytes_to_sector += 4;

					/* write packet length */				
					b = (packet_length >> 8) | (packet_length << 8);	// packet length in b to little endian
					cwrite(fdo, &b, 2);
					bytes_to_sector += 2;

					/* write pes header with stuffing bytes if needed */

					/*
					there are 3 possibilities,
						first pes header and first in vob (11 bytes basic):
							PTS
							length	
							P-STD params
							stuffing bytes if sector not full
						first pes header, not first in vob (8 bytes basic):
							PTS
							length
							stuffing bytes if sector not full
						not first pes header (3 bytes basic): 			
							length
							stuffing bytes if sector not full
					*/

					if(header_mode == FIRST_FIRST)
						{
						if(debug_flag)
							{
							fprintf(stdout, "header_mode == FIRST_FIRST\n");
							}

						/* first in vob, first in sub */

/*
2 bytes DVD spec:
byte 1:
bit	function					Value according to DVD spec
7	?							1
6	?							0
5	PES scrambling control		user
4	PES scrambling control		user
3	PES priority				user
2	data_alignment_indicator	user
1	copyright					user
0	original or copy			user
That makes: 1 0 0 0  0 0 0 0 = 0x80

byte 2:
bit
7	PTS flag					user
6	DTS flag					user
5	ESCR flag					0
4	ES_rate flag				0
3	DSM_trick_mode_flag			0
2	additional copy info		0
1	PES_CRC_flag				0
0	PES_extension_flag			user
That makes: 1 0 0 0  0 0 0 1 = 0x81
*/

						/* byte 1 */
						/* bit 7 = 1, bit 6 = 0, DVD spec */
						header[0] = 0x80 | (pes_scrambling_control << 4) | (pes_priority_flag << 3) |
						(data_alignment_indicator_flag << 2) | (copyright_flag << 1) | original_flag;

						/* byte 2 */
						header[1] = 0;
						header[1] |= 0x80;	// set pts flag
						header[1] |= 0x01;	// set pes extension flag always because of P-STD

						header[2] = 8 + stuffing_size;		// header size
/*
DVD spec:
PTS[32] shall be zero
5 bytes, 24	bits
byte	function	value 			
1					0 0 1 0  pts[32:30]  1
2					pts[29-22]
3					pts[21-15]  1
4					pts[14-7]
5					pts[6-0]  1
*/
						header[3] = 0x21 | ((spts >> 29) & 6);
						header[4] = spts >> 22;
						header[5] = 1 | (spts >> 14);
						header[6] = (spts >> 7);
						header[7] = 1 | (spts << 1);

						// Extension for the P-STD buffers 3 bytes
						// sub picture stream buffer 3 bytes (P-STD parameters),
						// ONLY allowed in FIRST PES packet.
/*
DVD standard:
bit function								value per DVD standard
7	PES private data flag					0
6	pack_header_field_flag					0
5	program_packet_sequence_counter_flag	0
4	P-STD buffer flag						1
3											1
2											1
1											1
0	PES extention flag 2					0
That makes: 0 0 0 1 1 1 1 0 = 0x1e
*/
						header[8] = 0x1e;

						/*
						DVD spec:
						P-STD buffer scale shall be 1
						P-STD bufer size shall be 58 for private_stream_1
						*/
						header[9] = 0x01;	// P-STD buffer scale = 1024 bytes (fixed for DVD see spec)
						header[10] = 58;	// P-STD buffer size = 58 for private_stream_1
											// 1024 * 58 = 59352

						/* add stuffing bytes if any */
						for(j = 0; j < stuffing_size; j++) header[11 + j] = 0xff;

						/* write header */
						cwrite(fdo, header, 3 + 8 + stuffing_size);
						bytes_to_sector +=  3 + 8 + stuffing_size;
						}
					else if(header_mode == NEXT_FIRST)
						{ 
						if(debug_flag)
							{
							fprintf(stdout, "header_mode == NEXT_FIRST\n");
							}

						/* first header, not first in vob */

						/* bit 7 = 1, bit 6 = 0, DVD spec */
						header[0] = 0x80 | (pes_scrambling_control << 4) | (pes_priority_flag << 3) |
						(data_alignment_indicator_flag << 2) | (copyright_flag << 1) | original_flag;

						header[1] = 0;
						header[1] |= 0x80;	// set pts flag

						header[2] = 5 + stuffing_size;	// PES header data length

						header[3] = 0x21 | ((spts >> 29) & 6);
						header[4] = spts >> 22;
						header[5] = 1 | (spts >> 14);
						header[6] = (spts >> 7);
						header[7] = 1 | (spts << 1);

						/* add stuffing bytes if any */
						for(j = 0; j < stuffing_size; j++) header[8 + j] = 0xff;

						/* write header */
						cwrite(fdo, header, 3 + 5 + stuffing_size);
						bytes_to_sector += 3 + 5 + stuffing_size;
						}
					else if(header_mode == NEXT_NEXT)
						{
						if(debug_flag)
							{
							fprintf(stdout, "header_mode == NEXT_NEXT\n");
							}

						/* not first header, not first in vob */

						/* bit 7 = 1, bit 6 = 0, DVD spec */
						header[0] = 0x80 | (pes_scrambling_control << 4) | (pes_priority_flag << 3) |
						(data_alignment_indicator_flag << 2) | (copyright_flag << 1) | original_flag;

						header[1] = 0; /* no PTS, bit 7 pts flag = 0 */
 
						header[2] = 0 + stuffing_size;	// PES header data length

						/* add stuffing bytes if any */
						for(j = 0; j < stuffing_size; j++) header[3 + j] = 0xff;

						/* write header */
						cwrite(fdo, header, 3 + 0 + stuffing_size);
						bytes_to_sector += 3 + 0 + stuffing_size;
						}

					if(debug_flag)
						{	
						if(padding_size) fprintf(stdout, "PADDING padding_size=%d\n", padding_size);
						if(stuffing_size) fprintf(stdout, "STUFFING stuffing_size=%d\n", stuffing_size);

						if(stuffing_size || padding_size)
							{
							fprintf(stdout,\
							"sub_size=%d\n\
	bytes_send=%d\n\
	available_space=%d
	bytes_left=%d\n\
	bytes_free=%d\n\
	header_mode=%d\n\
	i=%d\n\
	stuffing_size=%d\n\
	padding_size=%d\n\
	packet_length=%d\n",\

	sub_size,\
	bytes_send,\
	available_space,\
	bytes_left,\
	bytes_free,\
	header_mode,\
	i,\
	stuffing_size,\
	padding_size,\
	packet_length);
							}
						} /* end if debug_flag */
	
					/* write sub stream ID, 1 byte */
					cwrite(fdo, &substr, 1);	// stream ID
					bytes_to_sector += 1;

					/* increment */
					seq++;

					/* write data */
					/* write i data bytes, increment bytes_send by bytes written */
					bytes_send += cwrite(fdo, sub + bytes_send, i);
					bytes_to_sector += i;

					/* write padding bytes if needed */
					if(padding_size)
						{	
						/* write padding code */
						c = 0xbe010000;
						cwrite(fdo, &c, 4);
						bytes_to_sector += 4;     

						/* write padding stream size */
						if(debug_flag)
							{
							fprintf(stderr, "padding_size=%d\n", padding_size);
							}

						b = (padding_size >> 8) | (padding_size << 8); // padding stream size in b to little endian
						cwrite(fdo, &b, 2);
						bytes_to_sector += 2;

						/* write padding bytes */
						c = 0xff;

						for(q = 0; q < padding_size; q++)
							{
							cwrite(fdo, &c, 1);
							bytes_to_sector += 1;
							}
						} /* end if padding bytes */
					} /* while bytes_send != sub_size */

				} /* end if mode DVD */
			else /* mode is CVD or SVCD */
				{
				// header_size is 12 before while starts    
				bytes_send = 0;
				while(bytes_send != sub_size)
					{
					/* if not first time here */
					if(bytes_send)
						{
						/* send packet start code */
						header_size = 4; 
						c = 0xba010000;
						cwrite(fdo, &c, 4);
						bytes_to_sector += 4;
						}
					else if (header_size != 12) header_size = 9; // not first in vob, first in sub
	 
    				if(debug_flag)
						{ 
						fprintf(stdout, "New header_size=%d bytes_send=%d sub_size=%d nbuf=%s\n",\
						header_size, bytes_send, sub_size, nbuf);
						}

					/* calculate how many bytes to send */

					/* test if less then 26 bytes free */
					if( (sub_size - bytes_send) > (sector_size - 26 - header_size - svcd) )
						{
						/* test if less then 26 and more then 20 bytes free */
						if( (sub_size - bytes_send) <= (sector_size - 20 - header_size - svcd) )
							{
							i = sector_size - 26 - header_size - svcd;
							}
						else	/* less then 20 bytes free */
							{
							/* fill up sector */
							i = sector_size - 20 - header_size - svcd;
							}
						}
					else /* more then 26 bytes free */
						{
						i = sub_size - bytes_send;
		        		}

					//void mkpackh(unsigned long int time, unsigned short int ext, unsigned int muxrate,
					//unsigned char stuffing)
					//{
					//header[0] = 0x44 | ((time >> 27) & 0x38) | ((time >> 28) & 3);
					//header[1] = (time >> 20);
					//header[2] = 4 | ((time >> 12) & 0xf8) | ((time >> 13) & 3);
					//header[3] = (time >> 5);
					//header[4] = 4 | ((time & 31) << 3) | ((ext >> 7) & 2);

					//header[5] = 1 | (ext << 1);
					//header[6] = muxrate >> 14;
					//header[7] = muxrate >> 6;
					//header[8] = 3 | (muxrate << 2);
					//header[9] = 0xF8 | stuffing;
					//}
					/* write header */
					mkpackh(gts, 0, muxrate, 0);

/*
fprintf(stderr, "system time: %d 0x%lx %d\n", gts, ftell(fds), frame);
fprintf(stderr, "last_pts=%d\n", last_pts);
fprintf(stderr, "spts=%d last_pts=%d\n", spts, last_pts);
*/
					cwrite(fdo, header, 10); 
					bytes_to_sector += 10;

					/* write private stream code */
				    c = 0xbd010000;
					cwrite(fdo, &c, 4);     
					bytes_to_sector += 4;

					/* write packet length */				
					i += header_size + svcd;
					b = (i >> 8) | (i << 8);	// packet length in b to little endian
					i -= header_size + svcd;
					cwrite(fdo, &b, 2);
					bytes_to_sector += 2;

					/* i has NOT changed here! and is still bytes to send */
    
					if(svcd)
						if (header_size == 9)
							{
							//void mkpesh0(unsigned long int pts, unsigned char id)
							//{   
							//header[0] = 0x81;  
							//header[1] = 0x80;	//pts flag
							//header[2] = 5;
							//header[3] = 0x21 | ((pts >> 29) & 6);
							//header[4] = pts >> 22;
							//header[5] = 1 | (pts >> 14);
							//header[6] = (pts >> 7);
							//header[7] = 1 | (pts << 1);
							//header[8] = id;
							//}
							mkpesh0(spts, substr); //SVCD_SUB_CHANNEL);
							}
						else if (header_size == 12)
							{
							//void mkpesh1(unsigned long int pts, unsigned char id)
							//{   
							//header[0] = 0x81;  
							//header[1] = 0x81;	//pts flag + pes extension flag
							//header[2] = 8;
							//header[3] = 0x21 | ((pts >> 29)&6);
							//header[4] = pts >> 22;
							//header[5] = 1 | (pts >> 14);
							//header[6] = (pts >> 7);
							//header[7] = 1 | (pts << 1);
							//header[8] = 0x1e; //P - STD_buffer_flag
							//header[9] = 0x60; //buffer scale
							//header[10] = 0x3a; //buffer size (wtf nu det r..) (svcdverifier tycker  att 64 r ett bra tal hr..)
							//header[11] = id;
							//}
							mkpesh1(spts, substr); //SVCD_SUB_CHANNEL);
							}
						else
							{
							//void mkpesh2 (unsigned char id)
							//{
							//header[0] = 0x81;  
							//header[1] = 0;
							//header[2] = 0;
							//header[3] = id;
							//}
							mkpesh2(substr); //SVCD_SUB_CHANNEL);
							}

					/* not svcd */
					else if (header_size == 12) // only here first packet of picture 
						{
						if(debug_flag)
							{
							fprintf(stderr, "sending header size 12\n");
							}

						//void mkpesh1(unsigned long int pts, unsigned char id)
						//{   
						//header[0] = 0x81;  
						//header[1] = 0x81;	//pts flag + pes extension flag
						//header[2] = 8;
						//header[3] = 0x21 | ((pts >> 29) & 6);
						//header[4] = pts >> 22;
						//header[5] = 1 | (pts >> 14);
						//header[6] = (pts >> 7);
						//header[7] = 1 | (pts << 1);
						//header[8] = 0x1e;
						//header[9] = 0x60;
						//header[10] = 0x3a; // 48 dec
						//buffer size (wtf nu det r..) (svcdverifier tycker  att 64 r ett bra tal hr..)
						//header[11] = id;

						//}
						mkpesh1(spts, substr);
						}
					else if (header_size == 9) // first packet of not first picture
						{
						if(debug_flag)
							{
							fprintf(stderr, "sending header size 9\n");
							}

						//void mkpesh0(unsigned long int pts, unsigned char id)
						//{   
						//header[0] = 0x81; 
						//header[1] = 0x80;	//pts flag
						//header[2] = 5;
						//header[3] = 0x21 | ((pts >> 29) & 6);
						//header[4] = pts >> 22;
						//header[5] = 1 | (pts >> 14);
						//header[6] = (pts >> 7);
						//header[7] = 1 | (pts << 1);
						//header[8] = id;
						//}
						mkpesh0(spts, substr);
						}
					else // not first packet
						{
						if(debug_flag)
							{
							fprintf(stderr, "sending header size 4\n");
							}

						//void mkpesh2 (unsigned char id)
						//{
						//header[0] = 0x81;  
						//header[1] = 0;
						//header[2] = 0;
						//header[3] = id;
						//}
						mkpesh2(substr);
						}
					cwrite(fdo, header, header_size); 
					bytes_to_sector += header_size;

					if(svcd)
						{
						/* 4 byte svcd header */

						cwrite(fdo, &substr, 1);							// current subtitle stream
						bytes_to_sector += 1;

						if (bytes_send + i == sub_size) seq |= 128;		
						cwrite(fdo, &seq, 1);							// packet number in current sub
						bytes_to_sector += 1;							// 0 - up, last packet has bit 7 set

						cc = subno >> 8;      
						cwrite(fdo, &cc, 1);								// h current sub nr 
						bytes_to_sector += 1;

						cwrite(fdo, &subno, 1);          				// l current sub nr
						bytes_to_sector += 1;
						} 

					seq++;

					/* write i data bytes, increment bytes_send by bytes written */
					bytes_send += cwrite(fdo, sub + bytes_send, i);
					bytes_to_sector += i;

					/* test if not full sector */
					if (i != sector_size - 20 - header_size - svcd)
						{
						/*
						If sector not exactly filled, write padding.
						A previous test has checked if there is actually space for the padding header
						The padding size could be zero, so only the padding header.
						*/
					
						/* write padding code */
						c = 0xbe010000;
						cwrite(fdo, &c, 4);
						bytes_to_sector += 4;     

						/* calculate number of padding bytes */
						b = sector_size - i - header_size - 26 - svcd;

						if(debug > 4)
							{
							fprintf(stderr, "padding, b: %d\n", b);
							}
					
						/* write padding stream size */

						if(debug_flag)
							{
							fprintf(stderr, "padding bytes b=%d\n", b);
							}

						b = (b >> 8) | (b << 8); // padding stream size in b to little endian
						cwrite(fdo, &b, 2);
						bytes_to_sector += 2;

						/* write padding bytes */

						b = (b >> 8) | (b << 8); // padding stream size in b back to big endian

						c = 0xff;

						for(q = 0; q < b; q++)
							{
							cwrite(fdo, &c, 1);
							bytes_to_sector += 1;
							}
						if (b > sector_size - header_size - 26 - svcd)
							{
							fprintf(stderr, "too many padding bytes, Fatal, aborting\n");
					
							exit(1);
							}
						} 
			
				    } /* end while bytes_send ! sub_size */

				} /* end else sub_mode != dvd */

   			if(debug_flag)
				{
				fprintf(stderr, "bytes_to_sector=%d\n", bytes_to_sector);
				}

			if(bytes_to_sector % sector_size)
				{
				fprintf(stderr,\
				"submux-dvd: INTERNAL ERROR\n\
				bytes_to_sector=%d\n\
				bytes_to_sector/sector_size=%d bytes_to_sector%%sector_size=%d,\n\
				FATAL error, aborting\n",\
				bytes_to_sector, bytes_to_sector / sector_size, bytes_to_sector % sector_size);

				fprintf(stdout,\
				"Contact panteltje@yahoo.com or one of the other developers so we can look into this\n"); 		

				exit(1);
				}

			if(debug_flag)
				{
				fprintf(stdout, "Complete!! bytes_send=%d\n", bytes_send);
				}

			if(bytes_send != sub_size)
				{
				fprintf(stderr, "submux-dvd: INTERNAL ERROR\n\
				sub_size=%d bytes_send=%d\n\
				FATAL error, aborting\n",\
				sub_size, bytes_send);

				fprintf(stdout,\
				"Contact panteltje@yahoo.com or one of the other developers so we can look into this\n"); 		

				exit(1);
				}

			/* write packet start code */
			c = 0xba010000;
			cwrite(fdo, &c, 4);        
			bytes_to_sector += 4;

			if (debug > 0)
				{
				fprintf(stderr,\
				"subtitle inserted at: %f sd=%d\n", (double)spts / 90000, sd / 90000);    
				}

			} /* end if valid sub */
		 
 		if (debug > 5)
			{
			fprintf(stderr, "system time: %d 0x%lx %d\n",\
			gts, ftell(fds), frame);
			}

		cwrite(fdo, psbuf, psbufs);
		bytes_to_sector += psbufs;
		} 
	else /* copy stream */
		{
		if ((c != 0xb7010000)  &&  (c != 0xb9010000))
			{
			if (cread(fdi, &b, 2) != 2) break;
			cwrite(fdo, &b, 2);
			bytes_to_sector += 2;

			b = (b >> 8) | (b << 8);
   
			if (cread(fdi, cbuf, b) != b) break;
			cwrite(fdo, cbuf, b);
			bytes_to_sector += b;
			} 

		/* skip unknown stuff (garbage) and  get video PTS in lvpts */    
		switch(c)
			{
			case 0xb7010000:
				if (debug > 5) fprintf(stderr, "end packet(?)\n");
				break;
			case 0xb9010000:
				if (debug > 5) fprintf(stderr, "end packet\n");
				break;
			case 0xbb010000:
				if (debug > 5) fprintf(stderr, "system header\n");
				break;
			case 0xbf010000:
				if (debug > 5) fprintf(stderr, "private stream 2\n"); // some special DVD info is here ?
				break;
			case 0xbd010000:
				if (debug > 5) fprintf(stderr, "private stream 1\n");  
				a = getpts(cbuf);
				pts = -1;
				if (a != -1) pts = a;
				else if (cbuf[1] & 0xc0) fprintf(stderr, "incorrect pes header (pts)\n");
				a = cbuf[2] + 3;
				if (debug > 4)
					{
					fprintf(stderr, "id: 0x%x length: 0x%x header length: %d  pts: %d\n",\
					cbuf[a], b, a - 3, pts);
					}
				break;   
			case 0xe0010000: if (debug > 5) fprintf(stderr, "video stream\n"); 
				a = getpts(cbuf);
				if (a != -1) lvpts = a;
				break;   
			case 0xe2010000:
				if (debug > 5) fprintf(stderr, "video stream 3??\n");
				break;   
			case 0xbe010000:
				if (debug > 5) fprintf(stderr, "padding stream\n");
				break;   
			case 0xc0010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 1\n");
				break; 
			case 0xc1010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 2\n");
				break; 
			case 0xc2010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 3\n");
				break; 
			case 0xc3010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 4\n");
				break; 
			case 0xc4010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 5\n");
				break; 
			case 0xc5010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 6\n");
				break; 
			case 0xc6010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 7\n");
				break; 
			case 0xc7010000:
				a = getpts(cbuf);
				if (a != -1) last_pts = a;
				break;   
				if (debug > 5) fprintf(stderr, "audio stream 8\n");
				break; 
			default:
				if (debug > 0)
					{
					fprintf(stderr, "unknown header %.2x %.2x %.2x %.2x\n",\
					c & 255, (c >> 8) & 255, (c >> 16) & 255, (c >> 24) & 255);   
    				}

				a = b = 0;
				while(a  !=  0x1ba)
					{
					a = a << 8;
					if (cread(fdi, &a, 1) < 1) break;

					cwrite(fdo, &a, 1);
					bytes_to_sector += 1;

					if(debug > 6) fprintf(stderr, "0x%x\n", a);
					b++;
					}
				fprintf(stderr, "skipped %d bytes of garbage\n", b);

				goto l_01ba;
				break;
			} /* end switch stream type */	

		} /* end if 0xba010000 packet start code */

	} /* end while read / write all */
 
fprintf(stderr, "max_sub_size=%d\n", max_sub_size);

if (subno  !=  0xffff)
	{
	fprintf(stderr,\
	"%d subtitles added, %d subtitles skipped, stream: %d, offset: %.2f\n",\
	subno + 1, skip, substr, (double)tofs / 90000);
	}
else
	{
	fprintf(stderr, "warning: no subtitles added\n"); 
	}
      
close(fdo);
fclose(fds);
close(fdi);

return 0;
} /* end function main */


int read_bmp(char *name)
{
bmpt bmp;
int fdr;
unsigned int a, d, i, x, y, size, pals, cst[256];
unsigned short int b;
unsigned char c;
unsigned char *limg;
palt lpal[256];
int pallette_start;

for(i = 0; i < maxx * maxy; i++)
	{
	img[i] = 0;
	}

fdr = open(name, O_RDONLY | O_BINARY);
if(fdr < 0)
	{
	fprintf(stderr,"error, unable to open file %s\n",name);
	return -1;
	} 
 
if(cread(fdr, &bmp, 54) < 54)
	{
	fprintf(stderr,"error, file too short: %s\n",name);
	close(fdr);
	return -1;
	}	
 
if(bmp.BM  !=  19778)
	{
	fprintf(stderr,"error, file %s isn't a bmp\n",name);
	close(fdr);
	return -1;
	}
 
if(debug > 3) fprintf(stderr,"xd: %d  yd: %d\n", bmp.x, bmp.y);
 
xd = bmp.x;
yd = bmp.y;

if( (bmp.x > 720) || (bmp.y > 576) )
	{
	fprintf(stderr,"error, image larger than 720x576\n");
	close(fdr);
	return -1;
	} 

if( (bmp.bpp  !=  4)  &&  (bmp.bpp  !=  8) )
	{
	fprintf(stderr,"error, only 4 & 8bpp images supported\n");
	close(fdr);
	return -1;
	}

if(bmp.comp)
	{
	fprintf(stderr,"error, only uncompressed images are supported\n");
	close(fdr);
	return -1;
	}

d = 0;
 
//lseek(fdr, bmp.hsize - 40, SEEK_CUR);
 
/*
start color table
file header size + info header size
*/

pallette_start = 14 + bmp.hsize; // hsize = BitmapInfoHeader size!

if(debug > 3)
	{
	fprintf(stderr, "name=%s pallette_start=%d\n", name, pallette_start);
	}

lseek(fdr, pallette_start, SEEK_SET);

pals = 1  <<  bmp.bpp;

for(b = 0; b < pals; b++)
	{
	d += cread(fdr, &lpal[b].b, 1); 
	d += cread(fdr, &lpal[b].g, 1); 
	d += cread(fdr, &lpal[b].r, 1); 
	d += cread(fdr, &c, 1);
	if(debug > 3)
		{
		fprintf(stderr, "WAS lpal[b].b=%d lpal[b].g=%d lpal[b].r=%d c=%d d=%d\n",\
		lpal[b].b, lpal[b].g, lpal[b].r, c, d);
		}
	}
 
if(d != pals * 4)
	{
	fprintf(stderr,"error file too short: %s\n",name);
	close(fdr);
	return -1;
	}	
 
if(bmp.bpp  ==  4)
	{
	if(xd & 7) size = (xd & (-8) ) + 8;
	else size = xd;
  
	size *= yd;
	size /= 2;

	limg = malloc(size);
  
	lseek(fdr, bmp.ofs, SEEK_SET);
  
	if( cread(fdr, limg, size)  !=  size)
		{
		fprintf(stderr,"error, file too short: %s\n",name);
		free(limg);
		close(fdr);
		return -1;
		}	
 
	d = 0;
	for(y = yd - 1; y  !=  -1; y--)
		{
		for(x = 0; x < xd; x += 2)
			{
			img[y * xd + x] = limg[d]  >>  4;
			if(x + 1  ==  xd)
				{
				/* should clear img[...] here? */
				d++;
				}
			else img[y * xd + x + 1] = limg[d++] & 15;
			}
//printf("WAS img[y * xd + x]=%d\n", img[y * xd + x]);

		if(d & 3) d += 4 - (d & 3);
		} 

	/*
	ONLY if values for fg, bg, e1 anf e2 specified in .sub file,
	make a 4 bits bitmap representing 0 = bg, 1 = fg, 2 = e1, 3 = e2.
	This flags is ONLY set if all 4 color values afre specified.

	NEVER use 2 the same values for colors!!!!
	*/
	if(colors_specified_flag)
		{

		/* check if not same colors used */
		a = 0;
		if(background == pattern) a = 1;
		if(background == emphasis1) a = 1;
		if(background == emphasis2) a = 1;

		if(pattern == emphasis1) a = 1;
		if(pattern == emphasis2) a = 1;

		if(emphasis1 == emphasis2) a = 1;

		if(a)
			{
			fprintf(stderr,\
	"ERROR some identical colors used for background=%d pattern=%d emphasis1=%d emphasis2=%d, aborting\n",\
			background, pattern, emphasis1, emphasis2);

			exit(1);
			}

		d = 0;
		for(y = 0; y < yd; y++)
			{
			for(x = 0; x < xd; x++)
				{
				if(img[d] == background)		img[d] = 0; // background
				else if(img[d] == pattern)		img[d] = 1; // pattern
				else if(img[d] == emphasis1)	img[d] = 2; // emphasis1
				else if(img[d] == emphasis2)	img[d] = 3; // emphasis2

				d++;
				} /* end for x */
			} /* end for y */
		} /* end if colors_specified_flag */

	} /* end if 4 bpp */
else /* 8 bits per pixel */
	{
 	if(xd & 3) size = (xd & (-4) ) + 4;
	else size = xd;
  
	size *= yd;

	limg = malloc(size);
  
	lseek(fdr, bmp.ofs, SEEK_SET);
  
	if(cread(fdr, limg, size)  !=  size)
		{
		fprintf(stderr,"error, file too short: %s\n",name);
		free (limg);
		close(fdr);
		return -1;
		}	
	d = 0;
	for(y = yd - 1; y  !=  -1; y--)
		{
		for(x = 0; x < xd; x++) img[y * xd + x] = limg[d++];

		if(d & 3) d += 4 - (d & 3);
		} 
	} /* end if 8 bpp */
 
free(limg);
close(fdr);
 
//#define P_TEST
#ifdef P_TEST

for(a = 0; a < 4; a++)
	{
	pal[a].r = lpal[a].r;
	pal[a].g = lpal[a].g;
	pal[a].b = lpal[a].b;
	pal[a].t = lpal[a].t;

	if(debug > 3)
		{
		fprintf(stderr, "WAS P_TEST setting\n\
		pal[a].r=%d\n\
		pal[a].g=%d\n\
		pal[a].b=%d\n\
		lpal[a].t=%d\n",\
		pal[a].r,\
		pal[a].g,\
		pal[a].b,\
		lpal[a].t);
		}
	}

a = 0;
return 0;
#endif

if(debug > 3)
	{
	for(i = 0; i < pals; i++)
		{
		fprintf(stderr,\
		"WAS 1 lpal[%d].b=%d lpal[%d].g=%d lpal[%d].r=%d c=%d d=%d\n",\
		i, lpal[i].b, i, lpal[i].g, i, lpal[i].r, c, d);
		}
	}

for(a = 0; a < pals; a++) cst[a] = 0;

a = 0;
for(y = 0; y < yd; y++)
	{
	for(x = 0; x < xd; x++)
		{
/*
		fprintf(stderr, "WAS a=%d img[a]=%d cst[%d]=%d\n",\
		a, img[a], img[a], cst[img[a]]);
*/

		cst[ img[a++] ]++;
		}
	}

if(debug > 3)
	{
	fprintf(stderr, "WAS name=%s pals=%d yd=%d xd=%d\n", name, pals, yd, xd);
	}

b = 0;
for(a = 0; a < pals; a++)
	{
	if(debug > 3)
		{
		fprintf(stderr, "WAS cst[%d]=%d b=%d\n", a, cst[a], b);
		}

	if(cst[a])
		{
		if(b > 3)
			{
			if(debug > -1) fprintf(stderr,\
"warning: more than 4 colors found in bitmap %s, setting color %d to 0\n",\
name, a);
			lpal[a].t = 0;
			}
		else
			{
		   	pal[b].r = lpal[a].r;
			pal[b].g = lpal[a].g;
			pal[b].b = lpal[a].b;

			if(debug > 3)
				{
				fprintf(stderr, "WAS 3 setting\n\
				b=%d a=%d\n\
				pal[b].r=%d lpal[a].r=%d\n\
				pal[b].g=%d lpal[a].g=%d\n\
				pal[b].b=%d lpal[a].b=%d\n",\
				b, a,\
				pal[b].r, lpal[a].r,\
				pal[b].g, lpal[a].g,\
				pal[b].b, lpal[a].b);
				}

			lpal[a].t = b++;

			if(debug > 3)
				{
				fprintf(stderr, "WAS 3a setting\n\
				lpal[a].t=%d\n",
				lpal[a].t);
				}
			} /* end if b <= 3 */
		} /* end if cst[a] */
	} /* end for all pallettes */ 

a = 0;
for(y = 0; y < yd; y++)
	{
	for(x = 0; x < xd; x++)
		{
		img[a++] = lpal[ img[a] ].t;
//		img[a++] = pal[ img[a] ].t;
		}
	}

return 0;
} /* end function read_bmp */



unsigned short int dsize;
unsigned char *oimg;
unsigned char gn()
{
if(!bc)
	{
	bb = sub[ofs++];
	bc = 1;
	return bb >> 4; 
	}
bc = 0;

if(debug_flag)
	{
	fprintf(stderr, "gn(): returning sub=%p ofs=%d bc=%d val=0x%01x\n", sub, ofs, bc, bb & 15);
	}

return bb & 15;
} /* end function gn */


static int store_mode;
static unsigned char *ocptr, *ecptr;
static int rnibbles;
static int oddp;

void store_nibble(int val)
{
int a;
unsigned char *ptr;

if(store_mode == 1) ptr = ocptr;
else ptr = ecptr;

if(debug_flag)
	{
	fprintf(stderr,\
	"store_nibble(): arg val=0x%01x using store_mode=%d ptr=%p\n",\
	val, store_mode,  ptr);
	}

if(val > 0xf)
	{
	fprintf(stderr, "store_nibble(): val > 0xf = 0x%0x, aborting.\n", val);

	exit(1);
	}

a = *ptr & 0xff;
if(! oddp)
	{
	a &= 0x0f;
	a += (val << 4);
	*ptr = a;
	}
else
	{
	a &= 0xf0;
	a += val;
	*ptr = a;

	if(store_mode == 1) ptr = ocptr++;
	else ptr = ecptr++;
	}

oddp = 1 - oddp;

rnibbles++;
} /* end function store_nibble */


int do_rle(int count, int color)
{
int a, b;

if(debug_flag)
	{
	fprintf(stderr, "do_rle(): arg count=%d color=%d\n", count, color);
	}

/* argument check */
if(count > 255)
	{
	fprintf(stderr, "do_rle(): count=%d > 255, error.\n", count);

	return 0;
	}
if(color > 3)
	{
	fprintf(stderr, "do_rle(): color=%d > 3, error.\n", color);

	return 0;
	}

/* make rle code in b */
a = count << 2;
b = a | color;

/* b now ranges from 0x4 up, because count is at least 1 */

if(count >= 64)			// 64 - 255
	{
	/* 64-255, 16 bits, 0 0 0 0  0 0 n n  n n n n  n n c c */
	store_nibble(0);
	store_nibble( (a & 0xf00) >> 8);
	store_nibble( (a & 0xf0) >> 4);
	store_nibble( b & 0xf);

	return 4;
	}
else if(count >= 16)	// 16 - 63
	{
	/* 16 - 63, 12 bits, 0 0 0 0  n n n n  n n c c */
	store_nibble( 0);
	store_nibble( (a & 0xf0) >> 4);
	store_nibble( b & 0xf);

	return 3;
	}
else if(count >= 4)		// 4 - 15
	{
	/* 4-15, 8 bits, 0 0 n n  n n c c */
	store_nibble( (a & 0xf0) >> 4);
	store_nibble( b & 0xf);

	return 2;
	}
else					// 1 - 3
	{
	/* 1-3, 4 bits, n n c c */
	store_nibble( b);

	return 1;
	}

/* never here */
return 0;
} /* end function do_rle */


int send_colors(int color, int count)
{
int a, b, c, d, i;

if(debug_flag)
	{
	fprintf(stderr, "send_colors(): arg color=%d count=%d\n", color, count);
	}

c = count / 255;
d = count % 255;

b = 0;
for(i = 0; i < c; i++)
	{
	a = do_rle(255, color);
	if(! a)
		{
		fprintf(stderr, "fatal error, aborting.\n");

		exit(1);
		}

	b += a;
	} /* end for i */

if(d == 0) return b;

a = do_rle(d, color);
if(! a)
	{
	fprintf(stderr, "fatal error, aborting.\n");

	exit(1);
	}

b += a;

return b;
} /* end function send_colors */


static int max_bits_in_line;

//#define TEST_PIC
int dvd_encode()
{
int a, e, i;
int subtitle_packet_size;
int xstart, xsize, xend;
int ystart, ysize, yend;
unsigned char *cptr, *next_command_ptr;
int display_duration_in_frames;
int offset0, offset1;
unsigned int delay_units;
int image_size;
int idx, new_pos;
int bits_in_odd_line, bits_in_even_line;

//#define BIN_DUMP
#ifdef BIN_DUMP
FILE *fptest;
#endif


#ifdef TEST_PIC
int c;
FILE *ppmptr;
unsigned char *ucptr;
#endif

int x, y;
unsigned char *icptr;
int odd;
int odd_line_nibbles, even_line_nibbles;

if(debug_flag)
	{
	fprintf(stderr,\
	"dvd_encode(): spts=%d sd=%d x=%d yd=%d x0=%d y0=%d\n",\
	spts / 90000, sd / 90000, xd, yd, x0, y0);
	}
	
xstart = x0;
xsize = xd;
ystart = y0;
ysize = yd;


i = 0; /* for gcc -Wall */
idx = 0; /* for gcc -Wall */

/*
720 x 576 = 414720 bytes, for a 2 bit bitmap = 103680 bytes, compressing MUST reduce this to less then 65536 bytes,
or a 2 byte number - overhead 65535 - 65507 = 28 bytes, as max. 65507 is OK).
This 23 bytes control buffer, 6 bytes end sequence?
*/

display_duration_in_frames = 515;
offset0 = 0;
offset1 = 0;

memset(subtitle_image_buffer, 0, maxx * maxy * 3);

#ifdef TEST_PIC
//pal[0].b = 123; pal[0].g = 240; pal[0].r = 68;
//pal[1].b = 0; pal[1].g = 255; pal[1].r = 0;
//pal[2].b = 255; pal[2].g = 0; pal[2].r = 255;
//pal[3].b = 255; pal[3].g = 255; pal[3].r = 0;

ucptr = fimg;
//ucptr = img;// use if call to imgfix() commented out
ppmptr = fopen("test.ppm", "w");
if(! ppmptr)
	{
	fprintf(stderr, "could not open file test.ppm for write, aborting.\n");

	exit(1);
	}

/* write a ppm file. */
fprintf(ppmptr, "P6\n%i %i\n255\n", xd, yd);
for(y = 0; y < yd; y++)
	{
	for(x = 0; x < xd; x++)
		{
		/* bgr */
/*
		fprintf(stderr, "*ucptr=%d  pal[*ucptr].b=%d pal[*ucptr].g=%d pal[*ucptr].r=%d\n",\
		*ucptr, pal[*ucptr].b, pal[*ucptr].g, pal[*ucptr].r);
*/
		fprintf(ppmptr, "%c", pal[*ucptr].r);
		fprintf(ppmptr, "%c", pal[*ucptr].g);
		fprintf(ppmptr, "%c", pal[*ucptr].b);

		ucptr++;
		} /* end for x */
	} /* end for y */

fclose(ppmptr);
#endif /* TEST_PIC */

/* encode the .ppm to DVD run length encoded format */
/* for all bytes in img */

/*
(X >> 2) is the number of pixels to display, and (X & 0x3)
is the color of the pixel.
*/

/* clear buffers */
memset(even_buf, 0, xd * yd);
memset(odd_buf, 0, xd * yd); // interlaced part, the odd lines go here

even_line_nibbles = 0;
odd_line_nibbles = 0;
rnibbles = 0;
odd = 0;

icptr = fimg;  
//icptr = img;// use if call to imgfix() commented out

/*
Recalculate the 16 positions bitmap to a 4 position one
This is done by testing if the value equals the background, pattern,
emphasis1 or emphasis2 value, and if so, assign
0, 1, 2, 3 respectively
*/ 

/* run length encode data */
ecptr = even_buf;
ocptr = odd_buf;
for(y = 0; y < yd; y++)
	{
	bits_in_odd_line = 0;
	bits_in_even_line = 0;

	if(oddp %2)
		{
		fprintf(stderr, "dvd_encode(): oddp odd at start of line, alignment error, aborting\n");
		exit(1);
		}

	if(!odd) store_mode = 0; // select ecptr for output
	else store_mode = 1; // select ocptr for output	

	new_pos = 0;
	for(x = 0; x < xd; x++)
		{
		idx = y * xd + x;
		
		/* get color from x,y */

		if(icptr[idx + 1] != icptr[idx])
			{
			e = send_colors(icptr[idx], x - new_pos + 1);

			if(odd) odd_line_nibbles += e;
			else even_line_nibbles += e;
		
			if(odd) bits_in_odd_line += e * 4;
			else bits_in_even_line += e * 4;

#ifdef TEST_PIC
			fprintf(stderr,\
			"WAS y=%d yd=%d x=%d xd=%d idx=%d new_pos=%d icptr[idx+1]=%d icptr[idx]=%d send=%d\n",\
			y, yd, x, xd, idx, new_pos, icptr[idx + 1], icptr[idx],  x - new_pos + 1);
#endif /* TEST_PIC */

			new_pos = x + 1;
			}
		} /* end for x */

	/*
	One special case,
	encoding a count of zero using the 16-bit format,
	indicates the same pixel value until the end of the line. 
	*/
	
	if( (x - new_pos) != 0)
		{
#ifdef TEST_PIC
		fprintf(stderr,\
		"WAS EOL y=%d yd=%d x=%d xd=%d idx=%d new_pos=%d icptr[idx+1]=%d icptr[idx]=%d left=%d\n",\
		y, yd, x, xd, idx, new_pos, icptr[idx + 1], icptr[idx],  x - new_pos );
#endif /* TEST_PIC */ 

		/* send same colors to end of line */
		store_nibble(0);
		store_nibble(0);
		store_nibble(0);
		store_nibble(icptr[idx]);

		if(odd) odd_line_nibbles += 4;
		else even_line_nibbles += 4;


		if(odd) bits_in_odd_line += 16;
		else bits_in_even_line += 16;
		}

	/*
	If, at the end of a line, the bit count is not a multiple of 8, four fill bits of 0 are added.
	*/

	if(odd)
		{
		if(odd_line_nibbles % 2)
			{
			store_nibble(0);
			odd_line_nibbles++;

			bits_in_odd_line += 4;
			}
		}
	else
		{
		if(even_line_nibbles % 2)
			{
			store_nibble(0);
			even_line_nibbles++;

			bits_in_even_line += 4;
			}
		}

	if(bits_in_odd_line > max_bits_in_line) max_bits_in_line = bits_in_odd_line;
	if(bits_in_even_line > max_bits_in_line) max_bits_in_line = bits_in_even_line;

//	fprintf(stderr, "max_bits_in_line=%d\n", max_bits_in_line);
	if(max_bits_in_line > 1440)
		{
		fprintf(stderr,\
		"dvd_encode(): bitmap too wide? max_bits_in_line=%d > 1440, aborting\n",\
		max_bits_in_line);

		exit(1);	
		}


	odd = 1 - odd;
	} /* end for y (all lines in an img) */ 

/* align on byte */
if(even_line_nibbles % 2) fprintf(stderr, "WAS ********************* even_line_nibbles %% 2***************\n");
if(odd_line_nibbles % 2)  fprintf(stderr, "WAS ********************* odd_line_nibbles %% 2 ***************\n");

if(even_line_nibbles % 2) even_line_nibbles++;
if(odd_line_nibbles % 2) odd_line_nibbles++;

/* nibbles to bytes XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */
//image_size = even_line_nibbles + odd_line_nibbles;
//image_size /= 2;
image_size = (even_line_nibbles / 2) + (odd_line_nibbles / 2); 

offset0 = 0;
offset1 = even_line_nibbles / 2;

/* max image size ! */
if(image_size > SUB_BUFFER_MAX)
	{
	fprintf(stderr, "dvd_encode(): image_size=%d > %d, aborting\n", image_size, SUB_BUFFER_MAX);

	exit(1);
	}

/* copy even and odd buffers to buffer */
memcpy(subtitle_image_buffer, even_buf, even_line_nibbles / 2);
memcpy(subtitle_image_buffer + offset1, odd_buf, odd_line_nibbles / 2); 

if(debug_flag)
	{
	fprintf(stderr,
	"rnibbles=%d even_line_nibbles=%d odd_line_nibbles=%d offset1=%d image_size=%d\n",\
	rnibbles, even_line_nibbles, odd_line_nibbles, offset1, image_size);

	fprintf(stderr,\
	"img=%p xd=%d yd=%d rnibbles=%d image_size=%d\n\
	even_line_nibbles=%d odd_line_nibbles=%d even + odd line nibbles=%d\n\
	offset0=%d offset1=%d\n",\
	img, xd, yd, rnibbles, image_size,\
	even_line_nibbles, odd_line_nibbles, even_line_nibbles + odd_line_nibbles,\
	offset0, offset1);
	}

#ifdef TEST_PIC
/* decode rle again to check */
oimg = malloc(xd * yd * 3);
if(! oimg)
	{
	fprintf(stderr, "could not allocate space for oimg, aborting.\n");

	exit(1);
	}

dsize = image_size;
ofs = 0;
ofs1 = offset1;
sub = subtitle_image_buffer;

bc = 0; // used by gn()
x = y = 0;
io = 0;
while( (ofs < dsize) && (y < yd) )
	{
	i = gn();

	if(i < 4)
		{
		i = (i << 4) + gn();
		if(i < 16)
			{
			i = (i << 4) + gn(); 
			if(i < 0x40)
				{
				i = (i << 4) + gn();
				if(i < 256)
					{
					bc = 0; 

					y += 2;
					while(x++ != xd) oimg[io++] = i;

					x = 0;
					if( (y >= yd) && !(y & 1) )
						{
						y = 1;
						io = xd;
						ofs = ofs1;
						}
					else io += xd;
					continue;
					} /* end if i < 256 */
				} /* end if i < 0x40 */
			} /* end if i < 16 */
		} /* end if i < 4 */

	c = i & 3;
	i = i >> 2;

	while(i--)
		{ 
		oimg[io++] = c; 
		if(++x == xd)
			{
			y += 2;
			x = 0;
			io += xd;
			bc = 0;
			} /* end if < line end */	
		} /* end while colors */

	} /* end while lines */

if(debug_flag)
	{
	fprintf(stderr,"ofs: 0x%x y: %d\n", ofs, y);
	fprintf(stderr, "offset0=%d offset1=%d xd=%d yd=%d x=%d y=%d ofs=%d ofs1=%d\n",\
	offset0, offset1, xd, yd, x, y, ofs, ofs1);
	}

ppmptr = fopen("otest.ppm", "w");
if(! ppmptr)
	{
	fprintf(stderr, "could not open file test.ppm for write, aborting.\n");

	exit(1);
	}

/* write a ppm file. */
fprintf(ppmptr, "P6\n%i %i\n255\n", xd, yd);
ucptr = oimg;
for(y = 0; y < yd; y++)
	{
	for(x = 0; x < xd; x++)
		{
		/* bgr */
/*
		fprintf(stderr, "y=%d x=%d *ucptr=%d  pal[*ucptr].b=%d pal[*ucptr].g=%d pal[*ucptr].r=%d\n",\
		y, x, *ucptr, pal[*ucptr].b, pal[*ucptr].g, pal[*ucptr].r);
*/
		fprintf(ppmptr, "%c", pal[*ucptr].r);
		fprintf(ppmptr, "%c", pal[*ucptr].g);
		fprintf(ppmptr, "%c", pal[*ucptr].b);

		ucptr++;
		} /* end for x */
	} /* end for y */

fclose(ppmptr);

icptr = fimg;
//icptr = img;// use if call to imgfix() commented out

/* compare byte for byte to original */
a = 0;
for(y = 0; y < yd; y++)
	{
	for(x = 0; x < xd; x++)
		{
		i = y * xd + x;

		if(icptr[i] != oimg[i])
			{
			a = 1;
			if(i > 2)
				{
				fprintf(stderr,\
	"V i=%d -2=0x%02x -1=0x%02x fimg[i]=0x%02x +1=0x%02x  -2=0x%02x -1=0x%02x oimg[i]=0x%02x +1=0x%02x\n",\
				i, icptr[i- 2], icptr[i - 1], icptr[i], icptr[i + 1],\
				oimg[i - 2], oimg[i - 1], oimg[i], oimg[i  + 1]);
				}
			else
				{
				fprintf(stderr,\
				"V i=%d fimg[i]=0x%02x  oimg[i]=0x%02x\n",\
				i, icptr[i], oimg[i]);
				}
			}
if(a) break;

		} /* end for x */
if(a) break;

	} /* end for y */

fprintf(stderr, "\n");
if(a)
	{
	fprintf(stderr, "rle coding error found at y=%d x=%d i=%d, test aborted.\n", y, x, i);
	exit(1);
	}
#endif /* TEST_PIC */

if(debug_flag)
	{
	fprintf(stderr,\
	"subtitle_image_buffer=%p image_size=%d\n", subtitle_image_buffer, image_size);
	fprintf(stderr, "subtitle_packet_buffer=%p\n", subtitle_packet_buffer);
	}

cptr = subtitle_packet_buffer;
//2 bytes packet size, to be filled in later
//2 bytes pointer to control area, to be filled in later
cptr += 4;

if(current_submux_command & 1)
	{
	/* copy image data to subtitle_packet_buffer */
	memcpy(cptr, subtitle_image_buffer, image_size);
	cptr += image_size;
	} /* end if current_submux_command & 1 */

/* start first command block */
/* 
control area starts here, with same pointer
SP_DCSQT
Sub-Picture Display Control SeQuence Table
This area contains blocks (SP_DCSQ) of commands to the decoder.
Each SP_DCSQ begins with a 2 word header

offset  name            contents
0       SP_DCSQ_STM     delay to wait before executing these commands.
                         The units are 90KHz clock (same as PTM) divided by 1024 - see below.

2       SP_NXT_DCSQ_SA  offset within the Sub-Picture Unit to the next SP_DCSQ.
                         If this is the last SP_DCSQ, it points to itself.

Converting frames and time to SP_DCSQ_STM values
The direct method of converting time to delay values is to multiply time in seconds by 90000/1024 and
truncate the value.
Rounding up will cause the display to occur one frame late.
*/

/* set pointer to this command block */
a = cptr - subtitle_packet_buffer;
subtitle_packet_buffer[2] = (a / 256) & 0xff;
subtitle_packet_buffer[3] = (a % 256) & 0xff;

if(debug_flag)
	{
	fprintf(stderr,
	"pointer to this command block=%d\n",\
	subtitle_packet_buffer[2] * 256 + subtitle_packet_buffer[3]);
	}

a = 0; // delay to wait before executing this command block
*cptr = (a / 256) & 0xff;
cptr++;
*cptr = (a % 256) & 0xff;
cptr++;

/* remember position, will set later */
next_command_ptr = cptr;
cptr++; // pointer to next command block, 2 bytes, to be filled in from next command block. 
cptr++;
if(debug_flag)
	{
	fprintf(stderr,
	"next_command_ptr=%p\n", next_command_ptr);
	}

if(current_submux_command & 8)
	{
	/* command 0, forced start display time, 1 byte. */
	*cptr = 0;
	cptr++;
	}

if(current_submux_command & 16)
	{
	/* Either FSTA_DSP or STA_DSP shall be described in the SP_DCSQ#0 */
	/* command 1, start display time, 1 byte */
	*cptr = 1;
	cptr++;
	}

if(current_submux_command & 1)
	{
	/* selected palettes for pixel value */

	/* 
	Set pointers to the color lookup table in the IFO (CLUT) for each parameter.
	Range = 0 - 15
	*/
	// now set in rns for defaults and if specified in the .sub file.

	/* 
	command 3, SET_COLOR, 3 bytes
	03 - SET_COLOR - provides four indices into the CLUT for the current PGC,
	to associate with the four pixel values.
	One nibble per pixel value for a total of 2 bytes.
	e2 e1   p b
	The CLUT is the color table in the IFO.
	*/

	if(debug_flag)
		{
		fprintf(stderr,\
		"current_background=%d current_pattern=%d current_emphasis1=%d current_emphasis2=%d\n",\
		current_background, current_pattern, current_emphasis1, current_emphasis2);
		}

	*cptr = 3;
	cptr++;
	*cptr = ( (current_emphasis2 & 0xf) << 4) | (current_emphasis1 & 0xf);
	cptr++;
	*cptr = ( (current_pattern & 0xf) << 4) | (current_background & 0xf);
	cptr++;

	if(debug_flag)
		{
		for(i = 0; i < 4; i++)
			{
			fprintf(stderr,\
			"epal[%d].r=%d epal[%d].g=%d epal[%d].b=%d epal[%d].t=%d\n",\
			i, epal[i].r, i, epal[i].g, i, epal[i].b, i, epal[i].t);
			}

		for(i = 0; i < 4; i++)
			{
			fprintf(stderr,\
			"pal[%d].r=%d pal[%d].g=%d pal[%d].b=%d pal[%d].t=%d\n",\
			i, pal[i].r, i, pal[i].g, i, pal[i].b, i, pal[i].t);
			}
		} /* end if debug_flag */

	/* command 4, alpha blend, contrast / transparency t_palette, 3 bytes  0, 15, 15, 15 */

	if(debug_flag)
		{
		fprintf(stderr, "epal[0].t=%d epal[1].t=%d epal[2].t=%d epal[3].t=%d\n",\
		epal[0].t, epal[1].t, epal[2].t, epal[3].t);
		}

	if(debug_flag)
		{
		fprintf(stdout,\
		"current_background_contrast=%d current_pattern_contrast=%d\n\
		current_emphasis1_contrast=%d current_emphasis2_contrast=%d\n",\
		current_background_contrast, current_pattern_contrast,\
		current_emphasis1_contrast, current_emphasis2_contrast);
		}

	*cptr = 4;
	cptr++;
	*cptr = ( (current_emphasis2_contrast & 0xf) << 4) | (current_emphasis1_contrast & 0xf); // 3(h) 2(l) blend1
	cptr++;
	*cptr = ( (current_pattern_contrast & 0xf) << 4) | (current_background_contrast & 0xf); // 1(h) 0(l) blend2
	cptr++;

	/* command 5, display area, 7 bytes from: startx, xsize, starty, ysize */
	xsize -= 1;
	ysize -= 1;

	/* for interlace need to start on an even line (0,2,4,..), else text jumps up and down */
	if(ystart % 2) ystart--;

	xend = xstart + xsize;
	yend = ystart + ysize;

	if(debug_flag)
		{
		fprintf(stderr, "in control buffer: xsize=%d ysize=%d  xstart=%d ystart=%d  xend=%d yend=%d\n",\
		xsize, ysize,  xstart, ystart,  xend, yend);
		}

	*cptr = 5;
	cptr++;
	*cptr = ( ( (xstart & 0xf00) >> 8) << 4)	| ( (xstart & 0xf0) >> 4);		// xstart xstart
	cptr++;
	*cptr = ( (xstart & 0xf) << 4)				| ( (xend & 0xf00) >> 8);		// xstart xend
	cptr++;
	*cptr = ( ( (xend & 0xf0) >> 4) << 4)		| (xend & 0xf);					// xend xend
	cptr++;
	*cptr = ( ( (ystart & 0xf00) >> 8) << 4)	| ( (ystart & 0xf0) >> 4);		// ystart ystart
	cptr++;
	*cptr = ( (ystart & 0xf) << 4)				| ( (yend & 0xf00) >> 8);		// ystart yend
	cptr++;
	*cptr = ( ( (yend & 0xf0) >> 4) << 4)		| (yend & 0xf);					// yend yend
	cptr++;

	/* command 6, image offsets, 5 bytes */
	*cptr = 6;
	cptr++;

	a = offset0 + 4;
	*cptr =  (a / 256) & 0xff;
	cptr++;
	*cptr = (a % 256) & 0xff;
	cptr++;

	a = offset1 + 4;
	*cptr = (a / 256) & 0xff;
	cptr++;
	*cptr = (a % 256) & 0xff;
	cptr++;
	} /* end if current_submux_command & 1 */

if(current_submux_command & 4)
	{
	if(debug_flag)
		{
		fprintf(stdout, "WAS COLCON\n");
		}

	/*
	command 7
	07 - CHG_COLCON - allows for changing the COLor and CONtrast within one or more areas of the display.
	This command contains a series of parameters, arranged in a hierarchy.
	Following the command byte is a 2-byte value for the total size of the parameter area, including the
	size word.
	The parameter sequence begins with a LN_CTLI, which defines a vertically bounded area of the display.
	The LN_CTLI may include from one to fifteen PX_CTLI parameters, which define a starting horizontal
	position and new color and contrast value to apply from that column on towards the right to the next
	PX_CTLI or the right side of the display.

	LN_CTLI, 4 bytes, special value of 0f ff ff ff signifies the end of the parameter area (this termination
	code MUST be present as the last parameter)
	0 s   s s   n t   t t 
	sss = csln, the starting (top-most) line number for this area
	n = number of PX_CTLI to follow
	ttt = ctln, the terminating (bottom-most) line number for this area

	PX_CTLI, 6 bytes, defines a starting column and new color and contrast values
	bytes 0 and 1 - starting column number
	bytes 2 and 3 - new color values, as per SET_COLOR
	bytes 4 and 5 - new contrast values, as per SET_CONTR

	Line Control Information (LN_CTLI) Line control information LN_CTLI is
	constituted by a change start line number, the number of changes (a change
	point count), and a change termination line number (or continuous line
	count).  The number of pixel control data each constituting line control
	information LN_CTLI and pixel control information PX_CTLI is set for
	sub-picture display frames, as needed. LN_CTLI, contains 4 bytes, the
	special value of 0f ff ff ff signifies the end of the parameter area (this
	termination code MUST be present as the last parameter) 0 s s s n t t t sss
	= csln, the starting (top-most) line number for this area n = number of
	PX_CTLI to follow ttt = ctln, the terminating (bottom-most) line number for
	this area

	Offset 7 6 5 4 3 2 1 0 0 reserved (0) Change Start Line numbers (upper bits)
	1 Change Start Line numbers (lower bits) 2 Number of Changes reserved (0)   
	Change Termination Line Number (upper bits) 3 Change Termination Line Number
	(lower bits)

	Change Start Line numbers:              Number of Line from which content of
	pixel control starts to change, and described by Line number of video
	display. Number of Changes: Number of Change Points (number of PX_CTLIs)
	spead evenly on lines to be changed, could be described with numbers between
	1 and 8. Change Termination Line Number: Number of Line Describes at which  
	content of pixel control terminates the change, and described by Line number
	of video display.

	Command LN_CTLI, change line number shall be within:
	2 .. 479 (TV system with 525/60)
	2 .. 574 (TV system with 625/50)

	-        Command LN_CTLI Number_of_changes
	shall be within 1..8.  At least 8 pixels with the same content shall be
	continued on the change start pixel and the pixels which follow.
	*/

	*cptr = 7; /* CHG_COLCON */
	cptr++;

	/* remember position, will set later */
	change_colcon_size = cptr;
	/* reserve 2 bytes for change size, to be set later */
	cptr += 2; 

	/*
	LN_CTLI, 4 bytes, special value of 0f ff ff ff signifies the end of the parameter area
	(this termination code MUST be present as the last parameter)
	0 s   s s   n t   t t
	sss = csln, the starting (top-most) line number for this area
	n = number of PX_CTLI to follow
	ttt = ctln, the terminating (bottom-most) line number for this area
	*/

	*cptr = (current_c_start_line & 0x300) >> 8;
	cptr++;

	*cptr = current_c_start_line & 0xff;
	cptr++;

	*cptr = (current_c_h_blocks << 4) | ( (current_c_end_line & 0x300) >> 8);
	cptr++;

	*cptr = current_c_end_line & 0xff;
	cptr++;

	/* any number of PX_CTLI blocks */
	for(i = 0; i < current_c_h_blocks; i++)
		{
		/*
		PX_CTLI, 6 bytes, defines a starting column and new color and contrast values
		bytes 0 and 1 - starting column number
		bytes 2 and 3 - new color values, as per SET_COLOR
		bytes 4 and 5 - new contrast values, as per SET_CONTR

		Note: I assume 'column' is really horizontal pixel number.
		*/

		/* horizontal start point */
		*cptr = (current_c_h_start[i] & 0x300) >> 8;
		cptr++;
		*cptr = current_c_h_start[i] & 0xff;
		cptr++;

		/* color */
		*cptr = (current_c_emphasis2[i] << 4) | current_c_emphasis1[i];
		cptr++;
		*cptr = (current_c_pattern[i] << 4) | current_c_background[i];
		cptr++;

		/* contrast */
		*cptr = ( (current_c_contrast3[i] & 0xf) << 4) | (current_c_contrast2[i] & 0xf);
		cptr++;
		*cptr = ( (current_c_contrast1[i] & 0xf) << 4) | (current_c_contrast0[i] & 0xf);
		cptr++;

		} /* end for all PX_CTLI */

	/* termination code LN_CTLI for this CHG_COLCON command */
	*cptr = 0x0f;
	cptr++;
	*cptr = 0xff;
	cptr++;
	*cptr = 0xff;
	cptr++;
	*cptr = 0xff;
	cptr++;

	/* set the 2 parameter area size bytes at start of CHG_COLCON command */
	a = cptr - change_colcon_size;	
	change_colcon_size[0] = (a / 256) & 0xff;
	change_colcon_size[1] = (a % 256) & 0xff;

	} /* end if current_submux_command & 4 */

/* command 0xff, end command block, 1 byte, */
*cptr = 0xff;
cptr++;

/* end first command block */


/* start second command block */
 
/* set pointer in previous block to point to this position */
a = cptr - subtitle_packet_buffer;
next_command_ptr[0] = a / 256;
next_command_ptr[1] = a % 256;

if(debug_flag)
	{
	fprintf(stderr, "next_command_ptr=%d\n", (256 * next_command_ptr[0]) + next_command_ptr[1]);
	}

/* update pointer to this command block */
next_command_ptr = cptr;

/* delay to wait before executing next command */
delay_units = sd / 1024;

if(debug_flag)
	{
	fprintf(stderr, "sd=%u delay_units=%d\n", sd, delay_units);
	}

*cptr = (delay_units / 256) & 0xff;
cptr++;
*cptr = (delay_units % 256) & 0xff;
cptr++;

/* last block, point to self */
a = next_command_ptr - subtitle_packet_buffer;
*cptr = (a / 256) & 0xff;
cptr++;
*cptr = (a % 256) & 0xff;
cptr++;

if(current_submux_command & 2)
	{
	/* stop command (executed after above delay) */
	*cptr = 0x02;
	cptr++;
	} /* end if current_submux_command &2  */

/* end command block command */
*cptr = 0xff;
cptr++;

/* end second commmand block */

/* set the packet size */
subtitle_packet_size = cptr - subtitle_packet_buffer;

/* make size even if odd */
if(subtitle_packet_size % 2)
	{
	if(debug_flag)
		{
		fprintf(stderr, "WAS ODD\n");
		}

	/* only if odd length, to make it even */
	cptr++;
	*cptr = 0xff;

	subtitle_packet_size++;
	}

/* set subtitle packet size */
a = subtitle_packet_size;
subtitle_packet_buffer[0] = (a / 256) & 0xff;
subtitle_packet_buffer[1] = (a % 256) & 0xff;

if(debug_flag)
	{
	fprintf(stderr,
	"subtitle_packet_size=%d\n",
	(subtitle_packet_buffer[0] * 256) + subtitle_packet_buffer[1]);
	}

/*
1 SPDSZ SP unit size shall be > 0. 
SP unit size shall be even !
SPU even size padding byte shall be 0xff .
SP unit size shall describe the size of a SPU in number of bytes.
SP unit size shall be <= 53.220 bytes.
The size of SP_ DCSQT in a SPU shall be equal or less than half the size of the SPU.
*/


#ifdef BIN_DUMP
fptest = fopen("subtitle_packet_buffer.bin", "w");
if(! fptest)
	{
	fprintf(stderr, "Could not open subtitle_packet_buffer.bin for write, aborting\n");
	exit(1);
	}

fwrite(subtitle_packet_buffer, 1, subtitle_packet_size, fptest);

fclose(fptest);

exit(1);
#endif /*BIN_DUMP */

return subtitle_packet_size;
} /* end function dvd_encode */


//size_t write(fdo, &c, 4);
size_t cwrite(int fd, const void *buf, size_t count)
{
size_t bytes_written;
size_t wret;

bytes_written = 0;
while(bytes_written < count)
	{
	errno = 0;
	wret = write(fd, buf + bytes_written, count - bytes_written);
	if(wret < 0)
		{
		fprintf(stderr, "WHOOPY ! write returned=%d, requested=%d\n", wret, count - bytes_written);	

		if(errno == EAGAIN) continue;
		if(errno == EINTR) continue;

		perror("write(): ");
		fprintf(stderr, "write(): fatal error, aborting\n");

		exit(1);		
		}

	if(wret != count - bytes_written)
		{
		fprintf(stderr, "write(): retry ****************************************************\n");
		}
		
	bytes_written += wret;
	}

return bytes_written;
} /* end function cwrite */


//ssize_t read(int fd, void *buf, size_t count)
size_t cread(int fd, void *buf, size_t count)
{
size_t bytes_read;
size_t rret;

bytes_read = 0;
while(bytes_read < count)
	{
	errno = 0;
	rret = read(fd, buf + bytes_read, count - bytes_read);
	if(rret < 0)
		{
		fprintf(stderr, "WHOOPY ! read returned=%d, requested=%d\n", rret, count - bytes_read);	

		if(errno == EAGAIN) continue;
		if(errno == EINTR) continue;

		perror("read(): ");
		fprintf(stderr, "read(): fatal error, aborting\n");

		exit(1);		
		}

	/* test for EOF */
	if(rret == 0)
		{
		return 0;
		}

	if(rret != count - bytes_read)
		{
		fprintf(stderr, "read(): retry count=%d bytes_read=%d **************************\n",\
		count, bytes_read);
		}
		
	bytes_read += rret;
	}

return bytes_read;
} /* end function cread */

