/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;

public class UnionNode
extends SetOperatorNode {
    private boolean addNewNodesCalled;
    boolean tableConstructor;
    boolean topTableConstructor;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        super.init(object, object2, object3, object5);
        this.tableConstructor = (Boolean)object4;
    }

    public void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    public void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        if (this.tableConstructor()) {
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof UnionNode) {
                UnionNode unionNode = resultSetNode;
                ((RowResultSetNode)unionNode.rightResultSet).setTableConstructorTypes(resultColumnList);
                resultSetNode = unionNode.leftResultSet;
            }
            ((RowResultSetNode)resultSetNode).setTableConstructorTypes(resultColumnList);
        }
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        if (optimizablePredicateList != null && !this.getCurrentAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = optimizablePredicateList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(optimizablePredicateList.getOptPredicate(i))) continue;
                optimizablePredicateList.removeOptPredicate(i);
            }
        }
        this.addOrLoadBestPlanMapping(true, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftOptPredicateList(), costEstimate);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightOptPredicateList(), costEstimate);
        CostEstimate costEstimate2 = this.getCostEstimate(optimizer);
        costEstimate2.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEstimate2.add(this.rightResultSet.costEstimate, costEstimate2);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, costEstimate2);
        optimizer.considerCost(this, optimizablePredicateList, costEstimate2, costEstimate);
        return costEstimate2;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.leftResultSet instanceof UnionNode) {
            ((UnionNode)this.leftResultSet).pushExpressions(predicateList);
        } else if (this.leftResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.leftResultSet, true);
        }
        if (this.rightResultSet instanceof UnionNode) {
            ((UnionNode)this.rightResultSet).pushExpressions(predicateList);
        } else if (this.rightResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.rightResultSet, true);
        }
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        Optimizable optimizable = super.modifyAccessPath(jBitSet);
        if (this.addNewNodesCalled) {
            return optimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return resultSetNode;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        ResultSetNode resultSetNode = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                resultSetNode = this.genNormalizeResultSetNode(this, false);
            }
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(124, resultSetNode.genProjectRestrict(), Boolean.FALSE, this.tableProperties, this.getContextManager());
            ((FromTable)resultSetNode).setTableNumber(this.tableNumber);
            resultSetNode.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
            this.all = true;
        }
        if (this.orderByList != null) {
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return resultSetNode;
    }

    public String toString() {
        return "";
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        super.bindExpressions(fromList);
        if (this.topTableConstructor && !this.insertSource) {
            RowResultSetNode rowResultSetNode;
            SetOperatorNode setOperatorNode;
            DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int n = 0;
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof SetOperatorNode) {
                setOperatorNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)setOperatorNode.rightResultSet;
                n += this.getParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = setOperatorNode.leftResultSet;
            }
            if ((n += this.getParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode)) < dataTypeDescriptorArray.length) {
                throw StandardException.newException("42Y10");
            }
            resultSetNode = this;
            while (resultSetNode instanceof SetOperatorNode) {
                setOperatorNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)setOperatorNode.rightResultSet;
                this.setParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = setOperatorNode.leftResultSet;
            }
            this.setParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode);
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.leftResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        this.closeMethodArgument(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getUnionResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount() + costEstimate2.singleScanRowCount());
        this.finalCostEstimate.add(costEstimate2, this.finalCostEstimate);
        return this.finalCostEstimate;
    }

    String getOperatorName() {
        return "UNION";
    }
}

