/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.math.BigInteger;

final class ConsistencyToken {
    private final byte[] bytes;
    private int hash = 0;

    ConsistencyToken(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConsistencyToken)) {
            return false;
        }
        ConsistencyToken consistencyToken = (ConsistencyToken)object;
        int n = this.bytes.length;
        if (n != consistencyToken.bytes.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bytes[i] == consistencyToken.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = this.bytes.length;
            for (int i = 0; i < n; ++i) {
                this.hash ^= this.bytes[i];
            }
        }
        return this.hash;
    }

    public String toString() {
        return new BigInteger(this.bytes).toString();
    }
}

