/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.SqlException;

public class EncryptionManager {
    transient Agent agent_;
    private static final byte[] modulusBytes__ = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private static final BigInteger modulus__ = new BigInteger(1, modulusBytes__);
    private static final byte[] baseBytes__ = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private static final BigInteger base__ = new BigInteger(1, baseBytes__);
    private static final int exponential_length__ = 255;
    private DHParameterSpec paramSpec_;
    private KeyPairGenerator keyPairGenerator_;
    private KeyPair keyPair_;
    private KeyAgreement keyAgreement_;
    private byte[] token_;
    private byte[] secKey_;
    private SecretKeyFactory secretKeyFactory_ = null;
    private String providerName;
    private Provider provider;

    public EncryptionManager(Agent agent) throws SqlException {
        this.agent_ = agent;
        try {
            Provider[] providerArray = Security.getProviders("KeyAgreement.DH");
            if (providerArray == null) {
                throw new NoSuchProviderException();
            }
            this.provider = providerArray[0];
            this.providerName = this.provider.getName();
            this.paramSpec_ = new DHParameterSpec(modulus__, base__, 255);
            this.keyPairGenerator_ = KeyPairGenerator.getInstance("DH", this.providerName);
            this.keyPairGenerator_.initialize(this.paramSpec_);
            this.keyPair_ = this.keyPairGenerator_.generateKeyPair();
            this.keyAgreement_ = KeyAgreement.getInstance("DH", this.providerName);
            this.keyAgreement_.init(this.keyPair_.getPrivate());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SqlException(this.agent_.logWriter_, noSuchProviderException, "java.security.NoSuchProviderException is caught when initializing EncryptionManager '" + noSuchProviderException.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SqlException(this.agent_.logWriter_, noSuchAlgorithmException, "java.security.NoSuchAlgorithmException is caught when initializing EncryptionManager '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SqlException(this.agent_.logWriter_, invalidAlgorithmParameterException, "java.security.InvalidAlgorithmParameterException is caught when initializing EncryptionManager '" + invalidAlgorithmParameterException.getMessage() + "'");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeyException, "java.security.InvalidKeyException is caught when initializing EncryptionManager '" + invalidKeyException.getMessage() + "'");
        }
    }

    public byte[] obtainPublicKey() {
        BigInteger bigInteger = ((DHPublicKey)this.keyPair_.getPublic()).getY();
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 33 && byArray[0] == 0) {
            byte[] byArray2 = new byte[32];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = byArray[i + 1];
            }
            return byArray2;
        }
        if (byArray.length < 32) {
            int n;
            byte[] byArray3 = new byte[32];
            for (n = 0; n < 32 - byArray.length; ++n) {
                byArray3[n] = 0;
            }
            for (int i = n; i < byArray3.length; ++i) {
                byArray3[i] = byArray[i - n];
            }
            return byArray3;
        }
        return byArray;
    }

    private byte[] calculateEncryptionToken(int n, byte[] byArray) {
        byte[] byArray2;
        block7: {
            block6: {
                byArray2 = new byte[8];
                if (n != 7) break block6;
                if (byArray.length < 8) {
                    int n2;
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        byArray2[n2] = byArray[n2];
                    }
                    for (n2 = byArray.length; n2 < 8; ++n2) {
                        byArray2[n2] = 0;
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        byArray2[i] = byArray[i];
                    }
                }
                break block7;
            }
            if (n != 9) break block7;
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = byArray[i + 12];
            }
        }
        return byArray2;
    }

    private void keyParityCheck(byte[] byArray) throws SqlException {
        if (byArray.length != 8) {
            throw new SqlException(this.agent_.logWriter_, "DES key has the wrong length");
        }
        for (int i = 0; i < 8; ++i) {
            byte by = byArray[i];
            int n = 1;
            for (int j = 0; j < 8; ++j) {
                if (by < 0) {
                    n = 1 - n;
                }
                by = (byte)(by << 1);
            }
            if (n != true) continue;
            if ((byArray[i] & 1) != 0) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] & 0xFE);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] | 1);
        }
    }

    private byte[] generatePrivateKey(byte[] byArray) throws SqlException {
        try {
            int n;
            int n2;
            KeyFactory keyFactory = KeyFactory.getInstance("DH", this.provider);
            BigInteger bigInteger = new BigInteger(1, byArray);
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, modulus__, base__);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            this.keyAgreement_.doPhase(publicKey, true);
            byte[] byArray2 = this.keyAgreement_.generateSecret();
            byte[] byArray3 = new byte[32];
            if (byArray2.length == 33 && byArray2[0] == 0) {
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    byArray3[n2] = byArray2[n2 + 1];
                }
            }
            if (byArray2.length < 32) {
                for (n2 = 0; n2 < 32 - byArray2.length; ++n2) {
                    byArray3[n2] = 0;
                }
                for (n = n2; n < byArray2.length; ++n) {
                    byArray3[n] = byArray2[n - n2];
                }
            }
            byte[] byArray4 = new byte[8];
            if (byArray2.length == 32) {
                for (n = 0; n < 8; ++n) {
                    byArray4[n] = byArray2[n + 12];
                }
            } else if (byArray2.length == 33 || byArray2.length < 32) {
                for (n = 0; n < 8; ++n) {
                    byArray4[n] = byArray3[n + 12];
                }
            } else {
                throw new SqlException(this.agent_.logWriter_, "sharedSecret key length error " + byArray2.length);
            }
            this.keyParityCheck(byArray4);
            return byArray4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SqlException(this.agent_.logWriter_, noSuchAlgorithmException, "java.security.NoSuchAlgorithmException is caught when encrypting data '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeySpecException, "java.security.InvalidKeySpecException is caught when encrypting data");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeyException, "java.security.InvalidKeyException is caught when encrypting data '" + invalidKeyException.getMessage() + "'");
        }
    }

    public byte[] encryptData(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SqlException {
        byte[] byArray4 = null;
        Object object = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(n, byArray2);
        }
        try {
            Object object2;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(byArray3);
                object = object2 = new SecretKeySpec(this.secKey_, "DES");
            } else {
                object2 = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                object = this.secretKeyFactory_.generateSecret((KeySpec)object2);
            }
            object2 = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.token_);
            ((Cipher)object2).init(1, (Key)object, ivParameterSpec);
            byArray4 = ((Cipher)object2).doFinal(byArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SqlException(this.agent_.logWriter_, noSuchProviderException, "java.security.NoSuchProviderException is caught when encrypting data '" + noSuchProviderException.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SqlException(this.agent_.logWriter_, noSuchAlgorithmException, "java.security.NoSuchAlgorithmException is caught when encrypting data '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeyException, "java.security.InvalidKeyException is caught when encrypting data '" + invalidKeyException.getMessage() + "'");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SqlException(this.agent_.logWriter_, noSuchPaddingException, "javax.crypto.NoSuchPaddingException is caught when encrypting data '" + noSuchPaddingException.getMessage() + "'");
        }
        catch (BadPaddingException badPaddingException) {
            throw new SqlException(this.agent_.logWriter_, badPaddingException, "javax.crypto.BadPaddingException is caught when encrypting data '" + badPaddingException.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SqlException(this.agent_.logWriter_, invalidAlgorithmParameterException, "java.security.InvalidAlgorithmParameterException is caught when encrypting data '" + invalidAlgorithmParameterException.getMessage() + "'");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SqlException(this.agent_.logWriter_, illegalBlockSizeException, "javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + illegalBlockSizeException.getMessage() + "'");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeySpecException, "javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + invalidKeySpecException.getMessage() + "'");
        }
        return byArray4;
    }

    public byte[] decryptData(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SqlException {
        byte[] byArray4 = null;
        Object object = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(n, byArray2);
        }
        try {
            Object object2;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(byArray3);
                object = object2 = new SecretKeySpec(this.secKey_, "DES");
            } else {
                object2 = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                object = this.secretKeyFactory_.generateSecret((KeySpec)object2);
            }
            object2 = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.token_);
            ((Cipher)object2).init(2, (Key)object, ivParameterSpec);
            byArray4 = ((Cipher)object2).doFinal(byArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SqlException(this.agent_.logWriter_, noSuchProviderException, "java.security.NoSuchProviderException is caught when encrypting data '" + noSuchProviderException.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SqlException(this.agent_.logWriter_, noSuchAlgorithmException, "java.security.NoSuchAlgorithmException is caught when encrypting data '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeyException, "java.security.InvalidKeyException is caught when encrypting data '" + invalidKeyException.getMessage() + "'");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SqlException(this.agent_.logWriter_, noSuchPaddingException, "javax.crypto.NoSuchPaddingException is caught when encrypting data '" + noSuchPaddingException.getMessage() + "'");
        }
        catch (BadPaddingException badPaddingException) {
            throw new SqlException(this.agent_.logWriter_, badPaddingException, "javax.crypto.BadPaddingException is caught when encrypting data '" + badPaddingException.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SqlException(this.agent_.logWriter_, invalidAlgorithmParameterException, "java.security.InvalidAlgorithmParameterException is caught when encrypting data '" + invalidAlgorithmParameterException.getMessage() + "'");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SqlException(this.agent_.logWriter_, illegalBlockSizeException, "javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + illegalBlockSizeException.getMessage() + "'");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SqlException(this.agent_.logWriter_, invalidKeySpecException, "javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + invalidKeySpecException.getMessage() + "'");
        }
        return byArray4;
    }

    public void setInitVector(byte[] byArray) {
        this.token_ = byArray;
    }

    public void setSecKey(byte[] byArray) {
        this.secKey_ = byArray;
    }

    public void resetSecurityKeys() {
        this.token_ = null;
        this.secKey_ = null;
    }
}

