/* File: defines.h */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */


/*
 * Release state, CVS or not, remember to switch it when making releases
 */

#ifndef IS_CVS
/*#define IS_CVS          ""*/
#define IS_CVS          ""
#endif

#define USER_PATH_VERSION "/2.3"

#define ANGBAND_2_8_1

#define SAVEFILE_VERSION 103

/*
 * This value is not currently used
 */
#define VERSION_EXTRA   0

/*
 * Maximum amount of Angband windows.
 */
#define ANGBAND_TERM_MAX 8

/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	33


/*
 * Number of grids used to display the dungeon (vertically).
 * Must be a multiple of 11, probably hard-coded to 22.
 */
#define SCREEN_HGT      22

/*
 * Number of grids used to display the dungeon (horizontally).
 * Must be a multiple of 33, probably hard-coded to 66.
 */
#define SCREEN_WID      66


/*
 * Maximum dungeon height in grids, must be a multiple of SCREEN_HGT,
 * probably hard-coded to SCREEN_HGT * 3.
 */
#define MAX_HGT         66

/*
 * Maximum dungeon width in grids, must be a multiple of SCREEN_WID,
 * probably hard-coded to SCREEN_WID * 3.
 */
#define MAX_WID         198

/* Used only in object3.c / trap effects */
#if ((MAX_HGT / SCREEN_HGT) < (MAX_WID / SCREEN_WID))
 #define RATIO (MAX_WID / SCREEN_WID)
#else
 #define RATIO (MAX_HGT / SCREEN_HGT)
#endif

/*
 * Default radius of detection spells
 * Its area must be at least as large as SCREEN_WID * SCREEN_HGT
 */
#define DEFAULT_RADIUS	25


#define CHANCE_TRAP_JAMMED_DOOR 2500
#define CHANCE_TRAP_SECRET_DOOR 1500
#define CHANCE_TRAP_LOCKED_DOOR 1000
#define CHANCE_TRAP_DOOR  500        /* in 10000 */
#define CHANCE_TRAP_FLOOR 4          /* in 10000 chance of placing a trap */

#define MAX_BOUNTIES        24

#define MAX_SPELLS          100
#define MAX_RUNES           100

/*
 * Arena constants
 */
#define MAX_ARENA_MONS		29	/* -KMW- */

/*
 * Total number of stores (see "store.c", etc)
 */
#define STORE_GENERAL   0
#define STORE_ARMOURY   1
#define STORE_WEAPON    2
#define STORE_TEMPLE    3
#define STORE_ALCHEMIST 4
#define STORE_MAGIC     5
#define STORE_BLACK     6
#define STORE_HOME      7
#define STORE_BOOK      8
#define STORE_PET       9

/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES            3

/* The number of "patrons" available (for Chaos Warriors) */
#define MAX_PATRON          16

/* Number of Random Artifacts */
#define MAX_RANDARTS 84
#define MAX_T_ACT    51

/* Chaos Warrior: Reward types: */
#define REW_POLY_SLF    0
#define REW_GAIN_EXP    1
#define REW_LOSE_EXP    2
#define REW_GOOD_OBJ    3
#define REW_GREA_OBJ    4
#define REW_CHAOS_WP    5
#define REW_GOOD_OBS    6
#define REW_GREA_OBS    7
#define REW_TY_CURSE    8
#define REW_SUMMON_M    9
#define REW_H_SUMMON    10
#define REW_DO_HAVOC    11
#define REW_GAIN_ABL    12
#define REW_LOSE_ABL    13
#define REW_RUIN_ABL    14
#define REW_AUGM_ABL    15
#define REW_POLY_WND    16
#define REW_HEAL_FUL    17
#define REW_HURT_LOT    18
#define REW_CURSE_WP    19
#define REW_CURSE_AR    20
#define REW_PISS_OFF    21
#define REW_WRATH       22
#define REW_DESTRUCT    23
#define REW_GENOCIDE    24
#define REW_MASS_GEN    25
#define REW_DISPEL_C    26
#define REW_UNUSED_1    27
#define REW_UNUSED_2    28
#define REW_UNUSED_3    29
#define REW_UNUSED_4    30
#define REW_UNUSED_5    31
#define REW_IGNORE      32
#define REW_SER_UNDE    33
#define REW_SER_DEMO    34
#define REW_SER_MONS    35


/* bear barehanded attacks      ... */
#define MAX_BEAR        8

/* Monk martial arts... */
#define MAX_MA          17

#define MA_KNEE         0x0001
#define MA_SLOW         0x0002
#define MA_WOUND        0x0004
#define MA_STUN         0x0008
#define MA_FULL_SLOW    0x0010

/* Mindcraft */
#define MAX_MINDCRAFT_POWERS  12

/* Necromancy */
#define MAX_NECRO_POWERS  6

/* Mimicry */
#define MAX_MIMIC_POWERS  5

/* Symbiosis */
#define MAX_SYMBIOTIC_POWERS  9


/* A hack for cave.c */
#define BMP_FIRST_PC_CLASS 164
#define BMP_FIRST_PC_RACE 128


/*
 * Size of memory reserved for initialization of some arrays
 */
#define FAKE_NAME_SIZE  40 * 1024L
#define FAKE_TEXT_SIZE 120 * 1024L


/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES    100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH               128
#define MAX_DEPTH_MONSTER       200


/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 5, and even if the "lite"
 * was rectangular, we would never require more than 128 entries in the array.
 */
#define LITE_MAX 1536

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 16384


/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * OPTION: Maximum number of "quarks" (see "io.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX       768
	/* Was 512... 256 quarks added for random artifacts */

/*
 * OPTION: Maximum number of messages to remember (see "io.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX     2048

#define MESSAGE_NONE    0
#define MESSAGE_MSG     1
#define MESSAGE_IRC     2

/*
 * OPTION: Maximum space for the message text buffer (see "io.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF     32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767


/*
 * Store constants
 */
#define STORE_INVEN_MAX 255             /* Max number of discrete objs in inven */
#define STORE_CHOICES   56              /* Number of items to choose stock from */
#define STORE_OBJ_LEVEL 5               /* Magic Level for normal stores */
#define STORE_TURNOVER  9               /* Normal shop turnover, per day */
#define STORE_MIN_KEEP  6               /* Min slots to "always" keep full */
#define STORE_MAX_KEEP  18              /* Max slots to "always" keep full */
#define STORE_SHUFFLE   21              /* 1/Chance (per day) of an owner changing */
#define STORE_TURNS             1000    /* Number of turns between turnovers */

/*
 * Misc constants
 */
#define DAY                     11520                   /* Number of turns per day */
#define YEAR                    (DAY * 365)             /* Number of turns per year */
#define HOUR                    (DAY / 24)              /* Number of turns per hour */
#define MINUTE                  (HOUR / 60)             /* Number of turns per minute */
#define DAY_START               (HOUR * 6)              /* Sunrise */
#define START_YEAR              2890                    /* Bilbo birthday year */
#define START_DAY               (DAY * (42 + 127))      /* Bilbo birthday */

#define BREAK_GLYPH             550             /* Rune of protection resistance */
#define BREAK_MINOR_GLYPH       99             /* For explosive runes */
#define BTH_PLUS_ADJ    3       /* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ    10              /* High value slows multiplication */
#define MON_SUMMON_ADJ  2               /* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE  2               /* Percent of player exp drained per hit */
#define USE_DEVICE      3               /* x> Harder devices x< Easier devices     */

#define BIAS_ELEC 1                     /* "Biases" for random artifact gen */
#define BIAS_POIS 2
#define BIAS_FIRE 3
#define BIAS_COLD 4
#define BIAS_ACID 5
#define BIAS_STR 6
#define BIAS_INT 7
#define BIAS_WIS 8
#define BIAS_DEX 9
#define BIAS_CON 10
#define BIAS_CHR 11
#define BIAS_CHAOS 12
#define BIAS_PRIESTLY 13
#define BIAS_NECROMANTIC 14
#define BIAS_LAW 15
#define BIAS_ROGUE 16
#define BIAS_MAGE 17
#define BIAS_WARRIOR 18
#define BIAS_RANGER 19

/*
 * Location of objects when they were found
 */
#define OBJ_FOUND_MONSTER       1
#define OBJ_FOUND_FLOOR         2
#define OBJ_FOUND_VAULT         3
#define OBJ_FOUND_SPECIAL       4
#define OBJ_FOUND_RUBBLE        5
#define OBJ_FOUND_REWARD        6
#define OBJ_FOUND_STORE         7
#define OBJ_FOUND_STOLEN        8
#define OBJ_FOUND_SELFMADE      9
/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ       20

#define GREAT_EGO       20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       50              /* 1/chance of inflated monster level */



/*
 * Refueling constants
 */
#define FUEL_TORCH      5000    /* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT       20      /* Maximum view distance */
#define MAX_RANGE       18      /* Maximum range (spells, etc) */



/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD          4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN          8


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO       100


/*
 * Player constants
 */
#define SUBRACE_SAVE    9               /* Ugly hack, should be in foo-info, the subrace saved to the savefile */
#define PY_MAX_EXP      99999999L       /* Maximum exp */
#define PY_MAX_GOLD     999999999L      /* Maximum gold */
#define PY_MAX_LEVEL    50              /* Maximum level */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_MAX             15000   /* Food value (Bloated) */
#define PY_FOOD_FULL    10000   /* Food value (Normal) */
#define PY_FOOD_ALERT   2000    /* Food value (Hungry) */
#define PY_FOOD_WEAK    1000    /* Food value (Weak) */
#define PY_FOOD_FAINT   500             /* Food value (Fainting) */
#define PY_FOOD_STARVE  100             /* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL         197             /* Regen factor*2^16 when full */
#define PY_REGEN_WEAK           98              /* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT          33              /* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE         1442    /* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE         524             /* Min amount mana regen*2^16 */

/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK              23

/*
 * Body parts
 */
#define BODY_WEAPON     0
#define BODY_TORSO      1
#define BODY_ARMS       2
#define BODY_FINGER     3
#define BODY_HEAD       4
#define BODY_LEGS       5
#define BODY_MAX        6

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD     24 /* 3 weapons -- WEAPONS */
#define INVEN_BOW       27 /* 1 bow -- WEAPON */
#define INVEN_RING      28 /* 6 rings -- FINGER */
#define INVEN_NECK      34 /* 2 amulets -- HEAD */
#define INVEN_LITE      36 /* 1 lite -- TORSO */
#define INVEN_BODY      37 /* 1 body -- TORSO */
#define INVEN_OUTER     38 /* 1 cloak -- TORSO */
#define INVEN_ARM       39 /* 3 arms -- ARMS */
#define INVEN_HEAD      42 /* 2 heads -- HEAD */
#define INVEN_HANDS     44 /* 3 hands -- ARMS */
#define INVEN_FEET      47 /* 2 feets -- LEGS */
#define INVEN_CARRY     49 /* 1 carried monster -- TORSO */
#define INVEN_AMMO      50 /* 1 quiver -- TORSO */
#define INVEN_TOOL      51 /* 1 tool -- ARMS */

/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL     52
#define INVEN_EQ        (INVEN_TOTAL - INVEN_WIELD)

/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE                  100



/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR   0
#define A_INT   1
#define A_WIS   2
#define A_DEX   3
#define A_CON   4
#define A_CHR   5

/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE              0
#define SEX_MALE                1
#define SEX_NEUTER              2


/* Race flags */
#define PR1_EXPERIMENTAL        0x00000001L     /* Is still under developemnt */
/* XXX */
#define PR1_RESIST_BLACK_BREATH 0x00000004L     /* Resist black breath */
#define PR1_NO_STUN             0x00000008L     /* Never stunned */
#define PR1_XTRA_MIGHT_BOW      0x00000010L     /* Xtra might with bows */
#define PR1_XTRA_MIGHT_XBOW     0x00000020L     /* Xtra might with xbows */
#define PR1_XTRA_MIGHT_SLING    0x00000040L     /* Xtra might with slings */
#define PR1_AC_LEVEL            0x00000080L     /* More AC with levels */
#define PR1_HURT_LITE           0x00000100L     /* Hurt by light */
#define PR1_VAMPIRE             0x00000200L     /* Vampire */
#define PR1_UNDEAD              0x00000400L     /* Undead */
#define PR1_NO_CUT              0x00000800L     /* no cuts */
#define PR1_CORRUPT             0x00001000L     /* hack-- corrupted */
#define PR1_NO_FOOD             0x00002000L     /* little gain from food */
#define PR1_NO_GOD              0x00004000L     /* cannot worship */
/* XXX */
#define PR1_ELF                 0x00010000L     /* Is an elf */
#define PR1_SEMI_WRAITH         0x00020000L     /* Takes damage when going in walls */
#define PR1_NO_SUBRACE_CHANGE   0x00040000L     /* Impossible to change subrace */
/* XXX */
#define PR1_ANTIMAGIC           0x00100000L     /* antimagic ... hack */
#define PR1_MOLD_FRIEND         0x00200000L     /* Not attacked by molds wielded */
#define PR1_GOD_FRIEND          0x00400000L     /* Better grace */
/* XXX */
#define PR1_INNATE_SPELLS       0x01000000L     /* KNown all spells, only need books */
/* XXX */
/* XXX */
#define PR1_EASE_STEAL          0x08000000L     /* Gain xp by stealing */
/* XXX */
/* XXX */
/* XXX */
/* XXX */

/* XXX */
#define PR2_ASTRAL              0x00000002L     /* Is it an astral being coming from th halls of mandos ? */
/* XXX */

#define PRACE_FLAG2(f)          ((rp_ptr->flags2 | rmp_ptr->flags2 | cp_ptr->flags2 | spp_ptr->flags2) & (f))
#define PRACE_FLAG(f)           ((rp_ptr->flags1 | rmp_ptr->flags1 | cp_ptr->flags1 | spp_ptr->flags1) & (f))
#define PRACE_FLAGS(f)          PRACE_FLAG(f)

/* XXX */
#define MKEY_MINDCRAFT          2
#define MKEY_ANTIMAGIC          3
#define MKEY_BLADE              4
#define MKEY_ALCHEMY            5
#define MKEY_MIMIC              6
#define MKEY_NECRO              7
#define MKEY_POWER_MAGE         8
#define MKEY_RUNE               9
#define MKEY_FORGING            10
#define MKEY_INCARNATION        11
#define MKEY_TELEKINESIS        12
#define MKEY_SUMMON             13
#define MKEY_TRAP               14
#define MKEY_STEAL              15
#define MKEY_DODGE              16
#define MKEY_SCHOOL             17
#define MKEY_LEARN              18
#define MKEY_COPY               19
#define MKEY_SYMBIOTIC          20
#define MKEY_BOULDER            21
#define MKEY_COMPANION          22
#define MKEY_PIERCING           23


/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_MAP                 1
#define COL_MAP                 13		/* Dungeon map */

#define ROW_RACE                1
#define COL_RACE                0       /* <race name> */

#define ROW_CLASS               2
#define COL_CLASS               0       /* <class name> */

#define ROW_TITLE               3
#define COL_TITLE               0       /* <title> or <mode> */

#define ROW_LEVEL               4
#define COL_LEVEL               0       /* "LEVEL xxxxxx" */

#define ROW_EXP                 5
#define COL_EXP                 0       /* "EXP xxxxxxxx" */

#define ROW_GOLD                6
#define COL_GOLD                0       /* "AU xxxxxxxxx" */

#define ROW_STAT                8
#define COL_STAT                0       /* "xxx   xxxxxx" */

#define ROW_AC                  14
#define COL_AC                  0       /* "Cur AC xxxxx" */

#define ROW_HP                  15
#define COL_HP                  0       /* "HP xxxxx/xxxxx" */

#define ROW_SANITY              16      /* "Sanity  100%" */
#define COL_SANITY              0

#define ROW_SP                  17
#define COL_SP                  0       /* "SP xxxxx/xxxxx" */

#define ROW_PIETY               18
#define COL_PIETY               0       /* "Pt xxxxx/xxxxx" */

#define ROW_MH                  19
#define COL_MH                  0       /* "MH xxxxx/xxxxx" */

#define ROW_INFO                (Term->hgt - 4)
#define COL_INFO                0       /* "xxxxxxxxxxxx" */

#define ROW_CUT                 (Term->hgt - 3)
#define COL_CUT                 0       /* <cut> */

#define ROW_STUN                (Term->hgt - 2)
#define COL_STUN                0       /* <stun> */

#define ROW_HUNGRY              (Term->hgt - 1)
#define COL_HUNGRY              0       /* "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_BLIND               (Term->hgt - 1)
#define COL_BLIND               7       /* "Blind" */

#define ROW_CONFUSED            (Term->hgt - 1)
#define COL_CONFUSED            13      /* "Conf" */

#define ROW_AFRAID              (Term->hgt - 1)
#define COL_AFRAID              18      /* "Afraid" */

#define ROW_POISONED            (Term->hgt - 1)
#define COL_POISONED            25      /* "Poison" */

#define ROW_DTRAP               (Term->hgt - 1)
#define COL_DTRAP               32      /* "DTrap" */

#define ROW_STATE               (Term->hgt - 1)
#define COL_STATE               38      /* <state> */

#define ROW_SPEED               (Term->hgt - 1)
#define COL_SPEED               49      /* "Slow (-NN)" or "Fast (+NN)" */

#define ROW_STUDY               (Term->hgt - 1)
#define COL_STUDY               60      /* "Study" */

#define ROW_DEPTH               (Term->hgt - 1)
#define COL_DEPTH               (Term->wid - 14) /* "Lev NNN" / "NNNN ft" */



/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE               0x00

/* Basic features */
#define FEAT_FLOOR              0x01
#define FEAT_FOUNTAIN           0x02
#define FEAT_GLYPH              0x03
#define FEAT_OPEN               0x04
#define FEAT_BROKEN             0x05
#define FEAT_LESS               0x06
#define FEAT_MORE               0x07

/* Quest features -KMW- */
#define FEAT_QUEST_ENTER        0x08
#define FEAT_QUEST_EXIT         0x09
#define FEAT_QUEST_DOWN         0x0A
#define FEAT_QUEST_UP           0x0B

/* Shafts -GSN- */
#define FEAT_SHAFT_DOWN         0x0D
#define FEAT_SHAFT_UP           0x0E

/* Basic feature */
#define FEAT_EMPTY_FOUNTAIN     0x0F

/* Feature 0x10 -- web */

/* Traps */
#define FEAT_TRAP               0x11

/* Features 0x12 - 0x1F -- unused */

/* Doors */
#define FEAT_DOOR_HEAD          0x20
#define FEAT_DOOR_TAIL          0x2F

/* Extra */
#define FEAT_SECRET             0x30
#define FEAT_RUBBLE             0x31

/* Seams */
#define FEAT_MAGMA              0x32
#define FEAT_QUARTZ             0x33
#define FEAT_MAGMA_H            0x34
#define FEAT_QUARTZ_H           0x35
#define FEAT_MAGMA_K            0x36
#define FEAT_QUARTZ_K           0x37

/* Walls */
#define FEAT_WALL_EXTRA         0x38
#define FEAT_WALL_INNER         0x39
#define FEAT_WALL_OUTER         0x3A
#define FEAT_WALL_SOLID         0x3B
#define FEAT_PERM_EXTRA         0x3C
#define FEAT_PERM_INNER         0x3D
#define FEAT_PERM_OUTER         0x3E
#define FEAT_PERM_SOLID         0x3F

/* Explosive rune */
#define FEAT_MINOR_GLYPH        0x40

/* Pattern */
#define FEAT_PATTERN_START      0x41
#define FEAT_PATTERN_1          0x42
#define FEAT_PATTERN_2          0x43
#define FEAT_PATTERN_3          0x44
#define FEAT_PATTERN_4          0x45
#define FEAT_PATTERN_END        0x46
#define FEAT_PATTERN_OLD        0x47
#define FEAT_PATTERN_XTRA1      0x48
#define FEAT_PATTERN_XTRA2      0x49

/* Shops */
#define FEAT_SHOP               0x4A

/* Permanent walls for quests */
#define FEAT_QUEST1             0x4B
#define FEAT_QUEST2             0x4C
#define FEAT_QUEST3             0x4D
#define FEAT_QUEST4             0x4E

/* Features 0x4F - 0x53 -- unused */

/* Additional terrains */
#define FEAT_SHAL_WATER         0x54
#define FEAT_DEEP_LAVA          0x55
#define FEAT_SHAL_LAVA          0x56
#define FEAT_DARK_PIT           0x57
#define FEAT_DIRT               0x58
#define FEAT_GRASS              0x59
#define FEAT_ICE                0x5A
#define FEAT_SAND               0x5B
#define FEAT_DEAD_TREE          0x5C
#define FEAT_DEAD_SMALL_TREE    212
#define FEAT_ASH                0x5D
#define FEAT_MUD                0x5E
#define FEAT_ICE_WALL           0x5F
#define FEAT_TREES              0x60
#define FEAT_MOUNTAIN           0x61
#define FEAT_SANDWALL           0x62
#define FEAT_SANDWALL_H         0x63
#define FEAT_SANDWALL_K         0x64
/* Feature 0x65 -- high mountain chain */
/* Feature 0x66 -- nether mist */

/* Features 0x67 - 0x9F -- unused */

#define FEAT_BETWEEN            0xA0 /* 160 */

/* Altars */
#define FEAT_ALTAR_HEAD         0xA1 /* 161 */
#define FEAT_ALTAR_TAIL         0xAB /* 171 */

#define FEAT_MARKER             0xAC /* 172 */
/* Feature 0xAD -- Underground Tunnel */
#define FEAT_TAINTED_WATER      0xAE /* 174 */
#define FEAT_MON_TRAP           0xAF /* 175 */
#define FEAT_BETWEEN2           0xB0 /* 176 */
#define FEAT_LAVA_WALL          0xB1 /* 177 */
#define FEAT_GREAT_FIRE         0xB2 /* 178 */
#define FEAT_WAY_MORE           0xB3 /* 179 */
#define FEAT_WAY_LESS           0xB4 /* 180 */
/* Feature 0xB5 -- field */
#define FEAT_EKKAIA             0xB6 /* 182 */

/* Features 0xB7 - 0xBA -- unused */

#define FEAT_DEEP_WATER         0xBB /* 187 */
#define FEAT_GLASS_WALL         0xBC /* 188 */
#define FEAT_ILLUS_WALL         0xBD /* 189 */
/* Feature 0xBE -- grass roof */
/* Feature 0xBF -- grass roof top */
/* Feature 0xC0 -- grass roof chimney */
/* Feature 0xC1 -- brick roof */
/* Feature 0xC2 -- brick roof top */
/* Feature 0xC3 -- brick roof chimney */
/* Feature 0xC4 -- window */
/* Feature 0xC5 -- small window */
/* Feature 0xC6 -- rain barrel */
#define FEAT_FLOWER             0xC7 /* 199 */
/* Feature 0xC8 -- cobblestone road */
/* Feature 0xC9 -- cobblestone with outlet */
#define FEAT_SMALL_TREES        0xCA /* 202 */
#define FEAT_TOWN               0xCB /* 203 */
/* Feature 0xCC -- Underground Tunnel */
#define FEAT_FIRE               0xCD /* 205 */
/* Feature 0xCE -- pile of rubble (permanent) */

/* Features 0xCF - 0xFF -- unused */


#define MAX_BETWEEN_EXITS       2

/*
 * Number of effects
 */
#define MAX_EFFECTS             128
#define EFF_WAVE                0x00000001      /* A circle whose radius increase */
#define EFF_LAST                0x00000002      /* The wave lasts */
#define EFF_STORM               0x00000004      /* The area follows the player */
#define EFF_DIR1                0x00000008      /* Directed effect */
#define EFF_DIR2                0x00000010      /* Directed effect */
#define EFF_DIR3                0x00000020      /* Directed effect */
#define EFF_DIR4                0x00000040      /* Directed effect */
#define EFF_DIR6                0x00000080      /* Directed effect */
#define EFF_DIR7                0x00000100      /* Directed effect */
#define EFF_DIR8                0x00000200      /* Directed effect */
#define EFF_DIR9                0x00000400      /* Directed effect */

/*
 * Wilderness terrains
 */
#define TERRAIN_EDGE             0 /* Edge of the World */
#define TERRAIN_TOWN             1 /* Town */
#define TERRAIN_DEEP_WATER       2 /* Deep water */
#define TERRAIN_SHALLOW_WATER    3 /* Shallow water */
#define TERRAIN_SWAMP            4 /* Swamp */
#define TERRAIN_DIRT             5 /* Dirt */
#define TERRAIN_GRASS            6 /* Grass */
#define TERRAIN_TREES            7 /* Trees */
#define TERRAIN_DESERT           8 /* Desert */
#define TERRAIN_SHALLOW_LAVA     9 /* Shallow lava */
#define TERRAIN_DEEP_LAVA       10 /* Deep lava */
#define TERRAIN_MOUNTAIN        11 /* Mountain */

#define MAX_WILD_TERRAIN        18

/*** Artifact indexes (see "lib/edit/a_info.txt") ***/


/* Lites */
#define ART_GALADRIEL                   1
#define ART_ELENDIL                     2
#define ART_THRAIN                      3
#define ART_PALANTIR                    202
#define ART_UNDEATH                     200
#define ART_STONE_LORE                  15
#define ART_PALANTIR_ITHIL              208

/* Amulets */
#define ART_CARLAMMAS                   4
#define ART_INGWE                       5
#define ART_DWARVES                     6
#define ART_ANCHOR                      14
#define ART_ELESSAR                     206
#define ART_EVENSTAR                    207

/* Rings */
#define ART_FLAR                        7
#define ART_BARAHIR                     8
#define ART_TULKAS                      9
#define ART_NARYA                       10
#define ART_NENYA                       11
#define ART_VILYA                       12
#define ART_POWER                       13
/* 14 used by the anchor of space-time */
/* 15 used by the stone of lore */

/* Dragon Scale */
#define ART_RAZORBACK           16
#define ART_BLADETURNER         17
#define ART_MEDIATOR            166

/* Hard Armour */
#define ART_HIMRING             167
#define ART_SOULKEEPER          19
#define ART_ISILDUR             20
#define ART_ROHIRRIM            21
#define ART_BELEGENNON          22
#define ART_CELEBORN            23
#define ART_ARVEDUI             24
#define ART_CASPANION           25

/* Thunderlord flying suit */
#define ART_MARDA               26
#define ART_TRON                27

/* Soft Armour */
#define ART_THALKETTOTH         28

/* Shields */
#define ART_THORIN                      30
#define ART_CELEGORM                    31
#define ART_ANARION                     32
#define ART_GILGALAD                    169
#define ART_HARADRIM                    176

/* Helms and Crowns */
#define ART_MORGOTH                     34
#define ART_BERUTHIEL           35
#define ART_THRANDUIL           36
#define ART_THENGEL                     37
#define ART_HAMMERHAND          38
#define ART_DOR                         39
#define ART_HOLHENNETH          40
#define ART_GORLIM                      41
#define ART_GONDOR                      42
#define ART_KNOWLEDGE                   160
#define ART_NUMENOR                     43
#define ART_CELEBRIMBOR                 170

/* Cloaks */
#define ART_COLLUIN                     44
#define ART_HOLCOLLETH          45
#define ART_THINGOL                     46
#define ART_THORONGIL           47
#define ART_COLANNON            48
#define ART_LUTHIEN                     49
#define ART_TUOR                        50

/* Gloves */
#define ART_CAMBELEG            52
#define ART_CAMMITHRIM          53
#define ART_PAURHACH            54
#define ART_PAURNIMMEN          55
#define ART_PAURAEGEN           56
#define ART_PAURNEN                     57
#define ART_CAMLOST                     58
#define ART_FINGOLFIN           59
#define ART_EOL                 178

/* Boots */
#define ART_FEANOR                      60
#define ART_DAL                         61
#define ART_THROR                       62

/* Swords */
#define ART_NARSIL              164
#define ART_MAEDHROS            64
#define ART_ANGRIST                     65
#define ART_NARTHANC            66
#define ART_NIMTHANC            67
#define ART_DETHANC                     68
#define ART_RILIA                       69
#define ART_BELANGIL            70
#define ART_CALRIS                      71
#define ART_ARUNRUTH            72
#define ART_GLAMDRING           73
#define ART_AEGLIN                      74
#define ART_ORCRIST                     75
#define ART_GURTHANG            76
#define ART_ZARCUTHRA           77
#define ART_MORMEGIL            78
#define ART_GONDRICAM           79
#define ART_CRISDURIAN          80
#define ART_AGLARANG            81
#define ART_RINGIL                      82
#define ART_ANDURIL                     83
#define ART_ANGUIREL            84
#define ART_ELVAGIL                     85
#define ART_FORASGIL            86
#define ART_CARETH                      87
#define ART_STING                       88
#define ART_HARADEKKET          89
#define ART_GILETTAR            90
#define ART_DOOMCALLER          91
#define ART_VORPAL_BLADE        92
#define ART_ERU                 147

/* Polearms */
#define ART_THEODEN                     93
#define ART_PAIN                        94
#define ART_OSONDIR                     95
#define ART_TIL                         96
#define ART_AEGLOS                      97
#define ART_OROME                       98
#define ART_NIMLOTH                     99
#define ART_EORLINGAS           100
#define ART_DURIN                       101
#define ART_EONWE                       102
#define ART_BALLI                       103
#define ART_LOTHARANG           104
#define ART_MUNDWINE            105
#define ART_BARUKKHELED         106
#define ART_WRATH                       107
#define ART_ULMO                        108
#define ART_AVAVIR                      109
#define ART_FUNDIN                      175

/* The sword of the Dawn */
#define ART_DAWN                110

/* Hafted */
#define ART_MELKOR                      18
#define ART_HURIN                       33
#define ART_GROND                       111
#define ART_TOTILA                      112
#define ART_THUNDERFIST         113
#define ART_BLOODSPIKE          114
#define ART_FIRESTAR            115
#define ART_TARATOL                     116
#define ART_AULE                        117
#define ART_NAR                         118
#define ART_ERIRIL                      119
#define ART_OLORIN                      120
#define ART_DEATHWREAKER        121
#define ART_TURMIL                      122
#define ART_GOTHMOG                     123
#define ART_AXE_GOTHMOG                 145
#define ART_SKULLCLEAVER                177

#define ART_NAIN                        174

/* Bows */
#define ART_BELTHRONDING        124
#define ART_BARD                        125
#define ART_CUBRAGOL            126
#define ART_UMBAR                       171

/* Mage Staffs */
#define ART_GANDALF             127

/* Boomerangs */
#define ART_BEOR                128
#define ART_GLIMDRIR            129

/* Musical Instrument */
#define ART_MAGLOR              137
#define ART_SKY                 138
#define ART_DAERON              139
#define ART_DRUEDAIN            141
#define ART_ROHAN               142
#define ART_HELM                143
#define ART_BOROMIR             144

/* Diggers */
#define ART_EREBOR              140

#define ART_ORCHAST             156
#define ART_NIGHT               157
#define ART_NATUREBANE          158

/* Spell for various object */
#define SPELL_ID_PLAIN          1
#define SPELL_BO_FIRE           2
#define SPELL_BO_COLD           3
#define SPELL_BO_ELEC           4
#define SPELL_BO_POIS           5
#define SPELL_BO_ACID           6
#define SPELL_MAPPING           7
#define SPELL_CURE              8
#define SPELL_ID_FULL           9
#define SPELL_WRAITH            10
#define SPELL_INVIS             11


/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/

#define EGO_MANA                1
#define EGO_POWER               2
#define EGO_MANA_POWER          3
#define EGO_MSTAFF_SPELL        4
#define EGO_BRAND_POIS          77
#define EGO_BRAND_ELEC          74
#define EGO_BRAND_FIRE          75
#define EGO_BRAND_COLD          76
#define EGO_BRAND_ACID          73
#define EGO_EARTHQUAKES         80
#define EGO_BLESS_BLADE         67
#define EGO_VAMPIRIC            97
#define EGO_CHAOTIC             78
#define EGO_BLASTED             127
#define EGO_SHATTERED           126
#define EGO_FLAME               122
#define EGO_FROST               123
#define EGO_LIGHTNING_BOLT      121
#define EGO_FREE_ACTION         49
#define EGO_DF                  66
#define EGO_MOTION              59
#define EGO_SPECTRAL            102
#define EGO_NOLDOR              23
#define EGO_JUMP                15
#define EGO_SPINING             72
#define EGO_DRAGON              99
#define EGO_INST_DRAGONKIND     130
#define EGO_ENDURE_ELEC         17
#define EGO_ENDURE_ACID         16
#define EGO_ENDURE_FIRE         18
#define EGO_ENDURE_COLD         19
#define EGO_QUIET               58
#define EGO_WISDOM              25
#define EGO_RESIST_ELEC         6
#define EGO_RESIST_ACID         5
#define EGO_RESIST_FIRE         7
#define EGO_RESIST_COLD         8
#define EGO_LIFE                68
#define EGO_STEALTH             42
#define EGO_PROTECTION          41
#define EGO_MAGI                27
#define EGO_SPEED               60
#define EGO_RESISTANCE          9
#define EGO_LITE                32
#define EGO_AURA_FIRE           44
#define EGO_SLAYING_WEAPON      71
#define EGO_SLAYING             50
#define EGO_TELEPORTATION       35
#define EGO_ELVENKIND           10
#define EGO_LITE_MAGI           163
#define EGO_HA                  65


/* Activation effects for random artifacts */
#define ACT_SUNLIGHT            1
#define ACT_BO_MISS_1           2
#define ACT_BA_POIS_1           3
#define ACT_BO_ELEC_1           4
#define ACT_BO_ACID_1           5
#define ACT_BO_COLD_1           6
#define ACT_BO_FIRE_1           7
#define ACT_BA_COLD_1           8
#define ACT_BA_FIRE_1           9
#define ACT_DRAIN_1             10
#define ACT_BA_COLD_2           11
#define ACT_BA_ELEC_2           12
#define ACT_DRAIN_2             13
#define ACT_VAMPIRE_1           14
#define ACT_BO_MISS_2           15
#define ACT_BA_FIRE_2           16
#define ACT_BA_COLD_3           17
#define ACT_BA_ELEC_3           18
#define ACT_WHIRLWIND           19
#define ACT_VAMPIRE_2           20
#define ACT_CALL_CHAOS          21
#define ACT_ROCKET              22
#define ACT_DISP_EVIL           23
#define ACT_BA_MISS_3           24
#define ACT_DISP_GOOD           25
#define ACT_GILGALAD            26
#define ACT_CELEBRIMBOR         27
#define ACT_SKULLCLEAVER        28
#define ACT_HARADRIM            29
#define ACT_FUNDIN              30
#define ACT_EOL                 31
#define ACT_UMBAR               32
#define ACT_NUMENOR             33
#define ACT_KNOWLEDGE           34
#define ACT_UNDEATH             35
#define ACT_THRAIN              36
#define ACT_BARAHIR             37
#define ACT_TULKAS              38
#define ACT_NARYA               39
#define ACT_NENYA               40
#define ACT_VILYA               41
#define ACT_POWER               42
#define ACT_STONE_LORE          43
#define ACT_RAZORBACK           44
#define ACT_BLADETURNER         45
#define ACT_MEDIATOR            46
#define ACT_BELEGENNON          47
#define ACT_GORLIM              48
#define ACT_COLLUIN             49
#define ACT_BELANGIL            50
#define ACT_CONFUSE             51
#define ACT_SLEEP               52
#define ACT_QUAKE               53
#define ACT_TERROR              54
#define ACT_TELE_AWAY           55
#define ACT_BANISH_EVIL         56
#define ACT_GENOCIDE            57
#define ACT_MASS_GENO           58
#define ACT_ANGUIREL            59
#define ACT_ERU                 60
#define ACT_DAWN                61
#define ACT_FIRESTAR            62
#define ACT_TURMIL              63
#define ACT_CUBRAGOL            64
#define ACT_CHARM_ANIMAL        65
#define ACT_CHARM_UNDEAD        66
#define ACT_CHARM_OTHER         67
#define ACT_CHARM_ANIMALS       68
#define ACT_CHARM_OTHERS        69
#define ACT_SUMMON_ANIMAL       70
#define ACT_SUMMON_PHANTOM      71
#define ACT_SUMMON_ELEMENTAL    72
#define ACT_SUMMON_DEMON        73
#define ACT_SUMMON_UNDEAD       74
#define ACT_ELESSAR             75
#define ACT_GANDALF             76
#define ACT_MARDA               77
#define ACT_PALANTIR            78
/*
                                79
                                80
*/
#define ACT_CURE_LW             81
#define ACT_CURE_MW             82
#define ACT_CURE_POISON         83
#define ACT_REST_LIFE           84
#define ACT_REST_ALL            85
#define ACT_CURE_700            86
#define ACT_CURE_1000           87
/*
                                88
*/
#define ACT_EREBOR              89
#define ACT_DRUEDAIN            90
#define ACT_ESP                 91
#define ACT_BERSERK             92
#define ACT_PROT_EVIL           93
#define ACT_RESIST_ALL          94
#define ACT_SPEED               95
#define ACT_XTRA_SPEED          96
#define ACT_WRAITH              97
#define ACT_INVULN              98
#define ACT_ROHAN               99
#define ACT_HELM                100
#define ACT_BOROMIR             101
#define ACT_HURIN               102
#define ACT_AXE_GOTHMOG         103
#define ACT_MELKOR              104
#define ACT_GROND               105
#define ACT_NATUREBANE          106
#define ACT_NIGHT               107
#define ACT_ORCHAST             108
#define ACT_LIGHT               111
#define ACT_MAP_LIGHT           112
#define ACT_DETECT_ALL          113
#define ACT_DETECT_XTRA         114
#define ACT_ID_FULL             115
#define ACT_ID_PLAIN            116
#define ACT_RUNE_EXPLO          117
#define ACT_RUNE_PROT           118
#define ACT_SATIATE             119
#define ACT_DEST_DOOR          120
#define ACT_STONE_MUD           121
#define ACT_RECHARGE            122
#define ACT_ALCHEMY             123
#define ACT_DIM_DOOR            124
#define ACT_TELEPORT            125
#define ACT_RECALL              126

#define ACT_DEATH               127
#define ACT_RUINATION           128
#define ACT_DESTRUC             129
#define ACT_UNINT               130
#define ACT_UNSTR               131
#define ACT_UNCON               132
#define ACT_UNCHR               133
#define ACT_UNDEX               134
#define ACT_UNWIS               135
#define ACT_STATLOSS            136
#define ACT_HISTATLOSS          137
#define ACT_EXPLOSS             138
#define ACT_HIEXPLOSS           139
#define ACT_SUMMON_MONST        140
#define ACT_PARALYZE            141
#define ACT_HALLU               142
#define ACT_POISON              143
#define ACT_HUNGER              144
#define ACT_STUN                145
#define ACT_CUTS                146
#define ACT_PARANO              147
#define ACT_CONFUSION           148
#define ACT_BLIND               149
#define ACT_PET_SUMMON          150
#define ACT_CURE_PARA           151
#define ACT_CURE_HALLU          152
#define ACT_CURE_POIS           153
#define ACT_CURE_HUNGER         154
#define ACT_CURE_STUN           155
#define ACT_CURE_CUTS           156
#define ACT_CURE_FEAR           157
#define ACT_CURE_CONF           158
#define ACT_CURE_BLIND          159
#define ACT_CURING              160
#define ACT_DARKNESS            161
#define ACT_LEV_TELE            162
#define ACT_ACQUIREMENT         163
#define ACT_WEIRD               164
#define ACT_AGGRAVATE           165
#define ACT_MUT                 166
#define ACT_CURE_INSANITY       167
#define ACT_CURE_MUT            168
#define ACT_LIGHT_ABSORBTION    169
/* of dragonkind?*/
#define ACT_BA_FIRE_H           170
#define ACT_BA_COLD_H           171
#define ACT_BA_ELEC_H           172
#define ACT_BA_ACID_H           173
#define ACT_SPIN                174
#define ACT_NOLDOR              175
#define ACT_SPECTRAL            176
#define ACT_JUMP                177
#define ACT_DEST_TELE           178
/*amulet of serpents dam 100, rad 2 timout 40+d60 */
#define ACT_BA_POIS_4           179
/*rings of X 50,50+d50 dur 20+d20 */
#define ACT_BA_COLD_4           180
#define ACT_BA_FIRE_4           181
#define ACT_BA_ACID_4           182
#define ACT_BA_ELEC_4           183
#define ACT_BR_ELEC             184
#define ACT_BR_COLD             185
#define ACT_BR_FIRE             186
#define ACT_BR_ACID             187
#define ACT_BR_POIS             188
#define ACT_BR_MANY             189
#define ACT_BR_CONF             190
#define ACT_BR_SOUND            191
#define ACT_BR_CHAOS            192
#define ACT_BR_SHARD            193
#define ACT_BR_BALANCE          194
#define ACT_BR_LIGHT            195
#define ACT_BR_POWER            196
#define ACT_GROW_MOLD			197
#define ACT_MUSIC				200
/* 170 -> unused */

/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_SKELETON      1      /* Skeletons ('s') */
#define TV_BOTTLE        2      /* Empty bottles ('!') */
/* XXX */
#define TV_BATERIE       4      /* For the Alchemists */
#define TV_SPIKE         5      /* Spikes ('~') */
#define TV_MSTAFF        6      /* Mage Staffs */
#define TV_CHEST         7      /* Chests ('~') */
#define TV_PARCHMENT     8      /* Parchments from Kamband */
#define TV_PARCHEMENT    8      /* compatibility define */
#define TV_CORPSE        9      /* Monster corpses */
#define TV_EGG          10      /* Monster Eggs */
#define TV_JUNK         11      /* Sticks, Pottery, etc ('~') */
#define TV_TOOL         12      /* Tools */
#define TV_INSTRUMENT   14      /* Musical instruments */
#define TV_BOOMERANG    15      /* Boomerangs */
#define TV_SHOT         16      /* Ammo for slings */
#define TV_ARROW        17      /* Ammo for bows */
#define TV_BOLT         18      /* Ammo for x-bows */
#define TV_BOW          19      /* Slings/Bows/Xbows */
#define TV_DIGGING      20      /* Shovels/Picks */
#define TV_HAFTED       21      /* Priest Weapons */
#define TV_POLEARM      22      /* Pikes/Glaives/Spears/etc. */
#define TV_SWORD        23      /* Edged Weapons */
#define TV_AXE          24      /* Axes/Cleavers */
#define TV_BOOTS        30      /* Boots */
#define TV_GLOVES       31      /* Gloves */
#define TV_HELM         32      /* Helms */
#define TV_CROWN        33      /* Crowns */
#define TV_SHIELD       34      /* Shields */
#define TV_CLOAK        35      /* Cloaks */
#define TV_SOFT_ARMOR   36      /* Soft Armor */
#define TV_HARD_ARMOR   37      /* Hard Armor */
#define TV_DRAG_ARMOR   38      /* Dragon Scale Mail */
#define TV_LITE         39      /* Lites (including Specials) */
#define TV_AMULET       40      /* Amulets (including Specials) */
#define TV_RING         45      /* Rings (including Specials) */
#define TV_TRAPKIT      46      /* Trapkits */
#define TV_TOTEM        54      /* Summoner totems */
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_ROD_MAIN     67
#define TV_SCROLL       70
#define TV_POTION       71
#define TV_POTION2      72      /* Second set of potion */
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_HYPNOS       99      /* To wield monsters !:) */
#define TV_GOLD         100     /* Gold can only be picked up by players */
#define TV_RANDART      102     /* Random Artifacts */
#define TV_RUNE1        104      /* Base runes */
#define TV_RUNE2        105      /* Modifier runes */

#define TV_BOOK         111
#define TV_SYMBIOTIC_BOOK 112
#define TV_MUSIC_BOOK   113
#define TV_DRUID_BOOK   114
#define TV_DAEMON_BOOK  115


/* The "sval" codes for TV_JUNK */
#define SV_BOULDER      1


/* The "sval" codes for TV_TOOL */
#define SV_TOOL_CLIMB 0
#define SV_PORTABLE_HOLE 1

/* The "sval" codes for TV_MSTAFF */
#define SV_MSTAFF 1

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_INSTRUMENT */
#define SV_DRUM                          58
#define SV_HARP                          59
#define SV_HORN                          60

/* The "sval" codes for TV_TRAPKIT */
#define SV_TRAPKIT_SLING                 1
#define SV_TRAPKIT_BOW                   2
#define SV_TRAPKIT_XBOW                  3
#define SV_TRAPKIT_POTION                4
#define SV_TRAPKIT_SCROLL                5
#define SV_TRAPKIT_DEVICE                6

/* The "sval" codes for TV_BOOMERANG */
#define SV_BOOM_S_WOOD                   1      /* 1d4  */
#define SV_BOOM_WOOD                     2      /* 1d8  */
#define SV_BOOM_S_METAL                  3      /* 3d4  */
#define SV_BOOM_METAL                    4      /* 4d5  */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3) */
#define SV_LIGHT_XBOW                   23	/* (x3) */
#define SV_HEAVY_XBOW                   24	/* (x4) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_GNOMISH_SHOVEL                2
#define SV_DWARVEN_SHOVEL                3
#define SV_PICK                          4
#define SV_ORCISH_PICK                   5
#define SV_DWARVEN_PICK                  6
#define SV_MATTOCK                       7

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1	/* 1d4  */
#define SV_WHIP                          2	/* 1d6  */
#define SV_QUARTERSTAFF                  3	/* 1d9  */
#define SV_NUNCHAKU                      4	/* 2d3  */
#define SV_MACE                          5	/* 2d4  */
#define SV_BALL_AND_CHAIN                6	/* 2d4  */
#define SV_WAR_HAMMER                    8	/* 3d3  */
#define SV_LUCERN_HAMMER                10	/* 2d5  */
#define SV_THREE_PIECE_ROD              11	/* 3d3  */
#define SV_MORNING_STAR                 12	/* 2d6  */
#define SV_FLAIL                        13	/* 2d6  */
#define SV_LEAD_FILLED_MACE             15	/* 3d4  */
#define SV_TWO_HANDED_FLAIL             18	/* 3d6  */
#define SV_GREAT_HAMMER                 19	/* 4d6  */
#define SV_MACE_OF_DISRUPTION           20	/* 5d8  */
#define SV_GROND                        50	/* 3d4  */

/* The "sval" values for TV_AXE */
#define SV_HATCHET                       1	/* 1d5 */
#define SV_CLEAVER                       2      /* 2d4 */
#define SV_LIGHT_WAR_AXE                 8      /* 2d5 */
#define SV_BEAKED_AXE                   10	/* 2d6 */
#define SV_BROAD_AXE                    11	/* 2d6 */
#define SV_BATTLE_AXE                   22	/* 2d8 */
#define SV_GREAT_AXE                    25	/* 4d4 */
#define SV_LOCHABER_AXE                 28	/* 3d8 */
#define SV_SLAUGHTER_AXE                30      /* 5d7 */

/* The "sval" values for TV_POLEARM */
#define SV_SPEAR                         2	/* 1d6 */
#define SV_SICKLE                        3	/* 2d3 */
#define SV_AWL_PIKE                      4	/* 1d8 */
#define SV_TRIDENT                       5	/* 1d9 */
#define SV_FAUCHARD                      6  /* 1d10 */
#define SV_BROAD_SPEAR                   7	/* 1d9 */
#define SV_PIKE                          8	/* 2d5 */
#define SV_GLAIVE                       13	/* 2d6 */
#define SV_HALBERD                      15	/* 3d4 */
#define SV_GUISARME                     16  /* 2d5 */
#define SV_SCYTHE                       17	/* 5d3 */
#define SV_LANCE                        20	/* 2d8 */
#define SV_TRIFURCATE_SPEAR             26	/* 2d9 */
#define SV_HEAVY_LANCE                  29  /* 4d8 */
#define SV_SCYTHE_OF_SLICING            30	/* 8d4 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER                 1  /* 1d1 */
#define SV_BROKEN_SWORD                  2  /* 1d2 */
#define SV_DAGGER                        4  /* 1d4 */
#define SV_MAIN_GAUCHE                   5  /* 1d5 */
#define SV_RAPIER                        7  /* 1d6 */
#define SV_SMALL_SWORD                   8  /* 1d6 */
#define SV_BASILLARD                     9  /* 1d8 */
#define SV_SHORT_SWORD                  10  /* 1d7 */
#define SV_SABRE                        11  /* 1d7 */
#define SV_CUTLASS                      12  /* 1d7 */
#define SV_KHOPESH                      14  /* 2d4 */
#define SV_TULWAR                       15  /* 2d4 */
#define SV_BROAD_SWORD                  16  /* 2d5 */
#define SV_LONG_SWORD                   17  /* 2d5 */
#define SV_SCIMITAR                     18  /* 2d5 */
#define SV_KATANA                       20  /* 3d4 */
#define SV_BASTARD_SWORD                21  /* 3d4 */
#define SV_GREAT_SCIMITAR               22  /* 4d5 */
#define SV_CLAYMORE                     23  /* 2d8 */
#define SV_ESPADON                      24  /* 2d9 */
#define SV_TWO_HANDED_SWORD             25  /* 3d6 */
#define SV_FLAMBERGE                    26  /* 3d7 */
#define SV_EXECUTIONERS_SWORD           28  /* 4d5 */
#define SV_ZWEIHANDER                   29  /* 4d6 */
#define SV_BLADE_OF_CHAOS               30  /* 6d5 */
#define SV_BLUESTEEL_BLADE              31  /* 3d9 */
#define SV_SHADOW_BLADE                 32  /* 4d4 */
#define SV_DARK_SWORD                   33  /* 3d7 */

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_DRAGON_SHIELD                 6
#define SV_SHIELD_OF_DEFLECTION         10

/* The "sval" codes for TV_HELM */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_MORGOTH                      50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_METAL_SHOD_BOOTS      6

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_ELVEN_CLOAK                   2
#define SV_FUR_CLOAK                     3
#define SV_SHADOW_CLOAK                  6
#define SV_MIMIC_CLOAK                   100

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_CESTI                  5

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_FILTHY_RAG                    1
#define SV_ROBE                          2
#define SV_PAPER_ARMOR                   3  /* 4 */
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_SOFT_STUDDED_LEATHER          5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_HARD_STUDDED_LEATHER          7
#define SV_RHINO_HIDE_ARMOR              8
#define SV_CORD_ARMOR                    9  /*  6 */
#define SV_PADDED_ARMOR                 10  /*  4 */
#define SV_LEATHER_SCALE_MAIL           11
#define SV_LEATHER_JACK                 12
#define SV_STONE_AND_HIDE_ARMOR         15  /* 15 */
#define SV_THUNDERLORD_SUIT             16

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_RUSTY_CHAIN_MAIL              1  /* 14- */
#define SV_RING_MAIL                     2  /* 12  */
#define SV_METAL_SCALE_MAIL              3  /* 13  */
#define SV_CHAIN_MAIL                    4  /* 14  */
#define SV_DOUBLE_RING_MAIL              5  /* 15  */
#define SV_AUGMENTED_CHAIN_MAIL          6  /* 16  */
#define SV_DOUBLE_CHAIN_MAIL             7  /* 16  */
#define SV_BAR_CHAIN_MAIL                8  /* 18  */
#define SV_METAL_BRIGANDINE_ARMOUR       9  /* 19  */
#define SV_SPLINT_MAIL                  10  /* 19  */
#define SV_PARTIAL_PLATE_ARMOUR         12  /* 22  */
#define SV_METAL_LAMELLAR_ARMOUR        13  /* 23  */
#define SV_FULL_PLATE_ARMOUR            15  /* 25  */
#define SV_RIBBED_PLATE_ARMOUR          18  /* 28  */
#define SV_MITHRIL_CHAIN_MAIL           20  /* 28+ */
#define SV_MITHRIL_PLATE_MAIL           25  /* 35+ */
#define SV_ADAMANTITE_PLATE_MAIL        30  /* 40+ */

/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK                  1
#define SV_DRAGON_BLUE                   2
#define SV_DRAGON_WHITE                  3
#define SV_DRAGON_RED                    4
#define SV_DRAGON_GREEN                  5
#define SV_DRAGON_MULTIHUED              6
#define SV_DRAGON_SHINING               10
#define SV_DRAGON_LAW                   12
#define SV_DRAGON_BRONZE                14
#define SV_DRAGON_GOLD                  16
#define SV_DRAGON_CHAOS                 18
#define SV_DRAGON_BALANCE               20
#define SV_DRAGON_POWER                 30

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_TORCH_EVER               2
#define SV_LITE_DWARVEN                  3
#define SV_LITE_FEANORIAN                4
#define SV_LITE_GALADRIEL                100
#define SV_LITE_ELENDIL                  101
#define SV_LITE_THRAIN                   102
#define SV_LITE_UNDEATH                  103
#define SV_LITE_PALANTIR                 104
#define SV_ANCHOR_SPACETIME              105
#define SV_STONE_LORE                    106


/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_TELEPORT               1
#define SV_AMULET_ADORNMENT              2
#define SV_AMULET_SLOW_DIGEST            3
#define SV_AMULET_RESIST_ACID            4
#define SV_AMULET_SEARCHING              5
#define SV_AMULET_BRILLANCE              6
#define SV_AMULET_CHARISMA               7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_CARLAMMAS             10
#define SV_AMULET_INGWE                 11
#define SV_AMULET_DWARVES               12
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_NOTHING               16
#define SV_AMULET_SERPENT               17
#define SV_AMULET_TORIS_MEJISTOS        18
#define SV_AMULET_ELESSAR               19
#define SV_AMULET_EVENSTAR              20
#define SV_AMULET_SUSTENANCE            21
#define SV_AMULET_TELEPATHY             22
#define SV_AMULET_TRICKERY              23
#define SV_AMULET_WEAPONMASTERY         24
#define SV_AMULET_DEVOTION              25
#define SV_AMULET_INFRA                 26
#define SV_AMULET_SPELL                 27
#define SV_AMULET_WISDOM                28
#define SV_AMULET_RESIST_ELEC           29
#define SV_AMULET_REGEN                 30

/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_AGGRAVATION              1
#define SV_RING_WEAKNESS                 2
#define SV_RING_STUPIDITY                3
#define SV_RING_TELEPORTATION            4
#define SV_RING_SPECIAL                  5
#define SV_RING_SLOW_DIGESTION           6
#define SV_RING_FEATHER_FALL             7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_SUSTAIN_STR             10
#define SV_RING_SUSTAIN_INT             11
#define SV_RING_SUSTAIN_WIS             12
#define SV_RING_SUSTAIN_CON             13
#define SV_RING_SUSTAIN_DEX             14
#define SV_RING_SUSTAIN_CHR             15
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_RESIST_POIS             20
#define SV_RING_FREE_ACTION             21
#define SV_RING_SEE_INVIS               22
#define SV_RING_SEARCHING               23
#define SV_RING_STR                     24
#define SV_RING_INT                     25
#define SV_RING_DEX                     26
#define SV_RING_CON                     27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_BARAHIR                 32
#define SV_RING_TULKAS                  33
#define SV_RING_NARYA                   34
#define SV_RING_NENYA                   35
#define SV_RING_VILYA                   36
#define SV_RING_POWER                   37
#define SV_RING_RES_FEAR                38
#define SV_RING_RES_LD                  39
#define SV_RING_RES_NETHER              40
#define SV_RING_RES_NEXUS               41
#define SV_RING_RES_SOUND               42
#define SV_RING_RES_CONFUSION           43
#define SV_RING_RES_SHARDS              44
#define SV_RING_RES_DISENCHANT          45
#define SV_RING_RES_CHAOS               46
#define SV_RING_RES_BLINDNESS           47
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_NOTHING                 50
#define SV_RING_PRECONITION             51
#define SV_RING_FLAR                    52
#define SV_RING_INVIS                   53
#define SV_RING_FLYING                  54
#define SV_RING_WRAITH                  55
#define SV_RING_ELEC                    56
#define SV_RING_DURIN                   57
#define SV_RING_SPELL                   58
#define SV_RING_CRIT                    59

/* The "sval" codes for TV_STAFF */
#define SV_STAFF_SCHOOL                 1
#define SV_STAFF_NOTHING                2

/* needed for monster traps */
#define SV_STAFF_LIGHT                  3
#define SV_STAFF_FIERY_SHIELD           4
#define SV_STAFF_REMOVE_CURSES          5
#define SV_STAFF_WINGS_WIND             6
#define SV_STAFF_SHAKE                  7
#define SV_STAFF_DISARM                 8
#define SV_STAFF_TELEPORTATION          9
#define SV_STAFF_PROBABILITY_TRAVEL    10
#define SV_STAFF_RECOVERY              11
#define SV_STAFF_HEALING               12
#define SV_STAFF_VISION                13
#define SV_STAFF_IDENTIFY              14
#define SV_STAFF_SENSE_HIDDEN          15
#define SV_STAFF_REVEAL_WAYS           16
#define SV_STAFF_SENSE_MONSTER         17
#define SV_STAFF_GENOCIDE              18
#define SV_STAFF_SUMMON                19
#define SV_STAFF_WISH                  20
#define SV_STAFF_MANA                  21
#define SV_STAFF_MITHRANDIR            22

/* The "sval" codes for TV_WAND */
#define SV_WAND_SCHOOL                  1
#define SV_WAND_NOTHING                 2

/* needed for monster traps */
#define SV_WAND_MANATHRUST              3
#define SV_WAND_FIREFLASH               4
#define SV_WAND_FIREWALL                5
#define SV_WAND_TIDAL_WAVE              6
#define SV_WAND_ICE_STORM               7
#define SV_WAND_NOXIOUS_CLOUD           8
#define SV_WAND_POISON_BLOOD            9
#define SV_WAND_THUNDERSTORM           10
#define SV_WAND_DIG                    11
#define SV_WAND_STONE_PRISON           12
#define SV_WAND_STRIKE                 13
#define SV_WAND_TELEPORT_AWAY          14
#define SV_WAND_SUMMON_ANIMAL          15
#define SV_WAND_MAGELOCK               16
#define SV_WAND_SLOW_MONSTER           17
#define SV_WAND_SPEED                  18
#define SV_WAND_BANISHMENT             19
#define SV_WAND_DISPERSE_MAGIC         20
#define SV_WAND_CHARM                  21
#define SV_WAND_CONFUSE                22
#define SV_WAND_DEMON_BLADE            23
#define SV_WAND_HEAL_MONSTER           24
#define SV_WAND_HASTE_MONSTER          25
#define SV_WAND_THRAIN                 26

/* The "sval" codes for TV_ROD(Rod Tips) */
#define SV_ROD_NOTHING                   0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
/* xxx (aimed) */
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_LITE                     15
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28
#define SV_ROD_DETECT_TRAP              29
#define SV_ROD_HOME                     30


/* The "sval" codes for TV_ROD_MAIN(Rods) */
/* Note that the sval is the max mana capacity of the rod */

#define SV_ROD_WOODEN                   10
#define SV_ROD_COPPER                   20
#define SV_ROD_IRON                     50
#define SV_ROD_ALUMINIUM                75
#define SV_ROD_SILVER                   100
#define SV_ROD_GOLDEN                   125
#define SV_ROD_MITHRIL                  160
#define SV_ROD_ADMANTITE                200


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
#define SV_SCROLL_SUMMON_MINE            6
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_IDENTIFY              12
#define SV_SCROLL_STAR_IDENTIFY         13
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
#define SV_SCROLL_ENCHANT_WEAPON_PVAL   19
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_RESET_RECALL          23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
#define SV_SCROLL_DIVINATION            31
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION 39
#define SV_SCROLL_DEINCARNATION         40
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
#define SV_SCROLL_MASS_RESURECTION      43
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_RUMOR                 51
#define SV_SCROLL_ARTIFACT              52
#define SV_SCROLL_NOTHING               53

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
#define SV_POTION_BLOOD                  3
#define SV_POTION_SLOWNESS               4
#define SV_POTION_SALT_WATER             5
#define SV_POTION_POISON                 6
#define SV_POTION_BLINDNESS              7
#define SV_POTION_INVIS                  8
#define SV_POTION_CONFUSION              9
#define SV_POTION_MUTATION              10
#define SV_POTION_SLEEP                 11
#define SV_POTION_LEARNING              12
#define SV_POTION_LOSE_MEMORIES         13
/* xxx */
#define SV_POTION_RUINATION             15
#define SV_POTION_DEC_STR               16
#define SV_POTION_DEC_INT               17
#define SV_POTION_DEC_WIS               18
#define SV_POTION_DEC_DEX               19
#define SV_POTION_DEC_CON               20
#define SV_POTION_DEC_CHR               21
#define SV_POTION_DETONATIONS           22
#define SV_POTION_DEATH                 23
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_SLOW_POISON           26
#define SV_POTION_CURE_POISON           27
#define SV_POTION_BOLDNESS              28
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_HEROISM               32
#define SV_POTION_BESERK_STRENGTH       33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_LIFE                  39
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
#define SV_POTION_INC_STR               48
#define SV_POTION_INC_INT               49
#define SV_POTION_INC_WIS               50
#define SV_POTION_INC_DEX               51
#define SV_POTION_INC_CON               52
#define SV_POTION_INC_CHR               53
/* xxx */
#define SV_POTION_AUGMENTATION          55
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_STAR_ENLIGHTENMENT    57
#define SV_POTION_SELF_KNOWLEDGE        58
#define SV_POTION_EXPERIENCE            59
#define SV_POTION_RESISTANCE            60
#define SV_POTION_CURING                61
#define SV_POTION_INVULNERABILITY       62
#define SV_POTION_NEW_LIFE              63

#define SV_POTION_LAST                  63

/* The "sval" codes for TV_POTION2 */
#define SV_POTION2_MIMIC                 1
#define SV_POTION2_CURE_LIGHT_SANITY     14
#define SV_POTION2_CURE_SERIOUS_SANITY   15
#define SV_POTION2_CURE_CRITICAL_SANITY  16
#define SV_POTION2_CURE_SANITY           17
#define SV_POTION2_CURE_WATER            18

#define SV_POTION2_LAST                  18

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_POISON                   0
#define SV_FOOD_BLINDNESS                1
#define SV_FOOD_PARANOIA                 2
#define SV_FOOD_CONFUSION                3
#define SV_FOOD_HALLUCINATION            4
#define SV_FOOD_PARALYSIS                5
#define SV_FOOD_WEAKNESS                 6
#define SV_FOOD_SICKNESS                 7
#define SV_FOOD_STUPIDITY                8
#define SV_FOOD_NAIVETY                  9
#define SV_FOOD_UNHEALTH                10
#define SV_FOOD_DISEASE                 11
#define SV_FOOD_CURE_POISON             12
#define SV_FOOD_CURE_BLINDNESS          13
#define SV_FOOD_CURE_PARANOIA           14
#define SV_FOOD_CURE_CONFUSION          15
#define SV_FOOD_CURE_SERIOUS            16
#define SV_FOOD_RESTORE_STR             17
#define SV_FOOD_RESTORE_CON             18
#define SV_FOOD_RESTORING               19
/* many missing mushrooms */
#define SV_FOOD_BISCUIT                 32
#define SV_FOOD_JERKY                   33
#define SV_FOOD_RATION                  35
#define SV_FOOD_SLIME_MOLD              36
#define SV_FOOD_WAYBREAD                37
#define SV_FOOD_PINT_OF_ALE             38
#define SV_FOOD_PINT_OF_WINE            39
#define SV_FOOD_ATHELAS                 40
#define SV_FOOD_GREAT_HEALTH            41
#define SV_FOOD_FORTUNE_COOKIE          42

/* The "sval" codes for TV_BATERIE */
#define SV_BATERIE_POISON    1
#define SV_BATERIE_EXPLOSION 2
#define SV_BATERIE_TELEPORT  3
#define SV_BATERIE_COLD      4
#define SV_BATERIE_FIRE      5
#define SV_BATERIE_ACID      6
#define SV_BATERIE_LIFE      7
#define SV_BATERIE_CONFUSION 8
#define SV_BATERIE_LITE      9
#define SV_BATERIE_CHAOS     10
#define SV_BATERIE_TIME      11
#define SV_BATERIE_MAGIC     12
#define SV_BATERIE_XTRA_LIFE 13
#define SV_BATERIE_DARKNESS  14
#define SV_BATERIE_KNOWLEDGE 15
#define SV_BATERIE_FORCE     16
#define SV_BATERIE_LIGHTNING 17
#define SV_BATERIE_MANA      18
#define MAX_BATERIE_SVAL     18

/* The "sval" codes for TV_CORPSE */
#define SV_CORPSE_CORPSE     1
#define SV_CORPSE_SKELETON   2
#define SV_CORPSE_HEAD       3
#define SV_CORPSE_SKULL      4
#define SV_CORPSE_MEAT       5

/* The "sval" codes for TV_DAEMON_BOOK */
#define SV_DEMONBLADE  55
#define SV_DEMONSHIELD 56
#define SV_DEMONHORN   57

/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE      4

/*
 * Special "sval" limit -- last "good" magic/prayer book
 */
#define SV_BOOK_MAX_GOOD    49

/* flags for operation in get_random_trap in object3.c */

#define TRAP_EXISTS     0x00000001L
#define TRAP_FOUND      0x00000002L
#define TRAP_NOTFOUND   0x00000004L
#define TRAP_IDENTIFIED 0x00000008L

/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK       0x0001    /* memorized feature */
#define CAVE_GLOW       0x0002    /* self-illuminating */
#define CAVE_ICKY       0x0004    /* part of a vault */
#define CAVE_ROOM       0x0008    /* part of a room */
#define CAVE_SEEN       0x0010    /* seen flag  */
#define CAVE_VIEW       0x0020    /* view flag */
#define CAVE_TEMP       0x0040    /* temp flag */
#define CAVE_WALL       0x0080    /* wall flag */
#define CAVE_TRDT       0x0100    /* trap detected */
#define CAVE_IDNT       0x0200    /* grid identified (fountains) */
#define CAVE_SPEC       0x0400    /* special mark(quests) */
#define CAVE_FREE       0x0800    /* no random generation on it */
#define CAVE_DETECT     0x1000    /* Traps detected here */
#define CAVE_PLIT       0x2000    /* Player lit grid */
#define CAVE_MLIT       0x4000    /* Monster lit grid */

/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   WALL: Continue "through" the walls
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 */
#define PROJECT_JUMP       0x00000001
#define PROJECT_BEAM       0x00000002
#define PROJECT_THRU       0x00000004
#define PROJECT_STOP       0x00000008
#define PROJECT_GRID       0x00000010
#define PROJECT_ITEM       0x00000020
#define PROJECT_KILL       0x00000040
#define PROJECT_HIDE       0x00000080
#define PROJECT_VIEWABLE   0x00000100   /* Affect monsters in LOS */
#define PROJECT_METEOR_SHOWER 0x00000200        /* Affect random grids */
#define PROJECT_BLAST      0x00000400   /* Like Mega_blast, but will only affect viewable grids */
#define PROJECT_PANEL      0x00000800   /* Affect everything in the panel. */
#define PROJECT_ALL        0x00001000   /* Affect every single grid. */
#define PROJECT_WALL       0x00002000
#define PROJECT_MANA_PATH  0x00004000   /* Follow a mana path. */
#define PROJECT_ABSORB_MANA 0x00008000   /* The spell increase in power as it absord grid's mana. */
#define PROJECT_STAY       0x00010000

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT   0x01
#define ENCH_TODAM   0x02
#define ENCH_TOAC    0x04
#define ENCH_PVAL    0x08

/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *      KILL: Target monsters
 *      LOOK: Describe grid fully
 *      XTRA: Currently unused flag
 *      GRID: Select from all grids
 */
#define TARGET_KILL             0x01
#define TARGET_LOOK             0x02
#define TARGET_XTRA             0x04
#define TARGET_GRID             0x08


/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID             0x00000001
#define SM_RES_ELEC             0x00000002
#define SM_RES_FIRE             0x00000004
#define SM_RES_COLD             0x00000008
#define SM_RES_POIS             0x00000010
#define SM_RES_NETH             0x00000020
#define SM_RES_LITE             0x00000040
#define SM_RES_DARK             0x00000080
#define SM_RES_FEAR             0x00000100
#define SM_RES_CONF             0x00000200
#define SM_RES_CHAOS            0x00000400
#define SM_RES_DISEN            0x00000800
#define SM_RES_BLIND            0x00001000
#define SM_RES_NEXUS            0x00002000
#define SM_RES_SOUND            0x00004000
#define SM_RES_SHARD            0x00008000
#define SM_OPP_ACID             0x00010000
#define SM_OPP_ELEC             0x00020000
#define SM_OPP_FIRE             0x00040000
#define SM_OPP_COLD             0x00080000
#define SM_OPP_POIS             0x00100000
#define SM_OPP_XXX1             0x00200000
#define SM_CLONED               0x00400000
#define SM_NOTE_TRAP            0x00800000
#define SM_IMM_ACID             0x01000000
#define SM_IMM_ELEC             0x02000000
#define SM_IMM_FIRE             0x04000000
#define SM_IMM_COLD             0x08000000
#define SM_IMM_XXX5             0x10000000
#define SM_IMM_REFLECT          0x20000000
#define SM_IMM_FREE             0x40000000
#define SM_IMM_MANA             0x80000000

/*
 * Monster status(Player POV)
 */
#define MSTATUS_ENEMY           -2
#define MSTATUS_NEUTRAL_M       -1
#define MSTATUS_NEUTRAL         0
#define MSTATUS_NEUTRAL_P       1
#define MSTATUS_FRIEND          2
#define MSTATUS_PET             3
#define MSTATUS_COMPANION       4

/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP    0x01	/* Allow equip items */
#define USE_INVEN    0x02	/* Allow inven items */
#define USE_FLOOR    0x04	/* Allow floor items */
#define USE_EXTRA    0x08	/* Allow extra items */
#define USE_AUTO     0x10	/* Allow creation of automatizer rule */
/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L     /* Combine the pack */
#define PN_REORDER      0x00000002L     /* Reorder the pack */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L     /* Calculate bonuses */
#define PU_TORCH        0x00000002L     /* Calculate torch radius */
#define PU_BODY         0x00000004L     /* Calculate body parts */
#define PU_SANITY       0x00000008L     /* Calculate csan and msan */
#define PU_HP           0x00000010L     /* Calculate chp and mhp */
#define PU_MANA         0x00000020L     /* Calculate csp and msp */
#define PU_SPELLS       0x00000040L     /* Calculate spells */
#define PU_POWERS       0x00000080L     /* Calculate powers */
/* xxx (many) */
#define PU_UN_VIEW      0x00010000L     /* Forget view */
/* xxx (many) */
#define PU_VIEW         0x00100000L     /* Update view */
#define PU_MON_LITE     0x00200000L     /* Update monster light */
/* xxx */
#define PU_MONSTERS     0x01000000L     /* Update monsters */
#define PU_DISTANCE     0x02000000L     /* Update distances */
/* xxx */
#define PU_FLOW         0x10000000L     /* Update flow */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC         0x00000001L     /* Display Race/Class */
#define PR_TITLE        0x00000002L     /* Display Title */
#define PR_LEV          0x00000004L     /* Display Level */
#define PR_EXP          0x00000008L     /* Display Experience */
#define PR_STATS        0x00000010L     /* Display Stats */
#define PR_ARMOR        0x00000020L     /* Display Armor */
#define PR_HP           0x00000040L     /* Display Hitpoints */
#define PR_MANA         0x00000080L     /* Display Mana */
#define PR_GOLD         0x00000100L     /* Display Gold */
#define PR_DEPTH        0x00000200L     /* Display Depth */
/****/
#define PR_HEALTH       0x00000800L     /* Display Health Bar */
#define PR_CUT          0x00001000L     /* Display Extra (Cut) */
#define PR_STUN         0x00002000L     /* Display Extra (Stun) */
#define PR_HUNGER       0x00004000L     /* Display Extra (Hunger) */
#define PR_PIETY        0x00008000L     /* Display Piety */
#define PR_BLIND        0x00010000L     /* Display Extra (Blind) */
#define PR_CONFUSED     0x00020000L     /* Display Extra (Confused) */
#define PR_AFRAID       0x00040000L     /* Display Extra (Afraid) */
#define PR_POISONED     0x00080000L     /* Display Extra (Poisoned) */
#define PR_STATE        0x00100000L     /* Display Extra (State) */
#define PR_SPEED        0x00200000L     /* Display Extra (Speed) */
#define PR_STUDY        0x00400000L     /* Display Extra (Study) */
#define PR_SANITY       0x00800000L     /* Display Sanity */
#define PR_EXTRA        0x01000000L     /* Display Extra Info */
#define PR_BASIC        0x02000000L     /* Display Basic Info */
#define PR_MAP          0x04000000L     /* Display Map */
#define PR_WIPE         0x08000000L     /* Hack -- Total Redraw */
#define PR_MH           0x10000000L     /* Display Monster hitpoints */
#define PR_DTRAP        0x20000000L     /* Display Extra (DTrap) */
/* xxx */
/* xxx */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN        0x00000001L     /* Display inven/equip */
#define PW_EQUIP        0x00000002L     /* Display equip/inven */
/* xxx */
#define PW_PLAYER       0x00000008L     /* Display character */
#define PW_M_LIST       0x00000010L /* Show monster list */
#define PW_IRC          0x00000020L     /* Display irc messages */
#define PW_MESSAGE      0x00000040L     /* Display messages */
#define PW_OVERHEAD     0x00000080L     /* Display overhead view */
#define PW_MONSTER      0x00000100L     /* Display monster recall */
#define PW_OBJECT       0x00000200L     /* Display object recall */
/* xxx */
#define PW_SNAPSHOT     0x00000800L     /* Display snap-shot */
/* xxx */
/* xxx */
#define PW_BORG_1       0x00004000L     /* Display borg messages */
#define PW_BORG_2       0x00008000L     /* Display borg status */


/* jk */
#define FTRAP_CHEST      0x000000001 /* may appear on chests */
#define FTRAP_DOOR       0x000000002 /* may appear on doors/floors */
#define FTRAP_FLOOR      0x000000004 /* may appear on floor */
#define FTRAP_CHANGE     0x000000008 /* Color changing */
#define FTRAP_XXX5       0x000000010
#define FTRAP_XXX6       0x000000020
#define FTRAP_XXX7       0x000000040
#define FTRAP_XXX8       0x000000080
#define FTRAP_XXX9       0x000000100
#define FTRAP_XXX10      0x000000200
#define FTRAP_XXX11      0x000000400
#define FTRAP_XXX12      0x000000800
#define FTRAP_XXX13      0x000001000
#define FTRAP_XXX14      0x000002000
#define FTRAP_XXX15      0x000004000
#define FTRAP_XXX16      0x000008000
#define FTRAP_LEVEL1     0x000010000 /* low level ball/bolt trap */
#define FTRAP_LEVEL2     0x000020000 /* medium level ball/bolt trap */
#define FTRAP_LEVEL3     0x000040000 /* high level ball/bolt trap */
#define FTRAP_LEVEL4     0x000080000 /* oops level ball/bolt trap */
#define FTRAP_XXX21      0x000100000
#define FTRAP_XXX22      0x000200000
#define FTRAP_XXX23      0x000400000
#define FTRAP_XXX24      0x000800000
#define FTRAP_XXX25      0x001000000
#define FTRAP_XXX26      0x002000000
#define FTRAP_XXX27      0x004000000
#define FTRAP_XXX28      0x008000000
#define FTRAP_XXX29      0x010000000
#define FTRAP_XXX30      0x020000000
#define FTRAP_XXX31      0x040000000
#define FTRAP_XXX32      0x080000000

/* jk */
#define STAT_DEC_TEMPORARY 1
#define STAT_DEC_NORMAL 2
#define STAT_DEC_PERMANENT 3

/* jk - which trap is which number */
#define TRAP_OF_WEAKNESS_I                  1
#define TRAP_OF_WEAKNESS_II                 2
#define TRAP_OF_WEAKNESS_III                3
#define TRAP_OF_INTELLIGENCE_I              4
#define TRAP_OF_INTELLIGENCE_II             5
#define TRAP_OF_INTELLIGENCE_III            6
#define TRAP_OF_WISDOM_I                    7
#define TRAP_OF_WISDOM_II                   8
#define TRAP_OF_WISDOM_III                  9
#define TRAP_OF_FUMBLING_I                 10
#define TRAP_OF_FUMBLING_II                11
#define TRAP_OF_FUMBLING_III               12
#define TRAP_OF_WASTING_I                  13
#define TRAP_OF_WASTING_II                 14
#define TRAP_OF_WASTING_III                15
#define TRAP_OF_BEAUTY_I                   16
#define TRAP_OF_BEAUTY_II                  17
#define TRAP_OF_BEAUTY_III                 18

#define TRAP_OF_CURSE_WEAPON               20
#define TRAP_OF_CURSE_ARMOR                21
#define TRAP_OF_EARTHQUAKE                 22
#define TRAP_OF_POISON_NEEDLE              23
#define TRAP_OF_SUMMON_MONSTER             24
#define TRAP_OF_SUMMON_UNDEAD              25
#define TRAP_OF_SUMMON_GREATER_UNDEAD      26
#define TRAP_OF_TELEPORT                   27
#define TRAP_OF_PARALYZING                 28
#define TRAP_OF_EXPLOSIVE_DEVICE           29
#define TRAP_OF_TELEPORT_AWAY              30
#define TRAP_OF_LOSE_MEMORY                31
#define TRAP_OF_BITTER_REGRET              32
#define TRAP_OF_BOWEL_CRAMPS               33
#define TRAP_OF_BLINDNESS_CONFUSION        34
#define TRAP_OF_AGGRAVATION                35
#define TRAP_OF_MULTIPLICATION             36
#define TRAP_OF_STEAL_ITEM                 37
#define TRAP_OF_SUMMON_FAST_QUYLTHULGS     38
#define TRAP_OF_SINKING                    39
#define TRAP_OF_MANA_DRAIN                 40
#define TRAP_OF_MISSING_MONEY              41
#define TRAP_OF_NO_RETURN                  42
#define TRAP_OF_SILENT_SWITCHING           43
#define TRAP_OF_WALLS                      44
#define TRAP_OF_CALLING_OUT                45
#define TRAP_OF_SLIDING                    46
#define TRAP_OF_CHARGES_DRAIN              47
#define TRAP_OF_STAIR_MOVEMENT             48
#define TRAP_OF_NEW                        49
#define TRAP_OF_SCATTER_ITEMS              50
#define TRAP_OF_DECAY                      51
#define TRAP_OF_WASTING_WANDS              52
#define TRAP_OF_FILLING                    53
#define TRAP_OF_DRAIN_SPEED                54

#define TRAP_OF_ELEC_BOLT                  60
#define TRAP_OF_POIS_BOLT                  61
#define TRAP_OF_ACID_BOLT                  62
#define TRAP_OF_COLD_BOLT                  63
#define TRAP_OF_FIRE_BOLT                  64
#define TRAP_OF_PLASMA_BOLT                65
#define TRAP_OF_WATER_BOLT                 66
#define TRAP_OF_LITE_BOLT                  67
#define TRAP_OF_DARK_BOLT                  68
#define TRAP_OF_SHARDS_BOLT                69
#define TRAP_OF_SOUND_BOLT                 70
#define TRAP_OF_CONFUSION_BOLT             71
#define TRAP_OF_FORCE_BOLT                 72
#define TRAP_OF_INERTIA_BOLT               73
#define TRAP_OF_MANA_BOLT                  74
#define TRAP_OF_ICE_BOLT                   75
#define TRAP_OF_CHAOS_BOLT                 76
#define TRAP_OF_NETHER_BOLT                77
#define TRAP_OF_DISENCHANT_BOLT            78
#define TRAP_OF_NEXUS_BOLT                 79
#define TRAP_OF_TIME_BOLT                  80
#define TRAP_OF_GRAVITY_BOLT               81

#define TRAP_OF_ELEC_BALL                  82
#define TRAP_OF_POIS_BALL                  83
#define TRAP_OF_ACID_BALL                  84
#define TRAP_OF_COLD_BALL                  85
#define TRAP_OF_FIRE_BALL                  86
#define TRAP_OF_PLASMA_BALL                87
#define TRAP_OF_WATER_BALL                 88
#define TRAP_OF_LITE_BALL                  89
#define TRAP_OF_DARK_BALL                  90
#define TRAP_OF_SHARDS_BALL                91
#define TRAP_OF_SOUND_BALL                 92
#define TRAP_OF_CONFUSION_BALL             93
#define TRAP_OF_FORCE_BALL                 94
#define TRAP_OF_INERTIA_BALL               95
#define TRAP_OF_MANA_BALL                  96
#define TRAP_OF_ICE_BALL                   97
#define TRAP_OF_CHAOS_BALL                 98
#define TRAP_OF_NETHER_BALL                99
#define TRAP_OF_DISENCHANT_BALL           100
#define TRAP_OF_NEXUS_BALL                101
#define TRAP_OF_TIME_BALL                 102
#define TRAP_OF_GRAVITY_BALL              103

#define TRAP_OF_ARROW_I                   110
#define TRAP_OF_ARROW_II                  111
#define TRAP_OF_ARROW_III                 112
#define TRAP_OF_ARROW_IV                  113
#define TRAP_OF_POISON_ARROW_I            114
#define TRAP_OF_POISON_ARROW_II           115
#define TRAP_OF_POISON_ARROW_III          116
#define TRAP_OF_POISON_ARROW_IV           117
#define TRAP_OF_DAGGER_I                  118
#define TRAP_OF_DAGGER_II                 119
#define TRAP_OF_POISON_DAGGER_I           120
#define TRAP_OF_POISON_DAGGER_II          121
#define TRAP_OF_ARROWS_I                  122
#define TRAP_OF_ARROWS_II                 123
#define TRAP_OF_ARROWS_III                124
#define TRAP_OF_ARROWS_IV                 125
#define TRAP_OF_POISON_ARROWS_I           126
#define TRAP_OF_POISON_ARROWS_II          127
#define TRAP_OF_POISON_ARROWS_III         128
#define TRAP_OF_POISON_ARROWS_IV          129
#define TRAP_OF_DAGGERS_I                 130
#define TRAP_OF_DAGGERS_II                131
#define TRAP_OF_POISON_DAGGERS_I          132
#define TRAP_OF_POISON_DAGGERS_II         133

#define TRAP_OF_DROP_ITEMS                140
#define TRAP_OF_DROP_ALL_ITEMS            141
#define TRAP_OF_DROP_EVERYTHING           142

/* -SC- */
#define TRAP_OF_FEMINITY                  150
#define TRAP_OF_MASCULINITY               151
#define TRAP_OF_NEUTRALITY                152
#define TRAP_OF_AGING                     153
#define TRAP_OF_GROWING                   154
#define TRAP_OF_SHRINKING                 155
#define TRAP_OF_ELDRITCH_HORROR           156
/* XXX */
#define TRAP_OF_DIVINE_ANGER              158
#define TRAP_OF_DIVINE_WRATH              159
#define TRAP_OF_HALLUCINATION             160

#define TRAP_OF_ROCKET                    161
#define TRAP_OF_NUKE_BOLT                 162
#define TRAP_OF_DEATH_RAY                 163
#define TRAP_OF_HOLY_FIRE                 164
#define TRAP_OF_HELL_FIRE                 165
#define TRAP_OF_PSI_BOLT                  166
#define TRAP_OF_PSI_DRAIN                 167
#define TRAP_OF_NUKE_BALL                 168
#define TRAP_OF_PSI_BALL                  169

/* DG */
#define TRAP_OF_ACQUIREMENT               170

/* Runescrye */
#define TRAP_G_ELEC_BOLT                171
#define TRAP_G_POIS_BOLT                172
#define TRAP_G_ACID_BOLT                173
#define TRAP_G_COLD_BOLT                174
#define TRAP_G_FIRE_BOLT                175

/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT                  11
#define SUMMON_SPIDER               12
#define SUMMON_HOUND                13
#define SUMMON_HYDRA                14
#define SUMMON_ANGEL                15
#define SUMMON_DEMON                16
#define SUMMON_UNDEAD               17
#define SUMMON_DRAGON               18
#define SUMMON_HI_UNDEAD            21
#define SUMMON_HI_DRAGON            22
#define SUMMON_WRAITH               31
#define SUMMON_UNIQUE               32
#define SUMMON_BIZARRE1             33
#define SUMMON_BIZARRE2             34
#define SUMMON_BIZARRE3             35
#define SUMMON_BIZARRE4             36
#define SUMMON_BIZARRE5             37
#define SUMMON_BIZARRE6             38
#define SUMMON_HI_DEMON             39
#define SUMMON_KIN                  40
#define SUMMON_DAWN                 41
#define SUMMON_ANIMAL               42
#define SUMMON_ANIMAL_RANGER        43
#define SUMMON_HI_UNDEAD_NO_UNIQUES 44
#define SUMMON_HI_DRAGON_NO_UNIQUES 45
#define SUMMON_NO_UNIQUES           46
#define SUMMON_PHANTOM              47
#define SUMMON_ELEMENTAL            48
#define SUMMON_THUNDERLORD          49
#define SUMMON_BLUE_HORROR          50
#define SUMMON_BUG                  51
#define SUMMON_RNG                  52
#define SUMMON_MINE                 53
#define SUMMON_HUMAN                54
#define SUMMON_SHADOWS              55
#define SUMMON_GHOST                56
#define SUMMON_QUYLTHULG            57
#define SUMMON_LUA                  58


/*
 * Spell types used by project(), and related functions.
 */
#define GF_ELEC         1
#define GF_POIS         2
#define GF_ACID         3
#define GF_COLD         4
#define GF_FIRE         5
#define GF_UNBREATH     6
#define GF_CORPSE_EXPL  7
#define GF_MISSILE      10
#define GF_ARROW        11
#define GF_PLASMA       12
#define GF_WAVE         13
#define GF_WATER        14
#define GF_LITE         15
#define GF_DARK         16
#define GF_LITE_WEAK    17
#define GF_DARK_WEAK    18
#define GF_SHARDS       20
#define GF_SOUND        21
#define GF_CONFUSION    22
#define GF_FORCE        23
#define GF_INERTIA      24
#define GF_MANA         26
#define GF_METEOR       27
#define GF_ICE          28
#define GF_CHAOS        30
#define GF_NETHER       31
#define GF_DISENCHANT   32
#define GF_NEXUS        33
#define GF_TIME         34
#define GF_GRAVITY      35
#define GF_KILL_WALL    40
#define GF_KILL_DOOR    41
#define GF_KILL_TRAP    42
#define GF_MAKE_WALL    45
#define GF_MAKE_DOOR    46
#define GF_MAKE_TRAP    47
#define GF_OLD_CLONE    51
#define GF_OLD_POLY             52
#define GF_OLD_HEAL             53
#define GF_OLD_SPEED    54
#define GF_OLD_SLOW             55
#define GF_OLD_CONF             56
#define GF_OLD_SLEEP    57
#define GF_OLD_DRAIN    58
#define GF_AWAY_UNDEAD  61
#define GF_AWAY_EVIL    62
#define GF_AWAY_ALL     63
#define GF_TURN_UNDEAD  64
#define GF_TURN_EVIL    65
#define GF_TURN_ALL     66
#define GF_DISP_UNDEAD  67
#define GF_DISP_EVIL    68
#define GF_DISP_ALL 69
#define GF_DISP_DEMON   70      /* New types for Zangband begin here... */
#define GF_DISP_LIVING  71
#define GF_ROCKET       72
#define GF_NUKE         73
#define GF_MAKE_GLYPH   74
#define GF_STASIS       75
#define GF_STONE_WALL   76
#define GF_DEATH_RAY    77
#define GF_STUN         78
#define GF_HOLY_FIRE    79
#define GF_HELL_FIRE    80
#define GF_DISINTEGRATE 81
#define GF_CHARM        82
#define GF_CONTROL_UNDEAD   83
#define GF_CONTROL_ANIMAL   84
#define GF_PSI         85
#define GF_PSI_DRAIN   86
#define GF_TELEKINESIS  87
#define GF_JAM_DOOR     88
#define GF_DOMINATION   89
#define GF_DISP_GOOD    90
#define GF_IDENTIFY     91
#define GF_RAISE        92
#define GF_STAR_IDENTIFY 93
#define GF_DESTRUCTION  94
#define GF_STUN_CONF    95
#define GF_STUN_DAM     96
#define GF_CONF_DAM     98
#define GF_STAR_CHARM   99
#define GF_IMPLOSION    100
#define GF_LAVA_FLOW    101
#define GF_FEAR         102
#define GF_BETWEEN_GATE 103
#define GF_WINDS_MANA   104
#define GF_DEATH        105
#define GF_CONTROL_DEMON 106
#define GF_RAISE_DEMON 107
#define GF_TRAP_DEMONSOUL 108
#define GF_ATTACK       109
#define GF_CHARM_UNMOVING 110
#define MAX_GF          111

/*
 * Some things which induce learning
 */
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_NEXUS       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT     32



/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
#define ART_MIN_NORMAL          16
#define ART_MIN_SPECIAL         200


/*
 * Hack -- special "xtra" object powers
 */

/* Sustain one stat */
#define EGO_XTRA_SUSTAIN        1

/* High resist */
#define EGO_XTRA_POWER          2

/* Special ability */
#define EGO_XTRA_ABILITY        3

/*** Object flag values ***/


/*
 * Special Object Flags
 */
#define IDENT_SENSE             0x01    /* Item has been "sensed" */
#define IDENT_FIXED             0x02    /* Item has been "haggled" */
#define IDENT_EMPTY             0x04    /* Item charges are known */
#define IDENT_KNOWN             0x08    /* Item abilities are known */
#define IDENT_STOREB            0x10    /* Item is storebought !!!! */
#define IDENT_MENTAL            0x20    /* Item information is known */
#define IDENT_CURSED            0x40    /* Item is temporarily cursed */



/*
 * Special Monster Flags
 */
#define MFLAG_VIEW      0x00000001    /* Monster is in line of sight */
#define MFLAG_QUEST     0x00000002    /* Monster is subject to a quest */
#define MFLAG_PARTIAL   0x00000004    /* Monster is a partial summon */
#define MFLAG_CONTROL   0x00000008    /* Monster is controlled */
#define MFLAG_BORN      0x00000010    /* Monster is still being born */
#define MFLAG_NICE      0x00000020    /* Monster is still being nice */
#define MFLAG_SHOW      0x00000040    /* Monster is recently memorized */
#define MFLAG_MARK      0x00000080    /* Monster is currently memorized */
#define MFLAG_NO_DROP   0x00000100    /* Monster wont drop obj/corpse */
#define MFLAG_QUEST2    0x00000200    /* Monster is subject to a quest */
#define PERM_MFLAG_MASK ( \
        MFLAG_QUEST | MFLAG_QUEST2 | \
        MFLAG_PARTIAL | MFLAG_CONTROL | MFLAG_NO_DROP \
        )


/*
 * As of 2.7.8, the "object flags" are valid for all objects, and as
 * of 2.7.9, these flags are not actually stored with the object.
 *
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat bonuses, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "Stat Sustainers",
 * actual immunities, and resistances).  Note that "Hold Life" is really an
 * "immunity" to ExpLoss, and "Free Action" is "immunity to paralysis".
 *
 * Note that "flags3" contains everything else -- including the three "CURSED"
 * flags, and the "BLESSED" flag, several "item display" parameters, some new
 * flags for powerful Bows, and flags which affect the player in a "general"
 * way (LITE, TELEPATHY, SEE_INVIS, SLOW_DIGEST, REGEN, FEATHER), including
 * all the "general" curses (TELEPORT, AGGRAVATE, EXP_DRAIN).  It also has
 * four new flags called "ITEM_IGNORE_XXX" which lets an item specify that
 * it can not be affected by various forms of destruction.  This is NOT as
 * powerful as actually granting resistance/immunity to the wearer.
 */

#define TR1_STR                         0x00000001L     /* STR += "pval" */
#define TR1_INT                         0x00000002L     /* INT += "pval" */
#define TR1_WIS                         0x00000004L     /* WIS += "pval" */
#define TR1_DEX                         0x00000008L     /* DEX += "pval" */
#define TR1_CON                         0x00000010L     /* CON += "pval" */
#define TR1_CHR                         0x00000020L     /* CHR += "pval" */
#define TR1_MANA                        0x00000040L     /* Mana multipler */
#define TR1_SPELL                       0x00000080L     /* Spell power increase */
#define TR1_STEALTH                     0x00000100L     /* Stealth += "pval" */
#define TR1_SEARCH                      0x00000200L     /* Search += "pval" */
#define TR1_INFRA                       0x00000400L     /* Infra += "pval" */
#define TR1_TUNNEL                      0x00000800L     /* Tunnel += "pval" */
#define TR1_SPEED                       0x00001000L     /* Speed += "pval" */
#define TR1_BLOWS                       0x00002000L     /* Blows += "pval" */
#define TR1_CHAOTIC                     0x00004000L
#define TR1_VAMPIRIC                    0x00008000L
#define TR1_SLAY_ANIMAL         0x00010000L
#define TR1_SLAY_EVIL           0x00020000L
#define TR1_SLAY_UNDEAD         0x00040000L
#define TR1_SLAY_DEMON          0x00080000L
#define TR1_SLAY_ORC            0x00100000L
#define TR1_SLAY_TROLL          0x00200000L
#define TR1_SLAY_GIANT          0x00400000L
#define TR1_SLAY_DRAGON         0x00800000L
#define TR1_KILL_DRAGON         0x01000000L     /* Execute Dragon */
#define TR1_VORPAL                      0x02000000L     /* Later */
#define TR1_IMPACT                      0x04000000L     /* Cause Earthquakes */
#define TR1_BRAND_POIS                  0x08000000L
#define TR1_BRAND_ACID          0x10000000L
#define TR1_BRAND_ELEC          0x20000000L
#define TR1_BRAND_FIRE          0x40000000L
#define TR1_BRAND_COLD          0x80000000L
#define TR1_NULL_MASK           0x00000000L

#define TRAP2_AUTOMATIC_5       0x00000001L     /* Trap automatically rearms itself, 1 in 5 failure */
#define TRAP2_AUTOMATIC_99      0x00000002L     /* Trap automatically rearms itself */
#define TRAP2_KILL_GHOST        0x00000004L     /* Trap also affects PASS_WALL creatures */
#define TRAP2_TELEPORT_TO       0x00000008L     /* After everything else, teleport to player */
#define TRAP2_ONLY_DRAGON       0x00000010L     /* Affect only dragons & other AFFECTed creatures */
#define TRAP2_ONLY_DEMON        0x00000020L     /* Affect only demons & other AFFECTed creatures */
#define TRAP2_ONLY_ANIMAL       0x00000100L     /* Affect only animals & other AFFECTed creatures */
#define TRAP2_ONLY_UNDEAD       0x00000200L     /* Affect only undead & others */
#define TRAP2_ONLY_EVIL         0x00000400L     /* Affect only evil creatures &c. */

#define TRAP2_ONLY_MASK		(TRAP2_ONLY_DRAGON | TRAP2_ONLY_DEMON | TRAP2_ONLY_ANIMAL | \
				 TRAP2_ONLY_UNDEAD | TRAP2_ONLY_EVIL )

#define TR2_SUST_STR            0x00000001L
#define TR2_SUST_INT            0x00000002L
#define TR2_SUST_WIS            0x00000004L
#define TR2_SUST_DEX            0x00000008L
#define TR2_SUST_CON            0x00000010L
#define TR2_SUST_CHR            0x00000020L
#define TR2_INVIS                       0x00000040L     /* Invisibility */
#define TR2_LIFE                        0x00000080L     /* Life multiplier */
#define TR2_IM_ACID                     0x00000100L
#define TR2_IM_ELEC                     0x00000200L
#define TR2_IM_FIRE                     0x00000400L
#define TR2_IM_COLD                     0x00000800L
#define TR2_SENS_FIRE                   0x00001000L     /* Sensibility to fire */
#define TR2_REFLECT                     0x00002000L     /* Reflect 'bolts' */
#define TR2_FREE_ACT            0x00004000L     /* Free Action */
#define TR2_HOLD_LIFE           0x00008000L     /* Hold Life */
#define TR2_RES_ACID            0x00010000L
#define TR2_RES_ELEC            0x00020000L
#define TR2_RES_FIRE            0x00040000L
#define TR2_RES_COLD            0x00080000L
#define TR2_RES_POIS            0x00100000L
#define TR2_RES_FEAR            0x00200000L
#define TR2_RES_LITE            0x00400000L
#define TR2_RES_DARK            0x00800000L
#define TR2_RES_BLIND           0x01000000L
#define TR2_RES_CONF            0x02000000L
#define TR2_RES_SOUND           0x04000000L
#define TR2_RES_SHARDS          0x08000000L
#define TR2_RES_NETHER          0x10000000L
#define TR2_RES_NEXUS           0x20000000L
#define TR2_RES_CHAOS           0x40000000L
#define TR2_RES_DISEN           0x80000000L
#define TR2_NULL_MASK           0x00000000L

#define TR3_SH_FIRE             0x00000001L     /* Immolation (Fire) */
#define TR3_SH_ELEC             0x00000002L     /* Electric Sheath */
#define TR3_AUTO_CURSE          0x00000004L     /* The obj will recurse itself */
#define TR3_DECAY               0x00000008L     /* Decay */
#define TR3_NO_TELE             0x00000010L     /* Anti-teleportation */
#define TR3_NO_MAGIC            0x00000020L     /* Anti-magic */
#define TR3_WRAITH              0x00000040L     /* Wraithform */
#define TR3_TY_CURSE            0x00000080L     /* The Ancient Curse */
#define TR3_EASY_KNOW           0x00000100L     /* Aware -> Known */
#define TR3_HIDE_TYPE           0x00000200L     /* Hide "pval" description */
#define TR3_SHOW_MODS           0x00000400L     /* Always show Tohit/Todam */
#define TR3_INSTA_ART           0x00000800L     /* Item must be an artifact */
#define TR3_FEATHER                     0x00001000L     /* Feather Falling */
#define TR3_LITE1               0x00002000L     /* lite radius 1 */
#define TR3_SEE_INVIS           0x00004000L     /* See Invisible */
#define TR3_NORM_ART            0x00008000L     /* Artifact in k_info */
#define TR3_SLOW_DIGEST         0x00010000L     /* Item slows down digestion */
#define TR3_REGEN                       0x00020000L     /* Item induces regeneration */
#define TR3_XTRA_MIGHT          0x00040000L     /* Bows get extra multiplier */
#define TR3_XTRA_SHOTS          0x00080000L     /* Bows get extra shots */
#define TR3_IGNORE_ACID         0x00100000L     /* Item ignores Acid Damage */
#define TR3_IGNORE_ELEC         0x00200000L     /* Item ignores Elec Damage */
#define TR3_IGNORE_FIRE         0x00400000L     /* Item ignores Fire Damage */
#define TR3_IGNORE_COLD         0x00800000L     /* Item ignores Cold Damage */
#define TR3_ACTIVATE            0x01000000L     /* Item can be activated */
#define TR3_DRAIN_EXP           0x02000000L     /* Item drains Experience */
#define TR3_TELEPORT            0x04000000L     /* Item teleports player */
#define TR3_AGGRAVATE           0x08000000L     /* Item aggravates monsters */
#define TR3_BLESSED                     0x10000000L     /* Item is Blessed */
#define TR3_CURSED                      0x20000000L     /* Item is Cursed */
#define TR3_HEAVY_CURSE         0x40000000L     /* Item is Heavily Cursed */
#define TR3_PERMA_CURSE         0x80000000L     /* Item is Perma Cursed */
#define TR3_NULL_MASK           0x00000000L


#define TR4_NEVER_BLOW          0x00000001L     /* Weapon can't attack */
#define TR4_PRECOGNITION        0x00000002L     /* Like activating the cheat mode */
#define TR4_BLACK_BREATH        0x00000004L     /* Tolkien's Black Breath */
#define TR4_RECHARGE            0x00000008L     /* For artifact Wands and Staffs */
#define TR4_FLY                 0x00000010L     /* This one and ONLY this one allow you to fly over trees */
#define TR4_DG_CURSE            0x00000020L     /* The Ancient Morgothian Curse */
#define TR4_COULD2H             0x00000040L     /* Can wield it 2 Handed */
#define TR4_MUST2H              0x00000080L     /* Must wield it 2 Handed */
#define TR4_LEVELS              0x00000100L     /* Can gain exp/exp levels !! */
#define TR4_CLONE               0x00000200L     /* Can clone monsters */
#define TR4_SPECIAL_GENE        0x00000400L     /* The object can only be generated in special conditions like quests, special dungeons, ... */
#define TR4_CLIMB               0x00000800L     /* Allow climbing mountains */
#define TR4_FAST_CAST           0x00001000L     /* Rod is x2 time faster to use */
#define TR4_CAPACITY            0x00002000L     /* Rod can take x2 mana */
#define TR4_CHARGING            0x00004000L     /* Rod recharge faster */
#define TR4_CHEAPNESS           0x00008000L     /* Rod spells are cheaper(in mana cost) to cast */
#define TR4_FOUNTAIN            0x00010000L     /* Available as fountain (for potions) */
#define TR4_ANTIMAGIC_50        0x00020000L     /* Forbid magic */
#define TR4_ANTIMAGIC_30        0x00040000L     /* Forbid magic */
#define TR4_ANTIMAGIC_20        0x00080000L     /* Forbid magic */
#define TR4_ANTIMAGIC_10        0x00100000L     /* Forbid magic */
#define TR4_EASY_USE            0x00200000L     /* Easily activable */
#define TR4_IM_NETHER           0x00400000L     /* Immunity to nether */
#define TR4_RECHARGED           0x00800000L     /* Object has been recharged once */
#define TR4_ULTIMATE            0x01000000L     /* ULTIMATE artifact */
#define TR4_AUTO_ID             0x02000000L     /* Id stuff on floor */
#define TR4_LITE2               0x04000000L     /* lite radius 2 */
#define TR4_LITE3               0x08000000L     /* lite radius 3 */
#define TR4_FUEL_LITE           0x10000000L     /* fuelable lite */
#define TR4_ART_EXP             0x20000000L     /* Will accumulate xp */
#define TR4_CURSE_NO_DROP       0x40000000L     /* The obj wont be dropped */
#define TR4_NO_RECHARGE         0x80000000L     /* Object Cannot be recharged */
#define TR4_NULL_MASK           0xFFFFFFFCL

#define TR5_TEMPORARY           0x00000001L     /* In timeout turns it is destroyed */
#define TR5_DRAIN_MANA          0x00000002L     /* Drains mana */
#define TR5_DRAIN_HP            0x00000004L     /* Drains hp */
#define TR5_KILL_DEMON          0x00000008L     /* Execute Demon */
#define TR5_KILL_UNDEAD         0x00000010L     /* Execute Undead */
#define TR5_CRIT                0x00000020L     /* More critical hits */
#define TR5_ATTR_MULTI          0x00000040L     /* Object shimmer -- only allowed in k_info */
#define TR5_WOUNDING            0x00000080L     /* Wounds monsters */
#define TR5_FULL_NAME           0x00000100L     /* Uses direct name from k_info */
#define TR5_LUCK                0x00000200L     /* Luck += pval */
#define TR5_IMMOVABLE           0x00000400L     /* Cannot move */
#define TR5_SPELL_CONTAIN       0x00000800L     /* Can contain a spell */
#define TR5_RES_MORGUL          0x00001000L     /* Is not shattered by morgul fiends(nazguls) */
#define TR5_ACTIVATE_NO_WIELD   0x00002000L     /* Can be 'A'ctivated without being wielded */
#define TR5_MAGIC_BREATH        0x00004000L     /* Can breath anywere */
#define TR5_WATER_BREATH        0x00008000L     /* Can breath underwater */
#define TR5_WIELD_CAST          0x00010000L     /* Need to be wielded to cast spelsl fomr it(if it can be wiekded) */

/* ESP defines */
#define ESP_ORC                 0x00000001L
#define ESP_TROLL               0x00000002L
#define ESP_DRAGON              0x00000004L
#define ESP_GIANT               0x00000008L
#define ESP_DEMON               0x00000010L
#define ESP_UNDEAD              0x00000020L
#define ESP_EVIL                0x00000040L
#define ESP_ANIMAL              0x00000080L
#define ESP_THUNDERLORD         0x00000100L
#define ESP_GOOD                0x00000200L
#define ESP_NONLIVING           0x00000400L
#define ESP_UNIQUE              0x00000800L
#define ESP_SPIDER              0x00001000L
#define ESP_ALL                 0x80000000L

/* Number of group of flags to choose from */
#define MAX_FLAG_GROUP          12
#define NEW_GROUP_CHANCE        40      /* Chance to get a new group */

/*
 * Hack masks for "pval-dependant" flags.
 */
#define TR1_PVAL_MASK   \
	(TR1_STR | TR1_INT | TR1_WIS | TR1_DEX | \
     TR1_CON | TR1_CHR | \
	 TR1_STEALTH | TR1_SEARCH | TR1_INFRA | TR1_TUNNEL | \
     TR1_SPEED | TR1_BLOWS | TR1_SPELL)

#define TR5_PVAL_MASK   \
	(TR5_CRIT | TR5_LUCK)


/*** Ego flags ***/
#define ETR4_SUSTAIN           0x00000001L     /* Ego-Item gives a Random Sustain */
#define ETR4_OLD_RESIST        0x00000002L     /* The old "extra power" random high resist */
#define ETR4_ABILITY           0x00000004L     /* Ego-Item has a random Sustain */
#define ETR4_R_ELEM            0x00000008L     /* Item resists Acid/Fire/Cold/Elec or Poison */
#define ETR4_R_LOW             0x00000010L     /* Item has a random low resist */
#define ETR4_R_HIGH            0x00000020L     /* Item has a random high resist */
#define ETR4_R_ANY             0x00000040L     /* Item has one additional resist */
#define ETR4_R_DRAGON          0x00000080L     /* Item gets "Dragon" Resist */
#define ETR4_SLAY_WEAP         0x00000100L     /* Special 'Slaying' bonus */
#define ETR4_DAM_DIE           0x00000200L     /* Item has an additional dam die */
#define ETR4_DAM_SIZE          0x00000400L     /* Item has greater damage dice */
#define ETR4_PVAL_M1           0x00000800L     /* Item has +1 to pval */
#define ETR4_PVAL_M2           0x00001000L     /* Item has +(up to 2) to pval */
#define ETR4_PVAL_M3           0x00002000L     /* Item has +(up to 3) to pval */
#define ETR4_PVAL_M5           0x00004000L     /* Item has +(up to 5) to pval */
#define ETR4_AC_M1             0x00008000L     /* Item has +1 to AC */
#define ETR4_AC_M2             0x00010000L     /* Item has +(up to 2) to AC */
#define ETR4_AC_M3             0x00020000L     /* Item has +(up to 3) to AC */
#define ETR4_AC_M5             0x00040000L     /* Item has +(up to 5) to AC */
#define ETR4_TH_M1             0x00080000L     /* Item has +1 to hit */
#define ETR4_TH_M2             0x00100000L     /* Item has +(up to 2) to hit */
#define ETR4_TH_M3             0x00200000L     /* Item has +(up to 3) to hit */
#define ETR4_TH_M5             0x00400000L     /* Item has +(up to 5) to hit */
#define ETR4_TD_M1             0x00800000L     /* Item has +1 to dam */
#define ETR4_TD_M2             0x01000000L     /* Item has +(up to 2) to dam */
#define ETR4_TD_M3             0x02000000L     /* Item has +(up to 3) to dam */
#define ETR4_TD_M5             0x04000000L     /* Item has +(up to 5) to dam */
#define ETR4_R_P_ABILITY       0x08000000L     /* Item has a random pval-affected ability */
#define ETR4_R_STAT            0x10000000L     /* Item affects a random stat */
#define ETR4_R_STAT_SUST       0x20000000L     /* Item affects a random stat & sustains it */
#define ETR4_R_IMMUNITY        0x40000000L     /* Item gives a random immunity */
#define ETR4_LIMIT_BLOWS       0x80000000L     /* switch the "limit blows" feature */

/*** Features flags -- DG ***/
#define FF1_NO_WALK             0x00000001L
#define FF1_NO_VISION           0x00000002L
#define FF1_CAN_LEVITATE        0x00000004L
#define FF1_CAN_PASS            0x00000008L
#define FF1_FLOOR               0x00000010L
#define FF1_WALL                0x00000020L
#define FF1_PERMANENT           0x00000040L
#define FF1_CAN_FLY             0x00000080L
#define FF1_REMEMBER            0x00000100L
#define FF1_NOTICE              0x00000200L
#define FF1_DONT_NOTICE_RUNNING 0x00000400L
#define FF1_CAN_RUN             0x00000800L
#define FF1_DOOR                0x00001000L
#define FF1_SUPPORT_LIGHT       0x00002000L
#define FF1_CAN_CLIMB           0x00004000L
#define FF1_TUNNELABLE          0x00008000L
#define FF1_WEB                 0x00010000L
#define FF1_ATTR_MULTI          0x00020000L
#define FF1_SUPPORT_GROWTH      0x00040000L

/*** Dungeon type flags -- DG ***/
#define DF1_PRINCIPAL           0x00000001L	/* Is a principal dungeon */
#define DF1_MAZE                0x00000002L	/* Is a maze-type dungeon */
#define DF1_SMALLEST            0x00000004L	/* Creates VERY small levels like The Maze */
#define DF1_SMALL               0x00000008L	/* Creates small levels like Dol Goldor */
#define DF1_BIG                 0x00000010L	/* Creates big levels like Moria, and Angband dungeons */
#define DF1_NO_DOORS            0x00000020L	/* No doors on rooms, like Barrowdowns, Old Forest etc) */
#define DF1_WATER_RIVER         0x00000040L	/* Allow a single water streamer on a level */
#define DF1_LAVA_RIVER          0x00000080L	/* Allow a single lava streamer on a level */
#define DF1_WATER_RIVERS        0x00000100L	/* Allow multiple water streamers on a level */
#define DF1_LAVA_RIVERS         0x00000200L	/* Allow multiple lava streamers on a level */
#define DF1_CAVE                0x00000400L	/* Allow rooms */
#define DF1_CAVERN              0x00000800L	/* Allow cavern rooms */
#define DF1_NO_UP               0x00001000L	/* Disallow up stairs */
#define DF1_HOT                 0x00002000L	/* Corpses on ground and in pack decay quicker through heat */
#define DF1_COLD                0x00004000L	/* Corpses on ground and in pack decay quicker through cold */
#define DF1_FORCE_DOWN          0x00008000L	/* No up stairs generated */
#define DF1_FORGET              0x00010000L	/* Features are forgotten, like the Maze and Illusory Castle */
#define DF1_NO_DESTROY          0x00020000L	/* No destroyed levels in dungeon */
#define DF1_SAND_VEIN           0x00040000L	/* Like in the sandworm lair */
#define DF1_CIRCULAR_ROOMS      0x00080000L	/* Allow circular rooms */
#define DF1_EMPTY               0x00100000L	/* Allow arena levels */
#define DF1_DAMAGE_FEAT         0x00200000L
#define DF1_FLAT                0x00400000L	/* Creates paths to next areas at edge of level, like Barrowdowns */
#define DF1_TOWER               0x00800000L	/* You start at bottom and go up rather than the reverse */
#define DF1_RANDOM_TOWNS        0x01000000L	/* Allow random towns */
#define DF1_DOUBLE              0x02000000L	/* Creates double-walled dungeon like Helcaraxe and Erebor */
#define DF1_LIFE_LEVEL          0x04000000L	/* Creates dungeon level on modified 'game of life' algorithm */
#define DF1_EVOLVE              0x08000000L	/* Evolving, pulsing levels like Heart of the Earth */
#define DF1_ADJUST_LEVEL_1      0x10000000L	/* Minimum monster level will be equal to dungeon level */
#define DF1_ADJUST_LEVEL_2      0x20000000L	/* Minimum monster level will be double the dungeon level */
#define DF1_NO_RECALL           0x40000000L	/* No recall allowed */
#define DF1_NO_STREAMERS        0x80000000L	/* No streamers */

#define DF2_ADJUST_LEVEL_1_2    0x00000001L	/* Minimum monster level will be half the dungeon level */
#define DF2_NO_SHAFT            0x00000002L	/* No shafts */
#define DF2_ADJUST_LEVEL_PLAYER 0x00000004L	/* Uses player level*2 instead of dungeon level for other ADJUST_LEVEL flags */
#define DF2_NO_TELEPORT         0x00000008L
#define DF2_ASK_LEAVE           0x00000010L
#define DF2_NO_STAIR            0x00000020L
#define DF2_SPECIAL             0x00000040L
#define DF2_NO_NEW_MONSTER      0x00000080L
#define DF2_DESC                0x00000100L
#define DF2_NO_GENO             0x00000200L
#define DF2_NO_BREATH           0x00000400L     /* Oups, cannot breath here */
#define DF2_WATER_BREATH        0x00000800L     /* Oups, cannot breath here, need water breathing */
#define DF2_ELVEN               0x00001000L     /* Try to create elven monster ego */
#define DF2_DWARVEN             0x00002000L     /* Try to create dwarven monster ego */
#define DF2_NO_EASY_MOVE        0x00004000L     /* Forbid stuff like teleport level, probability travel, ... */
#define DF2_NO_RECALL_OUT       0x00008000L     /* Cannot recall out of the place */
#define DF2_DESC_ALWAYS         0x00010000L     /* Always shows the desc */

/*** Town flags ***/
#define TOWN_REAL	0x01	/* Town is really present */
#define TOWN_KNOWN	0x02	/* Town is found by the player */



/*** Monster blow constants ***/

#define MODIFY_AUX(o, n) ((o) = modify_aux((o), (n) >> 2, (n) & 3))
#define MODIFY(o, n, min) MODIFY_AUX(o, n); (o) = ((o) < (min))?(min):(o)

/*
 * New monster blow methods
 */
#define RBM_ANY          0
#define RBM_HIT          1
#define RBM_TOUCH        2
#define RBM_PUNCH        3
#define RBM_KICK         4
#define RBM_CLAW         5
#define RBM_BITE         6
#define RBM_STING        7
#define RBM_XXX1         8
#define RBM_BUTT         9
#define RBM_CRUSH       10
#define RBM_ENGULF      11
#define RBM_CHARGE      12
#define RBM_CRAWL       13
#define RBM_DROOL       14
#define RBM_SPIT        15
#define RBM_EXPLODE     16
#define RBM_GAZE        17
#define RBM_WAIL        18
#define RBM_SPORE       19
#define RBM_XXX4        20
#define RBM_BEG         21
#define RBM_INSULT      22
#define RBM_MOAN        23
#define RBM_SHOW        24


/*
 * New monster blow effects
 */
#define RBE_ANY          0
#define RBE_HURT         1
#define RBE_POISON       2
#define RBE_UN_BONUS     3
#define RBE_UN_POWER     4
#define RBE_EAT_GOLD     5
#define RBE_EAT_ITEM     6
#define RBE_EAT_FOOD     7
#define RBE_EAT_LITE     8
#define RBE_ACID         9
#define RBE_ELEC        10
#define RBE_FIRE        11
#define RBE_COLD        12
#define RBE_BLIND       13
#define RBE_CONFUSE     14
#define RBE_TERRIFY     15
#define RBE_PARALYZE    16
#define RBE_LOSE_STR    17
#define RBE_LOSE_INT    18
#define RBE_LOSE_WIS    19
#define RBE_LOSE_DEX    20
#define RBE_LOSE_CON    21
#define RBE_LOSE_CHR    22
#define RBE_LOSE_ALL    23
#define RBE_SHATTER     24
#define RBE_EXP_10      25
#define RBE_EXP_20      26
#define RBE_EXP_40      27
#define RBE_EXP_80      28
#define RBE_DISEASE     29
#define RBE_TIME        30
#define RBE_SANITY      31
#define RBE_HALLU       32
#define RBE_PARASITE    33
#define RBE_ABOMINATION 34


/*** Monster flag values (hard-coded) ***/

#define MONSTER_LEVEL_MAX       150
#define MONSTER_EXP(level)      ((((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * (((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * (((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * 6)

/*
 * New monster race bit flags
 */
#define RF1_UNIQUE                      0x00000001      /* Unique Monster */
#define RF1_QUESTOR                     0x00000002      /* Quest Monster */
#define RF1_MALE                        0x00000004      /* Male gender */
#define RF1_FEMALE                      0x00000008      /* Female gender */
#define RF1_CHAR_CLEAR          0x00000010      /* Absorbs symbol */
#define RF1_CHAR_MULTI          0x00000020      /* Changes symbol */
#define RF1_ATTR_CLEAR          0x00000040      /* Absorbs color */
#define RF1_ATTR_MULTI          0x00000080      /* Changes color */
#define RF1_FORCE_DEPTH         0x00000100      /* Start at "correct" depth */
#define RF1_FORCE_MAXHP         0x00000200      /* Start with max hitpoints */
#define RF1_FORCE_SLEEP         0x00000400      /* Start out sleeping */
#define RF1_FORCE_EXTRA         0x00000800      /* Start out something */
#define RF1_FRIEND              0x00001000      /* Arrive with a friend */
#define RF1_FRIENDS             0x00002000      /* Arrive with some friends */
#define RF1_ESCORT              0x00004000      /* Arrive with an escort */
#define RF1_ESCORTS             0x00008000      /* Arrive with some escorts */
#define RF1_NEVER_BLOW          0x00010000      /* Never make physical blow */
#define RF1_NEVER_MOVE          0x00020000      /* Never make physical move */
#define RF1_RAND_25             0x00040000      /* Moves randomly (25%) */
#define RF1_RAND_50             0x00080000      /* Moves randomly (50%) */
#define RF1_ONLY_GOLD           0x00100000      /* Drop only gold */
#define RF1_ONLY_ITEM           0x00200000      /* Drop only items */
#define RF1_DROP_60             0x00400000      /* Drop an item/gold (60%) */
#define RF1_DROP_90             0x00800000      /* Drop an item/gold (90%) */
#define RF1_DROP_1D2            0x01000000      /* Drop 1d2 items/gold */
#define RF1_DROP_2D2            0x02000000      /* Drop 2d2 items/gold */
#define RF1_DROP_3D2            0x04000000      /* Drop 3d2 items/gold */
#define RF1_DROP_4D2            0x08000000      /* Drop 4d2 items/gold */
#define RF1_DROP_GOOD           0x10000000      /* Drop good items */
#define RF1_DROP_GREAT          0x20000000      /* Drop great items */
#define RF1_DROP_USEFUL         0x40000000      /* Drop "useful" items */
#define RF1_DROP_CHOSEN         0x80000000      /* Drop "chosen" items */

/*
 * New monster race bit flags
 */
#define RF2_STUPID                      0x00000001      /* Monster is stupid */
#define RF2_SMART                       0x00000002      /* Monster is smart */
#define RF2_CAN_SPEAK            0x00000004  /* TY: can speak */
#define RF2_REFLECTING                  0x00000008      /* Reflects bolts */
#define RF2_INVISIBLE           0x00000010      /* Monster avoids vision */
#define RF2_COLD_BLOOD          0x00000020      /* Monster avoids infra */
#define RF2_EMPTY_MIND          0x00000040      /* Monster avoids telepathy */
#define RF2_WEIRD_MIND          0x00000080      /* Monster avoids telepathy? */
#define RF2_DEATH_ORB           0x00000100      /* Death Orb */
#define RF2_REGENERATE          0x00000200      /* Monster regenerates */
#define RF2_SHAPECHANGER        0x00000400  /* TY: shapechanger */
#define RF2_ATTR_ANY            0x00000800  /* TY: Attr_any */
#define RF2_POWERFUL            0x00001000      /* Monster has strong breath */
#define RF2_ELDRITCH_HORROR             0x00002000      /* Sanity-blasting horror    */
#define RF2_AURA_FIRE                   0x00004000      /* Burns in melee */
#define RF2_AURA_ELEC                   0x00008000      /* Shocks in melee */
#define RF2_OPEN_DOOR           0x00010000      /* Monster can open doors */
#define RF2_BASH_DOOR           0x00020000      /* Monster can bash doors */
#define RF2_PASS_WALL           0x00040000      /* Monster can pass walls */
#define RF2_KILL_WALL           0x00080000      /* Monster can destroy walls */
#define RF2_MOVE_BODY           0x00100000      /* Monster can move monsters */
#define RF2_KILL_BODY           0x00200000      /* Monster can kill monsters */
#define RF2_TAKE_ITEM           0x00400000      /* Monster can pick up items */
#define RF2_KILL_ITEM           0x00800000      /* Monster can crush items */
#define RF2_BRAIN_1                     0x01000000
#define RF2_BRAIN_2                     0x02000000
#define RF2_BRAIN_3                     0x04000000
#define RF2_BRAIN_4                     0x08000000
#define RF2_BRAIN_5                     0x10000000
#define RF2_BRAIN_6                     0x20000000
#define RF2_BRAIN_7                     0x40000000
#define RF2_BRAIN_8                     0x80000000

/*
 * New monster race bit flags
 */
#define RF3_ORC                         0x00000001      /* Orc */
#define RF3_TROLL                       0x00000002      /* Troll */
#define RF3_GIANT                       0x00000004      /* Giant */
#define RF3_DRAGON                      0x00000008      /* Dragon */
#define RF3_DEMON                       0x00000010      /* Demon */
#define RF3_UNDEAD                      0x00000020      /* Undead */
#define RF3_EVIL                        0x00000040      /* Evil */
#define RF3_ANIMAL                      0x00000080      /* Animal */
#define RF3_THUNDERLORD            0x00000100  /* DG: Thunderlord */
#define RF3_GOOD                        0x00000200      /* Good */
#define RF3_AURA_COLD                        0x00000400      /* Freezes in melee */
#define RF3_NONLIVING           0x00000800  /* TY: Non-Living (?) */
#define RF3_HURT_LITE           0x00001000      /* Hurt by lite */
#define RF3_HURT_ROCK           0x00002000      /* Hurt by rock remover */
#define RF3_SUSCEP_FIRE           0x00004000      /* Hurt badly by fire */
#define RF3_SUSCEP_COLD           0x00008000      /* Hurt badly by cold */
#define RF3_IM_ACID                     0x00010000      /* Resist acid a lot */
#define RF3_IM_ELEC                     0x00020000      /* Resist elec a lot */
#define RF3_IM_FIRE                     0x00040000      /* Resist fire a lot */
#define RF3_IM_COLD                     0x00080000      /* Resist cold a lot */
#define RF3_IM_POIS                     0x00100000      /* Resist poison a lot */
#define RF3_RES_TELE                    0x00200000      /* Resist teleportation */
#define RF3_RES_NETH            0x00400000      /* Resist nether a lot */
#define RF3_RES_WATE            0x00800000      /* Resist water */
#define RF3_RES_PLAS            0x01000000      /* Resist plasma */
#define RF3_RES_NEXU            0x02000000      /* Resist nexus */
#define RF3_RES_DISE            0x04000000      /* Resist disenchantment */
#define RF3_UNIQUE_4                    0x08000000      /* Is a "Nazgul" unique */
#define RF3_NO_FEAR                     0x10000000      /* Cannot be scared */
#define RF3_NO_STUN                     0x20000000      /* Cannot be stunned */
#define RF3_NO_CONF                     0x40000000      /* Cannot be confused */
#define RF3_NO_SLEEP            0x80000000      /* Cannot be slept */

/*
 * New monster race bit flags
 */
#define RF4_SHRIEK                      0x00000001  /* Shriek for help */
#define RF4_MULTIPLY                    0x00000002  /* Monster reproduces */
#define RF4_S_ANIMAL                    0x00000004  /* Summon animals */
#define RF4_ROCKET                      0x00000008  /* TY: Rocket */
#define RF4_ARROW_1                     0x00000010  /* Fire an arrow (light) */
#define RF4_ARROW_2                     0x00000020  /* Fire an arrow (heavy) */
#define RF4_ARROW_3                     0x00000040  /* Fire missiles (light) */
#define RF4_ARROW_4                     0x00000080  /* Fire missiles (heavy) */
#define RF4_BR_ACID                     0x00000100  /* Breathe Acid */
#define RF4_BR_ELEC                     0x00000200  /* Breathe Elec */
#define RF4_BR_FIRE                     0x00000400  /* Breathe Fire */
#define RF4_BR_COLD                     0x00000800  /* Breathe Cold */
#define RF4_BR_POIS                     0x00001000  /* Breathe Poison */
#define RF4_BR_NETH                     0x00002000  /* Breathe Nether */
#define RF4_BR_LITE                     0x00004000  /* Breathe Lite */
#define RF4_BR_DARK                     0x00008000  /* Breathe Dark */
#define RF4_BR_CONF                     0x00010000  /* Breathe Confusion */
#define RF4_BR_SOUN                     0x00020000  /* Breathe Sound */
#define RF4_BR_CHAO                     0x00040000  /* Breathe Chaos */
#define RF4_BR_DISE                     0x00080000  /* Breathe Disenchant */
#define RF4_BR_NEXU                     0x00100000  /* Breathe Nexus */
#define RF4_BR_TIME                     0x00200000  /* Breathe Time */
#define RF4_BR_INER                     0x00400000  /* Breathe Inertia */
#define RF4_BR_GRAV                     0x00800000  /* Breathe Gravity */
#define RF4_BR_SHAR                     0x01000000  /* Breathe Shards */
#define RF4_BR_PLAS                     0x02000000  /* Breathe Plasma */
#define RF4_BR_WALL                     0x04000000  /* Breathe Force */
#define RF4_BR_MANA                     0x08000000  /* Breathe Mana */
#define RF4_BA_NUKE                     0x10000000  /* TY: Nuke Ball */
#define RF4_BR_NUKE                     0x20000000  /* TY: Toxic Breath */
#define RF4_BA_CHAO                     0x40000000  /* Chaos Ball */
#define RF4_BR_DISI                     0x80000000  /* Breathe Disintegration */

/*
 * New monster race bit flags
 */
#define RF5_BA_ACID                     0x00000001      /* Acid Ball */
#define RF5_BA_ELEC                     0x00000002      /* Elec Ball */
#define RF5_BA_FIRE                     0x00000004      /* Fire Ball */
#define RF5_BA_COLD                     0x00000008      /* Cold Ball */
#define RF5_BA_POIS                     0x00000010      /* Poison Ball */
#define RF5_BA_NETH                     0x00000020      /* Nether Ball */
#define RF5_BA_WATE                     0x00000040      /* Water Ball */
#define RF5_BA_MANA                     0x00000080      /* Mana Storm */
#define RF5_BA_DARK                     0x00000100      /* Darkness Storm */
#define RF5_DRAIN_MANA          0x00000200      /* Drain Mana */
#define RF5_MIND_BLAST          0x00000400      /* Blast Mind */
#define RF5_BRAIN_SMASH         0x00000800      /* Smash Brain */
#define RF5_CAUSE_1                     0x00001000      /* Cause Light Wound */
#define RF5_CAUSE_2                     0x00002000      /* Cause Serious Wound */
#define RF5_CAUSE_3                     0x00004000      /* Cause Critical Wound */
#define RF5_CAUSE_4                     0x00008000      /* Cause Mortal Wound */
#define RF5_BO_ACID                     0x00010000      /* Acid Bolt */
#define RF5_BO_ELEC                     0x00020000      /* Elec Bolt (unused) */
#define RF5_BO_FIRE                     0x00040000      /* Fire Bolt */
#define RF5_BO_COLD                     0x00080000      /* Cold Bolt */
#define RF5_BO_POIS                     0x00100000      /* Poison Bolt (unused) */
#define RF5_BO_NETH                     0x00200000      /* Nether Bolt */
#define RF5_BO_WATE                     0x00400000      /* Water Bolt */
#define RF5_BO_MANA                     0x00800000      /* Mana Bolt */
#define RF5_BO_PLAS                     0x01000000      /* Plasma Bolt */
#define RF5_BO_ICEE                     0x02000000      /* Ice Bolt */
#define RF5_MISSILE                     0x04000000      /* Magic Missile */
#define RF5_SCARE                       0x08000000      /* Frighten Player */
#define RF5_BLIND                       0x10000000      /* Blind Player */
#define RF5_CONF                        0x20000000      /* Confuse Player */
#define RF5_SLOW                        0x40000000      /* Slow Player */
#define RF5_HOLD                        0x80000000      /* Paralyze Player */

/*
 * New monster race bit flags
 */
#define RF6_HASTE                       0x00000001      /* Speed self */
#define RF6_HAND_DOOM                   0x00000002      /* Hand of Doom */
#define RF6_HEAL                        0x00000004      /* Heal self */
#define RF6_S_ANIMALS                   0x00000008      /* Summon animals */
#define RF6_BLINK                       0x00000010      /* Teleport Short */
#define RF6_TPORT                       0x00000020      /* Teleport Long */
#define RF6_TELE_TO                     0x00000040      /* Move player to monster */
#define RF6_TELE_AWAY                   0x00000080      /* Move player far away */
#define RF6_TELE_LEVEL                  0x00000100      /* Move player vertically */
#define RF6_DARKNESS                    0x00000200      /* Create Darkness */
#define RF6_TRAPS                       0x00000400      /* Create Traps */
#define RF6_FORGET                      0x00000800      /* Cause amnesia */
#define RF6_RAISE_DEAD                  0x00001000      /* Raise Dead */
#define RF6_S_BUG                       0x00002000      /* Summon Software bug */
#define RF6_S_RNG                       0x00004000      /* Summon RNG */
#define RF6_S_THUNDERLORD               0x00008000      /* Summon Thunderlords */
#define RF6_S_KIN                       0x00010000      /* Summon "kin" */
#define RF6_S_HI_DEMON                  0x00020000      /* Summon greater demons! */
#define RF6_S_MONSTER                   0x00040000      /* Summon Monster */
#define RF6_S_MONSTERS                  0x00080000      /* Summon Monsters */
#define RF6_S_ANT                       0x00100000      /* Summon Ants */
#define RF6_S_SPIDER                    0x00200000      /* Summon Spiders */
#define RF6_S_HOUND                     0x00400000      /* Summon Hounds */
#define RF6_S_HYDRA                     0x00800000      /* Summon Hydras */
#define RF6_S_ANGEL                     0x01000000      /* Summon Angel */
#define RF6_S_DEMON                     0x02000000      /* Summon Demon */
#define RF6_S_UNDEAD            0x04000000      /* Summon Undead */
#define RF6_S_DRAGON            0x08000000      /* Summon Dragon */
#define RF6_S_HI_UNDEAD         0x10000000      /* Summon Greater Undead */
#define RF6_S_HI_DRAGON         0x20000000      /* Summon Ancient Dragon */
#define RF6_S_WRAITH            0x40000000      /* Summon Unique Wraith */
#define RF6_S_UNIQUE            0x80000000      /* Summon Unique Monster */

/*
 * New monster race bit flags
 */
#define RF7_AQUATIC             0x00000001  /* Aquatic monster */
#define RF7_CAN_SWIM            0x00000002  /* Monster can swim */
#define RF7_CAN_FLY             0x00000004  /* Monster can fly */
#define RF7_FRIENDLY            0x00000008  /* Monster is friendly */
#define RF7_PET                 0x00000010  /* Monster is a pet */
#define RF7_MORTAL              0x00000020  /* Monster is a mortal being */
#define RF7_SPIDER              0x00000040  /* Monster is a spider (can pass webs) */
#define RF7_NAZGUL              0x00000080  /* Monster is a Nazgul */
#define RF7_DG_CURSE            0x00000100  /* If killed the monster grant a DG Curse to the player */
#define RF7_POSSESSOR           0x00000200  /* Is it a dreaded possessor monster ? */
#define RF7_NO_DEATH            0x00000400  /* Cannot be killed */
#define RF7_NO_TARGET           0x00000800  /* Cannot be targeted */
#define RF7_AI_ANNOY            0x00001000  /* Try to tease the player */
#define RF7_AI_SPECIAL          0x00002000  /* For quests */
#define RF7_NEUTRAL             0x00004000  /* Monster is neutral */
#define RF7_DROP_ART            0x00008000  /* Monster drop one art */
#define RF7_DROP_RANDART        0x00010000  /* Monster drop one randart */
#define RF7_AI_PLAYER           0x00020000  /* Controlled by the player */
#define RF7_NO_THEFT		0x00040000  /* Monster is immune to theft */
#define RF7_SPIRIT		0x00080000  /* This is a Spirit, coming from the Void */
#define RF7_IM_MELEE            0x00100000  /* IM melee */


/*
 * Monster race flags
 */
#define RF8_DUNGEON             0x00000001
#define RF8_WILD_TOWN           0x00000002
#define RF8_XXX8X02             0x00000004
#define RF8_WILD_SHORE          0x00000008
#define RF8_WILD_OCEAN          0x00000010
#define RF8_WILD_WASTE          0x00000020
#define RF8_WILD_WOOD           0x00000040
#define RF8_WILD_VOLCANO        0x00000080
#define RF8_XXX8X08             0x00000100
#define RF8_WILD_MOUNTAIN       0x00000200
#define RF8_WILD_GRASS          0x00000400
#define RF8_NO_CUT              0x00000800
#define RF8_CTHANGBAND          0x00001000  /* Not used in ToME */
/* XXX */
#define RF8_ZANGBAND            0x00004000  /* Not used in ToME */
#define RF8_JOKEANGBAND         0x00008000
#define RF8_ANGBAND             0x00010000

#define RF8_WILD_TOO            0x80000000


/*
 * Monster race flags
 */
#define RF9_DROP_CORPSE         0x00000001
#define RF9_DROP_SKELETON       0x00000002
#define RF9_HAS_LITE            0x00000004      /* Carries a lite */
#define RF9_MIMIC               0x00000008      /* *REALLY* looks like an object ... only nastier */
#define RF9_HAS_EGG             0x00000010      /* Can be monster's eggs */
#define RF9_IMPRESED            0x00000020      /* The monster can follow you on each level until he dies */
#define RF9_SUSCEP_ACID         0x00000040      /* Susceptible to acid */
#define RF9_SUSCEP_ELEC         0x00000080      /* Susceptible to lightning */
#define RF9_SUSCEP_POIS         0x00000100      /* Susceptible to poison */
#define RF9_KILL_TREES          0x00000200      /* Monster can eat trees */
#define RF9_WYRM_PROTECT        0x00000400      /* The monster is protected by great wyrms of power: They'll be summoned if it's killed */
#define RF9_DOPPLEGANGER        0x00000800      /* The monster looks like you */
#define RF9_ONLY_DEPTH          0x00001000      /* The monster can only be generated at the GIVEN depth */
#define RF9_SPECIAL_GENE        0x00002000      /* The monster can only be generated in special conditions like quests, special dungeons, ... */
#define RF9_NEVER_GENE          0x00004000      /* The monster cannot be normaly generated */


/*
 * Hack -- choose "intelligent" spells when desperate
 */

#define RF4_INT_MASK \
   (RF4_S_ANIMAL)

#define RF5_INT_MASK \
  (RF5_HOLD | RF5_SLOW | RF5_CONF | RF5_BLIND | RF5_SCARE)

#define RF6_INT_MASK \
   (RF6_BLINK |  RF6_TPORT | RF6_TELE_LEVEL | RF6_TELE_AWAY | \
    RF6_HEAL | RF6_HASTE | RF6_TRAPS | \
    RF6_S_KIN | RF6_S_HI_DEMON | RF6_S_MONSTER | RF6_S_MONSTERS | \
    RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA | \
    RF6_S_ANGEL | RF6_S_DRAGON | RF6_S_UNDEAD | RF6_S_DEMON | \
    RF6_S_HI_DRAGON | RF6_S_HI_UNDEAD | RF6_S_WRAITH | RF6_S_UNIQUE | \
    RF6_S_THUNDERLORD | RF6_S_BUG | RF6_S_RNG | RF6_S_ANIMALS)


/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 */
#define RF4_BOLT_MASK \
  (RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4)

#define RF5_BOLT_MASK \
   (RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | \
    RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
    RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_BOLT_MASK \
   0L


/* Hack -- summon spells */

#define RF4_SUMMON_MASK \
    (RF4_S_ANIMAL)

#define RF5_SUMMON_MASK \
    0L

#define RF6_SUMMON_MASK \
    (RF6_S_KIN | RF6_S_HI_DEMON | RF6_S_MONSTER | RF6_S_MONSTERS | RF6_S_ANT | \
     RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA | RF6_S_ANGEL | RF6_S_DEMON | \
     RF6_S_UNDEAD | RF6_S_DRAGON | RF6_S_HI_UNDEAD | RF6_S_HI_DRAGON | \
     RF6_S_WRAITH | RF6_S_UNIQUE | RF6_S_THUNDERLORD | RF6_S_BUG | RF6_S_RNG | \
     RF6_S_ANIMALS)


/*** Macro Definitions ***/


/*
 * Hack -- The main "screen"
 */
#define term_screen     (angband_term[0])


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
    (k_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
    (k_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
    (((T)->ident & (IDENT_KNOWN)) || \
     (k_info[(T)->k_idx].easy_know && k_info[(T)->k_idx].aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	(((T)->tval == TV_RANDART) ? \
		random_artifacts[(T)->sval].attr : \
		(k_info[(T)->k_idx].flavor) ? \
			misc_to_attr[k_info[(T)->k_idx].flavor] : \
			k_info[(T)->k_idx].x_attr)

#define object_attr_default(T) \
	(((T)->tval == TV_RANDART) ? \
		random_artifacts[(T)->sval].attr : \
		(k_info[(T)->k_idx].flavor) ? \
			misc_to_attr[k_info[(T)->k_idx].flavor] : \
			k_info[(T)->k_idx].d_attr)

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((k_info[(T)->k_idx].flavor) ? \
		misc_to_char[k_info[(T)->k_idx].flavor] : \
		k_info[(T)->k_idx].x_char)

#define object_char_default(T) \
	((k_info[(T)->k_idx].flavor) ? \
		misc_to_char[k_info[(T)->k_idx].flavor] : \
		k_info[(T)->k_idx].d_char)



/*
 * Artifacts use the "name1" field
 */
#define artifact_p(T) \
	(                                                               \
	((T)->tval == TV_RANDART ||                                     \
	((T)->name1 ? TRUE : FALSE) ||                                  \
	((T)->art_name ? TRUE : FALSE) ||                               \
	((k_info[(T)->k_idx].flags3 & TR3_NORM_ART)? TRUE : FALSE))     \
	)

/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 || (T)->name2b ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define is_ego_p(T, e) \
	(((T)->name2 == (e)) || ((T)->name2b == (e)))



/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->ident & (IDENT_CURSED))


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


/*
 * Determines if a map location is fully inside the outer walls
 */
#define in_bounds(Y,X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < cur_hgt-1) && ((X) < cur_wid-1))

/*
 * Determines if a map location is on or inside the outer walls
 */
#define in_bounds2(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < cur_hgt) && ((X) < cur_wid))


/*
 * Determines if a map location is currently "on screen" -RAK-
 * Note that "panel_contains(Y,X)" always implies "in_bounds2(Y,X)".
 */
#define panel_contains(Y,X) \
  (((Y) >= panel_row_min) && ((Y) <= panel_row_max) && \
   ((X) >= panel_col_min) && ((X) <= panel_col_max))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an extremely fast single bit check below.
 *
 * Add in the fact that some new terrain (water & lava) do NOT block sight
 * -KMW-
 */
#define cave_floor_bold(Y,X) \
	((f_info[cave[Y][X].feat].flags1 & FF1_FLOOR) && \
	 (cave[Y][X].feat != FEAT_MON_TRAP))


/*
 * Determine if a "legal" grid is floor without the REMEMBER flag set
 * Sometimes called "boring" grid
 */
#define cave_plain_floor_bold(Y,X) \
	((f_info[cave[Y][X].feat].flags1 & FF1_FLOOR) && \
	 !(f_info[cave[Y][X].feat].flags1 & FF1_REMEMBER))


/*
 * Determine if a "legal" grid isn't a "blocking line of sight" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an extremely fast single bit check below.
 *
 * Add in the fact that some new terrain (water & lava) do NOT block sight
 * -KMW-
 */
#define cave_sight_bold(Y,X) \
	(!(f_info[cave[Y][X].feat].flags1 & FF1_NO_VISION))


/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid deep water -KMW-
 * Line 3 -- forbid deep lava -KMW-
 * Line 4 -- forbid normal objects
 */
#define cave_clean_bold(Y,X) \
	((f_info[cave[Y][X].feat].flags1 & FF1_FLOOR) && \
	 (cave[Y][X].feat != FEAT_MON_TRAP) && \
	 (cave[Y][X].o_idx == 0) && \
	 !(f_info[cave[Y][X].feat].flags1 & FF1_PERMANENT))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define cave_empty_bold(Y,X) \
    (cave_floor_bold(Y,X) && \
     !(cave[Y][X].m_idx) && \
     !(((Y) == p_ptr->py) && ((X) == p_ptr->px)))


/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors, non-shallow water & lava -KMW-
 * Line 2 -- forbid normal objects
 * Line 3 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	((f_info[cave[Y][X].feat].flags1 & FF1_FLOOR) && \
	 (cave[Y][X].feat != FEAT_MON_TRAP) && \
	 !(f_info[cave[Y][X].feat].flags1 & FF1_PERMANENT) && \
	  (cave[Y][X].o_idx == 0) && \
	  (cave[Y][X].m_idx == 0))

#define cave_naked_bold2(Y,X) \
	((f_info[cave[Y][X].feat].flags1 & FF1_FLOOR) && \
	 (cave[Y][X].feat != FEAT_MON_TRAP) && \
	  (cave[Y][X].o_idx == 0) && \
	  (cave[Y][X].m_idx == 0))



/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1   -- perma-walls
 * Line 2-3 -- stairs
 * Line 4-5 -- building doors -KMW-
 * Line 6-7 -- shop doors
 */
#define cave_perma_bold(Y,X) \
       (f_info[cave[Y][X].feat].flags1 & FF1_PERMANENT)


/*
 * Grid based version of "cave_floor_bold()"
 */
#define cave_floor_grid(C) \
    ((f_info[(C)->feat].flags1 & FF1_FLOOR) && ((C)->feat != FEAT_MON_TRAP))


/*
 * Grid based version of "cave_plain_floor_bold()"
 */
#define cave_plain_floor_grid(C) \
	((f_info[(C)->feat].flags1 & FF1_FLOOR) && \
	 !(f_info[(C)->feat].flags1 & FF1_REMEMBER))


/*
 * Grid based version of "cave_clean_bold()"
 */
#define cave_clean_grid(C) \
    ((f_info[(C)->feat].flags1 & FF1_FLOOR) && ((C)->feat != FEAT_MON_TRAP) && \
     (!(C)->o_idx))

/*
 * Grid based version of "cave_sight_bold()"
 */
#define cave_sight_grid(C) \
	(!(f_info[(C)->feat].flags1 & FF1_NO_VISION))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid(C) \
    (cave_floor_grid(C) && \
     !((C)->m_idx) && \
     !((C) == &cave[p_ptr->py][p_ptr->px]))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_naked_grid(C) \
    ((f_info[(C)->feat].flags1 & FF1_FLOOR) && ((C)->feat != FEAT_MON_TRAP) && \
     !((C)->o_idx) && \
     !((C)->m_idx) && \
     !((C) == &cave[p_ptr->py][p_ptr->px]))


/*
 * Grid based version of "cave_perma_bold()"
 */
#define cave_perma_grid(C) \
       (f_info[(C)->feat].flags1 & FF1_PERMANENT)



/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
    ((cave[Y][X].info & (CAVE_VIEW)) != 0)



/*
 * Determine if a "legal" grid can be "seen" by the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_can_see_bold(Y,X) \
	((cave[Y][X].info & (CAVE_SEEN)) != 0)



/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif



/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK                0  /* 'd' */   /* 0,0,0 */
#define TERM_WHITE               1  /* 'w' */   /* 4,4,4 */
#define TERM_SLATE               2  /* 's' */   /* 2,2,2 */
#define TERM_ORANGE              3  /* 'o' */   /* 4,2,0 */
#define TERM_RED                 4  /* 'r' */   /* 3,0,0 */
#define TERM_GREEN               5  /* 'g' */   /* 0,2,1 */
#define TERM_BLUE                6  /* 'b' */   /* 0,0,4 */
#define TERM_UMBER               7  /* 'u' */   /* 2,1,0 */
#define TERM_L_DARK              8  /* 'D' */   /* 1,1,1 */
#define TERM_L_WHITE             9  /* 'W' */   /* 3,3,3 */
#define TERM_VIOLET             10  /* 'v' */   /* 4,0,4 */
#define TERM_YELLOW             11  /* 'y' */   /* 4,4,0 */
#define TERM_L_RED              12  /* 'R' */   /* 4,0,0 */
#define TERM_L_GREEN            13  /* 'G' */   /* 0,4,0 */
#define TERM_L_BLUE             14  /* 'B' */   /* 0,4,4 */
#define TERM_L_UMBER            15  /* 'U' */   /* 3,2,1 */


/*** Graphics constants ***/

/*
 * Possible values of graphics_mode
 * Good only when use_graphics is set to TRUE
 * Set by reset_visuals() and used by map_info()
 */
#define GRAPHICS_NONE    0
#define GRAPHICS_UNKNOWN 1
#define GRAPHICS_IBM     2
#define GRAPHICS_OLD     3
#define GRAPHICS_NEW     4
#define GRAPHICS_ISO     5


/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT        1
#define SOUND_MISS       2
#define SOUND_FLEE       3
#define SOUND_DROP       4
#define SOUND_KILL       5
#define SOUND_LEVEL      6
#define SOUND_DEATH      7
#define SOUND_STUDY      8
#define SOUND_TELEPORT   9
#define SOUND_SHOOT     10
#define SOUND_QUAFF     11
#define SOUND_ZAP       12
#define SOUND_WALK      13
#define SOUND_TPOTHER   14
#define SOUND_HITWALL   15
#define SOUND_EAT       16
#define SOUND_STORE1    17
#define SOUND_STORE2    18
#define SOUND_STORE3    19
#define SOUND_STORE4    20
#define SOUND_DIG       21
#define SOUND_OPENDOOR  22
#define SOUND_SHUTDOOR  23
#define SOUND_TPLEVEL   24
#define SOUND_SCROLL	25
#define SOUND_BUY	    26
#define SOUND_SELL	    27
#define SOUND_WARN	    28
#define SOUND_ROCKET    29 /* Somebody's shooting rockets */
#define SOUND_N_KILL    30 /* The player kills a non-living/undead monster */
#define SOUND_U_KILL    31 /* The player kills a unique */
#define SOUND_QUEST     32 /* The player has just completed a quest */
#define SOUND_HEAL      33 /* The player was healed a little bit */
#define SOUND_X_HEAL    34 /* The player was healed full health */
#define SOUND_BITE      35 /* A monster bites you */
#define SOUND_CLAW      36 /* A monster claws you */
#define SOUND_M_SPELL   37 /* A monster casts a miscellaneous spell */
#define SOUND_SUMMON    38 /* A monster casts a summoning spell  */
#define SOUND_BREATH    39 /* A monster breathes */
#define SOUND_BALL      40 /* A monster casts a ball / bolt spell */
#define SOUND_M_HEAL    41 /* A monster heals itself somehow */
#define SOUND_ATK_SPELL 42 /* A monster casts a misc. offensive spell */
#define SOUND_EVIL      43 /* Something nasty has just happened! */
#define SOUND_TOUCH     44 /* A monster touches you */
#define SOUND_STING     45 /* A monster stings you */
#define SOUND_CRUSH     46 /* A monster crushes / envelopes you */
#define SOUND_SLIME     47 /* A monster drools/spits/etc on you */
#define SOUND_WAIL      48 /* A monster wails */
#define SOUND_WINNER    49 /* Just won the game! */
#define SOUND_FIRE      50 /* An item was burned  */
#define SOUND_ACID      51 /* An item was destroyed by acid */
#define SOUND_ELEC      52 /* An item was destroyed by electricity */
#define SOUND_COLD      53 /* An item was shattered */
#define SOUND_ILLEGAL   54 /* Illegal command attempted */
#define SOUND_FAIL      55 /* Fail to get a spell off / activate an item */
#define SOUND_WAKEUP    56 /* A monster wakes up */
#define SOUND_INVULN    57 /* Invulnerability! */
#define SOUND_FALL      58 /* Falling through a trapdoor... */
#define SOUND_PAIN      59 /* A monster is in pain! */
#define SOUND_DESTITEM  60 /* An item was destroyed by misc. means */
#define SOUND_MOAN      61 /* A monster makes a moan/beg/insult attack */
#define SOUND_SHOW      62 /* A monster makes a "show" attack */
#define SOUND_UNUSED    63 /* (no sound for gaze attacks) */
#define SOUND_EXPLODE   64 /* Something (or somebody) explodes */

/*
 * Mega-Hack -- maximum known sounds
 */
#define SOUND_MAX 65



/*** Hack ***/


/*
 * Hack -- attempt to reduce various values
 */
#ifdef ANGBAND_LITE
# undef MACRO_MAX
# define MACRO_MAX      128
# undef QUARK_MAX
# define QUARK_MAX      128
# undef MESSAGE_MAX
# define MESSAGE_MAX    128
# undef MESSAGE_BUF
# define MESSAGE_BUF    4096
#endif

/*
 * Road flags
 */
#define ROAD_NORTH	1
#define ROAD_SOUTH	2
#define ROAD_EAST	4
#define ROAD_WEST	8


/*
 * Buildings actions
 */
#define BACT_RESEARCH_ITEM           1
#define BACT_TOWN_HISTORY            2
#define BACT_RACE_LEGENDS            3
#define BACT_GREET_KING              4
#define BACT_KING_LEGENDS            5
#define BACT_QUEST1                  6
#define BACT_GOLD                    7
#define BACT_POSTER                  8
#define BACT_ARENA_RULES             9
#define BACT_ARENA                  10
#define BACT_ARENA_LEGENDS          11
#define BACT_IN_BETWEEN             12
#define BACT_GAMBLE_RULES           13
#define BACT_CRAPS                  14
#define BACT_SPIN_WHEEL             15
#define BACT_DICE_SLOTS             16
#define BACT_REST                   17
#define BACT_FOOD                   18
#define BACT_RUMORS                 19
#define BACT_RESEARCH_MONSTER       20
#define BACT_COMPARE_WEAPONS        21
#define BACT_LEGENDS                22
#define BACT_ENCHANT_WEAPON         23
#define BACT_ENCHANT_ARMOR          24
#define BACT_RECHARGE               25
#define BACT_IDENTS                 26
#define BACT_LEARN                  27
#define BACT_HEALING                28
#define BACT_RESTORE                29
#define BACT_ENCHANT_ARROWS         30
#define BACT_ENCHANT_BOW            31
#define BACT_GREET                  32
#define BACT_RECALL                 33
#define BACT_TELEPORT_LEVEL         34
/* XXX */
/* XXX */
#define BACT_MIMIC_NORMAL           37
#define BACT_VIEW_BOUNTIES          38
#define BACT_SELL_CORPSES           39
#define BACT_VIEW_QUEST_MON         40
#define BACT_SELL_QUEST_MON         41
#define BACT_DIVINATION             42
#define BACT_SELL                   43
#define BACT_BUY                    44
#define BACT_EXAMINE                45
#define BACT_STEAL                  46
#define BACT_QUEST2                 47
#define BACT_QUEST3                 48
#define BACT_QUEST4                 49
#define BACT_STAR_HEAL              50
#define BACT_REQUEST_ITEM           51
#define BACT_GET_LOAN               52
#define BACT_PAY_BACK_LOAN          53
// If one adds new BACT_ do NOT forget to increase max_bact in variables.c


/*
 * Quest status
 */
#define QUEST_STATUS_IGNORED         -1
#define QUEST_STATUS_UNTAKEN         0
#define QUEST_STATUS_TAKEN           1
#define QUEST_STATUS_COMPLETED       2
#define QUEST_STATUS_REWARDED        3
#define QUEST_STATUS_FAILED          4
#define QUEST_STATUS_FINISHED        5
#define QUEST_STATUS_FAILED_DONE     6

/*
 * Quest flags
 */
#define QUEST_FLAG_SILENT  0x01 /* no messages for completion */
#define QUEST_FLAG_PRESET  0x02 /* quest is outside the main dungeon */
#define QUEST_FLAG_ONCE    0x04 /* quest is marked finished after leaving */

/*
 * Initialization flags
 */
#define INIT_SHOW_TEXT        0x01
#define INIT_ASSIGN           0x02
#define INIT_CREATE_DUNGEON   0x04
#define INIT_GET_SIZE         0x08
#define INIT_POSITION         0x10

/*
 * Alchemists defines
 */
#define MAX_ALCHEMIST_RECIPES 20
#define ALCHEMIST_ENCHANT_DAM      0x01
#define ALCHEMIST_ENCHANT_PVAL     0x02
#define ALCHEMIST_ENCHANT_AC       0x04

/*
 * Music songs
 */
#define MUSIC_NONE              0
#define MUSIC_SLOW              1
#define MUSIC_CONF              2
#define MUSIC_STUN              3
#define MUSIC_LIFE              4
#define MUSIC_MIND              5
#define MUSIC_LITE              6
#define MUSIC_FURY              7
#define MUSIC_AWARE             8
#define MUSIC_ID                9
#define MUSIC_ILLUSION          10
#define MUSIC_WALL              11
#define MUSIC_RESIST            12
#define MUSIC_TIME              13
#define MUSIC_BETWEEN           14
#define MUSIC_CHARME            15
#define MUSIC_VIBRA             16
#define MUSIC_HOLY              17
#define MUSIC_HIDE              18
#define MUSIC_LIBERTY           19
#define MUSIC_RAISE             20
#define MUSIC_SHADOW            21
#define MUSIC_STAR_ID           22

#define MAX_MUSIC               23
#define MAX_MUSICS              11

/*
 * Fate
 */
#define MAX_FATES               200

#define FATE_NONE               0
#define FATE_FIND_O             1
#define FATE_NO_DIE_MORTAL      2
#define FATE_FIND_A             3
#define FATE_FIND_R             4
#define FATE_FIND_V             5
#define FATE_DIE                6

/*
 * Runes definition
 */
#define RUNE_SELF               0x00000001
#define RUNE_ARROW              0x00000002
#define RUNE_RAY                0x00000004
#define RUNE_SPHERE             0x00000008
#define RUNE_POWER_SURGE        0x00000010
#define RUNE_ARMAGEDDON         0x00000020
#define RUNE_MOD_MAX            6
#define RUNE_STONE              0x000000FF


/*
 * Defines of the different dungeon types
 */
#define DUNGEON_WILDERNESS      0
#define DUNGEON_MIRKWOOD        1
#define DUNGEON_MORDOR          2
#define DUNGEON_ANGBAND         3
#define DUNGEON_BARROW_DOWNS    4
#define DUNGEON_MOUNT_DOOM      5
#define DUNGEON_NETHER_REALM    6
#define DUNGEON_NUMENOR         7
#define DUNGEON_MANDOS          8
#define DUNGEON_VOID            11
#define DUNGEON_MAZE            18
#define DUNGEON_DOL_GULDUR      23

/* Max depth of each dungeon(max_depth - min_depth) */
#define MAX_DUNGEON_DEPTH       128

#define DUNGEON_MODE_NONE       0
#define DUNGEON_MODE_AND        1
#define DUNGEON_MODE_NAND       2
#define DUNGEON_MODE_OR         3
#define DUNGEON_MODE_NOR        4


/*
 * Returns the dungeon level or the feat,
 * if the player is not in a dungeon
 */
#define level_or_feat(DTYPE, DLEVEL) \
	((DTYPE) == DUNGEON_WILDERNESS ? \
		wild_map[p_ptr->wilderness_y][p_ptr->wilderness_x].feat : \
		(DLEVEL) )


/*
 * Defines for the inscriptions
 */
#define INSCRIP_EXEC_ENGRAVE    0x01
#define INSCRIP_EXEC_WALK       0x02
#define INSCRIP_EXEC_MONST_WALK 0x04

#define INSCRIP_NONE            0
#define INSCRIP_LIGHT           1
#define INSCRIP_DARK            2
#define INSCRIP_STORM           3
#define INSCRIP_PROTECTION      4
#define INSCRIP_DWARF_SUMMON    5
#define INSCRIP_CHASM           6
#define INSCRIP_BLACK_FIRE      7
#define MAX_INSCRIPTIONS        8

/*
 * Various class dependant defines
 */
#define CLASS_NONE              0
#define CLASS_MANA_PATH         1
#define CLASS_CANALIZE_MANA     2
#define CLASS_WINDS_MANA        3

#define CLASS_MANA_PATH_ERASE           0x0001
#define CLASS_FLOOD_LEVEL               0x0002
#define CLASS_CANALIZE_MANA_EXTRA       0x0004
#define CLASS_UNDEAD                    0x0008
#define CLASS_ANTIMAGIC                 0x0010
#define CLASS_LEGS                      0x0020
#define CLASS_ARMS                      0x0040
#define CLASS_WALL                      0x0080

/*
 * Types of birth presents
 */
#define BIRTH_NONE      0
#define BIRTH_RING      1
#define BIRTH_AMULET    2

/*
 * Automatic note taking types
 */
#define NOTE_BIRTH		1
#define NOTE_WINNER		2
#define NOTE_SAVE_GAME		3
#define NOTE_ENTER_DUNGEON	4

/*
 * Player monsters & ghost defines
 * NO MORE USED but for savefile compatibility
 */
#define GHOST_R_IDX_HEAD        967
#define GHOST_R_IDX_TAIL        977
#define MAX_GHOSTS              (GHOST_R_IDX_TAIL - GHOST_R_IDX_HEAD)

/* Stores/buildings defines */
#define STORE_HATED     0
#define STORE_LIKED     1
#define STORE_NORMAL    2

/* Pseudo-id defines */
#define SENSE_NONE                      0
#define SENSE_CURSED			1
#define SENSE_AVERAGE			2
#define SENSE_GOOD_LIGHT		3
#define SENSE_GOOD_HEAVY		4
#define SENSE_EXCELLENT			5
#define SENSE_WORTHLESS			6
#define SENSE_TERRIBLE			7
#define SENSE_SPECIAL			8
#define SENSE_BROKEN			9
#define SENSE_UNCURSED			10

/* Wilderness map related */
#define WILDERNESS_SEE_RADIUS   3       /* The amount of wilderness seen around the player */

/* Ego monsters defines */
#define MEGO_CHAR_ANY           127
#define MEGO_ADD                0
#define MEGO_SUB                1
#define MEGO_FIX                2
#define MEGO_PRC                3

#define MEGO_CHANCE             18      /* % chances of getting ego monsters */

#define race_inf(m_ptr) (((m_ptr)->sr_ptr) ? (m_ptr)->sr_ptr : race_info_idx((m_ptr)->r_idx, (m_ptr)->ego))

/* Object generation */
#define OBJ_GENE_TREASURE       20
#define OBJ_GENE_COMBAT         20
#define OBJ_GENE_MAGIC          20
#define OBJ_GENE_TOOL           20

/*
 * Used (or should be) by various functions and tables needing access to
 * single bits
 */
#define BIT(x) (1L << (x))

/* Town defines */
#define TOWN_RANDOM     20              /* First random town */
#define TOWN_DUNGEON    4               /* Maximun number of towns per dungeon */
#define TOWN_CHANCE     50              /* Chance of 1 town */


/*
 * Store flags
 */
#define SF1_DEPEND_LEVEL        0x00000001L
#define SF1_SHALLOW_LEVEL       0x00000002L
#define SF1_MEDIUM_LEVEL        0x00000004L
#define SF1_DEEP_LEVEL          0x00000008L
#define SF1_RARE                0x00000010L
#define SF1_VERY_RARE           0x00000020L
#define SF1_COMMON              0x00000040L
#define SF1_ALL_ITEM            0x00000080L     /* Works as the BM */
#define SF1_RANDOM              0x00000100L
#define SF1_FORCE_LEVEL         0x00000200L
#define SF1_MUSEUM              0x00000400L

/*
 * Powers (mutation, activations, ...)
 */
#define POWER_MAX_INIT                 62

#define PWR_SPIT_ACID                  0
#define PWR_BR_FIRE                    1
#define PWR_HYPN_GAZE                  2
#define PWR_TELEKINES                  3
#define PWR_VTELEPORT                  4
#define PWR_MIND_BLST                  5
#define PWR_RADIATION                  6
#define PWR_VAMPIRISM                  7
#define PWR_SMELL_MET                  8
#define PWR_SMELL_MON                  9
#define PWR_BLINK                      10
#define PWR_EAT_ROCK                   11
#define PWR_SWAP_POS                   12
#define PWR_SHRIEK                     13
#define PWR_ILLUMINE                   14
#define PWR_DET_CURSE                  15
#define PWR_BERSERK                    16
#define PWR_POLYMORPH                  17
#define PWR_MIDAS_TCH                  18
#define PWR_GROW_MOLD                  19
#define PWR_RESIST                     20
#define PWR_EARTHQUAKE                 21
#define PWR_EAT_MAGIC                  22
#define PWR_WEIGH_MAG                  23
#define PWR_STERILITY                  24
#define PWR_PANIC_HIT                  25
#define PWR_DAZZLE                     26
#define PWR_DARKRAY                    27
#define PWR_RECALL                     28
#define PWR_BANISH                     29
#define PWR_COLD_TOUCH                 30
#define PWR_LAUNCHER                   31

#define PWR_PASSWALL                    32
#define PWR_DETECT_TD                   33
#define PWR_COOK_FOOD                   34
#define PWR_UNFEAR                      35
#define PWR_EXPL_RUNE                   36
#define PWR_STM                         37
#define PWR_POIS_DART                   38
#define PWR_MAGIC_MISSILE               39
#define PWR_GROW_TREE                   40
#define PWR_BR_COLD                     41
#define PWR_BR_CHAOS                    42
#define PWR_BR_ELEM                     43
#define PWR_WRECK_WORLD                 44
#define PWR_SCARE                       45
#define PWR_REST_LIFE                   46
#define PWR_SUMMON_MONSTER              47
#define PWR_NECRO                       48
#define PWR_ROHAN                       49
#define PWR_THUNDER                     50
#define PWR_DEATHMOLD                   51
#define PWR_HYPNO                       52
#define PWR_UNHYPNO                     53
#define PWR_INCARNATE                   54
#define PWR_MAGIC_MAP                   55
#define PWR_LAY_TRAP                    56
#define PWR_MERCHANT                    57
#define PWR_COMPANION                   58
#define PWR_BEAR                        59
#define PWR_DODGE                       60
#define PWR_BALROG                      61

#define ADD_POWER(pow, p)       ((pow)[(p)] = TRUE)

/*
 * Shield effect options
 */
#define SHIELD_NONE             0x0000
#define SHIELD_COUNTER          0x0001
#define SHIELD_FIRE             0x0002
#define SHIELD_GREAT_FIRE       0x0004
#define SHIELD_FEAR             0x0008

/*
 * Quest constants
 */
#define MAX_MON_QUEST       10
#define MAX_ITEM_QUEST       5

#define MAX_RANDOM_QUEST    99

#define QUEST_NULL              0
#define QUEST_NECRO             1
#define QUEST_SAURON            2
#define QUEST_MORGOTH           3
#define QUEST_THIEVES           4
#define QUEST_RANDOM            5
#define QUEST_HOBBIT            6
#define QUEST_NAZGUL            7
#define QUEST_TROLL             8
#define QUEST_WIGHT             9
#define QUEST_SPIDER            10
#define QUEST_POISON            11
#define QUEST_NARSIL            12
#define QUEST_EOL               13
#define QUEST_NIRNAETH          14
#define QUEST_INVASION          15
#define QUEST_BETWEEN           16
#define QUEST_ONE               17
#define QUEST_SHROOM            18
#define QUEST_THRAIN            19
#define QUEST_ULTRA_GOOD        20
#define QUEST_ULTRA_EVIL        21
#define QUEST_WOLVES            22
#define QUEST_DRAGONS           23
#define QUEST_HAUNTED           24
#define QUEST_EVIL              25
#define MAX_Q_IDX_INIT          26

#define PLOT_MAIN               0
#define PLOT_BREE               1
#define PLOT_LORIEN             2
#define PLOT_OTHER              3
#define PLOT_GONDOLIN           4
#define PLOT_MINAS              5
#define PLOT_KHAZAD             6
#define MAX_PLOTS               7

/*
 * Hooks
 */
#define HOOK_MONSTER_DEATH      0
#define HOOK_OPEN               1
#define HOOK_GEN_QUEST          2
#define HOOK_END_TURN           3
#define HOOK_FEELING            4
#define HOOK_NEW_MONSTER        5
#define HOOK_GEN_LEVEL          6
#define HOOK_BUILD_ROOM1        7
#define HOOK_NEW_LEVEL          8
#define HOOK_QUEST_FINISH       9
#define HOOK_QUEST_FAIL         10
#define HOOK_GIVE               11
#define HOOK_CHAR_DUMP          12
#define HOOK_INIT_QUEST         13
#define HOOK_WILD_GEN           14
#define HOOK_DROP               15
#define HOOK_IDENTIFY           16
#define HOOK_MOVE               17
#define HOOK_STAIR              18
#define HOOK_MONSTER_AI         19
#define HOOK_PLAYER_LEVEL       20
#define HOOK_WIELD              21
#define HOOK_INIT               22
#define HOOK_QUAFF              23
#define HOOK_AIM                24
#define HOOK_USE                25
#define HOOK_ACTIVATE           26
#define HOOK_ZAP                27
#define HOOK_READ               28
#define HOOK_CALC_BONUS         29
#define HOOK_CALC_POWERS        30
#define HOOK_KEYPRESS           31
#define HOOK_CHAT               32
#define HOOK_MON_SPEAK          33
#define HOOK_MKEY               34
#define HOOK_BIRTH_OBJECTS      35
#define HOOK_ACTIVATE_DESC      36
#define HOOK_INIT_GAME          37
#define HOOK_ACTIVATE_POWER     38
#define HOOK_ITEM_NAME          39
#define HOOK_SAVE_GAME          40
#define HOOK_LOAD_GAME          41
#define HOOK_LEVEL_REGEN        42
#define HOOK_LEVEL_END_GEN      43
#define HOOK_BUILDING_ACTION    44
#define HOOK_PROCESS_WORLD      45
#define HOOK_WIELD_SLOT         46
#define HOOK_STORE_STOCK        47
#define HOOK_STORE_BUY          48
#define HOOK_GEN_LEVEL_BEGIN    49
#define HOOK_GET                50
#define HOOK_REDRAW             51
#define HOOK_RECALC_SKILLS      52
#define HOOK_ENTER_DUNGEON      53
#define HOOK_FIRE               54
#define HOOK_EAT                55
#define HOOK_DIE                56
#define HOOK_CALC_HP            57
#define HOOK_GF_COLOR           58
#define HOOK_GF_EXEC            59
#define HOOK_CALC_MANA          60
#define HOOK_LOAD_END           61
#define HOOK_RECALL             62
#define HOOK_FOLLOW_GOD         63
#define HOOK_SACRIFICE_GOD      64
#define HOOK_BODY_PARTS         65
#define HOOK_APPLY_MAGIC        66
#define HOOK_PLAYER_EXP         67
#define HOOK_BIRTH              68
#define HOOK_CALC_LITE          69
#define HOOK_LEARN_ABILITY      70
#define HOOK_MOVED              71
#define HOOK_GAME_START         72
#define HOOK_TAKEOFF            73
#define HOOK_CALC_WEIGHT        74
#define HOOK_FORBID_TRAVEL      75
#define HOOK_DEBUG_COMMAND      76
#define HOOK_CALC_BONUS_END     77
#define MAX_HOOKS               78

#define HOOK_TYPE_C             0
#define HOOK_TYPE_LUA           1

/*
 * Defines for loadsave.c
 * Why 3 and 7? So if it's uninitialized, the code will be able to catch it, as
 * 0 is an invalid flag. Also, having them apart means that it being accidentally
 * modified will also result in an invalid value -- Improv
 */
#define LS_LOAD 3
#define LS_SAVE 7

/*
 * In game help
 */
#define HELP1_BETWEEN           0x00000001
#define HELP1_ALTAR             0x00000002
#define HELP1_FOUNTAIN          0x00000004
#define HELP1_IDENTIFY          0x00000008
#define HELP1_WILD_MODE         0x00000010

/*
 * Special weapon effects
 */
#define SPEC_POIS               0x00000001L
#define SPEC_CUT                0x00000002L

/*
 * Ambushes in the wild
 */
#define AMBUSH_RACE             1
#define AMBUSH_MIX              2

/*
 * Macro trigger
 */
#define MAX_MACRO_MOD 12
#define MAX_MACRO_TRIG 200


/*
 * Skills !
 */
#define SKILL_MAX               50000           /* Maximun skill value */
#define SKILL_STEP              1000            /* 1 skill point */

#define SKILL_EXCLUSIVE         9999            /* Flag to tell exclusive skills */

#define SKILL_CONVEYANCE        1
#define SKILL_MANA              2
#define SKILL_FIRE              3
#define SKILL_AIR               4
#define SKILL_WATER             5
#define SKILL_NATURE            6
#define SKILL_EARTH             7
#define SKILL_SYMBIOTIC         8
#define SKILL_MUSIC             9
#define SKILL_DIVINATION        10
#define SKILL_TEMPORAL          11
#define SKILL_DRUID             12
#define SKILL_DAEMON            13
#define SKILL_META              14
#define SKILL_MAGIC             15
#define SKILL_COMBAT            16
#define SKILL_MASTERY           17
#define SKILL_SWORD             18
#define SKILL_AXE               19
#define SKILL_POLEARM           20
#define SKILL_HAFTED            21
#define SKILL_BACKSTAB          22
#define SKILL_ARCHERY           23
#define SKILL_SLING             24
#define SKILL_BOW               25
#define SKILL_XBOW              26
#define SKILL_BOOMERANG         27
#define SKILL_SPIRITUALITY      28
#define SKILL_MINDCRAFT         29
#define SKILL_MISC              30
#define SKILL_NECROMANCY        31
#define SKILL_MIMICRY           32
#define SKILL_ANTIMAGIC         33
#define SKILL_RUNECRAFT         34
#define SKILL_SNEAK             35
#define SKILL_STEALTH           36
#define SKILL_DISARMING         37
/* XXX */
#define SKILL_ALCHEMY           39
#define SKILL_STEALING          40
#define SKILL_SORCERY           41
#define SKILL_HAND              42
#define SKILL_THAUMATURGY       43
#define SKILL_SUMMON            44
#define SKILL_SPELL             45
#define SKILL_DODGE             46
#define SKILL_BEAR              47
#define SKILL_LORE              48
#define SKILL_PRESERVATION      49
#define SKILL_POSSESSION        50
#define SKILL_MIND              51
#define SKILL_CRITS             52
#define SKILL_PRAY              53
#define SKILL_LEARN             54
#define SKILL_UDUN              55
#define SKILL_DEVICE            56
#define SKILL_STUN              57
#define SKILL_BOULDER           58
#define SKILL_GEOMANCY          59

/* Ugly but needed */
#define MAX_SKILLS              200

/* SKill flags */
#define SKF1_HIDDEN             0x00000001      /* Starts hidden */
#define SKF1_AUTO_HIDE          0x00000002      /* Tries to rehide at calc_bonus */
#define SKF1_RANDOM_GAIN        0x00000004      /* Can be randomly gained by certain quests & such */

#define MAX_MELEE               3

/*
 * Player specialities, should be external but ti would be a mess
 */
#define MAX_SPEC                20


/*
 * Spellbinder triggers
 */
#define SPELLBINDER_HP75        1
#define SPELLBINDER_HP50        2
#define SPELLBINDER_HP25        3

/*
 * God's defines
 */
#define GOD_ALL                 -1
#define GOD_NONE                0
#define GOD_ERU                 1
#define GOD_MANWE               2
#define GOD_TULKAS              3
#define GOD_MELKOR              4
#define GOD_YAVANNA             5
#define MAX_GODS_INIT           6

#define GOD(g)                  if (p_ptr->pgod == (g))
#define PRAY_GOD(g)             if ((p_ptr->pgod == (g)) && (p_ptr->praying))
#define NOT_PRAY_GOD(g)         if ((p_ptr->pgod == (g)) && (!p_ptr->praying))

/*
 * Command numbers for do_cmd_cli().
 *
 * As the user is not intended to have a way to enter these codes directly
 * (doing so isn't harmful, but these codes are not intended as mnemonics),
 * only codes in the range 0xE000 - 0xF8FF (the private area of Unicode 3.0)
 * should be used.
 *
 * In addition, values at the lower end of this range are preferred as the upper
 * end may have a system-specific encoding
 */
#define CMD_CLI_HELP	-8192
#define CMD_IRC_CONNECT	-8191
#define CMD_IRC_CHAT	-8190
#define CMD_IRC_DISCON	-8189
#define CMD_SHOW_TIME	-8188
#define CMD_SHOW_SKILL	-8187
#define CMD_DUMP_HTML	-8186
#define CMD_MACRO    	-8185
#define CMD_QUEST    	-8184
#define CMD_BLUNDER	-8183
#define CMD_SHOW_ABILITY -8182

#define CLI_MAX	128


/*
 * The various winner state
 */
#define WINNER_NORMAL           1
#define WINNER_ULTRA            2

/*
 * The abilities
 */
#define AB_SPREAD_BLOWS         0
#define AB_TREE_WALK            1
#define AB_PERFECT_CASTING      2
#define AB_MAX_BLOW1            3
#define AB_MAX_BLOW2            4
#define AB_AMMO_CREATION        5
#define AB_DEATH_TOUCH          6
#define AB_CREATE_ART           7
#define AB_FAR_REACHING         8
#define AB_TRAPPING             9
#define AB_UNDEAD_FORM          10
