-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- This package creates an instance of an array that expands.

generic
   type Item is private;
package Expanding_Array is

   type Big_Array is limited private;

   procedure Create (Left         : in out Big_Array;
                     Initial_Size : in     Positive);

   procedure Copy (Left  : in out Big_Array;
                   Right : in     Big_Array);

   procedure Set(A     : in out Big_Array;
                 Index : in     Positive;
                 Value : in     Item);

   function Value(A     : Big_Array;
                  Index : Positive) return Item;

   function First (A : Big_Array) return Natural;

   function Size (A : Big_Array) return Positive;

   function Last (A : Big_Array) return Positive;

   -- Increase the array by this much.
   procedure Expand(A : in out Big_Array;
                    S : in     Positive);
   -- If an attempt is made to use Set for an index beyond Last, then the
   -- array size will be doubled until it is large enough.  So this call
   -- should never need to be explicitly used.

private

   type Actual_Array is array (Positive range <>) of Item;
   type Actual_Array_Pointer is access Actual_Array;

   type Big_Array is record
      Actual     : Actual_Array_Pointer;
      Array_Size : Positive;
   end record;

end Expanding_Array;
