/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;

public class MethodInvocationExceptionTest
extends TestCase {
    public MethodInvocationExceptionTest() {
        super("MethodInvocationExceptionTest");
        try {
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup MethodInvocationExceptionTest : " + e);
            System.exit(1);
        }
    }

    public static Test suite() {
        return new MethodInvocationExceptionTest();
    }

    public void runTest() {
        String template = "$woogie.doException() boing!";
        VelocityContext vc = new VelocityContext();
        vc.put("woogie", (Object)this);
        StringWriter w = new StringWriter();
        try {
            Velocity.evaluate((Context)vc, (Writer)w, "test", template);
            Assert.fail((String)"No exception thrown");
        }
        catch (MethodInvocationException mie) {
            System.out.println("Caught MIE (good!) :");
            System.out.println("  reference = " + mie.getReferenceName());
            System.out.println("  method    = " + mie.getMethodName());
            Throwable t = mie.getWrappedThrowable();
            System.out.println("  throwable = " + t);
            if (t instanceof Exception) {
                System.out.println("  exception = " + ((Exception)t).getMessage());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception thrown");
        }
    }

    public void doException() throws Exception {
        throw new NullPointerException();
    }
}

