/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.texen.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.configuration.Configuration;
import org.apache.velocity.texen.Generator;
import org.apache.velocity.util.StringUtils;

public class TexenTask
extends Task {
    protected String controlTemplate;
    protected String templatePath;
    protected String outputDirectory;
    protected String outputFile;
    protected Configuration contextProperties;

    public void setControlTemplate(String controlTemplate) {
        this.controlTemplate = controlTemplate;
    }

    public String getControlTemplate() {
        return this.controlTemplate;
    }

    public void setTemplatePath(File templatePath) {
        try {
            this.templatePath = templatePath.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setOutputDirectory(File outputDirectory) {
        try {
            this.outputDirectory = outputDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setContextProperties(File file) {
        this.contextProperties = new Configuration();
        try {
            this.contextProperties.load(new FileInputStream(file));
        }
        catch (Exception e) {
            this.contextProperties = null;
        }
    }

    public Configuration getContextProperties() {
        return this.contextProperties;
    }

    public Context initControlContext() {
        return new VelocityContext();
    }

    public void execute() throws BuildException {
        if (this.templatePath == null) {
            throw new BuildException("The template path needs to be defined!");
        }
        if (this.controlTemplate == null) {
            throw new BuildException("The control template needs to be defined!");
        }
        if (this.outputDirectory == null) {
            throw new BuildException("The output directory needs to be defined!");
        }
        if (this.outputFile == null) {
            throw new BuildException("The output file needs to be defined!");
        }
        try {
            Velocity.setProperty("file.resource.loader.path", this.templatePath);
            Velocity.init();
            Generator generator = Generator.getInstance();
            generator.setOutputPath(this.outputDirectory);
            generator.setTemplatePath(this.templatePath);
            File file = new File(this.outputDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String path = this.outputDirectory + File.separator + this.outputFile;
            System.out.println(path);
            FileWriter writer = new FileWriter(path);
            Context c = this.initControlContext();
            this.populateInitialContext(c);
            if (this.contextProperties != null) {
                Iterator i = this.contextProperties.getKeys();
                while (i.hasNext()) {
                    String property = (String)i.next();
                    String value = this.contextProperties.getString(property);
                    try {
                        c.put(property, new Integer(value));
                    }
                    catch (NumberFormatException nfe) {
                        String booleanString = this.contextProperties.testBoolean(value);
                        if (booleanString != null) {
                            c.put(property, new Boolean(booleanString));
                            continue;
                        }
                        if (property.endsWith("file.contents")) {
                            value = StringUtils.fileContentsToString(this.project.resolveFile(value).getCanonicalPath());
                            property = property.substring(0, property.indexOf("file.contents") - 1);
                        }
                        c.put(property, value);
                    }
                }
            }
            writer.write(generator.parse(this.controlTemplate, c));
            writer.flush();
            writer.close();
            generator.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void populateInitialContext(Context context) {
        context.put("now", new Date().toString());
    }
}

