/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Filter;
import org.webmacro.Macro;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Directive;
import org.webmacro.engine.Variable;
import org.webmacro.util.HTMLEscaper;

public abstract class EscapeDirective
implements Directive {
    static final Filter _filter = new EscapeFilter();

    public static Object build(BuildContext buildContext, Object object) throws BuildException {
        Variable variable;
        try {
            variable = (Variable)object;
        }
        catch (ClassCastException classCastException) {
            throw new BuildException("Escape directive takes a variable as its argument");
        }
        buildContext.addFilter(variable, _filter);
        return null;
    }

    public abstract Object evaluate(Context var1) throws ContextException;

    public abstract void write(FastWriter var1, Context var2) throws ContextException, IOException;

    static class EscapeFilterMacro
    implements Macro {
        private final Macro _m;

        public EscapeFilterMacro(Macro macro) {
            this._m = macro;
        }

        public Object evaluate(Context context) throws ContextException {
            Object object = this._m.evaluate(context);
            return object != null ? HTMLEscaper.escape(object.toString()) : null;
        }

        public void write(FastWriter fastWriter, Context context) throws IOException, ContextException {
            fastWriter.write(this.evaluate(context).toString());
        }
    }

    static class EscapeFilter
    implements Filter {
        EscapeFilter() {
        }

        public Filter getFilter(String string) {
            return this;
        }

        public Macro getMacro(Macro macro) {
            return new EscapeFilterMacro(macro);
        }
    }
}

