/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.Vector;

public final class StringArray {
    public final String[] a;

    public StringArray(String[] stringArray) {
        this.a = stringArray;
        this.intern();
    }

    public StringArray(int n) {
        this.a = new String[n];
    }

    public StringArray(Vector vector) {
        this.a = new String[vector.size()];
        vector.copyInto(this.a);
        this.intern();
    }

    public final void intern() {
        int n = 0;
        while (n < this.a.length) {
            try {
                this.a[n] = this.a[n].intern();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n;
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.a.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"");
            stringBuffer.append(this.a[n]);
            stringBuffer.append("\"");
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StringArray)) {
            return false;
        }
        StringArray stringArray = (StringArray)object;
        if (this.a.length != stringArray.a.length) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n] != stringArray.a[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < this.a.length) {
            boolean bl2 = bl = !bl;
            n = bl ? (n += this.a[n2].hashCode() * (n2 + 1)) : (n -= this.a[n2].hashCode() * (n2 + 1));
            ++n2;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"hello", "there", "world"};
        Vector<String> vector = new Vector<String>();
        vector.addElement("hello");
        vector.addElement("there");
        vector.addElement("world");
        StringArray stringArray3 = new StringArray(stringArray);
        StringArray stringArray4 = new StringArray(stringArray2);
        StringArray stringArray5 = new StringArray(vector);
        if (stringArray5.equals(stringArray4)) {
            System.out.println("Vector and array compatible: OK");
        } else {
            System.out.println("Vector and array compatible: FAILED");
        }
        if (stringArray3.equals(stringArray4)) {
            System.out.println("args equal my array (hello,there,world)");
        } else {
            System.out.println("args NOT equal my array (hello,there,world)");
        }
        if (stringArray3.hashCode() == stringArray4.hashCode()) {
            System.out.println("Same hashcode:" + stringArray3.hashCode());
        } else {
            System.out.println("Different hashcode.");
        }
    }
}

