/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.xml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.xml.PI;
import org.apache.ecs.xml.XML;

public class XMLDocument
implements Serializable,
Cloneable {
    private static final float DEFAULT_XML_VERSION = 1.0f;
    private String versionDecl;
    private Vector prolog = new Vector(2);
    private XML content;
    private String codeset = null;

    public XMLDocument() {
        this(1.0, true);
    }

    public XMLDocument(double d) {
        this(d, true);
    }

    public XMLDocument(double d, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"");
        stringBuffer.append(d);
        stringBuffer.append("\" standalone=\"");
        if (bl) {
            stringBuffer.append("yes\"?>");
        } else {
            stringBuffer.append("no\"?>\n");
        }
        this.versionDecl = stringBuffer.toString();
    }

    public XMLDocument(double d, boolean bl, String string) {
        this(d, bl);
        this.setCodeset(string);
    }

    public XMLDocument addElement(XML xML) {
        if (this.content == null) {
            this.content = xML;
        } else {
            this.content.addElement(xML);
        }
        return this;
    }

    public XMLDocument addStylesheet(String string) {
        return this.addStylesheet(string, "text/xsl");
    }

    public XMLDocument addStylesheet(String string, String string2) {
        PI pI = new PI();
        pI.setTarget("xml-stylesheet").addInstruction("href", string).addInstruction("type", string2);
        this.prolog.addElement(pI);
        return this;
    }

    public XMLDocument addToProlog(ConcreteElement concreteElement) {
        this.prolog.addElement(concreteElement);
        return this;
    }

    public Object clone() {
        return this.content.clone();
    }

    public String getCodeset() {
        return this.codeset;
    }

    public void output(OutputStream outputStream) {
        try {
            outputStream.write(this.versionDecl.getBytes());
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < this.prolog.size()) {
            ConcreteElement concreteElement = (ConcreteElement)this.prolog.elementAt(n);
            concreteElement.output(outputStream);
            ++n;
        }
        if (this.content != null) {
            this.content.output(outputStream);
        }
    }

    public void output(PrintWriter printWriter) {
        printWriter.write(this.versionDecl);
        int n = 0;
        while (n < this.prolog.size()) {
            ConcreteElement concreteElement = (ConcreteElement)this.prolog.elementAt(n);
            concreteElement.output(printWriter);
            ++n;
        }
        if (this.content != null) {
            this.content.output(printWriter);
        }
    }

    public void setCodeset(String string) {
        this.codeset = string;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.codeset != null) {
            int n = 0;
            while (n < this.prolog.size()) {
                ConcreteElement concreteElement = (ConcreteElement)this.prolog.elementAt(n);
                stringBuffer.append(String.valueOf(concreteElement.toString(this.getCodeset())) + "\n");
                ++n;
            }
            if (this.content != null) {
                stringBuffer.append(this.content.toString(this.getCodeset()));
            }
        } else {
            int n = 0;
            while (n < this.prolog.size()) {
                ConcreteElement concreteElement = (ConcreteElement)this.prolog.elementAt(n);
                stringBuffer.append(String.valueOf(concreteElement.toString()) + "\n");
                ++n;
            }
            if (this.content != null) {
                stringBuffer.append(this.content.toString());
            }
        }
        return String.valueOf(this.versionDecl) + stringBuffer.toString();
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.prolog.size()) {
            ConcreteElement concreteElement = (ConcreteElement)this.prolog.elementAt(n);
            stringBuffer.append(String.valueOf(concreteElement.toString(this.getCodeset())) + "\n");
            ++n;
        }
        if (this.content != null) {
            stringBuffer.append(String.valueOf(this.content.toString(this.getCodeset())) + "\n");
        }
        return String.valueOf(this.versionDecl) + stringBuffer.toString();
    }
}

