/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import weblogic.ejb.utils.DDCreator;

public class DDCreatorHelper {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    String[] descriptors;

    private DDCreatorHelper(String[] args) {
        int index = 0;
        this.descriptorDirectory = new File(args[index++]);
        this.generatedFilesDirectory = new File(args[index++]);
        this.descriptors = new String[args.length - index];
        int i = 0;
        while (index < args.length) {
            this.descriptors[i] = args[index++];
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        DDCreatorHelper helper = new DDCreatorHelper(args);
        helper.process();
    }

    private void process() throws Exception {
        int i = 0;
        while (i < this.descriptors.length) {
            String descriptorName = this.descriptors[i];
            File descriptorFile = new File(this.descriptorDirectory, descriptorName);
            int extIndex = descriptorName.lastIndexOf(".");
            String serName = null;
            serName = extIndex != -1 ? String.valueOf(descriptorName.substring(0, extIndex)) + ".ser" : String.valueOf(descriptorName) + ".ser";
            File serFile = new File(this.generatedFilesDirectory, serName);
            if (!serFile.exists() || serFile.lastModified() < descriptorFile.lastModified()) {
                String[] args = new String[]{"-noexit", "-d", this.generatedFilesDirectory.getPath(), "-outputfile", serFile.getName(), descriptorFile.getPath()};
                try {
                    DDCreator.main((String[])args);
                }
                catch (Exception exception) {
                    String[] newArgs = new String[]{"-d", this.generatedFilesDirectory.getPath(), "-outputfile", serFile.getName(), descriptorFile.getPath()};
                    DDCreator.main((String[])newArgs);
                }
            }
            ++i;
        }
    }
}

