/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.PDFWriter;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ExportPDFAction extends Action {
	public static final String NAME = "action.file.export-pdf";

	private static final int PAGE_WIDTH = 550;
	
	private static final int PAGE_HEIGHT = 800;
	
	public ExportPDFAction(TablatureEditor tablatureEditor) {
		super(NAME,tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		final PrintDocumentData data = PrintDocumentData.openDialog(TuxGuitar.instance().getShell());
		if(data != null){		
			Shell parent = getEditor().getTablature().getShell();
			String selectedName = FileChooser.instance().save(parent,FileChooser.EXPORT_PDF_FORMAT);
			if (selectedName != null) {
				boolean canWrite = true;
				if (!isSuportedFormat(selectedName)) {
					selectedName += getDefaultExtension();
				}
				final String fileName = selectedName;

				File file = new File(fileName);
				if (file.exists()) {
					ConfirmDialog confirm = new ConfirmDialog(getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"));

					if (!confirm.confirm()) {
						canWrite = false;
					}
				}

				if (canWrite) {
					getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
					new SyncThread(new Runnable() {
						public void run() {
							if(!TuxGuitar.isDisposed()){
								try {																
									writeFile(new FileOutputStream(fileName),data);
									getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);								
								} catch (FileNotFoundException e) {
									e.printStackTrace();
								}	
							}
						}
					}).start();
				}
			}
		}
		return true;
	}	

	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(getDefaultExtension()));
	}

	private String getDefaultExtension() {
		return ".pdf";
	}
	
	private void writeFile(OutputStream out,PrintDocumentData data){
    	try{
    		PDFWriter.write(out,makePrintDocument(data));   	
    	}catch(OutOfMemoryError error){
    		showErrorMessage(error);
    		return;
    	}
	}
	
	public PrintDocument makePrintDocument(PrintDocumentData data){
		
		Tablature tablature = new Tablature(getEditor().getTablature(),SWT.NONE);
        tablature.setSongManager(getEditor().getSongManager());
        tablature.reloadStyles();
        
        PrinterViewLayout layout = new PrinterViewLayout(tablature,getEditor().getSongManager(),data);
        tablature.setViewLayout(layout);
        tablature.initDefaults();	
        tablature.updateTablature();	
        tablature.getCaret().update(getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        
        PrintDocument doc = layout.makeDocument(new Rectangle(0,0,PAGE_WIDTH,PAGE_HEIGHT));        
        tablature.dispose();        
		return doc;
	}

    private void showErrorMessage(final Error error){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){                              
                	String name = error.getClass().getName();
                	String message = error.getMessage();
                	new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }

}
