/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SaveAsFileAction extends Action {
	public static final String NAME = "action.file.save-as";

	public SaveAsFileAction(TablatureEditor tablatureEditor) {
		super(NAME,true, tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		Shell parent = getEditor().getTablature().getShell();
		String selectedName = FileChooser.instance().save(parent, FileChooser.SAVE_FORMAT);
		if (selectedName != null) {
			boolean canWrite = true;
			if (!isSuportedFormat(selectedName)) {
				selectedName += getDefaultExtension();
			}
			final String fileName = selectedName;

			File file = new File(fileName);
			if (file.exists()) {
				ConfirmDialog confirm = new ConfirmDialog(getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"));

				if (!confirm.confirm()) {
					canWrite = false;
				}
			}

			if (canWrite) {
				getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
				new SyncThread(new Runnable() {
					public void run() {
						if(!TuxGuitar.isDisposed()){
							getEditor().getSongManager().save(fileName);
							TuxGuitar.instance().getFileHistory().setFile(fileName);
							TuxGuitar.instance().updateCache(true);
							TuxGuitar.instance().showTitle();
							getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
						}
					}
				}).start();
			}
		}

		return true;
	}

	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(".tg") || fileName.endsWith(".gp3") || fileName.endsWith(".gp4"));
	}

	private String getDefaultExtension() {
		return ".gp4";
	}

}
