package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoard;

public class FretBoardEditor {
	private TablatureEditor tablatureEditor;
	private FretBoard fretBoard;
	private boolean visible;
	
	public FretBoardEditor(TablatureEditor tablatureEditor){
		this.tablatureEditor = tablatureEditor;
	}    
    
    private FretBoard getFretBoard(){
    	return this.fretBoard;
    }
	
	public void hideFretBoard(){
		this.visible = false;
		getFretBoard().setVisible(this.visible);	 
		TuxGuitar.instance().updateShellFooter(0,0,0);
	}		
	
	public void showFretBoard(){		
		this.visible = true;
		getFretBoard().setVisible(this.visible);
		TuxGuitar.instance().updateShellFooter(getFretBoard().getHeight(), 730,520);		
	}
			
    public void showFretBoard(Composite parent) {
    	FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0,0);
		data.bottom = new FormAttachment(100,0);
    	
    	this.fretBoard = new FretBoard(parent,this.tablatureEditor);		
    	this.fretBoard.setLayoutData(data);
    }	
	
	public void setScaleChanges(){
		if(isVisible()){
			getFretBoard().setChanges(true);
		}
	}
    
	public void dispose(){
		if(getFretBoard() != null && !getFretBoard().isDisposed()){
			getFretBoard().dispose();
		}
	}
	
	public void redraw(){
		if(getFretBoard() != null && !getFretBoard().isDisposed()){
			getFretBoard().redraw();
		}
	}
	
	public void redrawPlayingMode(){
		if(getFretBoard() != null && !getFretBoard().isDisposed()){
			getFretBoard().redrawPlayingMode();
		}
	}
	
	public boolean isVisible(){
		return (getFretBoard() != null && !getFretBoard().isDisposed() && this.visible);
	}
	
	public void loadProperties(){
		if(getFretBoard() != null && !getFretBoard().isDisposed()){
			getFretBoard().loadProperties();
		}
	}

}
