/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteCoords implements MeasureComponent {
	public static final int NATURAL = 0;
	public static final int SHARP = 1;
	public static final int FLAT = 2;
	
	public static final int KEY_SIGNATURES[][] = new int[][]{
		//------------NATURAL------------------------------------
		{NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL}, // NATURAL
		//------------SHARPS------------------------------------
		{NATURAL,NATURAL,NATURAL,SHARP,NATURAL,NATURAL,NATURAL}, // 1 SHARP
		{SHARP,NATURAL,NATURAL,SHARP,NATURAL,NATURAL,NATURAL}, // 2 SHARPS
		{SHARP,NATURAL,NATURAL,SHARP,SHARP,NATURAL,NATURAL}, // 3 SHARPS
		{SHARP,SHARP,NATURAL,SHARP,SHARP,NATURAL,NATURAL}, // 4 SHARPS
		{SHARP,SHARP,NATURAL,SHARP,SHARP,SHARP,NATURAL}, // 5 SHARPS
		{SHARP,SHARP,SHARP,SHARP,SHARP,SHARP,NATURAL}, // 6 SHARPS
		{SHARP,SHARP,SHARP,SHARP,SHARP,SHARP,SHARP}, // 7 SHARPS
		//------------FLATS------------------------------------		
		{NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,FLAT}, // 1 FLAT
		{NATURAL,NATURAL,FLAT,NATURAL,NATURAL,NATURAL,FLAT}, // 2 FLATS
		{NATURAL,NATURAL,FLAT,NATURAL,NATURAL,FLAT,FLAT}, // 3 FLATS
		{NATURAL,FLAT,FLAT,NATURAL,NATURAL,FLAT,FLAT}, // 4 FLATS
		{NATURAL,FLAT,FLAT,NATURAL,FLAT,FLAT,FLAT}, // 5 FLATS
		{FLAT,FLAT,FLAT,NATURAL,FLAT,FLAT,FLAT}, // 6 FLATS
		{FLAT,FLAT,FLAT,FLAT,FLAT,FLAT,FLAT}, // 7 FLATS
	};

	public static final int SCORE_SHARP_NOTES[] = new int[]{0,0,1,1,2,3,3,4,4,5,5,6};
	public static final int SCORE_FLAT_NOTES[] = new int[]{0,1,1,2,2,3,4,4,5,5,6,6};
	
	/**
	 * Notas que tienen sostenido
	 */	
	public static final boolean NO_NATURAL_NOTES[] = new boolean[]{false,true,false,true,false,false,true,false,true,false,true,false};	
    /**
     * desviacion a la izquierda
     */
    private static final int JOINED_TYPE_NONE_LEFT = 1;
    /**
     * desviacion a la derecha
     */
    private static final int JOINED_TYPE_NONE_RIGHT = 2;    
    /**
     * Union a la izquierda
     */
    private static final int JOINED_TYPE_LEFT = 3;
    /**
     * Union a la derecha
     */
    private static final int JOINED_TYPE_RIGHT = 4;
    
    private boolean joinedGreaterThanQuarter;
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;    
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Nota de Referencia
     */
    private Note note;
    /**
     * Valor real de la nota, sumado a el valor de la cuerda
     */    
    private int realValue;       
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;
    /**
     * Tipo de union de notas
     */
    private int joinedType;
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;

    /**
     * Helper para la partitura
     */
    private MeasureTimeHelper measureTimeHelper;
    
    private Rectangle noteOrientation;
    
    private int scorePosY;
    
    public NoteCoords(Tablature tablature, SongTrackCoords trackCoords, MeasureCoords meassureCoords, Note note, int posX, int posY) {
        this.tablature = tablature;
        this.trackCoords = trackCoords;
        this.meassureCoords = meassureCoords;
        this.note = note;
        this.posX = posX;
        this.posY = posY;
        this.durationCoords = new DurationCoords();
        this.noteOrientation = new Rectangle(0,0,0,0);
        this.calculateRealValue();
    }

    /**
     * Actualiza los valores para dibujar
     */
    public void update(ViewLayout layout) {    	
    	int scale = (layout.getStringSpan() / 2);
    	
        this.joinedType = JOINED_TYPE_NONE_RIGHT;
        this.joinedGreaterThanQuarter = false;
        this.durationCoords.setNote1(this);
        this.durationCoords.setNote2(this);

        boolean noteJoined = false;
        boolean withPrev = false;

        MeasureComponent prevComponent = meassureCoords.getPreviousComponent(this);
        MeasureComponent nextComponent = meassureCoords.getNextComponent(this);
        NoteCoords prevNote = null;
        NoteCoords nextNote = null;

        //trato de unir con el componente anterior
        if (prevComponent instanceof NoteCoords) {
            prevNote = (NoteCoords) prevComponent;
            if (meassureCoords.areInSameBeat(this, prevNote)) {
            	withPrev = true;
                if (prevNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote1(prevNote);
                    if (nextNote == null || nextNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote2(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_LEFT;
                }
                if (prevNote.getNote().getDuration().getValue() > Duration.QUARTER){
                	this.joinedGreaterThanQuarter = true;
                }
            }
        }

        //trato de unir con el componente que le sigue
        if (nextComponent instanceof NoteCoords) {
            nextNote = (NoteCoords) nextComponent;
            if (meassureCoords.areInSameBeat(this, nextNote)) {
                if (nextNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote2(nextNote);
                    if (prevNote == null || prevNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote1(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_RIGHT;
                }
                if (nextNote.getNote().getDuration().getValue() > Duration.QUARTER){
                	this.joinedGreaterThanQuarter = true;
                }                
            }

        }

        //si no hubo union decido para que lado girar la figura
        if (!noteJoined && withPrev) {            
            this.joinedType = JOINED_TYPE_NONE_LEFT;            
        }

        this.scorePosY = measureTimeHelper.getY1(layout,this,meassureCoords.getMeasure().getKeySignature(),meassureCoords.getMeasure().getClef());
        this.updateUsedStrings();                
    }

    private void updateUsedStrings() {
        if (note.getDuration().getValue() >= Duration.QUARTER) {
            boolean[] usedStrings = new boolean[trackCoords.getTrack().getStrings().size()];
            List notesAtBeat = this.meassureCoords.getComponents(getStart());
            Iterator it = notesAtBeat.iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent) it.next();
                if (component instanceof NoteCoords) {
                    NoteCoords currNote = (NoteCoords) component;
                    usedStrings[currNote.getNote().getString() - 1] = true;
                }
            }
            this.durationCoords.setUsedStrings(usedStrings);
        }
    }
    
    public void calculateRealValue(){
    	this.realValue = (getNote().getValue() + ((InstrumentString)trackCoords.getTrack().getStrings().get((getNote().getString() - 1))).getValue());    	
    }        
    
    
    
    /**
     * Pinta la nota
     */
    public void paint(ViewLayout layout,GC gc, int fromX, int fromY) {  
    	paintScoreNote(layout, gc, fromX, fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES));        
        paintOfflineEffects(layout,gc,fromX,fromY);        
        paintTabNote(layout, gc, fromX, fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TABLATURE));
    }
    
    private void paintOfflineEffects(ViewLayout layout,GC gc, int fromX, int fromY){    	
    	NoteEffect effect = getNote().getEffect();    	    	
    	
    	layout.setOfflineEffectStyle(gc);
    	if(effect.isAccentuatedNote()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_ACCENTUATED_EFFECT));
            gc.drawString(">",x, y);
    	}  
    	else if(effect.isHeavyAccentuatedNote()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_ACCENTUATED_EFFECT));
            gc.drawString("^",x, y);
    	}  
    	if(effect.isFadeIn()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_FADE_IN));
            gc.drawString("<",x, y);
    	}  
    	if(effect.isHarmonic() && !layout.isScoreEnabled()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_HARMONIC_EFFEC));
            String key = new String();
            key = effect.getHarmonic().isNatural()?HarmonicEffect.KEY_NATURAL:key;
            key = effect.getHarmonic().isArtificial()?HarmonicEffect.KEY_ARTIFICIAL:key;
            key = effect.getHarmonic().isTapped()?HarmonicEffect.KEY_TAPPED:key;
            key = effect.getHarmonic().isPinch()?HarmonicEffect.KEY_PINCH:key;
            key = effect.getHarmonic().isSemi()?HarmonicEffect.KEY_SEMI:key;            
            gc.drawString(key,x, y);
    	} 
    	
    	if(effect.isTapping()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TAPPING_EFFEC));
            gc.drawString("T",x, y);
    	}  
    	else if(effect.isSlapping()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TAPPING_EFFEC));
            gc.drawString("S",x, y);
    	}  
    	else if(effect.isPopping()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TAPPING_EFFEC));
            gc.drawString("P",x, y);
    	}  

    	
    	if(effect.isPalmMute()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_PALM_MUTE_EFFEC));
            gc.drawString("P.M",x, y);
    	}
    	
    	if(effect.isVibrato()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_VIBRATO_EFFEC));
            paintVibrato(gc,x,y);
    	}    	
    	if(effect.isTrill()){
            int x = fromX + getPosX() + getSpan();
            int y = (fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_VIBRATO_EFFEC));
            paintTrill(gc,x,y);
    	}        	
    }
    
    
    /**
     * Pinta la nota en la tablatura
     */
    public void paintTabNote(ViewLayout layout,GC gc, int fromX, int fromY) {
    	if(layout.isTablatureEnabled()){     	
    		int x = fromX + getPosX() + getSpan() + 2;
    		int y = fromY + getPosY();
        
    		this.noteOrientation.x = x;
    		this.noteOrientation.y = y;
    		this.noteOrientation.width = 1;
    		this.noteOrientation.height = 1;    		
    		//-------------estilo--------------------------------------
    		layout.setNoteStyle(gc);
    		if(layout.isPlayModeEnabled() && isPlaying()){
    			layout.setPlayNoteColor(gc);
    		}else{
    			layout.setTabNoteColor(gc);
    		}
        
    		//-------------ligadura--------------------------------------        
    		if (getNote().isTiedNote() && !layout.isScoreEnabled()) {           	    
    			NoteCoords noteForTie = getNoteForTie(); 
    			//if (noteForTie != null && areAtSameLine(this,noteForTie)) {
    			if (noteForTie != null) {
    				int ligadureX = (fromX + noteForTie.getPosX() + noteForTie.getSpan());
    				int ligadureY = (fromY + noteForTie.getPosY() + 10);
    				gc.drawArc(ligadureX, ligadureY, (x - ligadureX), -30, 225, 90);
            	
    			}else{        		
    				Rectangle r = layout.getNoteOrientation(gc,x,y,note);
    				gc.drawArc(r.x - 20,(fromY + getPosY() + 10),20, -30, 225, 90);            	
    			}           	
    		//-------------nota--------------------------------------     
    		} else if(!getNote().isTiedNote()){        	        	
    			Rectangle r = layout.getNoteOrientation(gc,x,y,note);
    			this.noteOrientation.x = r.x;
    			this.noteOrientation.y = r.y;
    			this.noteOrientation.width = r.width;
    			this.noteOrientation.height = r.height;    			
    			String visualNote = (note.getEffect().isDeadNote())?"X":Integer.toString(getNote().getValue());
    			visualNote = (note.getEffect().isGhostNote())?"(" + visualNote + ")":visualNote;
    			gc.drawString(visualNote, noteOrientation.x, noteOrientation.y);     			 		
    		}        
                                
    		if(layout.isPlayModeEnabled() && isPlaying()){
    			layout.setTabNoteColor(gc);
    		}
         
    		//-------------efectos--------------------------------------     
    		paintEffects(layout,gc,fromX,fromY);
                     
    		if(!layout.isScoreEnabled()){            	        	
    			int stringSpan = layout.getStringSpan();            
    			int y1 = (fromY + meassureCoords.getTrackCoords().getTabHeight() + (stringSpan / 2));
    			int y2 = (fromY + meassureCoords.getTrackCoords().getTabHeight() + ((stringSpan / 2) * 5));                        
            
    			//-------------pie de nota--------------------------------------   
    			if (note.getDuration().getValue() >= Duration.QUARTER) {            	
    				boolean[] usedStrings = this.durationCoords.getUsedStrings();
    				for (int i = getNote().getString() - 1; i < usedStrings.length; i++) {
    					if (!usedStrings[i]) {
    						int stringPosition = (fromY + (stringSpan * (i + 1)) - stringSpan);
    						int posY1 = stringPosition - (stringSpan / 2);
    						int posY2 = stringPosition + (stringSpan / 2);
    						posY2 = ((posY2 - posY1 < stringSpan)?posY2 + 1:posY2);                        
    						gc.drawLine(x, posY1, x, posY2);
    					}
    				}                
    				gc.drawLine(x, y1, x,y2);                                           
    				if (note.getDuration().getValue() >= Duration.EIGHTH) {
    					paintTabJoindeds(layout,gc, fromX + 2, y2);
    				}
                
    			} else if (note.getDuration().getValue() == Duration.HALF) {
    				gc.drawLine(x, (y1 + ((y2 - y1) / 2)), x, y2);
    			}

    			//-------------puntillo--------------------------------------
    			if (note.getDuration().isDotted() || note.getDuration().isDoubleDotted()) {            	            	            	
    				int posX = ((note.getDuration().getValue() > Duration.WHOLE)?((joinedType == JOINED_TYPE_NONE_RIGHT || joinedType == JOINED_TYPE_RIGHT)?(x+4):(x-5)):x);            	
    				int posY = (y2 - ((note.getDuration().getValue() >= Duration.EIGHTH)? ((stringSpan / 2) * (note.getDuration().log2() - 2)):1));
                
    				gc.drawOval(posX, posY, 1, 1);
    				if(note.getDuration().isDoubleDotted()){
    					gc.drawOval(posX + 3,posY, 1, 1);    
    				}            	
    			}        
            
    			//-------------tresillo--------------------------------------            
    			if (!note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
    				layout.setTupletoStyle(gc);
    				gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x - 3,((fromY - meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TABLATURE)) + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TUPLETO)));
    			}        	
        
    			//-------------tremolo picking--------------------------------------    
    			if(note.getEffect().isTremoloPicking()){
    				gc.setAdvanced(true);
    				gc.setLineWidth(2);
    				int posy = (y1 + ((y2 - y1) / 2));
    				for(int i = Duration.EIGHTH;i <= note.getEffect().getTremoloPicking().getDuration().getValue(); i += i){                		
    					gc.drawLine(x - 3, posy - 1, x + 4,posy + 1);
    					posy += 4;
    				}
    				gc.setLineWidth(1);
    				gc.setAdvanced(false);
    			}            
    		}
    	}
    }
    

    /**
     * Pinta la nota en la partitura
     */
    private void paintScoreNote(ViewLayout layout,GC gc, int fromX, int fromY) {  
    	if(layout.isScoreEnabled()){     	
    		//KEY  0 = DO
    		int key = meassureCoords.getMeasure().getKeySignature();
    		int clef = meassureCoords.getMeasure().getClef();
    		int noteValue = getRealValue();
    		int scoreLineSpan = layout.getScoreLineSpan();
    	
    		int x = fromX + getPosX() + getSpan();    	
    		int y1 = fromY + getScorePosY();		

    		//-------------foreground--------------------------------------
    		boolean playMode = (layout.isPlayModeEnabled() && isPlaying());		
    		if(playMode){
    			layout.setPlayNoteColor(gc);
    		}else{
    			layout.setScoreNoteColor(gc);
    		}        
    		//----------ligadura---------------------------------------
    		if (getNote().isTiedNote()) {        
    			NoteCoords noteForTie = getNoteForTie();
    			//if (noteForTie != null && areAtSameLine(this,noteForTie)) {     
    			if (noteForTie != null) {	
    				int ligadureX = (fromX + noteForTie.getPosX() + noteForTie.getSpan());
    				int ligadureY = (fromY + getScorePosY());
    				gc.drawArc(ligadureX + 3, ligadureY - 3, (x - ligadureX), 35, 45, 90);
    			}else{        		
    				gc.drawArc(x - 20,y1 - 2,20, 30, 45, 90);
    			}           	
    		}						
    		//----------sostenido--------------------------------------		
    		boolean isSharpKey = KEY_SIGNATURES[key][SCORE_SHARP_NOTES[noteValue % 12]] == SHARP;
    		boolean isFlatKey = KEY_SIGNATURES[key][SCORE_FLAT_NOTES[noteValue % 12]] == FLAT;
    		boolean isNoNaturalNote = NO_NATURAL_NOTES[noteValue % 12];
		
    		if(key <= 7){		
    			if(isNoNaturalNote && !isSharpKey){
    				gc.drawImage(SystemImages.KEY_SHARP,x - 7 ,y1 - 1);			
    			}		
    			if(isSharpKey && !isNoNaturalNote){
    				gc.drawImage(SystemImages.KEY_NATURAL,x - 7,y1 -3);
    			}
    		}else{
    			if(isNoNaturalNote && !isFlatKey){
    				gc.drawImage(SystemImages.KEY_FLAT,x - 7 ,y1 -2);			
    			}		
    			if(isFlatKey && !isNoNaturalNote){
    				gc.drawImage(SystemImages.KEY_NATURAL,x - 7,y1 -3);
    			}			
    		}
    		//----------fin sostenido--------------------------------------				
    		int size = (layout.getScoreLineSpan() - 2);		
    		if(note.getEffect().isHarmonic()){
    			gc.drawImage(layout.getHarmonicNote(note.getDuration().getValue(),playMode),x,y1);
    		}else{
    			gc.drawImage(layout.getScoreNote(note.getDuration().getValue(),playMode),x,y1);
    		}
    		if(note.getEffect().isGrace()){    							
    			Rectangle graceBounds = SystemImages.GRACE_IMAGE.getBounds();
    			gc.drawImage(SystemImages.GRACE_IMAGE,x - graceBounds.width - 2,y1 - (graceBounds.height / 2) + 2 );
    		}      		
    		//---------------------------------------------------		
    		if(playMode){
    			layout.setScoreNoteColor(gc);
    		} 		
        		  
    		//PUNTILLO y DOBLE PUNTILLO
    		if (note.getDuration().isDotted() || note.getDuration().isDoubleDotted()) {
    			gc.setLineWidth(3);        	
    			gc.drawOval(x + 13, y1 + 4, 1, 1);
    			if(note.getDuration().isDoubleDotted()){
    				gc.drawOval(x + 18,y1 + 4, 1, 1);    
    			}                       
    			gc.setLineWidth(1);
    		}        
    		//TUPLETO
    		if (!note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) { 
    			layout.setTupletoStyle(gc);
    			gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x ,((fromY - meassureCoords.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES)) + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TUPLETO)));
    		}                
    		//dibujo el pie
    		if(note.getDuration().getValue() >= Duration.HALF){
    			gc.setAdvanced(true);
				
    			if(measureTimeHelper.getDirection() == MeasureTimeHelper.DIRECTION_UP){
    				y1 += (layout.getScoreLineSpan() / 3) + 1;				
    				x += layout.getScoreNoteWidth();
    				fromX += layout.getScoreNoteWidth();
    			}else{
    				y1 += (layout.getScoreLineSpan() / 3) * 2;
    			}
			
    			int y2 = fromY + measureTimeHelper.getY2(layout,getPosX() + getSpan(),key,clef);
    			gc.drawLine(x, y1, x, y2);
	        	        	        
    			if (note.getDuration().getValue() >= Duration.EIGHTH) {	        
    				paintScoreJoindeds(layout,gc,fromX ,fromY,key,clef);	        	
    			}	        
    			//staccato
    			if (note.getEffect().isStaccato()) {
    				gc.setLineWidth(2);
    				gc.drawOval(x,y2 + (4 * ((measureTimeHelper.getDirection() == MeasureTimeHelper.DIRECTION_UP)?-1:1)),1,1);
    				gc.setLineWidth(1);
    			}    	
    			//tremolo picking    
    			if(note.getEffect().isTremoloPicking()){
    				gc.setLineWidth(2);
    				int tpY = fromY;
    				if((measureTimeHelper.getDirection() == MeasureTimeHelper.DIRECTION_UP)){
    					tpY += (measureTimeHelper.getMaxNote().getScorePosY() - layout.getScoreLineSpan() - 4);
    				}else{
    					tpY += (measureTimeHelper.getMinNote().getScorePosY() + layout.getScoreLineSpan() + 4);
    				}
    				for(int i = Duration.EIGHTH;i <= note.getEffect().getTremoloPicking().getDuration().getValue(); i += i){                		
    					gc.drawLine(x - 3, tpY + 1, x + 4,tpY - 1);
    					tpY += 4;
    				}
    				gc.setLineWidth(1);
    			}	        
	        
    			gc.setAdvanced(false);
    		}else{
    			//staccato
    			if (note.getEffect().isStaccato()) {
    				gc.setAdvanced(true);	        	
    				gc.setLineWidth(2);
    				gc.drawOval(x + (layout.getScoreNoteWidth() / 2),(fromY + measureTimeHelper.getMinNote().getScorePosY() + layout.getScoreLineSpan()) + 2,1,1);
    				gc.setLineWidth(1);
    				gc.setAdvanced(false);
    			}
    			//tremolo picking    
    			if(note.getEffect().isTremoloPicking()){
    				gc.setAdvanced(true);
    				gc.setLineWidth(2);
    				int tpX = (x + (layout.getScoreNoteWidth() / 2));
    				int tpY = fromY + (measureTimeHelper.getMaxNote().getScorePosY() - layout.getScoreLineSpan() - 4);
    				for(int i = Duration.EIGHTH;i <= note.getEffect().getTremoloPicking().getDuration().getValue(); i += i){                		
    					gc.drawLine(tpX - 3, tpY + 1, tpX + 4,tpY - 1);
    					tpY += 4;
    				}
    				gc.setLineWidth(1);
    				gc.setAdvanced(false);
    			}	        
    		}
  		
    	}
    }
    
    /**
     * Pinta las uniones entre notas
     */
    public void paintTabJoindeds(ViewLayout layout,GC gc, int fromX, int fromY) {
        gc.setLineWidth(2);
        int x1 = 0;
        int x2 = 0;        
        
        if(this.joinedType == JOINED_TYPE_NONE_RIGHT){
            x1 = getPosX() + getSpan();
            x2 = getPosX() + getSpan() + 6;
        }else if(this.joinedType == JOINED_TYPE_NONE_LEFT){
            x1 = getPosX() + getSpan() - 5;
            x2 = getPosX() + getSpan();            
        }else{                              
            x1 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1().getComponent());
            x2 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2().getComponent());          
        }
        if(note.getDuration().getValue() >= Duration.EIGHTH){
        	int scale = (layout.getStringSpan() / 2);
        	for(int i = (note.getDuration().log2() - 2); i > 0 ;i --){
        		gc.drawLine(fromX + x1, fromY + (scale - (i * scale)), fromX + x2, fromY + (scale - (i * scale)));
        	}
        }                
        gc.setLineWidth(1);
    } 
    
    


    public void paintScoreJoindeds(ViewLayout layout,GC gc, int fromX, int fromY,int key,int clef) {
        int dir = (measureTimeHelper.getDirection() == MeasureTimeHelper.DIRECTION_DOWN)?1:-1;
        
        if((this.joinedType == JOINED_TYPE_NONE_LEFT || this.joinedType == JOINED_TYPE_NONE_RIGHT) && !this.joinedGreaterThanQuarter){
        	gc.setLineWidth(2);
        	
        	int x = fromX + getPosX() + getSpan();
        	int x2 = x + 7;        	
        	int y = fromY + measureTimeHelper.getY2(layout,getPosX() + getSpan(),key,clef);        	
        	
        	switch (note.getDuration().getValue()) {
        	case Duration.EIGHTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));        		
        		break;
        	case Duration.SIXTEENTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir)); 
        		break;
        	case Duration.THIRTY_SECOND:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (10 * dir),x2,(y - (10 * dir)) - (6 * dir));
        		break;
        	case Duration.SIXTY_FOURTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (10 * dir),x2,(y - (10 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (15 * dir),x2,(y - (15 * dir)) - (6 * dir));        		
        		break;
        	}        	
        	y += dir;
        	
        	gc.drawLine(x2,y - (6 * dir),x2,y - (6 * dir) - (16 * dir));
        	gc.setLineWidth(1);
        }else{
        	gc.setLineWidth(3);
        	
            int x1 = 0;
            int x2 = 0;        
            
            if(this.joinedType == JOINED_TYPE_NONE_RIGHT){
                x1 = getPosX() + getSpan();
                x2 = getPosX() + getSpan() + 6;
            }else if(this.joinedType == JOINED_TYPE_NONE_LEFT){
                x1 = getPosX() + getSpan() - 5;
                x2 = getPosX() + getSpan();            
            }else{                              
                x1 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1().getComponent());
                x2 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2().getComponent());          
            }                                
        	int y1 = fromY + measureTimeHelper.getY2(layout,x1,key,clef);
        	int y2 = fromY + measureTimeHelper.getY2(layout,x2,key,clef);
        
        	        	
        	switch (note.getDuration().getValue()) {

        	case Duration.EIGHTH:        		
        		gc.drawLine(fromX + x1, y1, fromX + x2,y2);
        		break;
        	case Duration.SIXTEENTH:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		break;
        	case Duration.THIRTY_SECOND:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		gc.drawLine(fromX + x1,y1 - (10 * dir), fromX + x2,y2 - (10 * dir));
        		break;
        	case Duration.SIXTY_FOURTH:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		gc.drawLine(fromX + x1,y1 - (10 * dir), fromX + x2,y2 - (10 * dir));
        		gc.drawLine(fromX + x1,y1 - (15 * dir), fromX + x2,y2 - (15 * dir));
        		break;
        	}
        	
        	 gc.setLineWidth(1);
        }
               
    }        

    /**
     * Encuentra la nota a la que esta ligada
     */
    private NoteCoords getNoteForTie() {
        //Primero lo busco en el compas actual
        List currComponents = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        for (int cIdx = currComponents.size() - 1; cIdx >= 0; cIdx--) {
            MeasureComponent component = (MeasureComponent) currComponents.get(cIdx);
            if (component.getStart() < getNote().getStart()) {
                if (component instanceof NoteCoords) {
                    NoteCoords noteCoords = (NoteCoords) component;

                    if (noteCoords.getNote().getString() == getNote().getString()) {
                        return noteCoords;
                    }
                }
            }
        }

        //si no estaba en este compas lo busco en los anteriores
        /*
        for (int mIdx = (this.meassureCoords.getMeasure().getNumber() - 1); mIdx >= 0; mIdx--) {
            MeasureCoords measureCoords = (MeasureCoords) this.trackCoords.getMeasuresCoords().get(mIdx);

            List components = measureCoords.getComponentsBeforeEnd(measureCoords.getMeasure().getStart());
            for (int cIdx = components.size() - 1; cIdx >= 0; cIdx--) {
                MeasureComponent component = (MeasureComponent) components.get(cIdx);
                if (component.getStart() < getNote().getStart()) {
                    if (component instanceof NoteCoords) {
                        NoteCoords noteCoords = (NoteCoords) component;

                        if (noteCoords.getNote().getString() == getNote().getString()) {
                            return noteCoords;
                        }
                    }
                }
            }
        }
        */
        return null;
    }

    /**
     * Pinta los efectos
     */
    private void paintEffects(ViewLayout layout,GC gc, int fromX, int fromY){
        int x = fromX + getPosX() + getSpan();
        int y = fromY + getPosY();        
        
        NoteEffect effect = getNote().getEffect();                
		if(effect.isGrace()){    							
			layout.setGraceStyle(gc);
			String value = Integer.toString(effect.getGrace().getFret());
			Point gracePoint = gc.stringExtent(value);
			gc.drawString(value, (noteOrientation.x - gracePoint.x - 2), noteOrientation.y );
		}           
        if(effect.isBend()){            
        	gc.drawImage(SystemImages.BEND_IMAGE,(noteOrientation.x + noteOrientation.width),noteOrientation.y - (SystemImages.BEND_IMAGE.getBounds().height /2));
        }else if(effect.isTremoloBar()){
            gc.drawImage(SystemImages.TREMOLO_BAR,(noteOrientation.x + noteOrientation.width),noteOrientation.y + (noteOrientation.height / 2));                       
        }else if(effect.isSlide() || effect.isHammer()){                                
        	int nextFromX = fromX;
            MeasureComponent nextComponent = this.meassureCoords.getNextNoteComponent(this,getNote().getString());

            if(effect.isSlide()){                

            	if(nextComponent != null){
            		NoteCoords nextNote = (NoteCoords)nextComponent;                    
                    int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote.getComponent());
                    int nextY = y;
                    if(nextNote.getNote().getValue() < getNote().getValue()){                        
                    	y -= 3;
                        nextY += 3;                          
                    }else if(nextNote.getNote().getValue() > getNote().getValue()){
                    	y += 3;
                        nextY -= 3;                                             
                    }else{
                    	y -= 3;
                        nextY -= 3;
                    }
                    gc.drawLine(x + 5,y,nextX - 2,nextY);
                }else{
                	gc.drawLine(x + 5,y - 3,x + 20 - 2,y - 3);
                }
            }else if(effect.isHammer()){                   
            	if(nextComponent != null){                 
            		NoteCoords nextNote = (NoteCoords)nextComponent;
                    int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote.getComponent());                        
                    gc.drawArc(x + 5,y - 5, (nextX - 6 - (x + 5)),15,45,90);                                               
                }else{
                	gc.drawArc(x + 5,y - 5,10,15,45,90);                    
                }
            }
        }
    }
    
    private void paintVibrato(GC gc,int fromX,int fromY){                        
        int width = getWidth();
        int y1 = 0;
        int y2 = 0;
        int incrementX = 2;
        int incrementY = 2;
        int dir = -1;
        gc.setLineWidth(1);        
        for(int x = fromX;x < (fromX + width - 5) ;x += incrementX){            
            dir = (dir * -1);
            y1 = (fromY + (incrementY * dir)) + 6;
            y2 = (fromY - (incrementY * dir)) + 6;
        	
        	gc.drawLine(x,y1,x + incrementX + 1,y2);
        }
        gc.setLineWidth(1);
    }
     
    private void paintTrill(GC gc,int fromX,int fromY){                        
        int width = getWidth();
        int y1 = 0;
        int y2 = 0;
        int incrementX = 2;
        int incrementY = 2;
        int dir = -1;
        int charWidth = 9;
        gc.setLineWidth(1);
        gc.drawString("tr",fromX,fromY);        
        for(int x = fromX + charWidth;x < (fromX + width - charWidth) ;x += incrementX){            
            dir = (dir * -1);
            y1 = (fromY + (incrementY * dir)) + 6;
            y2 = (fromY - (incrementY * dir)) + 6;
        	
        	gc.drawLine(x,y1,x + incrementX + 1,y2);
        }        
    }    

    public boolean isPlaying(){
        if(meassureCoords.isPlaying()){
            long playerTickPosition = TuxGuitar.instance().getPlayer().getTickPosition();
            if(playerTickPosition >= getNote().getStart()  && playerTickPosition < getNote().getStart() + getNote().getDuration().getTime()){            
                return true;
            }
        }
        return false;
    }
    
    private int getWidth(){
        double quartersInDuration = ((1.00 / (double)getNote().getDuration().getValue()) * 4.00);
        int width = (int)((double)this.meassureCoords.getQuarterSpan() * quartersInDuration);
        return width;
    }
    
    /**
     * Asigna el start de la nota
     */
    public void setStart(long start) {
        this.note.setStart(start);
    }

    /**
     * Retorna el start de la nota
     */
    public long getStart() {
        return this.note.getStart();
    }

    /**
     * Asigna la duracion de la nota
     */
    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    /**
     * Retorna la duracion de la nota
     */
    public Duration getDuration() {
        return this.note.getDuration();
    }

    /**
     * Retorna la nota de Referencia
     */
    public Note getNote() {
        return note;
    }

    /**
     * Retorna posicion X dentro del compas
     */
    public int getPosX() {
        return posX;
    }

    /**
     * Retorna posicion Y dentro del compas
     */
    public int getPosY() {
        return posY;
    }

    public int getSpan(){
        return meassureCoords.getSpanForComponent(this.getComponent());
    }

    public int getRealValue(){
    	return this.realValue;    	
    }
    
	public MeasureTimeHelper getMeasureTimeHelper() {
		return measureTimeHelper;
	}

	public void setMeasureTimeHelper(MeasureTimeHelper measureTimeHelper) {
		this.measureTimeHelper = measureTimeHelper;
	}

	public Component getComponent() {
		return getNote();
	}

	public int getScorePosY() {
		return scorePosY;
	}
	/*
	private static boolean areAtSameLine(NoteCoords c1,NoteCoords c2){
		return ((!c1.meassureCoords.isOutOfBounds() && !c2.meassureCoords.isOutOfBounds()) && (c1.meassureCoords.getPosY() == c2.meassureCoords.getPosY()) && (c1.getPosY() == c2.getPosY()));		
	}
	*/
}