/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.song.managers.SongManager;



/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Tablature extends Composite {	
	
	public static final int ALLOW_PLAY_CACHE = 0x01;
	
	private int flags;
	private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;    
    private ViewLayout viewLayout;    
    private EditorKit editorKit;
    private Font defaultFont;
    private Font noteFont;
    private Font timeSignatureFont;     
    private Font printerDefaultFont;
    private Font printerNoteFont;
    private Font printerTimeSignatureFont;     
    private Font lyricFont;
    private Font graceFont;
    
    private Color lineColor;
    private Color scoreNoteColor;
    private Color tabNoteColor;
    private Color playNoteColor;
               
    private boolean locked;
        
    private int SCROLL_DELAY = 15;
    private long lastVScrollTime;
    private long lastHScrollTime;
    
    private MeasureCoords lastMeasure;
    private List lastComponents;
    
    public Tablature(final Composite parent, int style) {
        super(parent, style);        
        this.setBackground(new Color(getDisplay(), 255, 255, 255));
        this.editorKit = new EditorKit(this);
    }    
                
    public void initGUI(){
        this.addPaintListener(new TablaturePaintListener(this));
                        
        final Point origin = new Point(0, 0);
        final ScrollBar hBar = getHorizontalBar();
        hBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {        	  
        	if(lastHScrollTime + SCROLL_DELAY < System.currentTimeMillis()){
        		int hSelection = hBar.getSelection();
        		int destX = -hSelection - origin.x;
        		Rectangle rect = getClientArea();
        		getShell().scroll(destX, 0, 0, 0, rect.width, rect.height, false);
        		origin.x = -hSelection;           
        		redraw();
        		lastHScrollTime = System.currentTimeMillis();
        	}
          }
        });
        
        final ScrollBar vBar = getVerticalBar();
        vBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
        	  if(lastVScrollTime + SCROLL_DELAY < System.currentTimeMillis()){
        		  int vSelection = vBar.getSelection();
        		  int destY = -vSelection - origin.y;
        		  Rectangle rect = getBounds();
        		  getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
        		  origin.y = -vSelection;            
        		  redraw();
        		  lastVScrollTime = System.currentTimeMillis();
        	  }
          }
        });         
        
        this.addControlListener(new ControlAdapter() {		
			public void controlResized(ControlEvent arg0) {
				updateScroll();
			}		
		});
    }
    
    public void initDefaults(){
        this.songCoords = new SongCoords(this,this.songManager);        
        this.caret = new Caret(this,this.songManager,this.songCoords);
    }    
    
    public void updateTablature(){    	
    	this.lastMeasure = null;
    	this.lastComponents = null;
        getViewLayout().updateSong();
    }

    public void initCaret(){
    	this.caret.update(1,1000,1);
    }
    
    public void loadFlags(){
    	this.flags = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.TABLATURE_FLAGS);
    }    
    
    public void loadFonts(){
        this.defaultFont = getFont(ConfigKeys.FONT_DEFAULT);
        this.noteFont = getFont(ConfigKeys.FONT_NOTE);
        this.timeSignatureFont = getFont(ConfigKeys.FONT_TIME_SIGNATURE);
        this.printerDefaultFont = getFont(ConfigKeys.FONT_PRINTER_DEFAULT);
        this.printerNoteFont = getFont(ConfigKeys.FONT_PRINTER_NOTE);	        
        this.printerTimeSignatureFont = getFont(ConfigKeys.FONT_PRINTER_TIME_SIGNATURE);        
        this.lyricFont = getFont(ConfigKeys.FONT_LYRIC);
        this.graceFont = getFont(ConfigKeys.FONT_GRACE);
    }    
    
    public void loadColors(){
    	this.lineColor = getColor(ConfigKeys.COLOR_LINE);
        this.scoreNoteColor = getColor(ConfigKeys.COLOR_SCORE_NOTE);
        this.tabNoteColor = getColor(ConfigKeys.COLOR_TAB_NOTE);
        this.playNoteColor = getColor(ConfigKeys.COLOR_PLAY_NOTE);        
    }     

    public synchronized void paintTablature(GC gc){      
    	this.lock();
    		
    	int hScroll = getHorizontalBar().getSelection();
    	int vScroll = getVerticalBar().getSelection();                	
    	
    	this.getViewLayout().paintSong(gc,getClientArea(),-hScroll,-vScroll);
            	    	
    	this.width = this.viewLayout.getWidth();
    	this.height = this.viewLayout.getHeight();
        
    	this.updateScroll();
        
    	//Si no estoy reproduciendo muevo el scroll al compas que tiene el caret
    	if(getCaret().hasChanges() && !TuxGuitar.instance().getPlayer().isRunning()){   
    		getCaret().setChanges(false);
    		if(getCaret().getMeasureCoords() != null){
    			getViewLayout().followMeasure(getCaret().getMeasureCoords(),true);
    		}
    	}    

    	if(TuxGuitar.instance().getPlayer().isRunning()){
    		redrawPlayingMode(gc,true);
    	}    		
    		
    	this.unlock();
    }
    
    public void updateScroll(){
		Rectangle rect = getBounds();
		Rectangle client = getClientArea();        
        ScrollBar hBar = getHorizontalBar();
        ScrollBar vBar = getVerticalBar();
		hBar.setMaximum(width + 22);
		vBar.setMaximum(height);
		hBar.setThumb(Math.min(rect.width, client.width));
		vBar.setThumb(Math.min(rect.height, client.height));
    }
    
    public boolean moveScrollHorizontalTo(MeasureCoords measure,int span,boolean redraw){
        if(measure != null){
            int selectionX = getHorizontalBar().getSelection();
            int selectionWidth = getClientArea().width;            
            int measureX = measure.getPosX();
            int measureWidth = measure.getWidth();
            
            //si el largo del compas es mayor al de la pantalla. nunca se puede ajustar a la medida.
            if(measureWidth > selectionWidth && (measureX + measureWidth) > 0 && measureX < selectionWidth){
            	return true;
            }
            
            if(measureX < 0 || (measureX + measureWidth) > selectionWidth){
                getHorizontalBar().setSelection((selectionX + measureX) - span);
                if(redraw){
                    redraw();
                }
                return true;
            }
        }          
        return false;
    }
    
    public boolean moveScrollVerticalTo(MeasureCoords measure,int span,boolean redraw){
        if(measure != null){
            int selectionY = getVerticalBar().getSelection();
            int selectionHeight = getClientArea().height;            
            int measureY = measure.getPosY();
            int measureHeight = measure.getTs().getSize();
                        
            //si el alto del compas es mayor al de la pantalla. nunca se puede ajustar a la medida.
            if(measureHeight > selectionHeight && (measureY + measureHeight) > 0 && measureY < selectionHeight){
            	return true;
            }            

            if(measureY < 0 || (measureY + measureHeight) > selectionHeight){
                getVerticalBar().setSelection( (selectionY + measureY)  - span);                
                if(redraw){                	
                    redraw();
                }
                return true;
            }
        }           
        return false;
    }    
    

	public Font getDefaultFont() {
		return defaultFont;
	}

	public Font getNoteFont() {
		return noteFont;
	}

	public Font getTimeSignatureFont() {
		return timeSignatureFont;
	}
	
	public Font getPrinterDefaultFont() {
		return printerDefaultFont;
	}
    
	public Font getPrinterNoteFont() {
		return printerNoteFont;
	}

	public Font getPrinterTimeSignatureFont() {
		return printerTimeSignatureFont;
	}

	public Font getLyricFont(){
		return this.lyricFont;
	}
	    
	public Font getGraceFont() {
		return this.graceFont;
	}

	public Color getLineColor() {
		return lineColor;
	}
	
	public Color getPlayNoteColor() {
		return playNoteColor;
	}

	public Color getScoreNoteColor() {
		return scoreNoteColor;
	}

	public Color getTabNoteColor() {
		return tabNoteColor;
	}

	public void redraw(){
        if(!super.isDisposed()){        	
        	this.lock();        	        	        
        	this.lastMeasure = null;
        	this.lastComponents = null;        	
            super.redraw();                        
        }
    }
    
    public void redrawPlayingMode(){
    	if((this.flags & ALLOW_PLAY_CACHE) == 0){
    		this.redraw();
    		return;
    	}
    	GC gc = new GC(this);   
    	redrawPlayingMode(gc,false);
    	gc.dispose();
    }

	private void redrawPlayingMode(GC gc,boolean force){
        if(!super.isDisposed() && (!isLocked() || force)){
        	this.lock();
        	        		        
        	MeasureCoords measure = TuxGuitar.instance().getEditorCache().getPlayingMeasure();
        	List components = TuxGuitar.instance().getEditorCache().getPlayingComponents();
			if(measure != null && components != null && measure.hasTrack(getCaret().getSongTrackCoords().getTrack().getNumber())){				
				if(force || !getViewLayout().followMeasure(measure,true)){				
			
					boolean paintMeasure = (force || this.lastMeasure == null || !this.lastMeasure.equals(measure));	    		
					if(this.lastMeasure != null && this.lastComponents != null && !this.lastMeasure.isOutOfBounds() && this.lastMeasure.hasTrack(getCaret().getSongTrackCoords().getTrack().getNumber())){
						getViewLayout().paintCacheMode(gc, this.lastMeasure, this.lastComponents,paintMeasure,false);
					}	  
					if(!measure.isOutOfBounds()){
						getViewLayout().paintCacheMode(gc, measure, components,paintMeasure,true);						
					}
					this.lastMeasure =  measure;
					this.lastComponents = new ArrayList(components);
				}	    	
			}

			this.unlock();
        }
    }
	
	private void lock(){
		this.editorKit.tryBack();
		this.locked = true;
	}

	private void unlock(){
		this.locked = false;
	}
	
	public boolean isLocked(){
		return this.locked;
	}
	
    public void resetScroll(){
        getHorizontalBar().setSelection(0);
        getVerticalBar().setSelection(0);
    }
        
    public Caret getCaret(){
        return this.caret;
    }
      
    public EditorKit getEditorKit() {
		return editorKit;
	}

	public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    
    public SongCoords getSongCoords(){
        return this.songCoords;
    }
    
    public void changeCursor(int style){
        setCursor(new Cursor(getDisplay(),style));
    }    
    
    public ViewLayout getViewLayout(){
        return this.viewLayout;
    }
    
    public void setViewLayout(ViewLayout viewLayout){
    	if(getViewLayout() != null){
    		getViewLayout().disposeLayout();
    	}
        this.viewLayout = viewLayout;
        if(this.getHorizontalBar() != null){
        	this.getHorizontalBar().setSelection(0);
        }
        if(this.getVerticalBar() != null){
        	this.getVerticalBar().setSelection(0);
        }
    }

    public void reloadStyles(){
    	this.disposeGraphics();
        this.loadFonts();
        this.loadColors();
    }
    
    public void reloadViewLayout(){
    	boolean multitrack = TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.SHOW_MULTITRACK);
    	boolean scoreEnabled = TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.SHOW_SCORE);
    	boolean tablatureEnabled = TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.SHOW_TABLATURE);
    	int mode = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.LAYOUT_MODE);      	
    	mode = (mode == 0)?ViewLayout.DEFAULT_MODE:mode;
    	switch(mode){
        	case ViewLayout.MODE_PAGE:
        		setViewLayout(new PageViewLayout(this,this.songManager,multitrack,scoreEnabled,tablatureEnabled));
        		break;
        	case ViewLayout.MODE_LINEAR:
        		setViewLayout(new LinearViewLayout(this,this.songManager,multitrack,scoreEnabled,tablatureEnabled));
        		break;
    	}
    }
    
    private static final Font getFont(String key){
    	FontData data = TuxGuitar.instance().getConfig().getFontDataConfigValue(key);
    	if(data == null){
    		data = new FontData();
    	}
    	return new Font(TuxGuitar.instance().getDisplay(),data);
    }
    
    private static final Color getColor(String key){
    	RGB rgb = TuxGuitar.instance().getConfig().getRGBConfigValue(key);
    	if(rgb == null){
    		rgb = new RGB(0,0,0);
    	}
    	return new Color(TuxGuitar.instance().getDisplay(),rgb);  
    }
    
    public void dispose(){
    	super.dispose();
    	this.getViewLayout().disposeLayout();
    	this.disposeGraphics();
    }
    
    public void disposeGraphics(){
        if(this.defaultFont != null)this.defaultFont.dispose();
        if(this.noteFont != null)this.noteFont.dispose();
        if(this.timeSignatureFont != null)this.timeSignatureFont.dispose();
        if(this.printerDefaultFont != null)this.printerDefaultFont.dispose();
        if(this.printerNoteFont != null)this.printerNoteFont.dispose();
        if(this.printerTimeSignatureFont != null)this.printerTimeSignatureFont.dispose();
        if(this.lyricFont != null)this.lyricFont.dispose(); 
        if(this.graceFont != null)this.graceFont.dispose();
        if(this.lineColor != null)this.lineColor.dispose();
        if(this.scoreNoteColor != null)this.scoreNoteColor.dispose();
        if(this.tabNoteColor != null)this.tabNoteColor.dispose();
        if(this.playNoteColor != null)this.playNoteColor.dispose();
    }
}