package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;

public class UndoableInsertMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private TracksMeasures tracksMeasures;
	private long insertPosition;
	private int copyCount;
	private int fromNumber;
	private long theMove;

	public UndoableInsertMeasure(){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();	    
    	this.insertPosition = caret.getPosition();
	}	
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		} 
		TuxGuitar.instance().getSongManager().insertMeasures((TracksMeasures)tracksMeasures.clone(),fromNumber,theMove);
		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();	
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}							
		for(int i = 0;i < this.copyCount;i ++){
			TuxGuitar.instance().getSongManager().removeMeasure(insertPosition);
		}
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }

    public UndoableInsertMeasure endUndo(TracksMeasures tracksMeasures,int copyCount,int fromNumber,long theMove){
    	this.redoCaret = new UndoableCaretHelper();
    	this.copyCount = copyCount;
    	this.tracksMeasures = tracksMeasures;
    	this.fromNumber = fromNumber;
    	this.theMove = theMove;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
