package org.herac.tuxguitar.song.models;

public class Marker {
	private static final RGBColor DEFAULT_COLOR = RGBColor.RED;
	private static final String DEFAULT_TITLE = "Untitled";
	
	private int measure;
	private String title;
	private RGBColor color;
	
	public Marker() {
	}		
		
	public Marker(int measure) {
		this(measure,DEFAULT_TITLE);
	}		
	
	public Marker(int measure, String title) {
		this(measure,title,DEFAULT_COLOR);
	}	
	
	public Marker(int measure, String title, RGBColor color) {
		this.measure = measure;
		this.title = title;
		this.color = color;
	}
	
	public int getMeasure() {
		return measure;
	}
	public void setMeasure(int measure) {
		this.measure = measure;
	}

	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
		
	public RGBColor getColor() {
		return color;
	}
	public void setColor(RGBColor color) {
		this.color = color;
	}
	
	public Object clone(){
		return new Marker(getMeasure(),getTitle(),(RGBColor)getColor().clone());
	}
}
