/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.cmdl;

import xnap.util.*;

import java.util.*;

public abstract class AbstractCommand {

    //--- Constant(s) ---

    public static final String CMD = "cmd";
    public static final String LONG_HELP = "longHelp";
    public static final String PARAMETER = "parameter";
    public static final String SHORT_HELP = "shortHelp";

    //--- Data Field(s) ---

    private Hashtable table = new Hashtable();
    
    //--- Constructor(s) ---
    
    public AbstractCommand() 
    {
    }
    
    //--- Method(s) ---

    /**
     * Returns false if syntax is incorrect. An error message will be printed.
     *
     * @param argv the first element is always the executed command 
     */
    public abstract boolean execute(String[] argv) 
	throws SyntaxException, ParameterException;

    public String[] getCommands()
    {
	ArrayList cmds = (ArrayList)table.get(CMD);
	if (cmds != null) {
	    String[] array = new String[cmds.size()];
	    System.arraycopy(cmds.toArray(), 0, array, 0, array.length);
	    return array;
	}
	else {
	    return new String[0];
	}
    }

    public String getLongHelp()
    {
	Object s = table.get(LONG_HELP);
	return (s != null) ? s.toString() : getShortHelp();
    }

    public String getParameter()
    {
	Object s = table.get(PARAMETER);
	return (s != null) ? s.toString() : "";
    }

    public String getShortHelp()
    {
	Object s = table.get(SHORT_HELP);
	return (s != null) ? s.toString() : "Sorry, no help available.";
    }

    protected void putValue(String key, Object value)
    {
	if (key.equals(CMD)) {
	    ArrayList cmds = (ArrayList)table.get(CMD);
	    if (cmds == null) {
		cmds = new ArrayList();
		table.put(key, cmds);
	    }
	    if (value instanceof String) {
		cmds.add(value);
	    }
	    else if (value instanceof String[]) {
		cmds.addAll(Arrays.asList((String[])value)); 
	    }
	}
	else {
	    table.put(key, value);
	}
    }

    protected int getInt(String[] argv, int min, int max) 
	throws SyntaxException, ParameterException
    {
	    if (argv.length != 2) {
		throw(new SyntaxException());
	    }

	    int i;
	    try {
		i = Integer.parseInt(argv[1]);
	    }
	    catch (NumberFormatException e) {
		throw(new SyntaxException());
	    }

	    if (i < min || i > max) {
		throw new ParameterException("Invalid id.");
	    }

	    return i;
    }

}
