/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.cmdl;

import xnap.util.*;

import java.util.*;

public class Completer {

    // --- Data Field(s) ---

    private Vector completions = new Vector();

    // --- Constructor(s) ---

    public Completer()
    {
    }

    // --- Method(s) ---

    public void add(String completion)
    {
	completions.add(completion);
    }

    public void remove(String completion)
    {
	completions.remove(completion);
    }

    public String[] getCompletions()
    {
	String[] array = new String[completions.size()];
	System.arraycopy(completions.toArray(), 0, array, 0, array.length);
	return array;
    }

    /** 
     * 
     *
     */
    public String completer(String text, int pos) 
    {
	int matched = 0;

	// maybe we should do some caching here...
	for (int i = 0; i < completions.size(); i++) {
	    if (((String)completions.get(i)).startsWith(text)) {
		if (pos == matched)
		    return (String)completions.get(i);
		matched ++;
	    }
	}

	return null;
    }

}
