/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;
import javax.swing.event.*;

public class DirectoryList extends JPanel implements ListSelectionListener {
    
    //--- Data field(s) ---

    private DirectoryPanel dtfDir;
    private JList jlDirs;
    private DefaultListModel dlmDirs;

    //--- Constructor(s) ---

    public DirectoryList(String[] dirs, int size, int visibleRows) 
    {
	setLayout(new BorderLayout());

	AddAction acAdd = new AddAction();

	dtfDir = new MyDirectoryPanel("", size);
	KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
	dtfDir.getTextField().getInputMap().put(enter, acAdd);

	dlmDirs = new DefaultListModel();
	jlDirs = new JList(dlmDirs);
	jlDirs.addListSelectionListener(this);
	jlDirs.setVisibleRowCount(visibleRows);
	JScrollPane jsp = new JScrollPane(jlDirs);

	JButton jbAdd = new JButton(acAdd);
	jbAdd.setMargin(new Insets(1, 1, 1, 1));
	JButton jbRemove = new JButton(new RemoveAction());
	jbRemove.setMargin(new Insets(1, 1, 1, 1));

	Box bxInput = Box.createHorizontalBox();
	bxInput.add(dtfDir);
	bxInput.add(jbAdd);
	bxInput.add(jbRemove);

	add(bxInput, BorderLayout.NORTH);
	add(jsp, BorderLayout.CENTER);

	setDirs(dirs);
    }

    // --- Method(s) ---

    public void addCurrentDirectory()
    {
	String s = dtfDir.getDirectory();
	if (s.length() > 0 && !dlmDirs.contains(s)) {
	    dlmDirs.addElement(s);
	    jlDirs.ensureIndexIsVisible(dlmDirs.getSize() - 1);
	}
	dtfDir.setDirectory("");
    }

    public String[] getDirs()
    {
	String[] array = new String[dlmDirs.size()];
	System.arraycopy(dlmDirs.toArray(), 0, array, 0, array.length);
	return array;
    }

    public void setDirs(String[] dirs)
    {
  	for (int i = 0; i < dirs.length; i++) {
  	    dlmDirs.addElement(dirs[i]);
  	}
    }

    public void valueChanged(ListSelectionEvent e)
    {
	if (jlDirs.getSelectedValue() != null) {
	    dtfDir.setDirectory(jlDirs.getSelectedValue().toString());
	}
    }

    private class AddAction extends AbstractAction {
	
        public AddAction() 
	{
	    putValue(Action.SMALL_ICON, 
		     XNapFrame.getSmallIcon("edit_add.png"));
            putValue(Action.SHORT_DESCRIPTION, "Add directory");
            putValue(Action.MNEMONIC_KEY, new Integer('A'));
	}

        public void actionPerformed( ActionEvent event ) 
	{
	    addCurrentDirectory();
	}

    } 

    private class RemoveAction extends AbstractAction {
	
        public RemoveAction() 
	{
	    putValue(Action.SMALL_ICON, 
		     XNapFrame.getSmallIcon("edit_remove.png"));
            putValue(Action.SHORT_DESCRIPTION, "Remove directory");
            putValue(Action.MNEMONIC_KEY, new Integer('R'));
	}

        public void actionPerformed(ActionEvent event) 
	{
	    Object dirs[] = jlDirs.getSelectedValues();
	    for (int i = 0; i < dirs.length; i++) {
		dlmDirs.removeElement(dirs[i]);
	    }
	}

    } 

    private class MyDirectoryPanel extends DirectoryPanel
    {
	public MyDirectoryPanel(String text, int size) 
	{
	    super(text, size);
	}
	
	public void directorySelected(String dir)
	{
	    addCurrentDirectory();
	}
    }

}
