/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.util.*;

import java.net.URL;
import java.io.IOException;
import java.util.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.JEditorPane;
import javax.swing.event.*;

/**
 * Provides a pane with html support.
 *
 */
public class HTMLEditorPane extends JEditorPane
{
    
    //--- Constructor(s) ---
    
    public HTMLEditorPane()
    {
	super();
	initialize();
    }

    public HTMLEditorPane(URL url) throws IOException
    {
	super(url);
	initialize();
    }

    //--- Method(s) ---

    public void initialize()
    {
	setContentType("text/html");
	setEditable(false);
	addHyperlinkListener(new Hyperactive());
    }

    /**
     * Listens for links and filters out links pointing to different
     * frames, this code was taken from jdoc.
     */
    private class Hyperactive implements HyperlinkListener
    {

	public void hyperlinkUpdate(HyperlinkEvent e)
	{
	    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
		JEditorPane pane = (JEditorPane)e.getSource();
		if (e instanceof HTMLFrameHyperlinkEvent) {
		    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
		    HTMLDocument doc = (HTMLDocument)pane.getDocument();
		    doc.processHTMLFrameHyperlinkEvent(evt);
		}
		else {
		    try {
			pane.setPage(e.getURL());
		    }
		    catch (Throwable t) {
		    }
		}
	    }
	}

    }
    
}
