/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;
import xnap.net.IUser;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class UserEditorDialog extends DefaultDialog {
    
    //--- Data field(s) ---

    UserEditorPanel uep;

    //--- Constructor(s) ---
    
    public UserEditorDialog(IUser user)
    {
	uep = new UserEditorPanel(user);
	setMainComponent(uep);

	pack();
    }

    // --- Methods ---

    public static void showDialog(Component c, IUser u)
    {
	UserEditorDialog me = new UserEditorDialog(u);
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.show();
    }

    public void apply()
    {
	uep.apply();
    }

}
