/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.table;

import xnap.*;
import xnap.net.*;
import xnap.plugin.INetworkPlugin;
import xnap.util.*;
import xnap.util.event.*;

import java.util.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class ChannelTableModel extends AbstractDynamicTableModel
{
    //--- Constant(s) ---

    public static final int NAME = 0;
    public static final int USER_COUNT = 1;
    public static final int TOPIC = 2;

    protected Column columns[] = new Column[] {
	new Column(XNap.tr("Channel"), String.class),
	new Column(XNap.tr("Users"), Integer.class, new NumberCellRenderer()),
	new Column(XNap.tr("Topic"), String.class),
    };

    //--- Data field(s) ---

    private ArrayList rows = new ArrayList();

    //--- Constructor(s) ---

    public ChannelTableModel() 
    {
	super("channel", Preferences.getInstance());
	setColumns(columns);
    }

    //--- Method(s) ---

    public IChannel get(int i)
    {
	return (IChannel)rows.get(mapToIndex(i));
    }

    public int getRowCount() 
    {
        return rows.size();
    }
    
    public Object get(int i, int j) 
    {
        if (i >= rows.size()) 
	    return null;

        IChannel c = (IChannel)rows.get(i);

        if (c == null) 
	    return null;

        switch (j) {
	case NAME:
	    return c.getName();
	case USER_COUNT:
	    return new Integer(c.getUserCount());
	case TOPIC:
	    return c.getTopic();
	default:
	    return "";
        }
    }

    public String getTableName()
    {
	return XNap.tr("Channel Table");
    }

    public void set(IChannel[] channels)
    {
	if (channels != null) {
	    rows = new ArrayList(Arrays.asList(channels));
	}
	else {
	    rows.clear();
	}
	fireTableDataChanged();
	resort();
    }

}
