/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import xnap.io.*;
import xnap.util.*;

import java.beans.*;
import java.io.*;
import java.net.*;
import java.util.*;

public abstract class AbstractDownload implements IDownload {

    // --- Constant(s) ---

    //--- Data field(s) ---

    protected IUser user;
    protected long filesize;
    protected long lastTry = -1;
    private int tryCount = 0;
    private int queuePos = -1;
    private IDownloadContainer parent;

   //--- Constructor(s) ---
    
    public AbstractDownload(IUser user, long filesize)
    {
	this.user = user;
	this.filesize = filesize;
    }

    //--- Method(s) ---

    public boolean equals(Object o)
    {
	if (o instanceof AbstractDownload) {
	    AbstractDownload d = (AbstractDownload)o;
	    return (getFilesize() == d.getFilesize()
		    && (getUser().equals(d.getUser())));
	}

	return false;
    }

    public long getFilesize()
    {
	return filesize;
    }

    public long getLastTry()
    {
	return lastTry;
    }
    
    public int getQueuePos()
    {
	return queuePos;
    }

    public IDownloadContainer getParent()
    {
	return parent;
    }

    public IUser getUser() 
    {
        return user;
    }

    public void setParent(IDownloadContainer newParent)
    {
	parent = newParent;
    }

    public int getTryCount()
    {
	return tryCount;
    }

    public void reset()
    {
	tryCount = 0;
	lastTry = -1;
    }

    public void start()
    {
	tryCount++;
	lastTry = System.currentTimeMillis();
    }

    protected void setQueuePos(int newValue)
    {
	queuePos = newValue;
	parent.setQueuePos(this, queuePos);
    }

    public String toString()
    {
	return "download @" + getUser().getName();
    }
    
}
