/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net.event;

import xnap.net.IUser;

import java.util.EventObject;

public class ChannelEvent extends EventObject { 

    //--- Constant(s) ---

    public static final int MESSAGE_RECEIVED = 1;
    public static final int USER_ADDED = 2;
    public static final int USER_REMOVED = 3;
    public static final int TOPIC_CHANGED = 4;
    public static final int CHANNEL_CLOSED = 5;

    public static final int MESSAGE_TYPE_MESSAGE = 1;
    public static final int MESSAGE_TYPE_INFO = 2;
    public static final int MESSAGE_TYPE_ERROR = 3;

    //--- Data Field(s) ---
    
    protected int id;
    protected String message;
    protected int messageType;
    protected IUser user;
    protected String topic;

    //--- Constructor(s) ---

    public ChannelEvent(Object source, IUser user, String message, 
			int messageType)
    {	
	super(source);
    
	this.id = MESSAGE_RECEIVED;
	this.user = user;
	this.message = message;
	this.messageType = messageType;
    }

    public ChannelEvent(Object source, int id, IUser user)
    {
	super(source);

	this.id = id;
	this.user = user;
    }

    public ChannelEvent(Object source, String topic)
    {
	super(source);

	this.id = TOPIC_CHANGED;
	this.topic = topic;
    }

    public ChannelEvent(Object source)
    {
	super(source);
	
	this.id = CHANNEL_CLOSED;
    }

    //--- Method(s) ---

    public int getID()
    {
	return id;
    }

    public String getMessage()
    {
	return message;
    }

    public int getMessageType()
    {
	return messageType;
    }

    public IUser getUser()
    {
	return user;
    }

    public String getTopic()
    {
	return topic;
    }

}
