/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import xnap.net.*;
import xnap.util.*;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class Browse extends AbstractBrowse {
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---

    private String address;
    private int linkSpeed;

    protected HttpConnection conn = new HttpConnection();
    protected String nextResult;

    //--- Constructor(s) ---

    public Browse(IUser user, String address, int linkSpeed)
    {
	super(user);

	this.address = address;	    
	this.linkSpeed = linkSpeed;
    }

    //--- Method(s) ---

    public int available() throws IOException
    {
	while (buffer.size() == 0) {
	    String s = conn.nextLine();
	    if (s == null) {
		return -1;
	    }
	    
	    SearchResult sr = parse(s);
	    if (sr != null) {
		add(sr);
	    }
	}

	return buffer.size();
    }

    public void close() {
	conn.close();
    }

    public void connect() throws IOException
    {
	conn.connect(address);
    }

    public SearchResult parse(String line)
    {
	Debug.log(line);
		
	/* get filename and rest of url */
	StringTokenizer qt = new StringTokenizer(line, "\"");
		
	Debug.log("token count = " + qt.countTokens());

	if (qt.countTokens() == 3) {
	    /* skipt first token */
	    qt.nextToken();
		    
	    String filename = qt.nextToken();
	    String location = "http://" + address + filename;

	    filename = URLDecoder.decode(filename);
	    try {
		filename = filename.substring(filename.lastIndexOf("/") + 1);
	    }
	    catch (IndexOutOfBoundsException e) {
	    }
		    
	    long size = -1;
	    try {
		String sizeStr = line.substring(line.lastIndexOf(">")
						      + 1);
		Debug.log("Filesize should be: " + sizeStr);
		size = Long.parseLong(sizeStr);
	    }
	    catch (IndexOutOfBoundsException e) {
	    }
	    catch (NumberFormatException e) {
	    }
	    
	    SearchResult result = new SearchResult(size, 0, -1, 0, 
						   user, location, 
						   linkSpeed, filename,1);
	    return result;
	}
	
	return null;
    }

}
