/*
 * 09/14/2001
 *
 * UnknownMessage.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.util.*;
import xnap.plugin.gnutella.io.*;

import java.io.IOException;
import java.io.EOFException;


/**
 *
 * @version 0.1 09/14/2001
 * @author Frederik Zimmer
 */

public class UnknownMessage extends Message 
{
    private static final int MAX_PAYLOAD_LENGTH = 67092;

    public UnknownMessage(DescriptorHeader header, DataInputStream in)
	throws IOException, InvalidMessageException 
    {
	super(header);
	Debug.log("payload: " + header.payloadDescriptor + " payload-length: " 
		  + header.payloadLength);
	if (header.payloadLength > MAX_PAYLOAD_LENGTH) {
	    throw new InvalidMessageException("Payload-length too high");
	}
	read(in);
    }
    
    public void write(DataOutputStream out) throws IOException {}
    
    public void read(DataInputStream in) throws IOException {
	in.skip(header.payloadLength);
    }
}
