/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.gui.DefaultDialog;
import xnap.gui.EnableAction;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.ListenerThread;
import xnap.plugin.nap.net.Server;
import xnap.util.Preferences;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class UserLookupDialog extends DefaultDialog implements ListListener {
    
    //--- Data field(s) ---

    private EventVector servers = Connector.getInstance().getConnectedServers();
    private GlobalUser user;
    private JComboBox jcbServers;

    //--- Constructor(s) ---
    
    public UserLookupDialog(GlobalUser user)
    {
	super(BUTTON_CLOSE);

	this.user = user;

	initialize();

   	servers.addListListener(this);
    }

    // --- Methods ---

    private void initialize()
    {
        setTitle(Plugin.tr("User"));

	JPanel jp = getMainPanel();
	jp.setLayout(new GridBagLayout());

	jcbServers = new JComboBox(servers);
	GridBagHelper.add(jp, jcbServers);

	pack();
    }

    public void close()
    {
	server.removeListListener(this);
    }

    public void elementAdded(ListEvent e)
    {
        final Object obj = e.getElement();
	SwingUtilities.invokeLater(new Runnable() 
	    {
		public void run() {
		    jcbServers.addElement(obj);
		}
	    });
    }
    
    public  void elementRemoved(ListEvent e)
    {
        final Object obj = e.getElement();
	SwingUtilities.invokeLater(new Runnable() 
	    {
		public void run() {
		    jcbServers.removeElement(obj);
		}
	    });
    }

    public static void showDialog(Component c, GlobalUser u)
    {
	ServerEditorDialog me = new ServerEditorDialog(u);
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.show();
    }

    public void apply()
    {
   	servers.addListListener(this);
    }

}
