/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.net.HttpConnection;
import xnap.plugin.nap.util.NapPreferences;

import java.io.*;
import java.net.*;
import java.util.*;

public class Napigator extends HttpConnection {

    //--- Data Field(s) ---

    private HashSet filter = new HashSet();
    private HashSet fakeNetworks = new HashSet();

    //--- Constructor(s) ---
	
    public Napigator()
    {
	String s = NapPreferences.getInstance().getFilterNetworks();
	StringTokenizer t = new StringTokenizer(s, ";");
	while (t.hasMoreTokens()) {
	    filter.add(t.nextToken().trim());
	}

	s = NapPreferences.getInstance().getFakeNetworks();
	t = new StringTokenizer(s, ";");
	while (t.hasMoreTokens()) {
	    fakeNetworks.add(t.nextToken().trim());
	}
    }

    //--- Method(s) ---

    /*
     * the lines look like this:
     *
     * <ip> <port> <network name> <# users> <# files> <# gigabytes> 
     * <dns name>\n
     *
     * and the last line like this:
     *
     * <# of servers> <total # of users> <total # of files> 
     * <total # of gigabytes>\n
     *
     */
    public Server nextServer() {
	String line;
	while ((line = nextLine()) != null) {
	    StringTokenizer t = new StringTokenizer(line, " ");
	    
	    if (t.countTokens() < 6) {
		continue;
	    }
	    
	    try {
		String ip = t.nextToken();
		int port = Integer.parseInt(t.nextToken());
		String network = t.nextToken();
		int users = Integer.parseInt(t.nextToken());
		int files = Integer.parseInt(t.nextToken());
		int total = Integer.parseInt(t.nextToken());
		String host = t.hasMoreTokens() ? t.nextToken() : "";

		if (filter.contains(network)) {
		    continue;
		}
		else if (fakeNetworks.contains(network)) {
		    network = "";
		}

		if (host.length() == 0) {
		    host = ip;
		    ip = null;
		}
		
		return new Server(host, ip, port, network, files, total, users);
	    }
	    catch (NumberFormatException e) {
	    }
	} 

        return null;
    }

}
