/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.audio;

import xnap.util.*;

import java.net.*;
import java.io.*;

public class  NoatunPlayer extends AudioPlayer
{
    
    public NoatunPlayer(String command)
    {
	super(command);
    }

    public boolean canPlay(File f)
    {
	return super.canPlay(f) || f.getName().endsWith(".wav");
    }

    public boolean play()
    {

	String args[] = {
	    "dcop", "noatun", "Noatun", "playpause"
	};
	
	try {
	    player = Runtime.getRuntime().exec(args);
	} 
	catch (IOException e) {
	    Debug.log("noatun play: " + e.getMessage());
	    return false;
	}

	return true;
    }

    public boolean play(File f)
    {
	String args[] = {
	    "dcop", "noatun", "Noatun", "addFile", f.getAbsolutePath(), "true"
	};

	try {
	    player = Runtime.getRuntime().exec(args);
	} 
	catch (IOException e) {
	    Debug.log("noatun play: " + e.getMessage());
	    return false;
	}

	return true;
    }

    public boolean stop()
    {

	String args[] = {
	    "dcop", "noatun", "Noatun", "stop"
	};

	try {
	    player = Runtime.getRuntime().exec(args); 
	} 
	catch (IOException e) {
	    Debug.log("noatun play: " + e.getMessage());
	    return false;
	}

	return true;
    }

    public boolean enqueue(File f)
    {

	String args[] = {
	    "dcop", "noatun", "Noatun", "addFile", f.getAbsolutePath(), 
	    "false"
	};

	try
	    {
		player = Runtime.getRuntime().exec(args);
	    }
	catch (IOException e)
	    {
		Debug.log("noatun play: " + e.getMessage());
		return false;
	    }
	return true;
    }

}
