/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.prefs;

import xnap.XNap;
import xnap.util.PortRange;

import java.text.*;
import java.util.*;

public class PortRangeValidator implements Validator
{

    //--- Data field(s) ---

    private int min;
    private int max;
    private boolean valid;

    //--- Constant(s) ---

    public PortRangeValidator(int min, int max)
    {
	this.min = min;
	this.max = max;
    }

    public PortRangeValidator()
    {
	this(PortRange.MIN_PORT, PortRange.MAX_PORT);
    }

    //--- Method(s) ---

    public void validate(String value) throws IllegalArgumentException
    {
	valid = false;

	StringTokenizer t = new StringTokenizer(value, ";");
	while (t.hasMoreTokens()) {
	    String ports = t.nextToken().trim();

	    if (ports.length() == 0) {
		continue;
	    }

	    try {
		if (ports.indexOf("-") != -1) {
		    StringTokenizer u = new StringTokenizer(ports, "-");
		    if (u.countTokens() == 2) {
			int i = Integer.parseInt(u.nextToken());
			int j = Integer.parseInt(u.nextToken());
			check(i);
			check(j);
			valid |= (i <= j); 
		    }
		    else {
			throw(new IllegalArgumentException
			    (XNap.tr("Malformed range.")));
		    }
		}
		else {
		    check(Integer.parseInt(ports));
		    valid = true;
		}
	    }
	    catch (NumberFormatException e) {
		throw(new IllegalArgumentException
		    (XNap.tr("Malformed number.")));
	    }
	}

	if (!valid) {
	    // did not find at least one valid port
	    throw new IllegalArgumentException(XNap.tr("No port given."));
	}
    }

    public void check(int i) throws IllegalArgumentException
    {
	if (i < min || i > max) {
	    throw(new IllegalArgumentException
		(MessageFormat.format
		 (XNap.tr("Port out of range {0}."),
		  new Object[] { "(" + min + " - " + max + ")" })));
	}
    }

}
