/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
//package xnap.plugin.nap.net;

import xnap.plugin.nap.net.msg.server.SearchResponseMessage;
import xnap.util.*;

import junit.framework.*;

/**
 * 
 *
 */
public class SearchResponseMessageTest extends TestCase {
    
    public SearchResponseMessageTest(String name) 
    {
	super(name);
    }

    protected void setUp()
    {
    }

    public static Test suite()
    {
	return new TestSuite(SearchResponseMessageTest.class);
    }

    public void testParse()
    {
	String data = "\"E:\\WINMX\\MP3`s\\MP3 - Britney Spears-Stronger [Techno Remix](1).mp3\" 00000000000000000000000000000000 5435392 192 44100 226 shivetales 2275017040 7";
	QuotedStringTokenizer t = new QuotedStringTokenizer(data);

    String filename;
    String md5;
    long filesize;
    int bitrate;
    int frequency;
    int length;
    String nick;
    String ip;
    int linkSpeed;
    int weight;
    int queuePos;
    String clientInfo;

	filename = t.nextToken();
	md5 = t.nextToken();
	filesize = Long.parseLong(t.nextToken());
	bitrate = Integer.parseInt(t.nextToken());
	frequency = Integer.parseInt(t.nextToken());
	length = Integer.parseInt(t.nextToken());
	nick = t.nextToken();
	ip = StringHelper.parseIP(t.nextToken());
	linkSpeed = Integer.parseInt(t.nextToken());

	weight = 0;
	queuePos = -1;
	if (t.countTokens() >= 2) {
	    try {
		// could be set to "n/a"
		queuePos = Integer.parseInt(t.nextToken());
	    }
	    catch (NumberFormatException e) {
	    }
	    clientInfo = t.nextToken();
	}
	else if (t.hasMoreTokens()) {
	    weight = Integer.parseInt(t.nextToken());
	}

    }

}
