/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class MergeKeys {

    /**
     * 
     */
    public static void main(String[] argv)
    {
	if (argv.length < 1) {
	    System.err.println("usage: MergeKeys file [file...]");
	    System.exit(1);
	}

	HashSet keys = Helper.readKeys();

	for (int i = 0; i < argv.length; i++) {
	    try {
		System.out.println("Merging keys into file: " + argv[i]);
		merge(argv[i], keys);
	    }
	    catch (IOException e) {
		System.err.println("Error: " + e.getMessage());
	    }
	}
    }

    public static void merge(String filename, HashSet keys) throws IOException
    {
	BufferedReader in = new BufferedReader
	    (new InputStreamReader(new FileInputStream(new File(filename))));

	Hashtable fileTable = Helper.readI18nFile(filename, false);

	System.out.println("            total keys: " + fileTable.size());

	HashSet deprecatedKeys = new HashSet(fileTable.keySet());
	deprecatedKeys.removeAll(keys);

	HashSet keepKeys = new HashSet(keys);
	keepKeys.retainAll(fileTable.keySet());

	HashSet newKeys = new HashSet(keys);
	newKeys.removeAll(fileTable.keySet());

	System.out.println("                  keys: "
			   + deprecatedKeys.size() + " deprecated  "
			   + keepKeys.size() + " kept  "
			   + newKeys.size() + " new");

	BufferedWriter out = new BufferedWriter
	    (new OutputStreamWriter(new FileOutputStream(new File(filename)),
				    Helper.getI18nCharset(filename)));

	write(out, fileTable, deprecatedKeys, "#", false);
	write(out, fileTable, keepKeys, "", false);
	write(out, fileTable, newKeys, "", filename.endsWith("XNap.i18n"));

	out.close();
    }

    public static void write(BufferedWriter out, Hashtable table, HashSet keySet, 
			     String prefix, boolean keyEqualsValue) 
	throws IOException
    {
	LinkedList keys = new LinkedList(keySet);
	Collections.sort(keys);

	for (Iterator i = keys.iterator(); i.hasNext();) {
	    String key = (String)i.next();
	    out.write(prefix);
	    out.write(Helper.i18nKeyToRaw(key));
	    out.write("=");
	    String value = (String)table.get(key);
	    if (value != null) {
		out.write(value);
	    }
	    else if (keyEqualsValue) {
		out.write(key);
	    }
	    out.newLine();
	}
    }
		
}

    
