; NOTE: this .NSI script is designed for NSIS v1.3+

Name "XNap"
ComponentText "This will install XNap."
DirText "Select the directory to install XNap in:"

LicenseText "XNap is free software. Please read the license terms below before installing."
LicenseData "COPYING.txt"

OutFile "xnap-installer.exe"
InstallDir "$PROGRAMFILES\XNap"
InstallDirRegKey HKEY_LOCAL_MACHINE "SOFTWARE\XNap" ""
AutoCloseWindow true

UninstallText "This will uninstall XNap from your system."
UninstallExeName "xnap-uninstaller.exe"


Section ""
	SetOutPath "$INSTDIR"
	SetOverwrite on
	File xnap.jar
	File COPYING.txt
	File README.txt
	File ziga.dll
	File icons\16\xnap.ico

	SetOutPath "$SMPROGRAMS\XNap"
	; we need to set the correct working directory
	SetOutPath "$INSTDIR"
        SetOverwrite on
	CreateShortCut "$SMPROGRAMS\XNap\XNap.lnk" \
	  "$WINDIR\javaw.exe" '-jar "$INSTDIR\xnap.jar"' "$INSTDIR\xnap.ico" 0 
	CreateShortCut "$SMPROGRAMS\XNap\License.lnk" \
	  "$INSTDIR\COPYING.txt"
	CreateShortCut "$SMPROGRAMS\XNap\Readme.lnk" \
	  "$INSTDIR\README.txt"
	CreateShortCut "$SMPROGRAMS\XNap\Uninstall.lnk" \
	  "$INSTDIR\xnap-uninstaller.exe"

	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\XNap" "" "$INSTDIR"

	WriteRegStr HKEY_LOCAL_MACHINE \
	  "Software\Microsoft\Windows\CurrentVersion\Uninstall\XNap" \
	  "DisplayName" "XNap (remove only)"
	WriteRegStr HKEY_LOCAL_MACHINE \
	  "Software\Microsoft\Windows\CurrentVersion\Uninstall\XNap" \
	  "UninstallString" '"$INSTDIR\xnap-uninstaller.exe"'
SectionEnd


Section Uninstall	
	DeleteRegKey HKEY_LOCAL_MACHINE \
	  "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\XNap"

	DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\XNap"

	Delete "$SMPROGRAMS\XNap\*.*"
        RMDir  "$SMPROGRAMS\XNap"

	Delete "$INSTDIR\*.*"
	RMDir  "$INSTDIR"
SectionEnd


Function .onInit
	Call Check_JDK
FunctionEnd

	 
Function .onInstSuccess
	MessageBox MB_YESNO|MB_ICONQUESTION \
	  "XNap was successfully installed.$\n$\nLaunch now?" IDNO no_launch

	Exec 'javaw -jar "$INSTDIR\xnap.jar"'

    no_launch:
FunctionEnd


Function Check_JDK
	 IfFileExists "$WINDIR\javaw.exe" have_jdk no_jdk 

    no_jdk:	
	MessageBox MB_YESNO|MB_ICONSTOP \
          "Java could not be found. Please install a runtime \
enviroment from http://java.sun.com/j2se/1.4.1/download.html \
before running XNap.$\n$\nContinue anyway? " IDYES have_jdk

        Abort

    have_jdk:
FunctionEnd